// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2020 MediaTek Inc.
 */

#include <linux/kernel.h>

#include <pmic/upmu_sw.h>
#include <pmic/upmu_hw.h>
#include <mt-plat/upmu_common.h>

#include "include/pmic.h"

const struct pmu_flag_table_entry_t pmu_flags_table[] = {
	PMIC_ENTRY(PMIC_TOP_PSINT_ANA_ID),
	PMIC_ENTRY(PMIC_TOP_PSINT_DIG_ID),
	PMIC_ENTRY(PMIC_TOP_PSINT_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP_PSINT_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP_PSINT_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP_PSINT_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP_PSINT_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP_PSINT_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP_PSINT_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP_PSINT_DSN_FPI),
	PMIC_ENTRY(PMIC_TOP_PSINT_DSN_DXI),
	PMIC_ENTRY(PMIC_HWCID0),
	PMIC_ENTRY(PMIC_HWCID1),
	PMIC_ENTRY(PMIC_SWCID0),
	PMIC_ENTRY(PMIC_SWCID1),
	PMIC_ENTRY(PMIC_STS_PWRKEY),
	PMIC_ENTRY(PMIC_STS_RTCA),
	PMIC_ENTRY(PMIC_STS_CHRIN),
	PMIC_ENTRY(PMIC_STS_SPAR),
	PMIC_ENTRY(PMIC_STS_RBOOT),
	PMIC_ENTRY(PMIC_STS_ENON),
	PMIC_ENTRY(PMIC_STS_BWDT),
	PMIC_ENTRY(PMIC_STS_DDLO),
	PMIC_ENTRY(PMIC_STS_WDT),
	PMIC_ENTRY(PMIC_STS_PUPSRC),
	PMIC_ENTRY(PMIC_STS_KEYPWR),
	PMIC_ENTRY(PMIC_STS_PKSP),
	PMIC_ENTRY(PMIC_STS_OVLO),
	PMIC_ENTRY(PMIC_STS_EN_SHDN),
	PMIC_ENTRY(PMIC_STS_UVLO),
	PMIC_ENTRY(PMIC_STS_PGFAIL),
	PMIC_ENTRY(PMIC_STS_PSOC),
	PMIC_ENTRY(PMIC_STS_THRDN),
	PMIC_ENTRY(PMIC_STS_WRST),
	PMIC_ENTRY(PMIC_STS_CRST),
	PMIC_ENTRY(PMIC_STS_PKEYLP),
	PMIC_ENTRY(PMIC_STS_NORMOFF),
	PMIC_ENTRY(PMIC_RG_POFFSTS_CLR),
	PMIC_ENTRY(PMIC_RG_PONSTS_CLR),
	PMIC_ENTRY(PMIC_PMU_THERMAL_DEB),
	PMIC_ENTRY(PMIC_STRUP_THERMAL_STATUS),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_HW_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_HW_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN_SYNC_EN),
	PMIC_ENTRY(PMIC_RG_OSC_EN_AUTO_OFF),
	PMIC_ENTRY(PMIC_TEST_OUT0),
	PMIC_ENTRY(PMIC_RG_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_NANDTREE_MODE),
	PMIC_ENTRY(PMIC_RG_TEST_AUXADC),
	PMIC_ENTRY(PMIC_RG_EFUSE_MODE),
	PMIC_ENTRY(PMIC_RG_TEST_STRUP),
	PMIC_ENTRY(PMIC_RG_MON_OUT_SEL),
	PMIC_ENTRY(PMIC_RG_TEST_CON3_RSV),
	PMIC_ENTRY(PMIC_TESTMODE_SW),
	PMIC_ENTRY(PMIC_PMU_TEST_MODE_SCAN),
	PMIC_ENTRY(PMIC_PWRKEY_DEB),
	PMIC_ENTRY(PMIC_CHRDET_DEB),
	PMIC_ENTRY(PMIC_HOMEKEY_DEB),
	PMIC_ENTRY(PMIC_STS_PMIC_RESETB_SHDN),
	PMIC_ENTRY(PMIC_STS_PMIC_RESETB_WRST),
	PMIC_ENTRY(PMIC_STS_SPMI_SEQ_OFF),
	PMIC_ENTRY(PMIC_RG_PMU_TDSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_TDSEL),
	PMIC_ENTRY(PMIC_RG_E32CAL_TDSEL),
	PMIC_ENTRY(PMIC_RG_PMU_RDSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_RDSEL),
	PMIC_ENTRY(PMIC_RG_E32CAL_RDSEL),
	PMIC_ENTRY(PMIC_RG_SMT_WDTRSTB_IN),
	PMIC_ENTRY(PMIC_RG_SMT_SRCLKEN_IN0),
	PMIC_ENTRY(PMIC_RG_SMT_SRCLKEN_IN1),
	PMIC_ENTRY(PMIC_RG_SMT_RTC_32K1V8_0),
	PMIC_ENTRY(PMIC_RG_SMT_RTC_32K1V8_1),
	PMIC_ENTRY(PMIC_RG_SMT_SIM_CARD1_DET_N),
	PMIC_ENTRY(PMIC_RG_SMT_SIM_CARD2_DET_N),
	PMIC_ENTRY(PMIC_RG_SMT_SPMI_M_SCL),
	PMIC_ENTRY(PMIC_RG_SMT_SPMI_M_SDA),
	PMIC_ENTRY(PMIC_RG_SMT_SPMI_P_SCL),
	PMIC_ENTRY(PMIC_RG_SMT_SPMI_P_SDA),
	PMIC_ENTRY(PMIC_RG_TOP_RSV0),
	PMIC_ENTRY(PMIC_RG_TOP_RSV1),
	PMIC_ENTRY(PMIC_RG_OCTL_SRCLKEN_IN0),
	PMIC_ENTRY(PMIC_RG_OCTL_SRCLKEN_IN1),
	PMIC_ENTRY(PMIC_RG_OCTL_RTC_32K1V8_0),
	PMIC_ENTRY(PMIC_RG_OCTL_RTC_32K1V8_1),
	PMIC_ENTRY(PMIC_RG_OCTL_SPMI_M_SCL),
	PMIC_ENTRY(PMIC_RG_OCTL_SPMI_M_SDA),
	PMIC_ENTRY(PMIC_RG_OCTL_SPMI_P_SCL),
	PMIC_ENTRY(PMIC_RG_OCTL_SPMI_P_SDA),
	PMIC_ENTRY(PMIC_RG_OCTL_SIM_CARD1_DET_N),
	PMIC_ENTRY(PMIC_RG_OCTL_SIM_CARD2_DET_N),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPMI_M_SCL_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPMI_M_SDA_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPMI_P_SCL_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SPMI_P_SDA_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_IN_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SIM_CARD1_DET_N_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SIM_CARD2_DET_N_FILTER_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN0_RCSEL),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN1_RCSEL),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_RCSEL),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_M_SCL_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_M_SDA_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_P_SCL_RCSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_P_SDA_RCSEL),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_IN_RCSEL),
	PMIC_ENTRY(PMIC_RG_SIM_CARD1_DET_N_RCSEL),
	PMIC_ENTRY(PMIC_RG_SIM_CARD2_DET_N_RCSEL),
	PMIC_ENTRY(PMIC_TOP_STATUS),
	PMIC_ENTRY(PMIC_TOP_STATUS_SET),
	PMIC_ENTRY(PMIC_TOP_STATUS_CLR),
	PMIC_ENTRY(PMIC_VM_MODE),
	PMIC_ENTRY(PMIC_RG_INT_EN_RCS0),
	PMIC_ENTRY(PMIC_RG_INT_EN_RCS1),
	PMIC_ENTRY(PMIC_RG_INT_EN_RCS2),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRC_PROTREG),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_CON0_SET),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_BUCK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_EN_LDO_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_EN_PSC_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_EN_PLT_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_EN_HK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_EN_SCK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_EN_XPP_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_EN_TOP_PROTREG),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_CON1_SET),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_RCS0),
	PMIC_ENTRY(PMIC_RG_INT_MASK_RCS1),
	PMIC_ENTRY(PMIC_RG_INT_MASK_RCS2),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRC_PROTREG),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BUCK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_LDO_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PSC_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PLT_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_SCK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_XPP_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_TOP_PROTREG),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_MASK_CON1_SET),
	PMIC_ENTRY(PMIC_MISC_TOP_INT_MASK_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_RCS0),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_RCS1),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_RCS2),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRC_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BUCK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_LDO_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_PSC_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_PLT_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_HK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_SCK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_XPP_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_TOP_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRC_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BUCK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_LDO_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_PSC_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_PLT_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_HK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_SCK_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_XPP_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_TOP_PROTREG),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BUCK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_LDO_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PSC_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PLT_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_SCK_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BM_TOP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_AUD_TOP),
	PMIC_ENTRY(PMIC_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_CHIP_TOP),
	PMIC_ENTRY(PMIC_TOP_INT_MASK_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_INT_MASK_CON1_CLR),
	PMIC_ENTRY(PMIC_INT_STATUS_RCS0),
	PMIC_ENTRY(PMIC_INT_STATUS_RCS1),
	PMIC_ENTRY(PMIC_INT_STATUS_RCS2),
	PMIC_ENTRY(PMIC_INT_STATUS_TOP_RSV),
	PMIC_ENTRY(PMIC_INT_STATUS_CHIP_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_BUCK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_LDO_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_PSC_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_PLT_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_HK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_SCK_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_BM_TOP),
	PMIC_ENTRY(PMIC_INT_STATUS_AUD_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_RCS0),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_RCS1),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_RCS2),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_TOP_RSV),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_CHIP_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_BUCK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_LDO_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_PSC_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_PLT_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_HK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_SCK_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_BM_TOP),
	PMIC_ENTRY(PMIC_INT_RAW_STATUS_AUD_TOP),
	PMIC_ENTRY(PMIC_RG_INT_POLARITY),
	PMIC_ENTRY(PMIC_TOP_IO_ANA_ID),
	PMIC_ENTRY(PMIC_TOP_IO_DIG_ID),
	PMIC_ENTRY(PMIC_TOP_IO_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP_IO_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP_IO_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP_IO_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP_IO_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP_IO_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP_IO_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP_IO_DSN_FPI),
	PMIC_ENTRY(PMIC_TOP_IO_DSN_DXI),
	PMIC_ENTRY(PMIC_GPIO_DIR0),
	PMIC_ENTRY(PMIC_GPIO_DIR0_SET),
	PMIC_ENTRY(PMIC_GPIO_DIR0_CLR),
	PMIC_ENTRY(PMIC_GPIO_DIR1),
	PMIC_ENTRY(PMIC_GPIO_DIR1_SET),
	PMIC_ENTRY(PMIC_GPIO_DIR1_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLEN0_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLEN1),
	PMIC_ENTRY(PMIC_GPIO_PULLEN1_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLEN1_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL0_CLR),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL1),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL1_SET),
	PMIC_ENTRY(PMIC_GPIO_PULLSEL1_CLR),
	PMIC_ENTRY(PMIC_GPIO_DINV0),
	PMIC_ENTRY(PMIC_GPIO_DINV0_SET),
	PMIC_ENTRY(PMIC_GPIO_DINV0_CLR),
	PMIC_ENTRY(PMIC_GPIO_DINV1),
	PMIC_ENTRY(PMIC_GPIO_DINV1_SET),
	PMIC_ENTRY(PMIC_GPIO_DINV1_CLR),
	PMIC_ENTRY(PMIC_GPIO_DOUT0),
	PMIC_ENTRY(PMIC_GPIO_DOUT0_SET),
	PMIC_ENTRY(PMIC_GPIO_DOUT0_CLR),
	PMIC_ENTRY(PMIC_GPIO_DOUT1),
	PMIC_ENTRY(PMIC_GPIO_DOUT1_SET),
	PMIC_ENTRY(PMIC_GPIO_DOUT1_CLR),
	PMIC_ENTRY(PMIC_GPIO_PI0),
	PMIC_ENTRY(PMIC_GPIO_PI1),
	PMIC_ENTRY(PMIC_GPIO_POE0),
	PMIC_ENTRY(PMIC_GPIO_POE1),
	PMIC_ENTRY(PMIC_GPIO0_MODE),
	PMIC_ENTRY(PMIC_GPIO1_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE0_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE0_CLR),
	PMIC_ENTRY(PMIC_GPIO2_MODE),
	PMIC_ENTRY(PMIC_GPIO3_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE1_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE1_CLR),
	PMIC_ENTRY(PMIC_GPIO4_MODE),
	PMIC_ENTRY(PMIC_GPIO5_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE2_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE2_CLR),
	PMIC_ENTRY(PMIC_GPIO6_MODE),
	PMIC_ENTRY(PMIC_GPIO7_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE3_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE3_CLR),
	PMIC_ENTRY(PMIC_GPIO8_MODE),
	PMIC_ENTRY(PMIC_GPIO9_MODE),
	PMIC_ENTRY(PMIC_GPIO_MODE4_SET),
	PMIC_ENTRY(PMIC_GPIO_MODE4_CLR),
	PMIC_ENTRY(PMIC_GPIO_RSV),
	PMIC_ENTRY(PMIC_TOP_CFG_ANA_ID),
	PMIC_ENTRY(PMIC_TOP_CFG_DIG_ID),
	PMIC_ENTRY(PMIC_TOP_CFG_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP_CFG_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP_CFG_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP_CFG_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP_CFG_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP_CFG_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP_CFG_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP_CFG_DSN_FPI),
	PMIC_ENTRY(PMIC_TOP_CFG_DSN_DXI),
	PMIC_ENTRY(PMIC_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_CK_PDN_RSV2),
	PMIC_ENTRY(PMIC_RG_PMU32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FQMTR_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC32K_CK_PDN),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_PDN),
	PMIC_ENTRY(PMIC_RG_CK_PDN_RSV0),
	PMIC_ENTRY(PMIC_RG_CK_PDN_RSV1),
	PMIC_ENTRY(PMIC_RG_SPMI_CK_PDN),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_TRIM_128K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_RG_PCHR_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON2_SET),
	PMIC_ENTRY(PMIC_TOP_CKPDN_CON2_CLR),
	PMIC_ENTRY(PMIC_RG_TOP_CKSEL_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_CKSEL),
	PMIC_ENTRY(PMIC_RG_PMU32K_CK_CKSEL),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_SRCVOLTEN_SW),
	PMIC_ENTRY(PMIC_RG_VOWEN_SW),
	PMIC_ENTRY(PMIC_RG_SRCVOLTEN_MODE),
	PMIC_ENTRY(PMIC_RG_VOWEN_MODE),
	PMIC_ENTRY(PMIC_RG_TOP_CKSEL_CON2_RSV),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON2_SET),
	PMIC_ENTRY(PMIC_TOP_CKSEL_CON2_CLR),
	PMIC_ENTRY(PMIC_RG_REG_CK_DIVSEL),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKDIVSEL_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_EINT_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_RSV),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_CKHWEN_CON0_CLR),
	PMIC_ENTRY(PMIC_TOP_CKTST_CON0_RSV),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_DCXO_1M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_DCXO_26M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_XO_CLK_26M_DIG_TST_DIS),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_PMU_EFUSE_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_PCHR_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_FQMTR_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_TSTCK_SEL),
	PMIC_ENTRY(PMIC_RG_PMU_EFUSE_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_PMU128K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_DCXO_1M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_DCXO_26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_XO_CLK_26M_DIG_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_EFUSE_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_BUCK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_BUCK_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_BM_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_BM_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_HK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_HK_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_LDO_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_LDO_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_SCK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_SCK_SW),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_MDB_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_MDB_SW),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_BUCK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_BUCK_SW),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_LDO_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_LDO_SW),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_HK_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_HK_SW),
	PMIC_ENTRY(PMIC_RG_TOP_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_TOP_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_SCK_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_SCK_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_LDO_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_HK_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_HK_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_VRC_M_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_VRC_M_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_VRC_P_MDB_DCM_SW_MODE),
	PMIC_ENTRY(PMIC_RG_VRC_P_MDB_DCM_SW_EN),
	PMIC_ENTRY(PMIC_RG_MDB_DCXO26M_DCM_LP_EN),
	PMIC_ENTRY(PMIC_RG_EFUSE_MAN_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_RST),
	PMIC_ENTRY(PMIC_RG_FQMTR_RST),
	PMIC_ENTRY(PMIC_RG_RTC_RST),
	PMIC_ENTRY(PMIC_RG_TYPE_C_CC_RST),
	PMIC_ENTRY(PMIC_RG_CLK_TRIM_RST),
	PMIC_ENTRY(PMIC_RG_BUCK_SRCLKEN_RST),
	PMIC_ENTRY(PMIC_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_PROT_PMPP_RST),
	PMIC_ENTRY(PMIC_RG_SPK_RST),
	PMIC_ENTRY(PMIC_RG_FT_VR_SYSRSTB),
	PMIC_ENTRY(PMIC_RG_LDO_CALI_RST),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_SET),
	PMIC_ENTRY(PMIC_TOP_RST_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_CHR_LDO_DET_MODE),
	PMIC_ENTRY(PMIC_RG_CHR_LDO_DET_SW),
	PMIC_ENTRY(PMIC_RG_CHRWDT_FLAG_MODE),
	PMIC_ENTRY(PMIC_RG_CHRWDT_FLAG_SW),
	PMIC_ENTRY(PMIC_TOP_RST_CON2_RSV),
	PMIC_ENTRY(PMIC_RG_GPIO_RST_SEL),
	PMIC_ENTRY(PMIC_RG_PWRKEY_KEY_MODE_RSV),
	PMIC_ENTRY(PMIC_RG_PWRKEY_RST_EN_RSV),
	PMIC_ENTRY(PMIC_RG_PWRRST_TMR_DIS_RSV),
	PMIC_ENTRY(PMIC_RG_PWRKEY_RST_TD_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_MISC_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_MISC0_SET),
	PMIC_ENTRY(PMIC_TOP_RST_MISC0_CLR),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_MODE),
	PMIC_ENTRY(PMIC_WDTRSTB_STATUS),
	PMIC_ENTRY(PMIC_WDTRSTB_STATUS_CLR),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_FB_EN),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_DEB),
	PMIC_ENTRY(PMIC_TOP_RST_MISC1_SET),
	PMIC_ENTRY(PMIC_TOP_RST_MISC1_CLR),
	PMIC_ENTRY(PMIC_VPWRIN_RSTB_STATUS),
	PMIC_ENTRY(PMIC_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_UVLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_RTC_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_CHRWDT_REG_RSTB_STATUS),
	PMIC_ENTRY(PMIC_CHRDET_REG_RSTB_STATUS),
	PMIC_ENTRY(PMIC_BWDT_DDLO_RSTB_STATUS),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_RSV),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_SET),
	PMIC_ENTRY(PMIC_TOP_RST_STATUS_CLR),
	PMIC_ENTRY(PMIC_DCXO26M_CKEN_SCK),
	PMIC_ENTRY(PMIC_DCXO26M_CKEN_MDB),
	PMIC_ENTRY(PMIC_DCXO1M_CKEN),
	PMIC_ENTRY(PMIC_DCXO26M_CKEN),
	PMIC_ENTRY(PMIC_DCXO1M_CKEN_BUCK),
	PMIC_ENTRY(PMIC_DCXO1M_CKEN_LDO),
	PMIC_ENTRY(PMIC_DCXO1M_CKEN_HK),
	PMIC_ENTRY(PMIC_DCXO26M_CKEN_BUCK),
	PMIC_ENTRY(PMIC_DCXO26M_CKEN_LDO),
	PMIC_ENTRY(PMIC_DCXO26M_CKEN_HK),
	PMIC_ENTRY(PMIC_DCXO26M_CKEN_BM),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO26M_CKEN_SW),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_SW_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO1M_CKEN_SW),
	PMIC_ENTRY(PMIC_PMRC_EN0),
	PMIC_ENTRY(PMIC_PMRC_EN0_SET),
	PMIC_ENTRY(PMIC_PMRC_EN0_CLR),
	PMIC_ENTRY(PMIC_PMRC_EN1),
	PMIC_ENTRY(PMIC_PMRC_EN1_SET),
	PMIC_ENTRY(PMIC_PMRC_EN1_CLR),
	PMIC_ENTRY(PMIC_RG_VR_SPM_MODE),
	PMIC_ENTRY(PMIC_RG_VR_MD_MODE),
	PMIC_ENTRY(PMIC_RG_VR_SSHUB_MODE),
	PMIC_ENTRY(PMIC_PMRC_CON1_SET),
	PMIC_ENTRY(PMIC_PMRC_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_SRCLKEN2_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN3_MODE),
	PMIC_ENTRY(PMIC_TOP_CFG_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_SIF_SEL),
	PMIC_ENTRY(PMIC_RG_SIF_PULL_AUTO),
	PMIC_ENTRY(PMIC_RG_SIF_PULL_BY_EFUSE),
	PMIC_ENTRY(PMIC_RG_SIF_PULLEN),
	PMIC_ENTRY(PMIC_RG_SIF_PULLSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_M_SCL_E22),
	PMIC_ENTRY(PMIC_RG_SPMI_M_SDA_E22),
	PMIC_ENTRY(PMIC_RG_SPMI_P_SCL_E22),
	PMIC_ENTRY(PMIC_RG_SPMI_P_SDA_E22),
	PMIC_ENTRY(PMIC_RG_SPMI_M_SCL_RSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_M_SDA_RSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_P_SCL_RSEL),
	PMIC_ENTRY(PMIC_RG_SPMI_P_SDA_RSEL),
	PMIC_ENTRY(PMIC_RG_OCTL_SCLK),
	PMIC_ENTRY(PMIC_RG_OCTL_SDAT),
	PMIC_ENTRY(PMIC_OE_EARLY_ENABLE_B),
	PMIC_ENTRY(PMIC_RG_32K_CK_SEL),
	PMIC_ENTRY(PMIC_OE_EARLY2_ENABLE_B),
	PMIC_ENTRY(PMIC_RG_TOP_CFG_RSV0),
	PMIC_ENTRY(PMIC_RG_SLV_ID),
	PMIC_ENTRY(PMIC_RG_SLV2_ID),
	PMIC_ENTRY(PMIC_RG_TOP_CFG_RSV1),
	PMIC_ENTRY(PMIC_RG_TOP_CFG_RSV2),
	PMIC_ENTRY(PMIC_TOP_VRCTL_ANA_ID),
	PMIC_ENTRY(PMIC_TOP_VRCTL_DIG_ID),
	PMIC_ENTRY(PMIC_TOP_VRCTL_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP_VRCTL_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP_VRCTL_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_TOP_VRCTL_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_TOP_VRCTL_DSN_CBS),
	PMIC_ENTRY(PMIC_TOP_VRCTL_DSN_BIX),
	PMIC_ENTRY(PMIC_TOP_VRCTL_DSN_ESP),
	PMIC_ENTRY(PMIC_TOP_VRCTL_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_PG_H2L_EN),
	PMIC_ENTRY(PMIC_STRUP_VS1_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS2_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRFDIG_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_MD_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMD12_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMD11_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VCORE_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS3_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_2_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_1_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA12_1_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_CORE_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA12_2_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_RFDIG_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUX18_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VXO22_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VEMC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_PROC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VUSB_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDDQ_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDDR_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDD2_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRFCK_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VBBCK_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_EXT_PMIC_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS1_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS2_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRFDIG_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_MD_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMD12_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMD11_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VCORE_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS3_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_2_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_1_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA12_1_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_CORE_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA12_2_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_RFDIG_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUX18_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VXO22_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VEMC_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_PROC_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VUSB_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDDQ_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDDR_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDD2_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRFCK_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VBBCK_OC_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMD12_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMD11_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VCORE_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS3_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS1_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VS2_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRFDIG_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_MD_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA12_2_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_RFDIG_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VAUX18_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VXO22_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_2_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VIO18_1_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VA12_1_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_CORE_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDDR_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDD2_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRFCK_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VBBCK_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VEMC_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSRAM_PROC_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VUSB_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMDDQ_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VCN18_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSIM2_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VSIM1_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VEFUSE_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRF18_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRF13_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VRF09_MODE_STATUS),
	PMIC_ENTRY(PMIC_STRUP_VMC_MODE_STATUS),
	PMIC_ENTRY(PMIC_RG_VR_RST_CK_EN),
	PMIC_ENTRY(PMIC_RG_VRC_1M_CKEN_SW_SEL),
	PMIC_ENTRY(PMIC_RG_VRC_1M_CKEN_SW),
	PMIC_ENTRY(PMIC_RG_WDT_VOSEL_DBG_EN),
	PMIC_ENTRY(PMIC_RG_VRC_ATST_PG_MODE),
	PMIC_ENTRY(PMIC_RG_TOP_VRCTL_RSV),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_SPMI_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VR0_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VR0_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VR1_EN_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VR1_EN_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VR0_LP_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VR0_LP_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_LP),
	PMIC_ENTRY(PMIC_RG_BUCK_VR1_LP_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VR1_LP_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOSEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_VOSEL),
	PMIC_ENTRY(PMIC_RG_TOP_VRCTL_RSV0),
	PMIC_ENTRY(PMIC_RG_TOP_VRCTL_RSV1),
	PMIC_ENTRY(PMIC_PMRC_EN_L),
	PMIC_ENTRY(PMIC_PMRC_EN_H),
	PMIC_ENTRY(PMIC_RGS_TOP_VRCTL_DMY20),
	PMIC_ENTRY(PMIC_RGS_TOP_VRCTL_DMY21),
	PMIC_ENTRY(PMIC_RGS_TOP_VRCTL_DMY22),
	PMIC_ENTRY(PMIC_RGS_TOP_VRCTL_DMY23),
	PMIC_ENTRY(PMIC_RGS_TOP_VRCTL_DMY24),
	PMIC_ENTRY(PMIC_TOP_VRCTL_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_VOSEL_REMAP),
	PMIC_ENTRY(PMIC_PLT_CFG_ANA_ID),
	PMIC_ENTRY(PMIC_PLT_CFG_DIG_ID),
	PMIC_ENTRY(PMIC_PLT_CFG_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PLT_CFG_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PLT_CFG_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PLT_CFG_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PLT_CFG_DSN_CBS),
	PMIC_ENTRY(PMIC_PLT_CFG_DSN_BIX),
	PMIC_ENTRY(PMIC_PLT_CFG_DSN_ESP),
	PMIC_ENTRY(PMIC_PLT_CFG_DSN_FPI),
	PMIC_ENTRY(PMIC_PLT_CFG_DSN_DXI),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM_RATE),
	PMIC_ENTRY(PMIC_DA_OSC_128K_TRIM),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_OTP_OSC_CK_EN_SW),
	PMIC_ENTRY(PMIC_RG_OTP_OSC_CK_EN_SW_SEL),
	PMIC_ENTRY(PMIC_RG_OTP_PA),
	PMIC_ENTRY(PMIC_RG_OTP_PDIN),
	PMIC_ENTRY(PMIC_RG_OTP_PTM),
	PMIC_ENTRY(PMIC_RG_OTP_PWE),
	PMIC_ENTRY(PMIC_RG_OTP_PPROG),
	PMIC_ENTRY(PMIC_RG_OTP_PWE_SRC),
	PMIC_ENTRY(PMIC_RG_OTP_PROG_PKEY_L),
	PMIC_ENTRY(PMIC_RG_OTP_PROG_PKEY_H),
	PMIC_ENTRY(PMIC_RG_OTP_RD_PKEY_L),
	PMIC_ENTRY(PMIC_RG_OTP_RD_PKEY_H),
	PMIC_ENTRY(PMIC_RG_OTP_RD_TRIG),
	PMIC_ENTRY(PMIC_RG_RD_RDY_BYPASS),
	PMIC_ENTRY(PMIC_RG_SKIP_OTP_OUT),
	PMIC_ENTRY(PMIC_RG_OTP_RD_SW),
	PMIC_ENTRY(PMIC_RG_OTP_DOUT_SW_L),
	PMIC_ENTRY(PMIC_RG_OTP_DOUT_SW_H),
	PMIC_ENTRY(PMIC_RG_OTP_RD_BUSY),
	PMIC_ENTRY(PMIC_RG_OTP_RD_ACK),
	PMIC_ENTRY(PMIC_RG_OTP_PA_SW),
	PMIC_ENTRY(PMIC_RG_OTP_CON_RSV0),
	PMIC_ENTRY(PMIC_TMA_KEY_L),
	PMIC_ENTRY(PMIC_TMA_KEY_H),
	PMIC_ENTRY(PMIC_TOP_MDB_RSV0_L),
	PMIC_ENTRY(PMIC_TOP_MDB_RSV0_H),
	PMIC_ENTRY(PMIC_TOP_MDB_RSV1_L),
	PMIC_ENTRY(PMIC_TOP_MDB_RSV1_H),
	PMIC_ENTRY(PMIC_RG_MDB_DM1_DS_EN),
	PMIC_ENTRY(PMIC_RG_AUTO_LOAD_FORCE),
	PMIC_ENTRY(PMIC_RG_OTP_WRITE_SEL),
	PMIC_ENTRY(PMIC_RG_TOP_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_SCK_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_HK_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_VRC_M_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_VRC_P_MDB_BRIDGE_BYPASS_EN),
	PMIC_ENTRY(PMIC_RG_MDB_BRDG_ACS_SUSPEND),
	PMIC_ENTRY(PMIC_RG_MDB_BRDG_ACS_DEEPIDLE),
	PMIC_ENTRY(PMIC_PLT_WPK_KEY),
	PMIC_ENTRY(PMIC_PLT_WPK_KEY_H),
	PMIC_ENTRY(PMIC_PLT_CFG_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_OSC_128K_TRIM),
	PMIC_ENTRY(PMIC_RG_OTP_EFUSE_RSV),
	PMIC_ENTRY(PMIC_RG_OTP_RDY_DLY_SEL),
	PMIC_ENTRY(PMIC_RG_ELR_A_RSV),
	PMIC_ENTRY(PMIC_RG_ELR_D_RSV),
	PMIC_ENTRY(PMIC_RG_ELR_P_RSV),
	PMIC_ENTRY(PMIC_SPMI_ANA_ID),
	PMIC_ENTRY(PMIC_SPMI_DIG_ID),
	PMIC_ENTRY(PMIC_SPMI_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_SPMI_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_SPMI_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_SPMI_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_SPMI_DSN_CBS),
	PMIC_ENTRY(PMIC_SPMI_DSN_BIX),
	PMIC_ENTRY(PMIC_SPMI_DSN_ESP),
	PMIC_ENTRY(PMIC_SPMI_DSN_FPI),
	PMIC_ENTRY(PMIC_SPMI_DSN_DXI),
	PMIC_ENTRY(PMIC_RG_WDTRSTB_SRC_SEL),
	PMIC_ENTRY(PMIC_RG_SHUTDOWN_SRC_SEL),
	PMIC_ENTRY(PMIC_RG_SRCLKEN0_SRC_SEL),
	PMIC_ENTRY(PMIC_RG_SRCLKEN1_SRC_SEL),
	PMIC_ENTRY(PMIC_RG_SRCLKEN2_SRC_SEL),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_L),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_L_SET),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_L_CLR),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_H),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_H_SET),
	PMIC_ENTRY(PMIC_INT_TYPE_CON0_H_CLR),
	PMIC_ENTRY(PMIC_CPU_INT_STA),
	PMIC_ENTRY(PMIC_MD32_INT_STA),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_SMPS_CLK_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_EN_SMPS_TEST),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_SMPS_CLK_MODE),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_EN_SMPS_TEST),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN2_EN),
	PMIC_ENTRY(PMIC_RG_SRCLKEN_IN3_EN),
	PMIC_ENTRY(PMIC_RG_EXTADR_EXT_REG_RW),
	PMIC_ENTRY(PMIC_RG_EXTADR_REG0_W),
	PMIC_ENTRY(PMIC_RG_EXTADR_REG0_W_H),
	PMIC_ENTRY(PMIC_RG_EXTADR_REG_RW),
	PMIC_ENTRY(PMIC_RG_EXTADR_REG_RW_H),
	PMIC_ENTRY(PMIC_RG_SPMI_RXDATA_MD),
	PMIC_ENTRY(PMIC_RG_SPMI_DLY_SEL),
	PMIC_ENTRY(PMIC_RG_RCS_ENABLE),
	PMIC_ENTRY(PMIC_RG_RCS_ABIT),
	PMIC_ENTRY(PMIC_RG_RCS_CMD),
	PMIC_ENTRY(PMIC_RG_RCS_ID),
	PMIC_ENTRY(PMIC_RG_RCS_ADDR),
	PMIC_ENTRY(PMIC_RG_INT_RCS0),
	PMIC_ENTRY(PMIC_RG_INT_RCS1),
	PMIC_ENTRY(PMIC_RG_INT_RCS1_CLR),
	PMIC_ENTRY(PMIC_RG_PARTY_ERR_CLR),
	PMIC_ENTRY(PMIC_RG_RCS_REQ_WHEN_CHG),
	PMIC_ENTRY(PMIC_RG_GROUP_ID_EN),
	PMIC_ENTRY(PMIC_RG_RCS_RVS0),
	PMIC_ENTRY(PMIC_RG_SPMI_REG_RSV0),
	PMIC_ENTRY(PMIC_RG_SPMI_REG_RSV1),
	PMIC_ENTRY(PMIC_RG_SPMI_REG_RSV2),
	PMIC_ENTRY(PMIC_RG_ADDR_WR_MATCH),
	PMIC_ENTRY(PMIC_RG_ADDR_WR_MATCH_H),
	PMIC_ENTRY(PMIC_RG_ADDR_WR_MASK),
	PMIC_ENTRY(PMIC_RG_ADDR_WR_MASK_H),
	PMIC_ENTRY(PMIC_RG_ADDR_RD_MATCH),
	PMIC_ENTRY(PMIC_RG_ADDR_RD_MATCH_H),
	PMIC_ENTRY(PMIC_RG_ADDR_RD_MASK),
	PMIC_ENTRY(PMIC_RG_ADDR_RD_MASK_H),
	PMIC_ENTRY(PMIC_RG_DATA_WR_MATCH),
	PMIC_ENTRY(PMIC_RG_DATA_WR_MASK),
	PMIC_ENTRY(PMIC_RG_DATA_RD_MATCH),
	PMIC_ENTRY(PMIC_RG_DATA_RD_MASK),
	PMIC_ENTRY(PMIC_RG_SPMI_DBGMUX_OUT_L),
	PMIC_ENTRY(PMIC_RG_SPMI_DBGMUX_OUT_H),
	PMIC_ENTRY(PMIC_RG_SPMI_DBGMUX_SEL),
	PMIC_ENTRY(PMIC_RG_DEBUG_EN_TRIG),
	PMIC_ENTRY(PMIC_RG_DEBUG_DIS_TRIG),
	PMIC_ENTRY(PMIC_RG_SPMI_INT_STS),
	PMIC_ENTRY(PMIC_RG_WR_ADDR_INT_EN),
	PMIC_ENTRY(PMIC_RG_WR_DATA_INT_EN),
	PMIC_ENTRY(PMIC_RG_RD_ADDR_INT_EN),
	PMIC_ENTRY(PMIC_RG_RD_DATA_INT_EN),
	PMIC_ENTRY(PMIC_RG_SPMI_O_DLY_SEL),
	PMIC_ENTRY(PMIC_RG_BUS_IDLE_SEL),
	PMIC_ENTRY(PMIC_RG_BUS_RST_SEL),
	PMIC_ENTRY(PMIC_RG_NAK_RETRY_EN),
	PMIC_ENTRY(PMIC_RG_NAK_RETRY_CNT),
	PMIC_ENTRY(PMIC_RG_SPMI_RSV0),
	PMIC_ENTRY(PMIC_RG_SPMI_RSV1),
	PMIC_ENTRY(PMIC_RG_ADDR2_WR_MATCH),
	PMIC_ENTRY(PMIC_RG_ADDR2_WR_MATCH_H),
	PMIC_ENTRY(PMIC_RG_ADDR2_WR_MASK),
	PMIC_ENTRY(PMIC_RG_ADDR2_WR_MASK_H),
	PMIC_ENTRY(PMIC_RG_ADDR2_RD_MATCH),
	PMIC_ENTRY(PMIC_RG_ADDR2_RD_MATCH_H),
	PMIC_ENTRY(PMIC_RG_ADDR2_RD_MASK),
	PMIC_ENTRY(PMIC_RG_ADDR2_RD_MASK_H),
	PMIC_ENTRY(PMIC_RG_DATA2_WR_MATCH),
	PMIC_ENTRY(PMIC_RG_DATA2_WR_MASK),
	PMIC_ENTRY(PMIC_RG_DATA2_RD_MATCH),
	PMIC_ENTRY(PMIC_RG_DATA2_RD_MASK),
	PMIC_ENTRY(PMIC_RG_SPMI2_DBGMUX_OUT_L),
	PMIC_ENTRY(PMIC_RG_SPMI2_DBGMUX_OUT_H),
	PMIC_ENTRY(PMIC_RG_SPMI2_DBGMUX_SEL),
	PMIC_ENTRY(PMIC_RG_DEBUG2_EN_TRIG),
	PMIC_ENTRY(PMIC_RG_DEBUG2_DIS_TRIG),
	PMIC_ENTRY(PMIC_RG_EXTADR2_EXT_REG_RW),
	PMIC_ENTRY(PMIC_RG_EXTADR2_REG0_W),
	PMIC_ENTRY(PMIC_RG_EXTADR2_REG0_W_H),
	PMIC_ENTRY(PMIC_RG_EXTADR2_REG_RW),
	PMIC_ENTRY(PMIC_RG_EXTADR2_REG_RW_H),
	PMIC_ENTRY(PMIC_RG_SPMI2_RXDATA_MD),
	PMIC_ENTRY(PMIC_RG_SPMI2_DLY_SEL),
	PMIC_ENTRY(PMIC_RG_SPMI2_INT_STS),
	PMIC_ENTRY(PMIC_RG_WR2_ADDR_INT_EN),
	PMIC_ENTRY(PMIC_RG_WR2_DATA_INT_EN),
	PMIC_ENTRY(PMIC_RG_RD2_ADDR_INT_EN),
	PMIC_ENTRY(PMIC_RG_RD2_DATA_INT_EN),
	PMIC_ENTRY(PMIC_RG_SPMI2_O_DLY_SEL),
	PMIC_ENTRY(PMIC_RG_INT_RCS2),
	PMIC_ENTRY(PMIC_RG_INT_RCS2_CLR),
	PMIC_ENTRY(PMIC_RG_PARTY2_ERR_CLR),
	PMIC_ENTRY(PMIC_RG_GROUP2_ID_EN),
	PMIC_ENTRY(PMIC_RG_RCS2_RVS0),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_SCK_TOP_CBS),
	PMIC_ENTRY(PMIC_SCK_TOP_BIX),
	PMIC_ENTRY(PMIC_SCK_TOP_ESP),
	PMIC_ENTRY(PMIC_SCK_TOP_FPI),
	PMIC_ENTRY(PMIC_SCK_TOP_DXI),
	PMIC_ENTRY(PMIC_SCK_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_SCK_TOP_XTAL_SEL),
	PMIC_ENTRY(PMIC_SCK_TOP_RESERVED_L),
	PMIC_ENTRY(PMIC_SCK_TOP_RESERVED_H),
	PMIC_ENTRY(PMIC_XOSC32_ENB_DET),
	PMIC_ENTRY(PMIC_SCK_TOP_TEST_OUT),
	PMIC_ENTRY(PMIC_SCK_TOP_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_SCK_TOP_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_MCLK_PDN),
	PMIC_ENTRY(PMIC_RG_EOSC_CALI_TEST_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_EOSC32_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_MCLK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_2SEC_OFF_DET_PDN),
	PMIC_ENTRY(PMIC_SCK_TOP_CKPDN_CON0_L_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_CKPDN_CON0_L_CLR),
	PMIC_ENTRY(PMIC_RG_SCK32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_0_PDN),
	PMIC_ENTRY(PMIC_RG_RTC32K_1V8_1_PDN),
	PMIC_ENTRY(PMIC_RG_RTC_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_SCK_TOP_CKPDN_CON0_H_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_CKPDN_CON0_H_CLR),
	PMIC_ENTRY(PMIC_RG_RTC_26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_MCLK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_MCLK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_INTRP_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1_L),
	PMIC_ENTRY(PMIC_SCK_TOP_CKHWEN_CON_L_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_CKHWEN_CON_L_CLR),
	PMIC_ENTRY(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_1_H),
	PMIC_ENTRY(PMIC_RG_RTC_CLK_PDN_HWEN_RSV_0),
	PMIC_ENTRY(PMIC_SCK_TOP_CKHWEN_CON_H_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_CKHWEN_CON_H_CLR),
	PMIC_ENTRY(PMIC_RG_RTC_CK_TSTSEL_RSV),
	PMIC_ENTRY(PMIC_RG_RTCDET_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_EOSC_CALI_TEST_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_EOSC32_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_RTC_SWRST),
	PMIC_ENTRY(PMIC_RG_RTC_SEC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_RTC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_RTC_SEC_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_EOSC_CALI_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_SCK_TOP_SWRST),
	PMIC_ENTRY(PMIC_RG_BANK_FQMTR_RST),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_SCK_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_RTC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_RTC),
	PMIC_ENTRY(PMIC_SCK_TOP_POLARITY),
	PMIC_ENTRY(PMIC_EOSC_CALI_START),
	PMIC_ENTRY(PMIC_EOSC_CALI_TD),
	PMIC_ENTRY(PMIC_EOSC_CALI_TEST),
	PMIC_ENTRY(PMIC_EOSC_CALI_DCXO_RDY_TD),
	PMIC_ENTRY(PMIC_FRC_VTCXO0_ON),
	PMIC_ENTRY(PMIC_EOSC_CALI_RSV),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_LPDTB),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_LPDEN),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_PWDB),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDTB),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDEN),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_LPDRST),
	PMIC_ENTRY(PMIC_MIX_XOSC32_STP_CALI),
	PMIC_ENTRY(PMIC_STMP_MODE),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_CHOP_EN),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_LVSH_EN),
	PMIC_ENTRY(PMIC_MIX_PMU_STP_DDLO_VRTC),
	PMIC_ENTRY(PMIC_MIX_PMU_STP_DDLO_VRTC_EN),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_XOSC32_ENB),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_TEST_DEGLITCH_MODE),
	PMIC_ENTRY(PMIC_MIX_EOSC32_STP_RSV),
	PMIC_ENTRY(PMIC_MIX_EOSC32_VCT_EN),
	PMIC_ENTRY(PMIC_MIX_EOSC32_OPT),
	PMIC_ENTRY(PMIC_MIX_DCXO_STP_LVSH_EN_INT),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_COREDETB),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_F32KOB),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_GPO),
	PMIC_ENTRY(PMIC_MIX_RTC_GPIO_OE),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_DEBUG_OUT),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_DEBUG_SEL),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_K_EOSC32_EN),
	PMIC_ENTRY(PMIC_MIX_RTC_STP_EMBCK_SEL),
	PMIC_ENTRY(PMIC_MIX_STP_BBWAKEUP),
	PMIC_ENTRY(PMIC_MIX_STP_RTC_DDLO),
	PMIC_ENTRY(PMIC_MIX_RTC_XOSC32_ENB),
	PMIC_ENTRY(PMIC_MIX_EFUSE_XOSC32_ENB_OPT),
	PMIC_ENTRY(PMIC_RG_RTC_TEST_OUT),
	PMIC_ENTRY(PMIC_RG_RTC_DIG_TEST_IN),
	PMIC_ENTRY(PMIC_RG_RTC_DIG_TEST_MODE),
	PMIC_ENTRY(PMIC_FQMTR_TCKSEL),
	PMIC_ENTRY(PMIC_FQMTR_BUSY),
	PMIC_ENTRY(PMIC_FQMTR_DCXO26M_EN),
	PMIC_ENTRY(PMIC_FQMTR_EN),
	PMIC_ENTRY(PMIC_FQMTR_WINSET_L),
	PMIC_ENTRY(PMIC_FQMTR_WINSET_H),
	PMIC_ENTRY(PMIC_FQMTR_DATA_L),
	PMIC_ENTRY(PMIC_FQMTR_DATA_H),
	PMIC_ENTRY(PMIC_XO_SOC_VOTE_L),
	PMIC_ENTRY(PMIC_XO_SOC_VOTE_H),
	PMIC_ENTRY(PMIC_XO_WCN_VOTE_L),
	PMIC_ENTRY(PMIC_XO_WCN_VOTE_H),
	PMIC_ENTRY(PMIC_XO_NFC_VOTE_L),
	PMIC_ENTRY(PMIC_XO_NFC_VOTE_H),
	PMIC_ENTRY(PMIC_XO_CEL_VOTE_L),
	PMIC_ENTRY(PMIC_XO_CEL_VOTE_H),
	PMIC_ENTRY(PMIC_XO_EXT_VOTE_L),
	PMIC_ENTRY(PMIC_XO_EXT_VOTE_H),
	PMIC_ENTRY(PMIC_XO_MODE_CONN_BT_MASK),
	PMIC_ENTRY(PMIC_XO_BUF_CONN_BT_MASK),
	PMIC_ENTRY(PMIC_RG_RTC_32K1V8_SEL),
	PMIC_ENTRY(PMIC_RG_SCK_32K_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_SCK_32K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RTC_ANA_ID),
	PMIC_ENTRY(PMIC_RTC_DIG_ID),
	PMIC_ENTRY(PMIC_RTC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_CBS),
	PMIC_ENTRY(PMIC_RTC_BIX),
	PMIC_ENTRY(PMIC_RTC_ESP),
	PMIC_ENTRY(PMIC_RTC_FPI),
	PMIC_ENTRY(PMIC_RTC_DXI),
	PMIC_ENTRY(PMIC_BBPU),
	PMIC_ENTRY(PMIC_CLRPKY),
	PMIC_ENTRY(PMIC_RELOAD),
	PMIC_ENTRY(PMIC_CBUSY),
	PMIC_ENTRY(PMIC_ALARM_STATUS),
	PMIC_ENTRY(PMIC_KEY_BBPU),
	PMIC_ENTRY(PMIC_ALSTA),
	PMIC_ENTRY(PMIC_TCSTA),
	PMIC_ENTRY(PMIC_LPSTA),
	PMIC_ENTRY(PMIC_AL_EN),
	PMIC_ENTRY(PMIC_TC_EN),
	PMIC_ENTRY(PMIC_ONESHOT),
	PMIC_ENTRY(PMIC_LP_EN),
	PMIC_ENTRY(PMIC_SECCII),
	PMIC_ENTRY(PMIC_MINCII),
	PMIC_ENTRY(PMIC_HOUCII),
	PMIC_ENTRY(PMIC_DOMCII),
	PMIC_ENTRY(PMIC_DOWCII),
	PMIC_ENTRY(PMIC_MTHCII),
	PMIC_ENTRY(PMIC_YEACII),
	PMIC_ENTRY(PMIC_SECCII_1_2),
	PMIC_ENTRY(PMIC_SECCII_1_4),
	PMIC_ENTRY(PMIC_SECCII_1_8),
	PMIC_ENTRY(PMIC_SEC_MSK),
	PMIC_ENTRY(PMIC_MIN_MSK),
	PMIC_ENTRY(PMIC_HOU_MSK),
	PMIC_ENTRY(PMIC_DOM_MSK),
	PMIC_ENTRY(PMIC_DOW_MSK),
	PMIC_ENTRY(PMIC_MTH_MSK),
	PMIC_ENTRY(PMIC_YEA_MSK),
	PMIC_ENTRY(PMIC_TC_SECOND),
	PMIC_ENTRY(PMIC_TC_MINUTE),
	PMIC_ENTRY(PMIC_TC_HOUR),
	PMIC_ENTRY(PMIC_TC_DOM),
	PMIC_ENTRY(PMIC_TC_DOW),
	PMIC_ENTRY(PMIC_TC_MONTH),
	PMIC_ENTRY(PMIC_RTC_MACRO_ID_L),
	PMIC_ENTRY(PMIC_RTC_MACRO_ID_H),
	PMIC_ENTRY(PMIC_TC_YEAR),
	PMIC_ENTRY(PMIC_AL_SECOND),
	PMIC_ENTRY(PMIC_BBPU_AUTO_PDN_SEL),
	PMIC_ENTRY(PMIC_BBPU_2SEC_CK_SEL),
	PMIC_ENTRY(PMIC_BBPU_2SEC_EN),
	PMIC_ENTRY(PMIC_BBPU_2SEC_MODE),
	PMIC_ENTRY(PMIC_BBPU_2SEC_STAT_CLEAR),
	PMIC_ENTRY(PMIC_BBPU_2SEC_STAT_STA),
	PMIC_ENTRY(PMIC_RTC_LPD_OPT),
	PMIC_ENTRY(PMIC_K_EOSC32_VTCXO_ON_SEL),
	PMIC_ENTRY(PMIC_AL_MINUTE),
	PMIC_ENTRY(PMIC_AL_HOUR),
	PMIC_ENTRY(PMIC_NEW_SPARE0),
	PMIC_ENTRY(PMIC_AL_DOM),
	PMIC_ENTRY(PMIC_NEW_SPARE1),
	PMIC_ENTRY(PMIC_AL_DOW),
	PMIC_ENTRY(PMIC_RG_EOSC_CALI_TD),
	PMIC_ENTRY(PMIC_NEW_SPARE2),
	PMIC_ENTRY(PMIC_AL_MONTH),
	PMIC_ENTRY(PMIC_NEW_SPARE3),
	PMIC_ENTRY(PMIC_AL_YEAR),
	PMIC_ENTRY(PMIC_RTC_K_EOSC_RSV),
	PMIC_ENTRY(PMIC_XOSCCALI),
	PMIC_ENTRY(PMIC_RTC_XOSC32_ENB),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SEL_MODE),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SRC_SEL),
	PMIC_ENTRY(PMIC_RTC_EMBCK_SEL_OPTION),
	PMIC_ENTRY(PMIC_RTC_GPS_CKOUT_EN),
	PMIC_ENTRY(PMIC_RTC_EOSC32_VCT_EN),
	PMIC_ENTRY(PMIC_RTC_EOSC32_CHOP_EN),
	PMIC_ENTRY(PMIC_RTC_GP_OSC32_CON),
	PMIC_ENTRY(PMIC_RTC_REG_XOSC32_ENB),
	PMIC_ENTRY(PMIC_RTC_POWERKEY1_L),
	PMIC_ENTRY(PMIC_RTC_POWERKEY1_H),
	PMIC_ENTRY(PMIC_RTC_POWERKEY2_L),
	PMIC_ENTRY(PMIC_RTC_POWERKEY2_H),
	PMIC_ENTRY(PMIC_RTC_PDN1_L),
	PMIC_ENTRY(PMIC_RTC_PDN1_H),
	PMIC_ENTRY(PMIC_RTC_PDN2_L),
	PMIC_ENTRY(PMIC_RTC_PDN2_H),
	PMIC_ENTRY(PMIC_RTC_SPAR0_L),
	PMIC_ENTRY(PMIC_RTC_SPAR0_H),
	PMIC_ENTRY(PMIC_RTC_SPAR1_L),
	PMIC_ENTRY(PMIC_RTC_SPAR1_H),
	PMIC_ENTRY(PMIC_RTC_PROT_L),
	PMIC_ENTRY(PMIC_RTC_PROT_H),
	PMIC_ENTRY(PMIC_RTC_DIFF_L),
	PMIC_ENTRY(PMIC_RTC_DIFF_H),
	PMIC_ENTRY(PMIC_POWER_DETECTED),
	PMIC_ENTRY(PMIC_K_EOSC32_RSV),
	PMIC_ENTRY(PMIC_CALI_RD_SEL),
	PMIC_ENTRY(PMIC_RTC_CALI_L),
	PMIC_ENTRY(PMIC_RTC_CALI_H),
	PMIC_ENTRY(PMIC_CALI_WR_SEL),
	PMIC_ENTRY(PMIC_K_EOSC32_OVERFLOW),
	PMIC_ENTRY(PMIC_WRTGR),
	PMIC_ENTRY(PMIC_VBAT_LPSTA_RAW),
	PMIC_ENTRY(PMIC_EOSC32_LPEN),
	PMIC_ENTRY(PMIC_XOSC32_LPEN),
	PMIC_ENTRY(PMIC_LPRST),
	PMIC_ENTRY(PMIC_CDBO),
	PMIC_ENTRY(PMIC_F32KOB),
	PMIC_ENTRY(PMIC_GPO),
	PMIC_ENTRY(PMIC_GOE),
	PMIC_ENTRY(PMIC_GSR),
	PMIC_ENTRY(PMIC_GSMT),
	PMIC_ENTRY(PMIC_GPEN),
	PMIC_ENTRY(PMIC_GPU),
	PMIC_ENTRY(PMIC_GE4),
	PMIC_ENTRY(PMIC_GE8),
	PMIC_ENTRY(PMIC_GPI),
	PMIC_ENTRY(PMIC_LPSTA_RAW),
	PMIC_ENTRY(PMIC_DAT0_LOCK),
	PMIC_ENTRY(PMIC_DAT1_LOCK),
	PMIC_ENTRY(PMIC_DAT2_LOCK),
	PMIC_ENTRY(PMIC_RTC_INT_CNT_L),
	PMIC_ENTRY(PMIC_RTC_INT_CNT_H),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT0_L),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT0_H),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT1_L),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT1_H),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT2_L),
	PMIC_ENTRY(PMIC_RTC_SEC_DAT2_H),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_ID),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_ID),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_RTC_SEC_CBS),
	PMIC_ENTRY(PMIC_RTC_SEC_BIX),
	PMIC_ENTRY(PMIC_RTC_SEC_ESP),
	PMIC_ENTRY(PMIC_RTC_SEC_FPI),
	PMIC_ENTRY(PMIC_RTC_SEC_DXI),
	PMIC_ENTRY(PMIC_TC_SECOND_SEC),
	PMIC_ENTRY(PMIC_TC_MINUTE_SEC),
	PMIC_ENTRY(PMIC_TC_HOUR_SEC),
	PMIC_ENTRY(PMIC_TC_DOM_SEC),
	PMIC_ENTRY(PMIC_TC_DOW_SEC),
	PMIC_ENTRY(PMIC_TC_MONTH_SEC),
	PMIC_ENTRY(PMIC_TC_YEAR_SEC),
	PMIC_ENTRY(PMIC_RTC_SEC_CK_PDN),
	PMIC_ENTRY(PMIC_RTC_SEC_WRTGR),
	PMIC_ENTRY(PMIC_DCXO_ANA_ID),
	PMIC_ENTRY(PMIC_DCXO_DIG_ID),
	PMIC_ENTRY(PMIC_DCXO_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DCXO_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DCXO_DSN_CBS),
	PMIC_ENTRY(PMIC_DCXO_DSN_BIX),
	PMIC_ENTRY(PMIC_DCXO_DSN_ESP),
	PMIC_ENTRY(PMIC_DCXO_DSN_FPI),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_MODE),
	PMIC_ENTRY(PMIC_DCXO_CW00_SET),
	PMIC_ENTRY(PMIC_DCXO_CW00_CLR),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_EN_M),
	PMIC_ENTRY(PMIC_XO_BB_LPM_EN_M),
	PMIC_ENTRY(PMIC_XO_ENBB_MAN),
	PMIC_ENTRY(PMIC_XO_ENBB_EN_M),
	PMIC_ENTRY(PMIC_XO_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_DCXO_CW00_H_SET),
	PMIC_ENTRY(PMIC_DCXO_CW00_H_CLR),
	PMIC_ENTRY(PMIC_XO_CLKSEL_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_HV_PBUF_MAN),
	PMIC_ENTRY(PMIC_XO_HV_PBUF_EN_SYNC_M),
	PMIC_ENTRY(PMIC_XO_HV_PBUFBIAS_EN_M),
	PMIC_ENTRY(PMIC_XO_LV_PBUF_MAN),
	PMIC_ENTRY(PMIC_XO_LV_PBUFBIAS_EN_M),
	PMIC_ENTRY(PMIC_XO_LV_PBUF_EN_M),
	PMIC_ENTRY(PMIC_XO_BBLPM_CKSEL_M),
	PMIC_ENTRY(PMIC_XO_EN32K_MAN),
	PMIC_ENTRY(PMIC_XO_EN32K_M),
	PMIC_ENTRY(PMIC_RG_XO_CBANK_POL),
	PMIC_ENTRY(PMIC_XO_XMODE_M),
	PMIC_ENTRY(PMIC_XO_STRUP_MODE),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_CCOMP),
	PMIC_ENTRY(PMIC_XO_PCTAT_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_VTEST_SEL_MUX),
	PMIC_ENTRY(PMIC_XO_SWRST),
	PMIC_ENTRY(PMIC_XO_CBANK_SYNC_DYN),
	PMIC_ENTRY(PMIC_XO_PCTAT_EN_MAN),
	PMIC_ENTRY(PMIC_XO_PMU_CKEN_M),
	PMIC_ENTRY(PMIC_XO_PMU_CKEN_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_CKG_MAN),
	PMIC_ENTRY(PMIC_RG_XO_CORE_LPM_ISEL),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_CKG_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_CKG_EN_M),
	PMIC_ENTRY(PMIC_XO_FPM_ISEL_M),
	PMIC_ENTRY(PMIC_XO_CDAC_FPM),
	PMIC_ENTRY(PMIC_XO_CDAC_LPM),
	PMIC_ENTRY(PMIC_XO_32KDIV_NFRAC_FPM_L),
	PMIC_ENTRY(PMIC_XO_32KDIV_NFRAC_FPM_H),
	PMIC_ENTRY(PMIC_XO_COFST_FPM),
	PMIC_ENTRY(PMIC_XO_32KDIV_NFRAC_LPM_L),
	PMIC_ENTRY(PMIC_XO_32KDIV_NFRAC_LPM_H),
	PMIC_ENTRY(PMIC_XO_COFST_LPM),
	PMIC_ENTRY(PMIC_XO_CORE_MAN),
	PMIC_ENTRY(PMIC_XO_CORE_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_TURBO_EN_SYNC_M),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_IS_EN),
	PMIC_ENTRY(PMIC_XO_STARTUP_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_CMP_GSEL),
	PMIC_ENTRY(PMIC_XO_CORE_VBSEL_SYNC_M),
	PMIC_ENTRY(PMIC_XO_CORE_FPMBIAS_EN_M),
	PMIC_ENTRY(PMIC_XO_CORE_LPMCF_SYNC_FPM),
	PMIC_ENTRY(PMIC_XO_CORE_LPMCF_SYNC_LPM),
	PMIC_ENTRY(PMIC_RG_XO_CORE_LPM_ISEL_MAN),
	PMIC_ENTRY(PMIC_RG_XO_CORE_LPM_IDAC),
	PMIC_ENTRY(PMIC_XO_AAC_CMP_MAN),
	PMIC_ENTRY(PMIC_XO_AAC_EN_M),
	PMIC_ENTRY(PMIC_XO_PMIC_TOP_DIG_SW),
	PMIC_ENTRY(PMIC_XO_CMP_EN_M),
	PMIC_ENTRY(PMIC_XO_AAC_VSEL_M),
	PMIC_ENTRY(PMIC_RG_XO_AAC_X1EN),
	PMIC_ENTRY(PMIC_RG_XO_LVBUF_CKSEL),
	PMIC_ENTRY(PMIC_RG_XO_RFCK_EXTBUF_LP),
	PMIC_ENTRY(PMIC_RG_XO_BBCK_EXTBUF_LP),
	PMIC_ENTRY(PMIC_XO_AAC_FPM_TIME),
	PMIC_ENTRY(PMIC_XO_AAC_ISEL_MAN),
	PMIC_ENTRY(PMIC_XO_AAC_FPM_SWEN),
	PMIC_ENTRY(PMIC_XO_32KDIV_SWRST),
	PMIC_ENTRY(PMIC_XO_32KDIV_RATIO_MAN),
	PMIC_ENTRY(PMIC_XO_32KDIV_TEST_EN),
	PMIC_ENTRY(PMIC_XO_CTL_SYNC_BUF_MAN),
	PMIC_ENTRY(PMIC_RG_XO_HV_PBUF_VSET),
	PMIC_ENTRY(PMIC_DCXO_CW09_SET),
	PMIC_ENTRY(PMIC_DCXO_CW09_CLR),
	PMIC_ENTRY(PMIC_XO_CTL_SYNC_BUF_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_EN_M),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_MODE),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_EN_M),
	PMIC_ENTRY(PMIC_DCXO_CW09_H_SET),
	PMIC_ENTRY(PMIC_DCXO_CW09_H_CLR),
	PMIC_ENTRY(PMIC_XO_MDB_TBO_EN_SEL),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_XO_VIO18PG_BUFEN),
	PMIC_ENTRY(PMIC_XO_CAL_EN_MAN),
	PMIC_ENTRY(PMIC_XO_CAL_EN_M),
	PMIC_ENTRY(PMIC_RG_XO_CORE_OSCTD),
	PMIC_ENTRY(PMIC_XO_THADC_EN),
	PMIC_ENTRY(PMIC_RG_XO_SYNC_CKPOL),
	PMIC_ENTRY(PMIC_RG_XO_CORE_FPM_IDAC),
	PMIC_ENTRY(PMIC_RG_XO_CTL_POL),
	PMIC_ENTRY(PMIC_RG_XO_CTL_SYNC_BYP),
	PMIC_ENTRY(PMIC_RG_XO_VXO22PG_MAN),
	PMIC_ENTRY(PMIC_RG_XO_HV_PBUF_BYP),
	PMIC_ENTRY(PMIC_RG_XO_HV_PBUF_ENCL),
	PMIC_ENTRY(PMIC_RG_XO_CORE_VGBIAS_VSET),
	PMIC_ENTRY(PMIC_XO_CORE_TURBO_EN_SYNC_MAN),
	PMIC_ENTRY(PMIC_RG_XO_HV_PBUF_ISET),
	PMIC_ENTRY(PMIC_RG_XO_HEATER_SEL),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED6),
	PMIC_ENTRY(PMIC_RG_XO_VOW_EN),
	PMIC_ENTRY(PMIC_RG_XO_LV_PBUF_ISET),
	PMIC_ENTRY(PMIC_RG_XO_LV_PBUF_FPMISET),
	PMIC_ENTRY(PMIC_XO_BB_LPM_EN_SEL),
	PMIC_ENTRY(PMIC_XO_EXTBUF1_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF3_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF4_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF6_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_XO_EXTBUF7_BBLPM_EN_MASK),
	PMIC_ENTRY(PMIC_RG_XO_DIG26M_DIV4_32KDIV),
	PMIC_ENTRY(PMIC_RG_XO_BBLPM_FREQ_FPM),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF2_INV),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF3_INV),
	PMIC_ENTRY(PMIC_XO_THADC_EN_MAN),
	PMIC_ENTRY(PMIC_XO_EXTBUF2_CLKSEL_MAN),
	PMIC_ENTRY(PMIC_RG_XO_AUDIO_EN),
	PMIC_ENTRY(PMIC_RG_XO_AUDIO_ATTEN),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF2_SRSEL),
	PMIC_ENTRY(PMIC_RG_XO_DIG26M_DEGLITCH),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF4_SRSEL),
	PMIC_ENTRY(PMIC_RG_XO_DIG26M_DIV2_SW_MAN),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF1_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF3_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF6_HD),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF7_HD),
	PMIC_ENTRY(PMIC_XO_STA_CTL_MAN),
	PMIC_ENTRY(PMIC_XO_STA_CTL_M),
	PMIC_ENTRY(PMIC_XO_VBBCK_EN_MAN),
	PMIC_ENTRY(PMIC_XO_VBBCK_EN_M),
	PMIC_ENTRY(PMIC_XO_VRFCK_EN_MAN),
	PMIC_ENTRY(PMIC_XO_VRFCK_EN_M),
	PMIC_ENTRY(PMIC_XO_RESERVED2),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED1),
	PMIC_ENTRY(PMIC_RG_XO_RESERVED2),
	PMIC_ENTRY(PMIC_XO_STATIC_AUXOUT_SEL),
	PMIC_ENTRY(PMIC_XO_AUXOUT_SEL_L),
	PMIC_ENTRY(PMIC_XO_AUXOUT_SEL_H),
	PMIC_ENTRY(PMIC_XO_STATIC_AUXOUT_L),
	PMIC_ENTRY(PMIC_XO_STATIC_AUXOUT_H),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_BG_EN),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_RPTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_IPTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_ICTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_RCTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_CBANK_SYNC_BYP),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_VCTAT_SEL),
	PMIC_ENTRY(PMIC_RG_XO_PCTAT_VTEMP),
	PMIC_ENTRY(PMIC_RG_XO_CORE_LPM_PMICBIAS),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF1_RSEL),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF2_RSEL),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF7_RSEL),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF3_RSEL),
	PMIC_ENTRY(PMIC_RG_XO_EXTBUF4_RSEL),
	PMIC_ENTRY(PMIC_DCXO_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_XO_DIG26M_DIV2),
	PMIC_ENTRY(PMIC_XO_PWRKEY_RSTB_SEL),
	PMIC_ENTRY(PMIC_XO_ELR_RESERVED),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSC_TOP_CBS),
	PMIC_ENTRY(PMIC_PSC_TOP_BIX),
	PMIC_ENTRY(PMIC_PSC_TOP_ESP),
	PMIC_ENTRY(PMIC_PSC_TOP_FPI),
	PMIC_ENTRY(PMIC_PSC_TOP_DXI),
	PMIC_ENTRY(PMIC_PSC_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_PSC_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_CHRDET_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_RST),
	PMIC_ENTRY(PMIC_RG_PSEQ_PWRMSK_RST_SEL),
	PMIC_ENTRY(PMIC_BANK_STRUP_SWRST),
	PMIC_ENTRY(PMIC_BANK_PSEQ_SWRST),
	PMIC_ENTRY(PMIC_BANK_CHRDET_SWRST),
	PMIC_ENTRY(PMIC_RG_CHRDET_RST),
	PMIC_ENTRY(PMIC_RG_INT_EN_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_EN_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_EN_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_EN_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_EN_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_EN_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_EN_CHRDET_LEVEL),
	PMIC_ENTRY(PMIC_PSC_INT_CON0_SET),
	PMIC_ENTRY(PMIC_PSC_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_MASK_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_MASK_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_MASK_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_MASK_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_MASK_CHRDET_LEVEL),
	PMIC_ENTRY(PMIC_PSC_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_PSC_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_CHRDET_LEVEL),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_PWRKEY),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_HOMEKEY),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_PWRKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_HOMEKEY_R),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_NI_LBAT_INT),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_CHRDET_EDGE),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_CHRDET_LEVEL),
	PMIC_ENTRY(PMIC_RG_PSC_INT_POLARITY),
	PMIC_ENTRY(PMIC_RG_HOMEKEY_INT_SEL),
	PMIC_ENTRY(PMIC_RG_PWRKEY_INT_SEL),
	PMIC_ENTRY(PMIC_INT_MISC_CON_SET),
	PMIC_ENTRY(PMIC_INT_MISC_CON_CLR),
	PMIC_ENTRY(PMIC_RG_PSC_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_STRUP_ANA_ID),
	PMIC_ENTRY(PMIC_STRUP_DIG_ID),
	PMIC_ENTRY(PMIC_STRUP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_STRUP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_STRUP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_STRUP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_STRUP_CBS),
	PMIC_ENTRY(PMIC_STRUP_BIX),
	PMIC_ENTRY(PMIC_STRUP_ESP),
	PMIC_ENTRY(PMIC_STRUP_FPI),
	PMIC_ENTRY(PMIC_STRUP_DXI),
	PMIC_ENTRY(PMIC_RG_TM_OUT),
	PMIC_ENTRY(PMIC_RGS_ANA_CHIP_ID),
	PMIC_ENTRY(PMIC_RG_THRDET_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_THR_SEL),
	PMIC_ENTRY(PMIC_RG_THR_TMODE),
	PMIC_ENTRY(PMIC_RG_VREF_BG),
	PMIC_ENTRY(PMIC_RG_TS_BJT_EN),
	PMIC_ENTRY(PMIC_RG_RST_DRVSEL),
	PMIC_ENTRY(PMIC_RG_EXT_EN_DRVSEL),
	PMIC_ENTRY(PMIC_RG_PMU_RSV1),
	PMIC_ENTRY(PMIC_RG_PMU_RSV2),
	PMIC_ENTRY(PMIC_RGS_VXO22_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VAUX18_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_RFDIG_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VA12_1_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_CORE_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VA12_2_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VIO18_1_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VIO18_2_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VRFCK_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VBBCK_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMDD2_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMDDR_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMDDQ_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VUSB_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_PROC_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VEMC_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMD11_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMD12_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VRFDIG_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VCORE_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_MD_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VS1_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VS2_PG_STATUS),
	PMIC_ENTRY(PMIC_RGS_VS3_PG_STATUS),
	PMIC_ENTRY(PMIC_STRUP_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_STRUP_IREF_TRIM),
	PMIC_ENTRY(PMIC_RG_THR_LOC_SEL),
	PMIC_ENTRY(PMIC_RG_THR1_140_TRIM),
	PMIC_ENTRY(PMIC_RG_THR1_RSV0),
	PMIC_ENTRY(PMIC_RG_THR1_110_TRIM),
	PMIC_ENTRY(PMIC_RG_THR1_RSV1),
	PMIC_ENTRY(PMIC_RG_THR2_140_TRIM),
	PMIC_ENTRY(PMIC_RG_THR2_RSV0),
	PMIC_ENTRY(PMIC_RG_THR2_110_TRIM),
	PMIC_ENTRY(PMIC_RG_THR2_RSV1),
	PMIC_ENTRY(PMIC_RG_THR3_140_TRIM),
	PMIC_ENTRY(PMIC_RG_THR3_RSV0),
	PMIC_ENTRY(PMIC_RG_THR3_110_TRIM),
	PMIC_ENTRY(PMIC_RG_THR3_RSV1),
	PMIC_ENTRY(PMIC_RG_THR4_140_TRIM),
	PMIC_ENTRY(PMIC_RG_THR4_RSV0),
	PMIC_ENTRY(PMIC_RG_THR4_110_TRIM),
	PMIC_ENTRY(PMIC_RG_THR4_RSV1),
	PMIC_ENTRY(PMIC_PSEQ_ANA_ID),
	PMIC_ENTRY(PMIC_PSEQ_DIG_ID),
	PMIC_ENTRY(PMIC_PSEQ_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_PSEQ_CBS),
	PMIC_ENTRY(PMIC_PSEQ_BIX),
	PMIC_ENTRY(PMIC_PSEQ_ESP),
	PMIC_ENTRY(PMIC_PSEQ_FPI),
	PMIC_ENTRY(PMIC_PSEQ_DXI),
	PMIC_ENTRY(PMIC_RG_PWRHOLD),
	PMIC_ENTRY(PMIC_RG_USBDL_MODE),
	PMIC_ENTRY(PMIC_RG_WDTRST_ACT),
	PMIC_ENTRY(PMIC_RG_CRST),
	PMIC_ENTRY(PMIC_RG_WRST),
	PMIC_ENTRY(PMIC_RG_CRST_INTV),
	PMIC_ENTRY(PMIC_RG_WRST_INTV),
	PMIC_ENTRY(PMIC_RG_WDTRST_EN),
	PMIC_ENTRY(PMIC_RG_KEYPWR_VCORE_OPT),
	PMIC_ENTRY(PMIC_RG_KEYPWR_VCORE_SEL),
	PMIC_ENTRY(PMIC_RG_RSV_SWREG),
	PMIC_ENTRY(PMIC_RG_STRUP_THR_CLR),
	PMIC_ENTRY(PMIC_RG_UVLO_DEC_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_RTCA_CTRL),
	PMIC_ENTRY(PMIC_RG_SMART_RST_SDN_EN),
	PMIC_ENTRY(PMIC_RG_SMART_RST_MODE),
	PMIC_ENTRY(PMIC_RG_PWRRST_TMR_DIS),
	PMIC_ENTRY(PMIC_RG_PWRKEY_KEY_MODE),
	PMIC_ENTRY(PMIC_RG_PWRKEY_RST_EN),
	PMIC_ENTRY(PMIC_RG_PWRKEY_RST_TD),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_TD),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_CHR_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_PWRKEY_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_EXT_SPAR_CTRL),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRKEY_COUNT_RESET),
	PMIC_ENTRY(PMIC_PWRKEY_LONG_PRESS_COUNT),
	PMIC_ENTRY(PMIC_PUP_PKEY_RELEASE),
	PMIC_ENTRY(PMIC_PWRKEY_LONG_PRESS_COUNT_H),
	PMIC_ENTRY(PMIC_RG_POR_FLAG),
	PMIC_ENTRY(PMIC_USBDL),
	PMIC_ENTRY(PMIC_JUST_SMART_RST),
	PMIC_ENTRY(PMIC_JUST_PWRKEY_RST),
	PMIC_ENTRY(PMIC_RG_CLR_JUST_SMART_RST),
	PMIC_ENTRY(PMIC_CLR_JUST_RST),
	PMIC_ENTRY(PMIC_RG_STRUP_THER_DEB_RTD),
	PMIC_ENTRY(PMIC_RG_STRUP_THER_DEB_FTD),
	PMIC_ENTRY(PMIC_DA_EXT_PMIC_EN1),
	PMIC_ENTRY(PMIC_DA_EXT_PMIC_EN2),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_PG_DEBTD),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_SEL),
	PMIC_ENTRY(PMIC_RGS_EXT_PMIC_PG),
	PMIC_ENTRY(PMIC_RG_RTC_SPAR_DEB_EN),
	PMIC_ENTRY(PMIC_RG_RTC_ALARM_DEB_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_RFDIG_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFDIG_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_MD_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VMD12_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VMD11_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VS3_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUX18_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VBBCK_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_CORE_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VS2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VEMC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VUSB_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDDQ_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDDR_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_EN_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDD2_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFCK_PG_H2L_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFDIG_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_MD_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMD12_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMD11_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS3_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUX18_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VXO22_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_2_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_1_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_1_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_CORE_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_2_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS2_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_RFDIG_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VUSB_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDDQ_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDDR_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_EN_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDD2_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFCK_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VBBCK_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VEMC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFDIG_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_MD_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMD12_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMD11_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VCORE_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS3_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VAUX18_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VXO22_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_2_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VIO18_1_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_1_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_CORE_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VA12_2_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS1_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VS2_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_RFDIG_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VEMC_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VSRAM_PROC_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VUSB_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDDQ_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDDR_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VMDD2_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VRFCK_OC_ENB),
	PMIC_ENTRY(PMIC_RG_STRUP_VBBCK_OC_ENB),
	PMIC_ENTRY(PMIC_RG_PSEQ_FORCE_ON),
	PMIC_ENTRY(PMIC_RG_PSEQ_FORCE_TEST_EN),
	PMIC_ENTRY(PMIC_RG_PSEQ_BYPASS_DEB),
	PMIC_ENTRY(PMIC_RG_PSEQ_BYPASS_SEQ),
	PMIC_ENTRY(PMIC_RG_PSEQ_LPBWDT_ACC),
	PMIC_ENTRY(PMIC_RG_PSEQ_FORCE_ALL_DOFF),
	PMIC_ENTRY(PMIC_RG_PSEQ_PG_CK_SEL),
	PMIC_ENTRY(PMIC_RG_PSEQ_SPAR_XCPT_MASK),
	PMIC_ENTRY(PMIC_RG_PSEQ_RTCA_XCPT_MASK),
	PMIC_ENTRY(PMIC_RG_THM_SHDN_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_UVLO_U1U2_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_UVLO_U1U2_SEL_SWCTRL),
	PMIC_ENTRY(PMIC_RG_OVLO_RDB_TD),
	PMIC_ENTRY(PMIC_RG_OVLO_RDB_EN),
	PMIC_ENTRY(PMIC_RG_THR_TEST),
	PMIC_ENTRY(PMIC_RG_STRUP_ENVTEM),
	PMIC_ENTRY(PMIC_RG_STRUP_ENVTEM_CTRL),
	PMIC_ENTRY(PMIC_RG_BIASGEN_FORCE),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRON),
	PMIC_ENTRY(PMIC_RG_STRUP_PWRON_SEL),
	PMIC_ENTRY(PMIC_RG_BIASGEN),
	PMIC_ENTRY(PMIC_RG_BIASGEN_SEL),
	PMIC_ENTRY(PMIC_RG_DCXO_PMU_CKEN),
	PMIC_ENTRY(PMIC_RG_DCXO_PMU_CKEN_SEL),
	PMIC_ENTRY(PMIC_STRUP_DIG_IO_PG_FORCE),
	PMIC_ENTRY(PMIC_DDUVLO_DEB_EN),
	PMIC_ENTRY(PMIC_RG_STRUP_FT_CTRL),
	PMIC_ENTRY(PMIC_RG_ATST_PG_CHK),
	PMIC_ENTRY(PMIC_RG_STRUP_PG_DEB_MODE),
	PMIC_ENTRY(PMIC_RG_OVLO_FCMPL_SW_SEL),
	PMIC_ENTRY(PMIC_RG_OVLO_FCMPL_SW),
	PMIC_ENTRY(PMIC_RG_UVLO_VSYS_VTH_SW_SEL),
	PMIC_ENTRY(PMIC_RG_UVLO_VSYS_VTH_SW),
	PMIC_ENTRY(PMIC_RG_CPS_W_KEY),
	PMIC_ENTRY(PMIC_RG_CPS_W_KEY_H),
	PMIC_ENTRY(PMIC_RG_SLOT_INTV_DOWN),
	PMIC_ENTRY(PMIC_RG_DSEQ_LEN),
	PMIC_ENTRY(PMIC_RG_VXO22_DSA),
	PMIC_ENTRY(PMIC_RG_VAUX18_DSA),
	PMIC_ENTRY(PMIC_RG_VS3_DSA),
	PMIC_ENTRY(PMIC_RG_VCORE_DSA),
	PMIC_ENTRY(PMIC_RG_VMD11_DSA),
	PMIC_ENTRY(PMIC_RG_VMD12_DSA),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_DSA),
	PMIC_ENTRY(PMIC_RG_VRFDIG_DSA),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_DSA),
	PMIC_ENTRY(PMIC_RG_VS2_DSA),
	PMIC_ENTRY(PMIC_RG_VS1_DSA),
	PMIC_ENTRY(PMIC_RG_VA12_1_DSA),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_DSA),
	PMIC_ENTRY(PMIC_RG_VA12_2_DSA),
	PMIC_ENTRY(PMIC_RG_VIO18_1_DSA),
	PMIC_ENTRY(PMIC_RG_VIO18_2_DSA),
	PMIC_ENTRY(PMIC_RG_VBBCK_DSA),
	PMIC_ENTRY(PMIC_RG_VRFCK_DSA),
	PMIC_ENTRY(PMIC_RG_VMDD2_DSA),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_EN_DSA),
	PMIC_ENTRY(PMIC_RG_VMDDR_DSA),
	PMIC_ENTRY(PMIC_RG_VMDDQ_DSA),
	PMIC_ENTRY(PMIC_RG_VUSB_DSA),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_DSA),
	PMIC_ENTRY(PMIC_RG_VEMC_DSA),
	PMIC_ENTRY(PMIC_PSEQ_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BWDT_EN),
	PMIC_ENTRY(PMIC_RG_BWDT_TSEL),
	PMIC_ENTRY(PMIC_RG_BWDT_CSEL),
	PMIC_ENTRY(PMIC_RG_BWDT_TD),
	PMIC_ENTRY(PMIC_RG_BWDT_CHRTD),
	PMIC_ENTRY(PMIC_RG_BWDT_DDLO_TD),
	PMIC_ENTRY(PMIC_RG_SLOT_INTV_UP),
	PMIC_ENTRY(PMIC_RG_SEQ_LEN),
	PMIC_ENTRY(PMIC_RG_PSEQ_ELR_RSV0),
	PMIC_ENTRY(PMIC_RG_PSPG_SHDN_ENB),
	PMIC_ENTRY(PMIC_RG_PSEQ_F32K_FORCE),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_PG_CHK_SEL),
	PMIC_ENTRY(PMIC_RG_STRUP_LONG_PRESS_RESET_EXTEND),
	PMIC_ENTRY(PMIC_RG_CPS_S0EXT_ENB),
	PMIC_ENTRY(PMIC_RG_CPS_S0EXT_TD),
	PMIC_ENTRY(PMIC_RG_SDN_DLY_ENB),
	PMIC_ENTRY(PMIC_RG_CHRDET_DEB_TD),
	PMIC_ENTRY(PMIC_RG_PWRKEY_EVENT_MODE),
	PMIC_ENTRY(PMIC_RG_PWRKEY_EVENT_MODE_HW),
	PMIC_ENTRY(PMIC_RG_LDO_PG_STB_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_PG_STB_MODE),
	PMIC_ENTRY(PMIC_RG_STRUP_EXT_PMIC_PG_ENB),
	PMIC_ENTRY(PMIC_RG_PSC_ELR1_RSV1),
	PMIC_ENTRY(PMIC_RG_PMIC_RESETB_DEB_OPT),
	PMIC_ENTRY(PMIC_RG_PMIC_RESETB_SHDN_EN),
	PMIC_ENTRY(PMIC_RG_IVGEN_1MS_SYNC_OPT),
	PMIC_ENTRY(PMIC_RG_EN_FUNC_DISABLE),
	PMIC_ENTRY(PMIC_RG_PMIC_RESETB_FUNC_DISABLE),
	PMIC_ENTRY(PMIC_RG_PG_DEB_SEL),
	PMIC_ENTRY(PMIC_RG_PSC_ELR_RSV1),
	PMIC_ENTRY(PMIC_RG_VXO22_USA),
	PMIC_ENTRY(PMIC_RG_VAUX18_USA),
	PMIC_ENTRY(PMIC_RG_VS3_USA),
	PMIC_ENTRY(PMIC_RG_VCORE_USA),
	PMIC_ENTRY(PMIC_RG_VMD11_USA),
	PMIC_ENTRY(PMIC_RG_VMD12_USA),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_USA),
	PMIC_ENTRY(PMIC_RG_VRFDIG_USA),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_USA),
	PMIC_ENTRY(PMIC_RG_VS2_USA),
	PMIC_ENTRY(PMIC_RG_VS1_USA),
	PMIC_ENTRY(PMIC_RG_VA12_1_USA),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_USA),
	PMIC_ENTRY(PMIC_RG_VA12_2_USA),
	PMIC_ENTRY(PMIC_RG_VIO18_1_USA),
	PMIC_ENTRY(PMIC_RG_VIO18_2_USA),
	PMIC_ENTRY(PMIC_RG_VBBCK_USA),
	PMIC_ENTRY(PMIC_RG_VRFCK_USA),
	PMIC_ENTRY(PMIC_RG_VMDD2_USA),
	PMIC_ENTRY(PMIC_RG_EXT_PMIC_EN_USA),
	PMIC_ENTRY(PMIC_RG_VMDDR_USA),
	PMIC_ENTRY(PMIC_RG_VMDDQ_USA),
	PMIC_ENTRY(PMIC_RG_VUSB_USA),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_USA),
	PMIC_ENTRY(PMIC_RG_VEMC_USA),
	PMIC_ENTRY(PMIC_CHRDET_ANA_ID),
	PMIC_ENTRY(PMIC_CHRDET_DIG_ID),
	PMIC_ENTRY(PMIC_CHRDET_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_CHRDET_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_CHRDET_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_CHRDET_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_CHRDET_CBS),
	PMIC_ENTRY(PMIC_CHRDET_BIX),
	PMIC_ENTRY(PMIC_CHRDET_ESP),
	PMIC_ENTRY(PMIC_CHRDET_FPI),
	PMIC_ENTRY(PMIC_CHRDET_DXI),
	PMIC_ENTRY(PMIC_RGS_CHRDET),
	PMIC_ENTRY(PMIC_AD_VDET_DET),
	PMIC_ENTRY(PMIC_RG_VDET_DEB_BYPASS),
	PMIC_ENTRY(PMIC_RG_ENVTEM_D),
	PMIC_ENTRY(PMIC_RG_ENVTEM_EN),
	PMIC_ENTRY(PMIC_DA_QI_BGR_EXT_BUF_EN),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_RSTB),
	PMIC_ENTRY(PMIC_RG_BGR_TEST_EN),
	PMIC_ENTRY(PMIC_RG_BGR_UNCHOP),
	PMIC_ENTRY(PMIC_RG_BGR_UNCHOP_PH),
	PMIC_ENTRY(PMIC_RG_UVLO_VTHL),
	PMIC_ENTRY(PMIC_RG_LBAT_INT_VTH),
	PMIC_ENTRY(PMIC_RG_OVLO_VTH_SEL),
	PMIC_ENTRY(PMIC_RG_PCHR_RV),
	PMIC_ENTRY(PMIC_CHRDET_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BGR_TRIM),
	PMIC_ENTRY(PMIC_RG_BGR_TRIM_LSB),
	PMIC_ENTRY(PMIC_RG_BGR_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_BGR_RSEL),
	PMIC_ENTRY(PMIC_RG_OVLO_EN),
	PMIC_ENTRY(PMIC_RG_VDET_VTH_TRIM),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_PCAS_EN),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_NCAS_EN),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_EN),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_BIAS_SELECT),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_SIZE_SELECT),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_RSV),
	PMIC_ENTRY(PMIC_RG_FGD_BGR_CURRENT_TRIM),
	PMIC_ENTRY(PMIC_RG_VDET_DEB_L2H_DBTIME),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_HK_TOP_CBS),
	PMIC_ENTRY(PMIC_HK_TOP_BIX),
	PMIC_ENTRY(PMIC_HK_TOP_ESP),
	PMIC_ENTRY(PMIC_HK_TOP_FPI),
	PMIC_ENTRY(PMIC_HK_TOP_DXI),
	PMIC_ENTRY(PMIC_HK_CLK_OFFSET),
	PMIC_ENTRY(PMIC_HK_RST_OFFSET),
	PMIC_ENTRY(PMIC_HK_INT_OFFSET),
	PMIC_ENTRY(PMIC_HK_INT_LEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_HK_INTRP_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_HK_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_SDMADC_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_SDMADC_CK_PDN),
	PMIC_ENTRY(PMIC_RG_SDMADC_DIG_CK_PDN),
	PMIC_ENTRY(PMIC_RG_AUXADC_26M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_1M_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_AUXADC_32K_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_SDMADC_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_HK_INTRP_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_SDM_CK_TSTSEL),
	PMIC_ENTRY(PMIC_RG_SDM_CK_TST_DIS),
	PMIC_ENTRY(PMIC_RG_AUXADC_RST),
	PMIC_ENTRY(PMIC_RG_AUXADC_REG_RST),
	PMIC_ENTRY(PMIC_BANK_HK_TOP_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_1_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_2_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_3_SWRST),
	PMIC_ENTRY(PMIC_BANK_AUXADC_DIG_4_SWRST),
	PMIC_ENTRY(PMIC_RG_SDMADC_RST),
	PMIC_ENTRY(PMIC_RG_SDMADC_REG_RST),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT2_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT2_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_RG_INT_EN_THR_H),
	PMIC_ENTRY(PMIC_RG_INT_EN_THR_L),
	PMIC_ENTRY(PMIC_HK_INT_CON0_SET),
	PMIC_ENTRY(PMIC_HK_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_EN_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_HK_INT_CON1_SET),
	PMIC_ENTRY(PMIC_HK_INT_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT2_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT2_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_RG_INT_MASK_THR_H),
	PMIC_ENTRY(PMIC_RG_INT_MASK_THR_L),
	PMIC_ENTRY(PMIC_HK_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_HK_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_MASK_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_HK_INT_MASK_CON1_SET),
	PMIC_ENTRY(PMIC_HK_INT_MASK_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT2_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT2_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_THR_H),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_THR_L),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT2_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT2_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_THR_H),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_THR_L),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_AUXADC_IMP),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_NAG_C_DLTV),
	PMIC_ENTRY(PMIC_RG_HK_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_HK_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_RG_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_EXT_BATON_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_RG_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_DIFFBUF_SWEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_DIFFBUF_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_VBAT_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_DA_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_DA_ADCIN_BATID_SW_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_DIFFBUF_EN),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_RPCNT_MAX),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_START_SW),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_RSTB_SW),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_START_SEL),
	PMIC_ENTRY(PMIC_RG_HK_STRUP_AUXADC_RSTB_SEL),
	PMIC_ENTRY(PMIC_RG_VAUX18_AUXADC_STB_SWEN),
	PMIC_ENTRY(PMIC_RG_VAUX18_AUXADC_STB_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_AUXADC_ACK_SWEN),
	PMIC_ENTRY(PMIC_RG_VAUX18_AUXADC_ACK_EN),
	PMIC_ENTRY(PMIC_RG_VBIF28_AUXADC_STB_SWEN),
	PMIC_ENTRY(PMIC_RG_VBIF28_AUXADC_STB_EN),
	PMIC_ENTRY(PMIC_RG_VBIF28_AUXADC_ACK_SWEN),
	PMIC_ENTRY(PMIC_RG_VBIF28_AUXADC_ACK_EN),
	PMIC_ENTRY(PMIC_DD_AUXADC_VAUX18_REQ),
	PMIC_ENTRY(PMIC_DD_VAUX18_AUXADC_STB),
	PMIC_ENTRY(PMIC_DD_AUXADC_VAUX18_PWDB),
	PMIC_ENTRY(PMIC_DD_VAUX18_AUXADC_ACK),
	PMIC_ENTRY(PMIC_DD_AUXADC_VBIF28_REQ),
	PMIC_ENTRY(PMIC_DD_VBIF28_AUXADC_STB),
	PMIC_ENTRY(PMIC_DD_AUXADC_VBIF28_PWDB),
	PMIC_ENTRY(PMIC_DD_VBIF28_AUXADC_ACK),
	PMIC_ENTRY(PMIC_HK_AUXADC_KEY_L),
	PMIC_ENTRY(PMIC_HK_AUXADC_KEY_H),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_RAW_0),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_RAW_1),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_RAW_2),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_LIMIT_0),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_LIMIT_1),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_LIMIT_2),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_PRE_L),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_PRE_H),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_L),
	PMIC_ENTRY(PMIC_RGS_SDMADC_OUT_CIC_LATCH_H),
	PMIC_ENTRY(PMIC_DA_AUXADC_INTRES_LT_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_INTRES_NT_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_INTRES_HT_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_CH7_NTC1_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_CH7_NTC2_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_CH7_NTC3_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_CH7_NTC4_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_CH7_NTC5_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_THERMAL_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_SDMADC_VREF_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_SDMADC_ADC_EN),
	PMIC_ENTRY(PMIC_DA_AUXADC_SDMADC_INT_RST_EN),
	PMIC_ENTRY(PMIC_DD_AUXADC_SDMADC_DATAOUT),
	PMIC_ENTRY(PMIC_AD_AUXADC_SDMADC_DOUT),
	PMIC_ENTRY(PMIC_RG_SDMADC_DOUT_SWEN),
	PMIC_ENTRY(PMIC_RG_SDMADC_DOUT),
	PMIC_ENTRY(PMIC_RG_SDMADC_SHADE_PRD),
	PMIC_ENTRY(PMIC_RG_SDMADC_SHADE_PRD_SWEN),
	PMIC_ENTRY(PMIC_RG_SDMADC_CONVERT_PRD),
	PMIC_ENTRY(PMIC_RG_SDMADC_CONVERT_PRD_SWEN),
	PMIC_ENTRY(PMIC_AUXADC_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_DSN_DXI),
	PMIC_ENTRY(PMIC_RG_AUX_RSV0),
	PMIC_ENTRY(PMIC_RG_AUX_RSV1),
	PMIC_ENTRY(PMIC_RG_AUXADC_CALI),
	PMIC_ENTRY(PMIC_RG_VBUF_BYP),
	PMIC_ENTRY(PMIC_RG_VBUF_CALEN),
	PMIC_ENTRY(PMIC_RG_VBUF_EXTEN),
	PMIC_ENTRY(PMIC_RG_AUXADC_RNG_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_NOISE_RES),
	PMIC_ENTRY(PMIC_RG_AUXADC_INTRES_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_INTRES_TCTRIM_LT),
	PMIC_ENTRY(PMIC_RG_AUXADC_INTRES_TCTRIM_NT),
	PMIC_ENTRY(PMIC_RG_AUXADC_INTRES_TCTRIM_HT),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_MODE_CLK),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_MODE_1),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_MODE_2),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_BIAS_CALI),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_CHOPPER_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_DWA_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_CHOPRATE),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_INPUT_VCM_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_INPUT_AIN_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_INPUT_AMP_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_DITHER_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_SDMADC_DITHER_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_EFUSE_AUXADC_NDIF_EN),
	PMIC_ENTRY(PMIC_RG_AUXADC_INTRES_DCTRIM_LT),
	PMIC_ENTRY(PMIC_RG_AUXADC_INTRES_DCTRIM_NT),
	PMIC_ENTRY(PMIC_RG_AUXADC_INTRES_DCTRIM_HT),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_DIG_1_DSN_DXI),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH2_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH2_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH3_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH3_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH5_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH5_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH5),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH6_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH6_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH6),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH8_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH8_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH8),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH9_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH9_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH9),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH10_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH10_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH10),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH11_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH11_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH11),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH14_15_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH14_15_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH14_15),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_GPS_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_MD_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_MD_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_AP_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH7_BY_AP_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH7_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_MD_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_MD_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_PWRON_PCHR_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_PWRON_PCHR_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_WAKEUP_PCHR_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_MD_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_MD_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_AP_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH0_BY_AP_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH0_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_MD_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_MD_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_AP_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH1_BY_AP_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH1_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_FGADC_PCHR_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_FGADC_PCHR_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_PLUGIN_PCHR_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_RAW_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_RAW_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_GPS_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_MD_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_BY_AP_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_BY_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BATID_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BATID_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR1_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR1_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_THR1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR2_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR2_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_THR2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR3_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH4_BY_THR3_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH4_BY_THR3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_NTCT0_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_NTCT0_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH12_NTCT0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_NTCT1_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_NTCT1_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH12_NTCT1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_NTCT2_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_NTCT2_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH12_NTCT2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_NTCT3_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH12_NTCT3_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH12_NTCT3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH13_EXT0_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH13_EXT0_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH13_EXT0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH13_EXT1_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_CH13_EXT1_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_CH13_EXT1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_NAG_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_NAG_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_NAG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP_AVG_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_IMP_AVG_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_IMP_AVG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT2_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_LBAT2_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_LBAT2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_TEMP_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_BAT_TEMP_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_THR_HW_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_THR_HW_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_THR_HW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_MDRT_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_MDRT_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_MDRT_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_OUT_DCXO_MDRT_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_DCXO_MDRT),
	PMIC_ENTRY(PMIC_SDMADC_ADC_OUT_CH0_L),
	PMIC_ENTRY(PMIC_SDMADC_ADC_OUT_CH0_H),
	PMIC_ENTRY(PMIC_SDMADC_ADC_RDY_CH0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_L),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_H),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS_AP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_GPS),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR_MD),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_PLUGIN_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_FGADC_PCHR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BATID),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_PWRON),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_DCXO_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_MDRT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_THR_HW),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_LBAT2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_IMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_NAG),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_CH12_NTCT0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_CH12_NTCT1),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_CH12_NTCT2),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_CH12_NTCT3),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_CH13_EXT0),
	PMIC_ENTRY(PMIC_AUXADC_ADC_BUSY_IN_CH13_EXT1),
	PMIC_ENTRY(PMIC_SDMADC_ADC_BUSY_IN_CH0),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_DIG_2_DSN_DXI),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH0),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH2),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH3),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH5),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH6),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH8),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH9),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH10),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH11),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH12),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH13),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH14),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH15),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH0_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH1_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH7_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_RQST_DCXO_BY_MD),
	PMIC_ENTRY(PMIC_AUXADC_RQST_DCXO_BY_GPS),
	PMIC_ENTRY(PMIC_AUXADC_RQST_BATID),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_THR1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_THR2),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH4_BY_THR3),
	PMIC_ENTRY(PMIC_AUXADC_RQST_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH12_NTCT0),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH12_NTCT1),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH12_NTCT2),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH12_NTCT3),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH13_EXT0),
	PMIC_ENTRY(PMIC_AUXADC_RQST_CH13_EXT1),
	PMIC_ENTRY(PMIC_SDMADC_RQST_CH0),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_DSN_DXI),
	PMIC_ENTRY(PMIC_AUXADC_ADC_PWDB),
	PMIC_ENTRY(PMIC_AUXADC_ADC_PWDB_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_STRUP_CK_ON_ENB),
	PMIC_ENTRY(PMIC_AUXADC_SRCLKEN_CK_EN),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON_GPS),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON_MD),
	PMIC_ENTRY(PMIC_AUXADC_CK_AON),
	PMIC_ENTRY(PMIC_AUXADC_CK_ON_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_SRCLKEN_SRC_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SMALL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_LARGE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SLEEP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_L),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_H),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SEL_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_SLEEP_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH0),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH3),
	PMIC_ENTRY(PMIC_AUXADC_SPL_NUM_CH7),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SMALL),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LARGE),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SMALL_CH7_GPS),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LARGE_CH7_GPS),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_L),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_H),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_SHARE),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_BAT_TEMP),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH3),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH0),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_LBAT),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH7),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_CH7_WAKEUP),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_BTMP),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_HPC),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_DCXO),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH0_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH1_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH2_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH3_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH4_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH5_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH6_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH7_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH8_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH9_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH10_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH11_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH12_SEL),
	PMIC_ENTRY(PMIC_AUXADC_TRIM_CH13_SEL),
	PMIC_ENTRY(PMIC_AUXADC_VBUF_EN),
	PMIC_ENTRY(PMIC_AUXADC_OUT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_TRIM_COMP),
	PMIC_ENTRY(PMIC_AUXADC_ADC_2S_COMP_ENB),
	PMIC_ENTRY(PMIC_AUXADC_RNG_EN),
	PMIC_ENTRY(PMIC_AUXADC_TEST_MODE),
	PMIC_ENTRY(PMIC_AUXADC_BIT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_START_SWCTRL),
	PMIC_ENTRY(PMIC_AUXADC_TS_VBE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC_SWCTRL),
	PMIC_ENTRY(PMIC_AD_AUXADC_COMP),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC_L),
	PMIC_ENTRY(PMIC_AUXADC_DA_DAC_H),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_BATID_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_VXO22_EN),
	PMIC_ENTRY(PMIC_AUXADC_DIG0_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_CHSEL),
	PMIC_ENTRY(PMIC_AUXADC_SWCTRL_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VBAT_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_MUX_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_VSEN_EXT_BATON_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_CHR_EN),
	PMIC_ENTRY(PMIC_AUXADC_ADCIN_BATON_TDET_EN),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_ANASWCTRL_EN),
	PMIC_ENTRY(PMIC_AUXADC_XO_THADC_EN),
	PMIC_ENTRY(PMIC_AUXADC_EXT1_EN),
	PMIC_ENTRY(PMIC_AUXADC_EXT2_EN),
	PMIC_ENTRY(PMIC_AUXADC_EXT3_EN),
	PMIC_ENTRY(PMIC_AUXADC_EXT4_EN),
	PMIC_ENTRY(PMIC_AUXADC_EXT5_EN),
	PMIC_ENTRY(PMIC_AUXADC_EXT6_EN),
	PMIC_ENTRY(PMIC_AUXADC_SOURCE_LBAT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_SOURCE_LBAT2_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DAC_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_DAC_EXTD_EN),
	PMIC_ENTRY(PMIC_AUXADC_START_EXTD),
	PMIC_ENTRY(PMIC_AUXADC_DIG0_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_NUM_L),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_NUM_H),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_EN),
	PMIC_ENTRY(PMIC_AUXADC_START_SHADE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_WAKEUP_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_FGADC_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_BAT_PLUGIN_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ADC_RDY_PWRON_CLR),
	PMIC_ENTRY(PMIC_AUXADC_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_CH0_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_CH1_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_DATA_REUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_CH0_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_CH1_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_DATA_REUSE_SEL),
	PMIC_ENTRY(PMIC_AUXADC_STATE_CS_S),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_EN),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_PRD_L),
	PMIC_ENTRY(PMIC_AUXADC_AUTORPT_PRD_H),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_DIG0_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_AUTO_SPL),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_AUTO_RQST_CLR),
	PMIC_ENTRY(PMIC_AUXADC_ACCDET_DIG1_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_DBG_DIG1_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_DBG_DIG0_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_FGADC_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_IMP_FGADC_R_SW),
	PMIC_ENTRY(PMIC_AUXADC_IMP_FGADC_R_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_PLUGIN_START_SW),
	PMIC_ENTRY(PMIC_AUXADC_BAT_PLUGIN_START_SEL),
	PMIC_ENTRY(PMIC_SDMADC_EXT_THR_SRC_SEL),
	PMIC_ENTRY(PMIC_SDMADC_EXT_THR_PURES_SEL),
	PMIC_ENTRY(PMIC_SDMADC_TSX_DCXO_SRC_SEL),
	PMIC_ENTRY(PMIC_AUXADC_AVG_NUM_SEL_CH7_GPS),
	PMIC_ENTRY(PMIC_SDMADC_CIC_M1),
	PMIC_ENTRY(PMIC_SDMADC_CIC_M2),
	PMIC_ENTRY(PMIC_SDMADC_TRIM_COMP),
	PMIC_ENTRY(PMIC_SDMADC_2S_COMP_ENB),
	PMIC_ENTRY(PMIC_SDMADC_SHADE_PRD_SEL),
	PMIC_ENTRY(PMIC_SDMADC_CONVERT_PRD_SEL),
	PMIC_ENTRY(PMIC_SDMADC_STATE_CS_S),
	PMIC_ENTRY(PMIC_SDMADC_SAMPLE_LIST),
	PMIC_ENTRY(PMIC_AUXADC_DIG_3_ELR_LEN),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH0_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH0_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH0_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH0_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH2_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH2_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH2_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH2_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH4_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH4_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH4_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH4_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH7_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH7_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH7_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH7_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH12_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH12_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH12_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH12_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH13_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_CH13_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH13_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_CH13_TRIM_H),
	PMIC_ENTRY(PMIC_AUXADC_SW_GAIN_TRIM_L),
	PMIC_ENTRY(PMIC_AUXADC_SW_GAIN_TRIM_H),
	PMIC_ENTRY(PMIC_AUXADC_SW_OFFSET_TRIM_L),
	PMIC_ENTRY(PMIC_AUXADC_SW_OFFSET_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_SDM_CH0_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_SDM_CH0_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_SDM_CH0_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_SDM_CH0_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_SDM_CH1_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_GAIN_SDM_CH1_TRIM_H),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_SDM_CH1_TRIM_L),
	PMIC_ENTRY(PMIC_EFUSE_OFFSET_SDM_CH1_TRIM_H),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_DEGC_CALI),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ADC_CALI_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV0),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ID),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_SLOPE),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_SLOPE_SIGN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_L),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_H),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV1),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_2_L),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_2_H),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV2),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_3_L),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_3_H),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV3),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_4_L),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_O_VTS_4_H),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV4),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV5),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_GAIN_AUX),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV6),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_GAIN_BGRH),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_GAIN_BGRL),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_SIGN_BGRL),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_SIGN_BGRH),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_SIGN_AUX),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_RSV7),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_TRMPL_CALI),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_TRMPH_CALI),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_CALI_FROM_EFUSE_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ADC_BGRCALI_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_ADC_AUXCALI_EN),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_VAUX18),
	PMIC_ENTRY(PMIC_AUXADC_EFUSE_VBG12),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_ID),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_CBS),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_BIX),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_ESP),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_FPI),
	PMIC_ENTRY(PMIC_AUXADC_DIG_4_DSN_DXI),
	PMIC_ENTRY(PMIC_AUXADC_IMP_EN),
	PMIC_ENTRY(PMIC_AUXADC_IMP_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_IMP_CNT_SEL),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_CHSEL),
	PMIC_ENTRY(PMIC_AUXADC_IMPEDANCE_IRQ_STATUS),
	PMIC_ENTRY(PMIC_AUXADC_IMP_START),
	PMIC_ENTRY(PMIC_AUXADC_IMP_STATE),
	PMIC_ENTRY(PMIC_AUXADC_IMP_COUNT),
	PMIC_ENTRY(PMIC_AUXADC_IMP_FGADC_R_S),
	PMIC_ENTRY(PMIC_FGADC_AUXADC_IMP_R_DONE_S),
	PMIC_ENTRY(PMIC_AUXADC_IMP_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_IMP_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBT_MAX_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBT_MIN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MAX_L),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MAX_H),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DET_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MIN_L),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_VOLT_MIN_H),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_STATE),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBT_MAX_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBT_MIN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DET_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_VOLT_MAX_L),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_VOLT_MAX_H),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DET_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_VOLT_MIN_L),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_VOLT_MIN_H),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_STATE),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_LBAT2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_EN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_FROZE_EN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBT_MAX_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBT_MIN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DET_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_VOLT_MAX_L),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_VOLT_MAX_H),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DET_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_VOLT_MIN_L),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_VOLT_MIN_H),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_STATE),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_BAT_TEMP_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_THR_EN),
	PMIC_ENTRY(PMIC_AUXADC_THR_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBT_MAX_SEL),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBT_MIN_SEL),
	PMIC_ENTRY(PMIC_AUXADC_THR_IRQ_EN_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_DET_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_MAX_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_THR_VOLT_MAX_L),
	PMIC_ENTRY(PMIC_AUXADC_THR_VOLT_MAX_H),
	PMIC_ENTRY(PMIC_AUXADC_THR_IRQ_EN_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_DET_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_MIN_IRQ_B),
	PMIC_ENTRY(PMIC_AUXADC_THR_VOLT_MIN_L),
	PMIC_ENTRY(PMIC_AUXADC_THR_VOLT_MIN_H),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MAX),
	PMIC_ENTRY(PMIC_AUXADC_THR_DEBOUNCE_COUNT_MIN),
	PMIC_ENTRY(PMIC_AUXADC_THR_STATE),
	PMIC_ENTRY(PMIC_AUXADC_THR_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_THR_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_THR_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_L),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CNT_H),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_SRCLKEN_IND),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_DET_WKUP_START_CLR),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_STATE),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_START),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_MDRT_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_L),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CNT_H),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_SEL),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_EN),
	PMIC_ENTRY(PMIC_AUXADC_DCXO_MDRT_DET_WKUP_START_CLR),
	PMIC_ENTRY(PMIC_AUXADC_NAG_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CLR),
	PMIC_ENTRY(PMIC_AUXADC_NAG_VBAT1_SEL),
	PMIC_ENTRY(PMIC_AUXADC_NAG_PRD_SEL),
	PMIC_ENTRY(PMIC_AUXADC_NAG_IRQ_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_IRQ),
	PMIC_ENTRY(PMIC_AUXADC_NAG_ZCV_L),
	PMIC_ENTRY(PMIC_AUXADC_NAG_ZCV_H),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_7_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_15_8),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_23_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_TH_26_24),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_7_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_15_8),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_23_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CNT_25_24),
	PMIC_ENTRY(PMIC_AUXADC_NAG_DLTV_L),
	PMIC_ENTRY(PMIC_AUXADC_NAG_DLTV_H),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_7_0),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_15_8),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_23_16),
	PMIC_ENTRY(PMIC_AUXADC_NAG_C_DLTV_26_24),
	PMIC_ENTRY(PMIC_AUXADC_NAG_STATE),
	PMIC_ENTRY(PMIC_AUXADC_NAG_AUXADC_START),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CK_SW_EN),
	PMIC_ENTRY(PMIC_AUXADC_NAG_CK_SW_MODE),
	PMIC_ENTRY(PMIC_AUXADC_RSV_0),
	PMIC_ENTRY(PMIC_AUXADC_RSV_1),
	PMIC_ENTRY(PMIC_AUXADC_SAMPLE_LIST_07_00),
	PMIC_ENTRY(PMIC_AUXADC_SAMPLE_LIST_15_08),
	PMIC_ENTRY(PMIC_AUXADC_SAMPLE_LIST_23_16),
	PMIC_ENTRY(PMIC_AUXADC_SAMPLE_LIST_31_24),
	PMIC_ENTRY(PMIC_AUXADC_SAMPLE_LIST_33_32),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_TOP_CBS),
	PMIC_ENTRY(PMIC_BUCK_TOP_BIX),
	PMIC_ENTRY(PMIC_BUCK_TOP_ESP),
	PMIC_ENTRY(PMIC_BUCK_TOP_FPI),
	PMIC_ENTRY(PMIC_BUCK_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_BUCK_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK_VIO31_ANA_2M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK_PHASE26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK1M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK_SLEEP_CTRL_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_PHASE26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_CLK_HWEN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMD11_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMD12_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_MD_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRFDIG_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VS2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VS3_OC),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_EN_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_EN_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMD11_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMD12_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_MD_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRFDIG_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VS2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VS3_OC),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_TOP_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMD11_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMD12_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_MD_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRFDIG_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VS2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VS3_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMD11_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMD12_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_MD_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRFDIG_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VS1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VS2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VS3_OC),
	PMIC_ENTRY(PMIC_RG_BUCK_STB_MAX_LO),
	PMIC_ENTRY(PMIC_RG_BUCK_STB_MAX_HI),
	PMIC_ENTRY(PMIC_RG_BUCK_VGP2_MINFREQ_LATENCY_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_VGP2_MINFREQ_DURATION_MAX),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OC_SDN_STATUS),
	PMIC_ENTRY(PMIC_BUCK_TOP_WRITE_KEY_LO),
	PMIC_ENTRY(PMIC_BUCK_TOP_WRITE_KEY_HI),
	PMIC_ENTRY(PMIC_BUCK_VCORE_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VMD11_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VMD12_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS1_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS2_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS3_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_TOP_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OC_SDN_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_DCM_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VCORE_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_DVFS_DLY_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_EN_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_EN_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_EN_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_EN_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_CFG_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_CFG_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_CFG_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_CFG_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_MODE_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_MODE_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_MODE_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_OP_MODE_1_CLR),
	PMIC_ENTRY(PMIC_DA_VCORE_VOSEL),
	PMIC_ENTRY(PMIC_DA_VCORE_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VCORE_EN),
	PMIC_ENTRY(PMIC_DA_VCORE_STB),
	PMIC_ENTRY(PMIC_DA_VCORE_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VCORE_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VCORE_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VCORE_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VCORE_SSH),
	PMIC_ENTRY(PMIC_DA_VCORE_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VCORE_TRACK_STALL_BYPASS),
	PMIC_ENTRY(PMIC_BUCK_VMD11_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VMD11_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMD11_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VMD11_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_DVFS_DLY_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_EN_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_EN_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_EN_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_EN_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_CFG_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_CFG_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_CFG_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_CFG_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_MODE_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_MODE_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_MODE_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_OP_MODE_1_CLR),
	PMIC_ENTRY(PMIC_DA_VMD11_VOSEL),
	PMIC_ENTRY(PMIC_DA_VMD11_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VMD11_EN),
	PMIC_ENTRY(PMIC_DA_VMD11_STB),
	PMIC_ENTRY(PMIC_DA_VMD11_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VMD11_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VMD11_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VMD11_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VMD11_SSH),
	PMIC_ENTRY(PMIC_DA_VMD11_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD11_TRACK_STALL_BYPASS),
	PMIC_ENTRY(PMIC_BUCK_VMD12_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VMD12_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMD12_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VMD12_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_DVFS_DLY_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_EN_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_EN_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_EN_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_EN_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_CFG_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_CFG_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_CFG_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_CFG_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_MODE_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_MODE_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_MODE_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_OP_MODE_1_CLR),
	PMIC_ENTRY(PMIC_DA_VMD12_VOSEL),
	PMIC_ENTRY(PMIC_DA_VMD12_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VMD12_EN),
	PMIC_ENTRY(PMIC_DA_VMD12_STB),
	PMIC_ENTRY(PMIC_DA_VMD12_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VMD12_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VMD12_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VMD12_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VMD12_SSH),
	PMIC_ENTRY(PMIC_DA_VMD12_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VMD12_CK_SW_EN),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VSRAM_MD_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_DVFS_DLY_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_EN_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_EN_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_EN_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_EN_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_CFG_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_CFG_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_CFG_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_CFG_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_MODE_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_MODE_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_MODE_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_OP_MODE_1_CLR),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_SSH),
	PMIC_ENTRY(PMIC_DA_VSRAM_MD_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_TRACK_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_TRACK_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_VOSEL_DELTA),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_VOSEL_OFFSET),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_VOSEL_LB),
	PMIC_ENTRY(PMIC_RG_BUCK_VSRAM_MD_VOSEL_HB),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VRFDIG_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_DVFS_DLY_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_EN_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_EN_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_EN_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_EN_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_CFG_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_CFG_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_CFG_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_CFG_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_MODE_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_MODE_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_MODE_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_OP_MODE_1_CLR),
	PMIC_ENTRY(PMIC_DA_VRFDIG_VOSEL),
	PMIC_ENTRY(PMIC_DA_VRFDIG_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VRFDIG_EN),
	PMIC_ENTRY(PMIC_DA_VRFDIG_STB),
	PMIC_ENTRY(PMIC_DA_VRFDIG_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VRFDIG_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VRFDIG_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VRFDIG_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VRFDIG_SSH),
	PMIC_ENTRY(PMIC_DA_VRFDIG_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VRFDIG_CK_SW_EN),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VS1_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_DVFS_DLY_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_EN_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_EN_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_EN_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_EN_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_CFG_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_CFG_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_CFG_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_CFG_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_MODE_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_MODE_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_MODE_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_OP_MODE_1_CLR),
	PMIC_ENTRY(PMIC_DA_VS1_VOSEL),
	PMIC_ENTRY(PMIC_DA_VS1_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VS1_EN),
	PMIC_ENTRY(PMIC_DA_VS1_STB),
	PMIC_ENTRY(PMIC_DA_VS1_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VS1_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VS1_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VS1_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VS1_SSH),
	PMIC_ENTRY(PMIC_DA_VS1_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_LO),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_LO_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_LO_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_HI),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_HI_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_EN_HI_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS1_VOTER_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS2_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VS2_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VS2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VS2_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_DVFS_DLY_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_EN_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_EN_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_EN_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_EN_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_CFG_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_CFG_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_CFG_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_CFG_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_MODE_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_MODE_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_MODE_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_OP_MODE_1_CLR),
	PMIC_ENTRY(PMIC_DA_VS2_VOSEL),
	PMIC_ENTRY(PMIC_DA_VS2_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VS2_EN),
	PMIC_ENTRY(PMIC_DA_VS2_STB),
	PMIC_ENTRY(PMIC_DA_VS2_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VS2_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VS2_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VS2_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VS2_SSH),
	PMIC_ENTRY(PMIC_DA_VS2_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN_LO),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN_LO_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN_LO_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN_HI),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN_HI_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_EN_HI_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS2_VOTER_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_VS3_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_VS3_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_VS3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_CBS),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_BIX),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_ESP),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_FPI_SSHUB),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_FPI_TRACKING),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_FPI_PREOC),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_FPI_VOTER),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_FPI_ULTRASONIC),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_FPI_DLC),
	PMIC_ENTRY(PMIC_BUCK_VS3_DSN_FPI_TRAP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_SELR2R_CTRL),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_DVFS_DLY_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_EN_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_EN_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_EN_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_EN_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_CFG_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_CFG_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_CFG_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_CFG_1_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW0_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW3_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW4_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW5_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW6_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW7_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_MODE_0_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_MODE_0_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW8_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW9_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW10_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW11_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW12_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_HW14_OP_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_MODE_1_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_OP_MODE_1_CLR),
	PMIC_ENTRY(PMIC_DA_VS3_VOSEL),
	PMIC_ENTRY(PMIC_DA_VS3_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VS3_EN),
	PMIC_ENTRY(PMIC_DA_VS3_STB),
	PMIC_ENTRY(PMIC_DA_VS3_LOOP_SEL),
	PMIC_ENTRY(PMIC_DA_VS3_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VS3_DVS_EN),
	PMIC_ENTRY(PMIC_DA_VS3_DVS_DOWN),
	PMIC_ENTRY(PMIC_DA_VS3_SSH),
	PMIC_ENTRY(PMIC_DA_VS3_MINFREQ_DISCHARGE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_CK_SW_MODE),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_CK_SW_EN),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOTER_EN_LO),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOTER_EN_LO_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOTER_EN_LO_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOTER_EN_HI),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOTER_EN_HI_SET),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOTER_EN_HI_CLR),
	PMIC_ENTRY(PMIC_RG_BUCK_VS3_VOTER_VOSEL),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA0_CBS),
	PMIC_ENTRY(PMIC_BUCK_ANA0_BIX),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ESP),
	PMIC_ENTRY(PMIC_BUCK_ANA0_FPI),
	PMIC_ENTRY(PMIC_BUCK_ANA0_DXI),
	PMIC_ENTRY(PMIC_RG_SMPS_TESTMODE_B),
	PMIC_ENTRY(PMIC_RG_AUTOK_RST),
	PMIC_ENTRY(PMIC_RG_SMPS_DISAUTOK),
	PMIC_ENTRY(PMIC_RG_VMD11_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VMD11_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VMD11_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VMD11_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VMD11_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VMD11_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VMD11_OCP),
	PMIC_ENTRY(PMIC_RG_VMD11_OCN),
	PMIC_ENTRY(PMIC_RG_VMD11_FUGON),
	PMIC_ENTRY(PMIC_RG_VMD11_FLGON),
	PMIC_ENTRY(PMIC_RG_VMD11_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VMD11_UG_SR),
	PMIC_ENTRY(PMIC_RG_VMD11_LG_SR),
	PMIC_ENTRY(PMIC_RG_VMD11_FCCM),
	PMIC_ENTRY(PMIC_RG_VMD11_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_RSVH),
	PMIC_ENTRY(PMIC_RG_VMD11_RSVL),
	PMIC_ENTRY(PMIC_RGS_VMD11_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMD11_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VMD11_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VMD11_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VMD11_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VMD11_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VMD11_RCB),
	PMIC_ENTRY(PMIC_RG_VMD11_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VMD11_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_NEGI_SLOW_SR_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_DRV_FORCEFAST),
	PMIC_ENTRY(PMIC_RG_VMD11_LXRON),
	PMIC_ENTRY(PMIC_RG_VMD11_UGON_SR),
	PMIC_ENTRY(PMIC_RG_VMD11_MINOFF_C),
	PMIC_ENTRY(PMIC_RG_VMD11_VBATLOW_RAMPRSHORT),
	PMIC_ENTRY(PMIC_RG_VMD11_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VMD11_RAMPR_DIV),
	PMIC_ENTRY(PMIC_RG_VMD11_RAMPC_DIV),
	PMIC_ENTRY(PMIC_RG_VMD11_TM_KEY),
	PMIC_ENTRY(PMIC_RG_VMD11_TM),
	PMIC_ENTRY(PMIC_RG_VMD11_RON_TM),
	PMIC_ENTRY(PMIC_RG_VMD12_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VMD12_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VMD12_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VMD12_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VMD12_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VMD12_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VMD12_OCP),
	PMIC_ENTRY(PMIC_RG_VMD12_OCN),
	PMIC_ENTRY(PMIC_RG_VMD12_FUGON),
	PMIC_ENTRY(PMIC_RG_VMD12_FLGON),
	PMIC_ENTRY(PMIC_RG_VMD12_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VMD12_UG_SR),
	PMIC_ENTRY(PMIC_RG_VMD12_LG_SR),
	PMIC_ENTRY(PMIC_RG_VMD12_FCCM),
	PMIC_ENTRY(PMIC_RG_VMD12_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_RSVH),
	PMIC_ENTRY(PMIC_RG_VMD12_RSVL),
	PMIC_ENTRY(PMIC_RGS_VMD12_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VMD12_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VMD12_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VMD12_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VMD12_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VMD12_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VMD12_RCB),
	PMIC_ENTRY(PMIC_RG_VMD12_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VMD12_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_NEGI_SLOW_SR_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_DRV_FORCEFAST),
	PMIC_ENTRY(PMIC_RG_VMD12_LXRON),
	PMIC_ENTRY(PMIC_RG_VMD12_UGON_SR),
	PMIC_ENTRY(PMIC_RG_VMD12_MINOFF_C),
	PMIC_ENTRY(PMIC_RG_VMD12_VBATLOW_RAMPRSHORT),
	PMIC_ENTRY(PMIC_RG_VMD12_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VMD12_RAMPR_DIV),
	PMIC_ENTRY(PMIC_RG_VMD12_RAMPC_DIV),
	PMIC_ENTRY(PMIC_RG_VMD12_TM_KEY),
	PMIC_ENTRY(PMIC_RG_VMD12_TM),
	PMIC_ENTRY(PMIC_RG_VMD12_RON_TM),
	PMIC_ENTRY(PMIC_RG_VCORE_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VCORE_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VCORE_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VCORE_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VCORE_OCP),
	PMIC_ENTRY(PMIC_RG_VCORE_OCN),
	PMIC_ENTRY(PMIC_RG_VCORE_FUGON),
	PMIC_ENTRY(PMIC_RG_VCORE_FLGON),
	PMIC_ENTRY(PMIC_RG_VCORE_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VCORE_UG_SR),
	PMIC_ENTRY(PMIC_RG_VCORE_LG_SR),
	PMIC_ENTRY(PMIC_RG_VCORE_FCCM),
	PMIC_ENTRY(PMIC_RG_VCORE_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_RSVH),
	PMIC_ENTRY(PMIC_RG_VCORE_RSVL),
	PMIC_ENTRY(PMIC_RGS_VCORE_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VCORE_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VCORE_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VCORE_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VCORE_RCB),
	PMIC_ENTRY(PMIC_RG_VCORE_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VCORE_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_NEGI_SLOW_SR_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_DRV_FORCEFAST),
	PMIC_ENTRY(PMIC_RG_VCORE_LXRON),
	PMIC_ENTRY(PMIC_RG_VCORE_UGON_SR),
	PMIC_ENTRY(PMIC_RG_VCORE_MINOFF_C),
	PMIC_ENTRY(PMIC_RG_VCORE_VBATLOW_RAMPRSHORT),
	PMIC_ENTRY(PMIC_RG_VCORE_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VCORE_RAMPR_DIV),
	PMIC_ENTRY(PMIC_RG_VCORE_RAMPC_DIV),
	PMIC_ENTRY(PMIC_RG_VCORE_TM_KEY),
	PMIC_ENTRY(PMIC_RG_VCORE_TM),
	PMIC_ENTRY(PMIC_RG_VCORE_RON_TM),
	PMIC_ENTRY(PMIC_RG_VMD11_URT_EN),
	PMIC_ENTRY(PMIC_RG_VMD11_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_URT_EN),
	PMIC_ENTRY(PMIC_RG_VMD12_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_URT_EN),
	PMIC_ENTRY(PMIC_RG_VCORE_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VMDVCORE_TMDL),
	PMIC_ENTRY(PMIC_RG_VMDVCORE_SR_VBAT),
	PMIC_ENTRY(PMIC_RGS_3PH1_VMD11_DIGCFG_EN),
	PMIC_ENTRY(PMIC_RGS_3PH2_VMD12_DIGCFG_EN),
	PMIC_ENTRY(PMIC_RGS_3PH3_VCORE_DIGCFG_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_SR_VBAT),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_OCN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_OCP),
	PMIC_ENTRY(PMIC_RGS_VSRAM_MD_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VSRAM_MD_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_UG_SR),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_LG_SR),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TMDL),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_FUGON),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_FLGON),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_FCCM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RSVH),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RSVL),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RCB),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_VBATLOW_RAMPRSHORT),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_NEGI_SLOW_SR_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_DRV_FORCEFAST),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_LXRON),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_UGON_SR),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_MINOFF_C),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RAMPR_DIV),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RAMPC_DIV),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TM_KEY),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RON_TM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_URT_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_SR_VBAT),
	PMIC_ENTRY(PMIC_RG_VRFDIG_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_PWM_RSTRAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VRFDIG_LOOPSEL_DIS),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TB_DIS),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TB_PFM_OFF),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TB_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TON_EXTEND_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_DUMMY_LOAD_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_OVP_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_OVP_VREFSEL),
	PMIC_ENTRY(PMIC_RG_VRFDIG_OCN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_OCP),
	PMIC_ENTRY(PMIC_RGS_VRFDIG_OC_STATUS),
	PMIC_ENTRY(PMIC_RGS_VRFDIG_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VRFDIG_UG_SR),
	PMIC_ENTRY(PMIC_RG_VRFDIG_LG_SR),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TMDL),
	PMIC_ENTRY(PMIC_RG_VRFDIG_FUGON),
	PMIC_ENTRY(PMIC_RG_VRFDIG_FLGON),
	PMIC_ENTRY(PMIC_RG_VRFDIG_FCCM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_VDIFF_GROUNDSEL),
	PMIC_ENTRY(PMIC_RG_VRFDIG_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RSVH),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RSVL),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RCB),
	PMIC_ENTRY(PMIC_RG_VRFDIG_VDIFFCAP_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_VBAT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VRFDIG_VBAT_LOW_DIS),
	PMIC_ENTRY(PMIC_RG_VRFDIG_VOUT_HI_DIS),
	PMIC_ENTRY(PMIC_RG_VRFDIG_VBATLOW_RAMPRSHORT),
	PMIC_ENTRY(PMIC_RG_VRFDIG_NEGI_SLOW_SR_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_DRV_FORCEFAST),
	PMIC_ENTRY(PMIC_RG_VRFDIG_LXRON),
	PMIC_ENTRY(PMIC_RG_VRFDIG_UGON_SR),
	PMIC_ENTRY(PMIC_RG_VRFDIG_MINOFF_C),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RAMPR_DIV),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RAMPC_DIV),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TM_KEY),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RAMP_AC),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RON_TM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_VDIFF_OFF),
	PMIC_ENTRY(PMIC_RG_VRFDIG_URT_EN),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RETENTION_EN),
	PMIC_ENTRY(PMIC_BUCK_ANA0_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VMD11_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD11_CCOMP),
	PMIC_ENTRY(PMIC_RG_VMD11_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VMD11_RCOMP),
	PMIC_ENTRY(PMIC_RG_VMD11_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD12_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD12_CCOMP),
	PMIC_ENTRY(PMIC_RG_VMD12_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VMD12_RCOMP),
	PMIC_ENTRY(PMIC_RG_VMD12_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CCOMP),
	PMIC_ENTRY(PMIC_RG_VCORE_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VCORE_RCOMP),
	PMIC_ENTRY(PMIC_RG_VCORE_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD11_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD11_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD12_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD12_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD11_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD12_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VMDVCORE_CONFIG_2PH),
	PMIC_ENTRY(PMIC_RG_VMDVCORE_CONFIG_3PH),
	PMIC_ENTRY(PMIC_RG_VMD11_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VMD11_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VMD12_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VMD12_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VCORE_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VCORE_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VMD11_RSV_EFUSE),
	PMIC_ENTRY(PMIC_RG_VMD12_RSV_EFUSE),
	PMIC_ENTRY(PMIC_RG_VCORE_RSV_EFUSE),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_CCOMP),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RCOMP),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_RSV_EFUSE),
	PMIC_ENTRY(PMIC_RG_VRFDIG_DRIVER_SR_TRIM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_CCOMP),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RCOMP),
	PMIC_ENTRY(PMIC_RG_VRFDIG_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VRFDIG_SONIC_PFM_PEAK),
	PMIC_ENTRY(PMIC_RG_VRFDIG_RSV_EFUSE),
	PMIC_ENTRY(PMIC_RG_VS1_TRIMH),
	PMIC_ENTRY(PMIC_RG_VS2_TRIMH),
	PMIC_ENTRY(PMIC_RG_VMD11_TRIMH),
	PMIC_ENTRY(PMIC_RG_VMD12_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TRIMH),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TRIMH),
	PMIC_ENTRY(PMIC_RG_VCORE_TRIMH),
	PMIC_ENTRY(PMIC_RG_VS3_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_TRIMH),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_TRIMH),
	PMIC_ENTRY(PMIC_RG_VMD11_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VMD12_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VCORE_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_MD_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VRFDIG_TON_TRIM),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ANA_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DIG_ID),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_BUCK_ANA1_CBS),
	PMIC_ENTRY(PMIC_BUCK_ANA1_BIX),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ESP),
	PMIC_ENTRY(PMIC_BUCK_ANA1_FPI),
	PMIC_ENTRY(PMIC_BUCK_ANA1_DXI),
	PMIC_ENTRY(PMIC_RG_VS1_TON_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS1_VREF_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS1_COTNLIM_EN),
	PMIC_ENTRY(PMIC_RG_VS1_NLIM_GATING),
	PMIC_ENTRY(PMIC_RG_VS1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VS1_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VS1_RIPPLEH_SEL),
	PMIC_ENTRY(PMIC_RG_VS1_FCCM),
	PMIC_ENTRY(PMIC_RG_VS1_TMDL),
	PMIC_ENTRY(PMIC_RG_VS1_PROTECTION_KEY),
	PMIC_ENTRY(PMIC_RG_VS1_CMPV_FCOT),
	PMIC_ENTRY(PMIC_RG_VS1_FUGON),
	PMIC_ENTRY(PMIC_RG_VS1_FLGON),
	PMIC_ENTRY(PMIC_RGS_VS1_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VS1_OC_HALF),
	PMIC_ENTRY(PMIC_RG_VS1_OCP),
	PMIC_ENTRY(PMIC_RG_VS1_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VS1_OCN),
	PMIC_ENTRY(PMIC_RG_VS1_SONIC_TON),
	PMIC_ENTRY(PMIC_RG_VS1_DIG_MON_EN),
	PMIC_ENTRY(PMIC_RG_VS1_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RGS_VS1_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VS1_FCCM_DISCH_FOFF),
	PMIC_ENTRY(PMIC_RG_VS1_NLIM_LSR_FOFF),
	PMIC_ENTRY(PMIC_RG_VS1_TM),
	PMIC_ENTRY(PMIC_RG_VS1_PFM_DISCH_EN),
	PMIC_ENTRY(PMIC_RG_VS1_PFM_SR_BK),
	PMIC_ENTRY(PMIC_RG_VS1_PFM_FORCE_PFMCMP),
	PMIC_ENTRY(PMIC_RG_VS1_UG_SR),
	PMIC_ENTRY(PMIC_RG_VS1_LG_SR),
	PMIC_ENTRY(PMIC_RG_VS1_RSVH),
	PMIC_ENTRY(PMIC_RG_VS1_RSVL),
	PMIC_ENTRY(PMIC_RG_VS1_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VS1_VDIFF_CAP_EN),
	PMIC_ENTRY(PMIC_RG_VS1_HI_BAT_LSR_DIS),
	PMIC_ENTRY(PMIC_RG_VS1_URT),
	PMIC_ENTRY(PMIC_RG_VS2_TON_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS2_VREF_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS2_COTNLIM_EN),
	PMIC_ENTRY(PMIC_RG_VS2_NLIM_GATING),
	PMIC_ENTRY(PMIC_RG_VS2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VS2_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VS2_RIPPLEH_SEL),
	PMIC_ENTRY(PMIC_RG_VS2_FCCM),
	PMIC_ENTRY(PMIC_RG_VS2_TMDL),
	PMIC_ENTRY(PMIC_RG_VS2_PROTECTION_KEY),
	PMIC_ENTRY(PMIC_RG_VS2_CMPV_FCOT),
	PMIC_ENTRY(PMIC_RG_VS2_FUGON),
	PMIC_ENTRY(PMIC_RG_VS2_FLGON),
	PMIC_ENTRY(PMIC_RGS_VS2_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VS2_OC_HALF),
	PMIC_ENTRY(PMIC_RG_VS2_OCP),
	PMIC_ENTRY(PMIC_RG_VS2_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VS2_OCN),
	PMIC_ENTRY(PMIC_RG_VS2_SONIC_TON),
	PMIC_ENTRY(PMIC_RG_VS2_DIG_MON_EN),
	PMIC_ENTRY(PMIC_RG_VS2_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RGS_VS2_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VS2_FCCM_DISCH_FOFF),
	PMIC_ENTRY(PMIC_RG_VS2_NLIM_LSR_FOFF),
	PMIC_ENTRY(PMIC_RG_VS2_TM),
	PMIC_ENTRY(PMIC_RG_VS2_PFM_DISCH_EN),
	PMIC_ENTRY(PMIC_RG_VS2_PFM_SR_BK),
	PMIC_ENTRY(PMIC_RG_VS2_PFM_FORCE_PFMCMP),
	PMIC_ENTRY(PMIC_RG_VS2_UG_SR),
	PMIC_ENTRY(PMIC_RG_VS2_LG_SR),
	PMIC_ENTRY(PMIC_RG_VS2_RSVH),
	PMIC_ENTRY(PMIC_RG_VS2_RSVL),
	PMIC_ENTRY(PMIC_RG_VS2_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VS2_VDIFF_CAP_EN),
	PMIC_ENTRY(PMIC_RG_VS2_HI_BAT_LSR_DIS),
	PMIC_ENTRY(PMIC_RG_VS2_URT),
	PMIC_ENTRY(PMIC_RG_VS3_TON_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS3_VREF_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_VS3_COTNLIM_EN),
	PMIC_ENTRY(PMIC_RG_VS3_NLIM_GATING),
	PMIC_ENTRY(PMIC_RG_VS3_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VS3_SLEEP_TIME),
	PMIC_ENTRY(PMIC_RG_VS3_RIPPLEH_SEL),
	PMIC_ENTRY(PMIC_RG_VS3_FCCM),
	PMIC_ENTRY(PMIC_RG_VS3_TMDL),
	PMIC_ENTRY(PMIC_RG_VS3_PROTECTION_KEY),
	PMIC_ENTRY(PMIC_RG_VS3_CMPV_FCOT),
	PMIC_ENTRY(PMIC_RG_VS3_FUGON),
	PMIC_ENTRY(PMIC_RG_VS3_FLGON),
	PMIC_ENTRY(PMIC_RGS_VS3_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VS3_OC_HALF),
	PMIC_ENTRY(PMIC_RG_VS3_OCP),
	PMIC_ENTRY(PMIC_RG_VS3_NONAUDIBLE_EN),
	PMIC_ENTRY(PMIC_RG_VS3_OCN),
	PMIC_ENTRY(PMIC_RG_VS3_SONIC_TON),
	PMIC_ENTRY(PMIC_RG_VS3_DIG_MON_EN),
	PMIC_ENTRY(PMIC_RG_VS3_DIGMON_SEL),
	PMIC_ENTRY(PMIC_RGS_VS3_DIG_MON),
	PMIC_ENTRY(PMIC_RG_VS3_FCCM_DISCH_FOFF),
	PMIC_ENTRY(PMIC_RG_VS3_NLIM_LSR_FOFF),
	PMIC_ENTRY(PMIC_RG_VS3_TM),
	PMIC_ENTRY(PMIC_RG_VS3_PFM_DISCH_EN),
	PMIC_ENTRY(PMIC_RG_VS3_PFM_SR_BK),
	PMIC_ENTRY(PMIC_RG_VS3_PFM_FORCE_PFMCMP),
	PMIC_ENTRY(PMIC_RG_VS3_UG_SR),
	PMIC_ENTRY(PMIC_RG_VS3_LG_SR),
	PMIC_ENTRY(PMIC_RG_VS3_RSVH),
	PMIC_ENTRY(PMIC_RG_VS3_RSVL),
	PMIC_ENTRY(PMIC_RG_VS3_RETENTION_EN),
	PMIC_ENTRY(PMIC_RG_VS3_VDIFF_CAP_EN),
	PMIC_ENTRY(PMIC_RG_VS3_HI_BAT_LSR_DIS),
	PMIC_ENTRY(PMIC_RG_VS3_URT),
	PMIC_ENTRY(PMIC_BUCK_ANA1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VS1_VC_PARK_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_CCOMP),
	PMIC_ENTRY(PMIC_RG_VS1_RCOMP),
	PMIC_ENTRY(PMIC_RG_VS1_LDO_SENSE),
	PMIC_ENTRY(PMIC_RG_VS1_CSN_SLP_MOD),
	PMIC_ENTRY(PMIC_RG_VS1_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_RAMP_FILTER_RSEL),
	PMIC_ENTRY(PMIC_RG_VS1_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_COTRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VS1_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VS1_PFM_RIPPLEH_FOFF),
	PMIC_ENTRY(PMIC_RG_VS1_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VS1_ZC_TRIM_SEL),
	PMIC_ENTRY(PMIC_RG_VS1_EFUSE_RSV),
	PMIC_ENTRY(PMIC_RG_VS2_VC_PARK_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_CCOMP),
	PMIC_ENTRY(PMIC_RG_VS2_RCOMP),
	PMIC_ENTRY(PMIC_RG_VS2_LDO_SENSE),
	PMIC_ENTRY(PMIC_RG_VS2_CSN_SLP_MOD),
	PMIC_ENTRY(PMIC_RG_VS2_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_RAMP_FILTER_RSEL),
	PMIC_ENTRY(PMIC_RG_VS2_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_COTRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VS2_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VS2_PFM_RIPPLEH_FOFF),
	PMIC_ENTRY(PMIC_RG_VS2_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VS2_ZC_TRIM_SEL),
	PMIC_ENTRY(PMIC_RG_VS2_EFUSE_RSV),
	PMIC_ENTRY(PMIC_RG_VS3_VC_PARK_TRIM),
	PMIC_ENTRY(PMIC_RG_VS3_CCOMP),
	PMIC_ENTRY(PMIC_RG_VS3_RCOMP),
	PMIC_ENTRY(PMIC_RG_VS3_LDO_SENSE),
	PMIC_ENTRY(PMIC_RG_VS3_CSN_SLP_MOD),
	PMIC_ENTRY(PMIC_RG_VS3_NLIM_TRIM),
	PMIC_ENTRY(PMIC_RG_VS3_RAMP_FILTER_RSEL),
	PMIC_ENTRY(PMIC_RG_VS3_TON_TRIM),
	PMIC_ENTRY(PMIC_RG_VS3_COTRAMP_SLP),
	PMIC_ENTRY(PMIC_RG_VS3_PFM_TON),
	PMIC_ENTRY(PMIC_RG_VS3_PFM_RIPPLEH_FOFF),
	PMIC_ENTRY(PMIC_RG_VS3_CSNSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS3_CSPSLP_TRIM),
	PMIC_ENTRY(PMIC_RG_VS3_ZC_TRIM),
	PMIC_ENTRY(PMIC_RG_VS3_ZC_TRIM_SEL),
	PMIC_ENTRY(PMIC_RG_VS3_EFUSE_RSV),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_TOP_CBS),
	PMIC_ENTRY(PMIC_LDO_TOP_BIX),
	PMIC_ENTRY(PMIC_LDO_TOP_ESP),
	PMIC_ENTRY(PMIC_LDO_TOP_FPI),
	PMIC_ENTRY(PMIC_LDO_TOP_DXI),
	PMIC_ENTRY(PMIC_LDO_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_LDO_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_RG_LDO_32K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_LDO_INTRP_CK_PDN),
	PMIC_ENTRY(PMIC_RG_LDO_1M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_LDO_26M_CK_PDN),
	PMIC_ENTRY(PMIC_RG_LDO_32K_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_LDO_INTRP_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_LDO_1M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_LDO_26M_CK_PDN_HWEN),
	PMIC_ENTRY(PMIC_RG_LDO_DCM_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OSC_SEL_DIS),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRF13_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VA12_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VA12_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VCN18_OC),
	PMIC_ENTRY(PMIC_LDO_INT_CON0_SET),
	PMIC_ENTRY(PMIC_LDO_INT_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMDDR_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMDDQ_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VMDD2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRF09_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VIO18_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VIO18_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_PROC_OC),
	PMIC_ENTRY(PMIC_LDO_INT_CON1_SET),
	PMIC_ENTRY(PMIC_LDO_INT_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_CORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSRAM_RFDIG_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VBBCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VUSB_OC),
	PMIC_ENTRY(PMIC_RG_INT_EN_VRFCK_OC),
	PMIC_ENTRY(PMIC_LDO_INT_CON2_SET),
	PMIC_ENTRY(PMIC_LDO_INT_CON2_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRF13_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VA12_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VA12_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VCN18_OC),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON0_SET),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMDDR_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMDDQ_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VMDD2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRF09_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VIO18_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VIO18_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_PROC_OC),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON1_SET),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON1_CLR),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_CORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSRAM_RFDIG_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VBBCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VUSB_OC),
	PMIC_ENTRY(PMIC_RG_INT_MASK_VRFCK_OC),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON2_SET),
	PMIC_ENTRY(PMIC_LDO_INT_MASK_CON2_CLR),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRF13_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VA12_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VA12_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMDDR_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMDDQ_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VMDD2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRF09_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VIO18_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VIO18_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_PROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_CORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSRAM_RFDIG_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VBBCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VUSB_OC),
	PMIC_ENTRY(PMIC_RG_INT_STATUS_VRFCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VXO22_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRF18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRF13_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VEFUSE_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VA12_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VA12_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VCN18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMDDR_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMDDQ_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VMDD2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRF09_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VAUX18_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VIO18_1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VIO18_2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_PROC_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_CORE_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSRAM_RFDIG_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VBBCK_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VEMC_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSIM1_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VSIM2_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VUSB_OC),
	PMIC_ENTRY(PMIC_RG_INT_RAW_STATUS_VRFCK_OC),
	PMIC_ENTRY(PMIC_RG_LDO_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_INT_FLAG_EN),
	PMIC_ENTRY(PMIC_RG_LDO_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_WDT_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_DUMMY_LOAD_GATED_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_LP_PROT_DISABLE),
	PMIC_ENTRY(PMIC_RG_LDO_SLEEP_CTRL_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_TOP_RSV1),
	PMIC_ENTRY(PMIC_RG_LDO_TOP_RSV0),
	PMIC_ENTRY(PMIC_RG_VRTC28_EN),
	PMIC_ENTRY(PMIC_DA_VRTC28_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_OFF_ACKTIME_SEL),
	PMIC_ENTRY(PMIC_RG_VAUX18_LP_ACKTIME_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_TOP_RSV_BIT_0),
	PMIC_ENTRY(PMIC_RG_LDO_TOP_RSV_BIT_1),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_EN_SW_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_EN_TEST),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_PROC_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_CORE_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_RFDIG_VOSEL),
	PMIC_ENTRY(PMIC_LDO_TOP_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_ELR_1BIT_RSV0),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_VOSEL_LIMIT_SEL),
	PMIC_ENTRY(PMIC_RG_ELR_4BIT_RSV0),
	PMIC_ENTRY(PMIC_RG_ELR_4BIT_RSV1),
	PMIC_ENTRY(PMIC_RG_ELR_4BIT_RSV2),
	PMIC_ENTRY(PMIC_RG_ELR_4BIT_RSV3),
	PMIC_ENTRY(PMIC_RG_ELR_4BIT_RSV4),
	PMIC_ENTRY(PMIC_RG_ELR_4BIT_RSV5),
	PMIC_ENTRY(PMIC_LDO_GNR0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR0_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR0_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR0_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VEFUSE_B_EN),
	PMIC_ENTRY(PMIC_DA_VEFUSE_B_STB),
	PMIC_ENTRY(PMIC_DA_VEFUSE_B_LP),
	PMIC_ENTRY(PMIC_DA_VEFUSE_L_EN),
	PMIC_ENTRY(PMIC_DA_VEFUSE_L_STB),
	PMIC_ENTRY(PMIC_DA_VEFUSE_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VEFUSE_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEFUSE_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VA12_2_B_EN),
	PMIC_ENTRY(PMIC_DA_VA12_2_B_STB),
	PMIC_ENTRY(PMIC_DA_VA12_2_B_LP),
	PMIC_ENTRY(PMIC_DA_VA12_2_L_EN),
	PMIC_ENTRY(PMIC_DA_VA12_2_L_STB),
	PMIC_ENTRY(PMIC_DA_VA12_2_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VA12_2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_2_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VBBCK_B_EN),
	PMIC_ENTRY(PMIC_DA_VBBCK_B_STB),
	PMIC_ENTRY(PMIC_DA_VBBCK_B_LP),
	PMIC_ENTRY(PMIC_DA_VBBCK_L_EN),
	PMIC_ENTRY(PMIC_DA_VBBCK_L_STB),
	PMIC_ENTRY(PMIC_DA_VBBCK_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VBBCK_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VBBCK_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VRFCK_B_EN),
	PMIC_ENTRY(PMIC_DA_VRFCK_B_STB),
	PMIC_ENTRY(PMIC_DA_VRFCK_B_LP),
	PMIC_ENTRY(PMIC_DA_VRFCK_L_EN),
	PMIC_ENTRY(PMIC_DA_VRFCK_L_STB),
	PMIC_ENTRY(PMIC_DA_VRFCK_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRFCK_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRFCK_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VXO22_B_EN),
	PMIC_ENTRY(PMIC_DA_VXO22_B_STB),
	PMIC_ENTRY(PMIC_DA_VXO22_B_LP),
	PMIC_ENTRY(PMIC_DA_VXO22_L_EN),
	PMIC_ENTRY(PMIC_DA_VXO22_L_STB),
	PMIC_ENTRY(PMIC_DA_VXO22_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VXO22_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VXO22_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VAUX18_B_EN),
	PMIC_ENTRY(PMIC_DA_VAUX18_B_STB),
	PMIC_ENTRY(PMIC_DA_VAUX18_B_LP),
	PMIC_ENTRY(PMIC_DA_VAUX18_L_EN),
	PMIC_ENTRY(PMIC_DA_VAUX18_L_STB),
	PMIC_ENTRY(PMIC_DA_VAUX18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VAUX18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VAUX18_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_LDO_GNR1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR1_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR1_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR1_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSIM1_B_EN),
	PMIC_ENTRY(PMIC_DA_VSIM1_B_STB),
	PMIC_ENTRY(PMIC_DA_VSIM1_B_LP),
	PMIC_ENTRY(PMIC_DA_VSIM1_L_EN),
	PMIC_ENTRY(PMIC_DA_VSIM1_L_STB),
	PMIC_ENTRY(PMIC_DA_VSIM1_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSIM1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_EINT_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_EINT_POL),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM1_EINT_DB_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSIM2_B_EN),
	PMIC_ENTRY(PMIC_DA_VSIM2_B_STB),
	PMIC_ENTRY(PMIC_DA_VSIM2_B_LP),
	PMIC_ENTRY(PMIC_DA_VSIM2_L_EN),
	PMIC_ENTRY(PMIC_DA_VSIM2_L_STB),
	PMIC_ENTRY(PMIC_DA_VSIM2_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSIM2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_EINT_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_EINT_POL),
	PMIC_ENTRY(PMIC_RG_LDO_VSIM2_EINT_DB_SEL),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VCN18_B_EN),
	PMIC_ENTRY(PMIC_DA_VCN18_B_STB),
	PMIC_ENTRY(PMIC_DA_VCN18_B_LP),
	PMIC_ENTRY(PMIC_DA_VCN18_L_EN),
	PMIC_ENTRY(PMIC_DA_VCN18_L_STB),
	PMIC_ENTRY(PMIC_DA_VCN18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VCN18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VCN18_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VEMC_B_EN),
	PMIC_ENTRY(PMIC_DA_VEMC_B_STB),
	PMIC_ENTRY(PMIC_DA_VEMC_B_LP),
	PMIC_ENTRY(PMIC_DA_VEMC_L_EN),
	PMIC_ENTRY(PMIC_DA_VEMC_L_STB),
	PMIC_ENTRY(PMIC_DA_VEMC_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VEMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VEMC_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VMC_B_EN),
	PMIC_ENTRY(PMIC_DA_VMC_B_STB),
	PMIC_ENTRY(PMIC_DA_VMC_B_LP),
	PMIC_ENTRY(PMIC_DA_VMC_L_EN),
	PMIC_ENTRY(PMIC_DA_VMC_L_STB),
	PMIC_ENTRY(PMIC_DA_VMC_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VMC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMC_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VIO18_1_B_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_1_B_STB),
	PMIC_ENTRY(PMIC_DA_VIO18_1_B_LP),
	PMIC_ENTRY(PMIC_DA_VIO18_1_L_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_1_L_STB),
	PMIC_ENTRY(PMIC_DA_VIO18_1_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_1_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_LDO_GNR2_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR2_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR2_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR2_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR2_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR2_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VIO18_2_B_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_2_B_STB),
	PMIC_ENTRY(PMIC_DA_VIO18_2_B_LP),
	PMIC_ENTRY(PMIC_DA_VIO18_2_L_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_2_L_STB),
	PMIC_ENTRY(PMIC_DA_VIO18_2_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VIO18_2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VIO18_2_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VUSB_B_EN),
	PMIC_ENTRY(PMIC_DA_VUSB_B_STB),
	PMIC_ENTRY(PMIC_DA_VUSB_B_LP),
	PMIC_ENTRY(PMIC_DA_VUSB_L_EN),
	PMIC_ENTRY(PMIC_DA_VUSB_L_STB),
	PMIC_ENTRY(PMIC_DA_VUSB_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VUSB_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VUSB_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VRF09_B_EN),
	PMIC_ENTRY(PMIC_DA_VRF09_B_STB),
	PMIC_ENTRY(PMIC_DA_VRF09_B_LP),
	PMIC_ENTRY(PMIC_DA_VRF09_L_EN),
	PMIC_ENTRY(PMIC_DA_VRF09_L_STB),
	PMIC_ENTRY(PMIC_DA_VRF09_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRF09_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF09_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VA12_1_B_EN),
	PMIC_ENTRY(PMIC_DA_VA12_1_B_STB),
	PMIC_ENTRY(PMIC_DA_VA12_1_B_LP),
	PMIC_ENTRY(PMIC_DA_VA12_1_L_EN),
	PMIC_ENTRY(PMIC_DA_VA12_1_L_STB),
	PMIC_ENTRY(PMIC_DA_VA12_1_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VA12_1_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VA12_1_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VRF13_B_EN),
	PMIC_ENTRY(PMIC_DA_VRF13_B_STB),
	PMIC_ENTRY(PMIC_DA_VRF13_B_LP),
	PMIC_ENTRY(PMIC_DA_VRF13_L_EN),
	PMIC_ENTRY(PMIC_DA_VRF13_L_STB),
	PMIC_ENTRY(PMIC_DA_VRF13_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRF13_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF13_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VRF18_B_EN),
	PMIC_ENTRY(PMIC_DA_VRF18_B_STB),
	PMIC_ENTRY(PMIC_DA_VRF18_B_LP),
	PMIC_ENTRY(PMIC_DA_VRF18_L_EN),
	PMIC_ENTRY(PMIC_DA_VRF18_L_STB),
	PMIC_ENTRY(PMIC_DA_VRF18_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VRF18_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VRF18_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_LDO_GNR3_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_GNR3_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_GNR3_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR3_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR3_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR3_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_GNR3_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_GNR3_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_GNR3_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_GNR3_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VMDDR_B_EN),
	PMIC_ENTRY(PMIC_DA_VMDDR_B_STB),
	PMIC_ENTRY(PMIC_DA_VMDDR_B_LP),
	PMIC_ENTRY(PMIC_DA_VMDDR_L_EN),
	PMIC_ENTRY(PMIC_DA_VMDDR_L_STB),
	PMIC_ENTRY(PMIC_DA_VMDDR_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VMDDR_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDR_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VMDDQ_B_EN),
	PMIC_ENTRY(PMIC_DA_VMDDQ_B_STB),
	PMIC_ENTRY(PMIC_DA_VMDDQ_B_LP),
	PMIC_ENTRY(PMIC_DA_VMDDQ_L_EN),
	PMIC_ENTRY(PMIC_DA_VMDDQ_L_STB),
	PMIC_ENTRY(PMIC_DA_VMDDQ_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VMDDQ_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDDQ_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VMDD2_B_EN),
	PMIC_ENTRY(PMIC_DA_VMDD2_B_STB),
	PMIC_ENTRY(PMIC_DA_VMDD2_B_LP),
	PMIC_ENTRY(PMIC_DA_VMDD2_L_EN),
	PMIC_ENTRY(PMIC_DA_VMDD2_L_STB),
	PMIC_ENTRY(PMIC_DA_VMDD2_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VMDD2_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_EN_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_EN_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VMDD2_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_VSRAM0_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_PROC_EN),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_PROC_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_B_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_B_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_B_LP),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_L_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_L_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_LDO_VSRAM_PROC_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_PROC_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_EN1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_EN1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_PROC_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_CORE_EN),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_CORE_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_B_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_B_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_B_LP),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_L_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_L_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_LDO_VSRAM_CORE_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_CORE_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_EN1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_EN1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_TRACK_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_TRACK_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_VOSEL_DELTA),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_VOSEL_OFFSET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_VOSEL_LB),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_CORE_VOSEL_HB),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DSN_CBS),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DSN_BIX),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DSN_ESP),
	PMIC_ENTRY(PMIC_LDO_VSRAM1_DSN_FPI),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_RFDIG_EN),
	PMIC_ENTRY(PMIC_RG_VRC_LDO_VSRAM_RFDIG_LP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_STBTD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_ULP),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OCFB_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OC_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OC_TSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_MODE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_R2R_PDN_DIS),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_CK_SW_MODE),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_B_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_B_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_B_LP),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_L_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_L_STB),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_OCFB_EN),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_DUMMY_LOAD),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_VSLEEP_SEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_R2R_PDN),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_TRACK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_VOSEL_SLEEP),
	PMIC_ENTRY(PMIC_LDO_VSRAM_RFDIG_WDTDBG_VOSEL),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_VOSEL_GRAY),
	PMIC_ENTRY(PMIC_DA_VSRAM_RFDIG_VOSEL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_SFCHG_RRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_SFCHG_REN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_SFCHG_FRATE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_SFCHG_FEN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_DVS_TRANS_TD),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_DVS_TRANS_CTRL),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_DVS_TRANS_ONCE),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW0_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW1_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW2_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW3_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW4_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW5_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW6_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW7_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_EN0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_EN0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW8_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW9_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW10_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW11_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW12_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW13_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW14_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_SW_OP_EN),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_EN1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_EN1_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW0_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW1_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW2_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW3_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW4_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW5_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW6_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW7_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_CFG0_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_CFG0_CLR),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW8_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW9_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW10_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW11_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW12_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW13_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_HW14_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_SW_OP_CFG),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_CFG1_SET),
	PMIC_ENTRY(PMIC_RG_LDO_VSRAM_RFDIG_OP_CFG1_CLR),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA0_CBS),
	PMIC_ENTRY(PMIC_LDO_ANA0_BIX),
	PMIC_ENTRY(PMIC_LDO_ANA0_ESP),
	PMIC_ENTRY(PMIC_LDO_ANA0_FPI),
	PMIC_ENTRY(PMIC_LDO_ANA0_DXI),
	PMIC_ENTRY(PMIC_RG_VAUX18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VAUX18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VAUX18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VAUX18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VAUX18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VAUX18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VUSB_VOCAL),
	PMIC_ENTRY(PMIC_RG_VUSB_VOSEL),
	PMIC_ENTRY(PMIC_RG_VUSB_STB_SEL),
	PMIC_ENTRY(PMIC_RG_VUSB_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VUSB_RSV_1),
	PMIC_ENTRY(PMIC_RG_VUSB_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VUSB_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VUSB_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VUSB_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VUSB_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_VOCAL),
	PMIC_ENTRY(PMIC_RG_VEMC_VOSEL),
	PMIC_ENTRY(PMIC_RG_VEMC_STB_SEL),
	PMIC_ENTRY(PMIC_RG_VEMC_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_RSV_1),
	PMIC_ENTRY(PMIC_RG_VEMC_RSV_0),
	PMIC_ENTRY(PMIC_RG_VEMC_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VEMC_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VEMC_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VEMC_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOCAL),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOSEL),
	PMIC_ENTRY(PMIC_RG_VSIM1_STB_SEL),
	PMIC_ENTRY(PMIC_RG_VSIM1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_RSV_1),
	PMIC_ENTRY(PMIC_RG_VSIM1_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSIM1_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSIM1_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSIM1_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOCAL),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOSEL),
	PMIC_ENTRY(PMIC_RG_VSIM2_STB_SEL),
	PMIC_ENTRY(PMIC_RG_VSIM2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_RSV_1),
	PMIC_ENTRY(PMIC_RG_VSIM2_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSIM2_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSIM2_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSIM2_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOCAL),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOSEL),
	PMIC_ENTRY(PMIC_RG_VEFUSE_STB_SEL),
	PMIC_ENTRY(PMIC_RG_VEFUSE_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_RSV_1),
	PMIC_ENTRY(PMIC_RG_VEFUSE_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VEFUSE_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VEFUSE_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VEFUSE_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VMC_VOCAL),
	PMIC_ENTRY(PMIC_RG_VMC_VOSEL),
	PMIC_ENTRY(PMIC_RG_VMC_STB_SEL),
	PMIC_ENTRY(PMIC_RG_VMC_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMC_RSV_1),
	PMIC_ENTRY(PMIC_RG_VMC_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VMC_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VMC_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VMC_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VMC_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_ALDO_RSV),
	PMIC_ENTRY(PMIC_RG_DLDO_RSV),
	PMIC_ENTRY(PMIC_LDO_ANA0_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VAUX18_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VAUX18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VAUX18_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VUSB_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VUSB_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VUSB_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VEMC_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VEMC_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VEMC_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VSIM1_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VSIM1_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VSIM1_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VSIM2_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VSIM2_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VSIM2_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VEFUSE_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VEFUSE_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMC_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VMC_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VMC_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VRTC28_BIAS_SEL),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA1_CBS),
	PMIC_ENTRY(PMIC_LDO_ANA1_BIX),
	PMIC_ENTRY(PMIC_LDO_ANA1_ESP),
	PMIC_ENTRY(PMIC_LDO_ANA1_FPI),
	PMIC_ENTRY(PMIC_LDO_ANA1_DXI),
	PMIC_ENTRY(PMIC_RG_VRF18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRF18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRF18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_RSV_0),
	PMIC_ENTRY(PMIC_RG_VRF18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VRF18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VRF18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VRF18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VCN18_VOCAL),
	PMIC_ENTRY(PMIC_RG_VCN18_VOSEL),
	PMIC_ENTRY(PMIC_RG_VCN18_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_RSV_1),
	PMIC_ENTRY(PMIC_RG_VCN18_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VCN18_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VCN18_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VIO18_1_VOCAL),
	PMIC_ENTRY(PMIC_RG_VIO18_1_VOSEL),
	PMIC_ENTRY(PMIC_RG_VIO18_1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_1_RSV_1),
	PMIC_ENTRY(PMIC_RG_VIO18_1_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_1_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_1_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_1_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VIO18_1_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VIO18_2_VOCAL),
	PMIC_ENTRY(PMIC_RG_VIO18_2_VOSEL),
	PMIC_ENTRY(PMIC_RG_VIO18_2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_2_RSV_1),
	PMIC_ENTRY(PMIC_RG_VIO18_2_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_2_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_2_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VIO18_2_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VIO18_2_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_SLDO20_RSV),
	PMIC_ENTRY(PMIC_RG_VA12_1_VOCAL),
	PMIC_ENTRY(PMIC_RG_VA12_1_VOSEL),
	PMIC_ENTRY(PMIC_RG_VA12_1_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VA12_1_RSV_1),
	PMIC_ENTRY(PMIC_RG_VA12_1_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VA12_1_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VA12_1_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VA12_1_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VA12_1_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VA12_2_VOCAL),
	PMIC_ENTRY(PMIC_RG_VA12_2_VOSEL),
	PMIC_ENTRY(PMIC_RG_VA12_2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VA12_2_RSV_0),
	PMIC_ENTRY(PMIC_RG_VA12_2_RSV_1),
	PMIC_ENTRY(PMIC_RG_VA12_2_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VA12_2_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VA12_2_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VA12_2_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VA12_2_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VRF13_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRF13_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRF13_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRF13_RSV_0),
	PMIC_ENTRY(PMIC_RG_VRF13_RSV_1),
	PMIC_ENTRY(PMIC_RG_VRF13_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VRF13_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRF13_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VRF13_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VRF13_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VMDD2_VOCAL),
	PMIC_ENTRY(PMIC_RG_VMDD2_VOCAL_F),
	PMIC_ENTRY(PMIC_RG_VMDD2_VOSEL),
	PMIC_ENTRY(PMIC_RG_VMDD2_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMDD2_RSV_1),
	PMIC_ENTRY(PMIC_RG_VMDD2_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VMDD2_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VMDD2_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VMDD2_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VMDD2_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_RSV_1),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSRAM_PROC_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_SLDO14_RSV),
	PMIC_ENTRY(PMIC_RG_VRF09_VOCAL),
	PMIC_ENTRY(PMIC_RG_VRF09_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRF09_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRF09_RSV_0),
	PMIC_ENTRY(PMIC_RG_VRF09_RSV_1),
	PMIC_ENTRY(PMIC_RG_VRF09_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VRF09_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRF09_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VRF09_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VRF09_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VMDDQ_VOCAL),
	PMIC_ENTRY(PMIC_RG_VMDDQ_VOCAL_F),
	PMIC_ENTRY(PMIC_RG_VMDDQ_VOSEL),
	PMIC_ENTRY(PMIC_RG_VMDDQ_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMDDQ_RSV_1),
	PMIC_ENTRY(PMIC_RG_VMDDQ_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VMDDQ_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VMDDQ_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VMDDQ_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VMDDQ_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VMDDR_VOCAL),
	PMIC_ENTRY(PMIC_RG_VMDDR_VOCAL_F),
	PMIC_ENTRY(PMIC_RG_VMDDR_VOSEL),
	PMIC_ENTRY(PMIC_RG_VMDDR_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VMDDR_RSV_1),
	PMIC_ENTRY(PMIC_RG_VMDDR_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VMDDR_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VMDDR_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VMDDR_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VMDDR_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_RSV_1),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSRAM_CORE_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_RSV_1),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_NDIS_PLCUR),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VSRAM_RFDIG_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_SLDO10_RSV),
	PMIC_ENTRY(PMIC_LDO_ANA1_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VRF18_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VRF18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRF18_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VCN18_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VCN18_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VCN18_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VIO18_1_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VIO18_1_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VIO18_1_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VIO18_2_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VIO18_2_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VIO18_2_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VA12_1_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VA12_1_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VA12_1_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VA12_2_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VA12_2_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VA12_2_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VRF13_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VRF13_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRF13_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMDD2_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VMDD2_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VMDD2_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_PROC_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VRF09_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VRF09_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRF09_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMDDQ_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VMDDQ_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VMDDQ_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VMDDR_VO_F_TRIM),
	PMIC_ENTRY(PMIC_RG_VMDDR_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VMDDR_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_CORE_OC_TRIM),
	PMIC_ENTRY(PMIC_RG_VSRAM_RFDIG_OC_TRIM),
	PMIC_ENTRY(PMIC_LDO_ANA2_ANA_ID),
	PMIC_ENTRY(PMIC_LDO_ANA2_DIG_ID),
	PMIC_ENTRY(PMIC_LDO_ANA2_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA2_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA2_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA2_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_LDO_ANA2_CBS),
	PMIC_ENTRY(PMIC_LDO_ANA2_BIX),
	PMIC_ENTRY(PMIC_LDO_ANA2_ESP),
	PMIC_ENTRY(PMIC_LDO_ANA2_FPI),
	PMIC_ENTRY(PMIC_LDO_ANA2_DXI),
	PMIC_ENTRY(PMIC_RG_VXO22_VOCAL),
	PMIC_ENTRY(PMIC_RG_VXO22_VOSEL),
	PMIC_ENTRY(PMIC_RG_VXO22_RSV_1),
	PMIC_ENTRY(PMIC_RG_VXO22_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VXO22_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VXO22_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VXO22_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VXO22_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VRFCK_VOSEL),
	PMIC_ENTRY(PMIC_RG_VRFCK_OP_CUR_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_RSV_1),
	PMIC_ENTRY(PMIC_RG_VRFCK_OC_LP_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_ULP_IQ_CLAMP_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_ULP_BIASX2_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_MEASURE_FT_EN),
	PMIC_ENTRY(PMIC_RGS_VRFCK_OC_STATUS),
	PMIC_ENTRY(PMIC_RG_VBBCK_OP_CUR_EN),
	PMIC_ENTRY(PMIC_RGS_VBBCK_OC_STATUS),
	PMIC_ENTRY(PMIC_LDO_ANA2_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_VXO22_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VXO22_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_VOTRIM),
	PMIC_ENTRY(PMIC_RG_VRFCK_HV_EN),
	PMIC_ENTRY(PMIC_RG_VRFCK_NDIS_EN),
	PMIC_ENTRY(PMIC_RG_VBBCK_NDIS_EN),
	PMIC_ENTRY(PMIC_XPP_TOP_ANA_ID),
	PMIC_ENTRY(PMIC_XPP_TOP_DIG_ID),
	PMIC_ENTRY(PMIC_XPP_TOP_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_XPP_TOP_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_XPP_TOP_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_XPP_TOP_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_XPP_TOP_CBS),
	PMIC_ENTRY(PMIC_XPP_TOP_BIX),
	PMIC_ENTRY(PMIC_XPP_TOP_ESP),
	PMIC_ENTRY(PMIC_XPP_TOP_FPI),
	PMIC_ENTRY(PMIC_XPP_TOP_CLK_OFFSET),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_OFFSET),
	PMIC_ENTRY(PMIC_XPP_TOP_INT_OFFSET),
	PMIC_ENTRY(PMIC_XPP_TOP_INT_LEN),
	PMIC_ENTRY(PMIC_XPP_TEST_OUT),
	PMIC_ENTRY(PMIC_XPP_MON_GRP_SEL),
	PMIC_ENTRY(PMIC_XPP_MON_FLAG_SEL),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK0_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK1_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK2_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK3_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_128K_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_CHRIND_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK5_CK_PDN),
	PMIC_ENTRY(PMIC_RG_DRV_ISINK4_CK_PDN),
	PMIC_ENTRY(PMIC_XPP_TOP_CKPDN_CON0_SET),
	PMIC_ENTRY(PMIC_XPP_TOP_CKPDN_CON0_CLR),
	PMIC_ENTRY(PMIC_BST_32K_CK_RSV),
	PMIC_ENTRY(PMIC_RG_DRIVER_BL_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_CI_RST),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_CON0_SET),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_CON0_CLR),
	PMIC_ENTRY(PMIC_RG_DRIVER_BL_BANK_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_CI_BANK_RST),
	PMIC_ENTRY(PMIC_RG_DRIVER_DL_BANK_RST),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_BANK_CON0_SET),
	PMIC_ENTRY(PMIC_XPP_TOP_RST_BANK_CON0_CLR),
	PMIC_ENTRY(PMIC_DRIVER_BL_ANA_ID),
	PMIC_ENTRY(PMIC_DRIVER_BL_DIG_ID),
	PMIC_ENTRY(PMIC_DRIVER_BL_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_BL_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_BL_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_BL_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_BL_DSN_CBS),
	PMIC_ENTRY(PMIC_DRIVER_BL_DSN_BIX),
	PMIC_ENTRY(PMIC_DRIVER_BL_DSN_ESP),
	PMIC_ENTRY(PMIC_DRIVER_BL_DSN_FPI),
	PMIC_ENTRY(PMIC_ISINK3_DIM_FSEL_L),
	PMIC_ENTRY(PMIC_ISINK3_DIM_FSEL_H),
	PMIC_ENTRY(PMIC_ISINK3_DIM_DUTY),
	PMIC_ENTRY(PMIC_ISINK3_BREATH_TR2_SEL),
	PMIC_ENTRY(PMIC_ISINK3_BREATH_TR1_SEL),
	PMIC_ENTRY(PMIC_ISINK3_BREATH_TF2_SEL),
	PMIC_ENTRY(PMIC_ISINK3_BREATH_TF1_SEL),
	PMIC_ENTRY(PMIC_ISINK3_BREATH_TOFF_SEL),
	PMIC_ENTRY(PMIC_ISINK3_BREATH_TON_SEL),
	PMIC_ENTRY(PMIC_ISINK1_DIM_FSEL_L),
	PMIC_ENTRY(PMIC_ISINK1_DIM_FSEL_H),
	PMIC_ENTRY(PMIC_ISINK1_DIM_DUTY),
	PMIC_ENTRY(PMIC_ISINK1_BREATH_TR2_SEL),
	PMIC_ENTRY(PMIC_ISINK1_BREATH_TR1_SEL),
	PMIC_ENTRY(PMIC_ISINK1_BREATH_TF2_SEL),
	PMIC_ENTRY(PMIC_ISINK1_BREATH_TF1_SEL),
	PMIC_ENTRY(PMIC_ISINK1_BREATH_TOFF_SEL),
	PMIC_ENTRY(PMIC_ISINK1_BREATH_TON_SEL),
	PMIC_ENTRY(PMIC_ISINK2_DIM_FSEL_L),
	PMIC_ENTRY(PMIC_ISINK2_DIM_FSEL_H),
	PMIC_ENTRY(PMIC_ISINK2_DIM_DUTY),
	PMIC_ENTRY(PMIC_ISINK2_BREATH_TR2_SEL),
	PMIC_ENTRY(PMIC_ISINK2_BREATH_TR1_SEL),
	PMIC_ENTRY(PMIC_ISINK2_BREATH_TF2_SEL),
	PMIC_ENTRY(PMIC_ISINK2_BREATH_TF1_SEL),
	PMIC_ENTRY(PMIC_ISINK2_BREATH_TOFF_SEL),
	PMIC_ENTRY(PMIC_ISINK2_BREATH_TON_SEL),
	PMIC_ENTRY(PMIC_AD_ISINK3_STATUS),
	PMIC_ENTRY(PMIC_AD_ISINK2_STATUS),
	PMIC_ENTRY(PMIC_AD_ISINK1_STATUS),
	PMIC_ENTRY(PMIC_AD_ISINK0_STATUS),
	PMIC_ENTRY(PMIC_ISINK3_CHOP_CLK_SW_SEL),
	PMIC_ENTRY(PMIC_ISINK3_CHOP_CLK_SW),
	PMIC_ENTRY(PMIC_ISINK3_PHASE_DLY_EN),
	PMIC_ENTRY(PMIC_ISINK3_PHASE_DLY_TC),
	PMIC_ENTRY(PMIC_ISINK1_CHOP_CLK_SW_SEL),
	PMIC_ENTRY(PMIC_ISINK1_CHOP_CLK_SW),
	PMIC_ENTRY(PMIC_ISINK1_PHASE_DLY_EN),
	PMIC_ENTRY(PMIC_ISINK1_PHASE_DLY_TC),
	PMIC_ENTRY(PMIC_ISINK2_CHOP_CLK_SW_SEL),
	PMIC_ENTRY(PMIC_ISINK2_CHOP_CLK_SW),
	PMIC_ENTRY(PMIC_ISINK2_PHASE_DLY_EN),
	PMIC_ENTRY(PMIC_ISINK2_PHASE_DLY_TC),
	PMIC_ENTRY(PMIC_ISINK1_SFSTR_EN),
	PMIC_ENTRY(PMIC_ISINK1_SFSTR_TC),
	PMIC_ENTRY(PMIC_ISINK3_SFSTR_EN),
	PMIC_ENTRY(PMIC_ISINK3_SFSTR_TC),
	PMIC_ENTRY(PMIC_ISINK2_SFSTR_EN),
	PMIC_ENTRY(PMIC_ISINK2_SFSTR_TC),
	PMIC_ENTRY(PMIC_ISINK3_RSV),
	PMIC_ENTRY(PMIC_ISINK3_PWM_MODE),
	PMIC_ENTRY(PMIC_ISINK3_MODE),
	PMIC_ENTRY(PMIC_ISINK1_RSV),
	PMIC_ENTRY(PMIC_ISINK1_PWM_MODE),
	PMIC_ENTRY(PMIC_ISINK1_MODE),
	PMIC_ENTRY(PMIC_ISINK2_RSV),
	PMIC_ENTRY(PMIC_ISINK2_PWM_MODE),
	PMIC_ENTRY(PMIC_ISINK2_MODE),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_EN),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_SEL),
	PMIC_ENTRY(PMIC_RG_ISINK_RSV),
	PMIC_ENTRY(PMIC_RG_ISINK1_CHOP_EN),
	PMIC_ENTRY(PMIC_RG_ISINK2_CHOP_EN),
	PMIC_ENTRY(PMIC_RG_ISINK3_CHOP_EN),
	PMIC_ENTRY(PMIC_RG_ISINK1_DOUBLE),
	PMIC_ENTRY(PMIC_RG_ISINK2_DOUBLE),
	PMIC_ENTRY(PMIC_RG_ISINK3_DOUBLE),
	PMIC_ENTRY(PMIC_DA_ISINK0_EN),
	PMIC_ENTRY(PMIC_DA_ISINK0_BIAS_EN),
	PMIC_ENTRY(PMIC_DA_ISINK0_CHOP_CLK),
	PMIC_ENTRY(PMIC_DA_ISINK0_STEP),
	PMIC_ENTRY(PMIC_DA_ISINK1_EN),
	PMIC_ENTRY(PMIC_DA_ISINK1_BIAS_EN),
	PMIC_ENTRY(PMIC_DA_ISINK1_CHOP_CLK),
	PMIC_ENTRY(PMIC_DA_ISINK1_STEP),
	PMIC_ENTRY(PMIC_DA_ISINK2_EN),
	PMIC_ENTRY(PMIC_DA_ISINK2_BIAS_EN),
	PMIC_ENTRY(PMIC_DA_ISINK2_CHOP_CLK),
	PMIC_ENTRY(PMIC_DA_ISINK2_STEP),
	PMIC_ENTRY(PMIC_DA_ISINK3_EN),
	PMIC_ENTRY(PMIC_DA_ISINK3_BIAS_EN),
	PMIC_ENTRY(PMIC_DA_ISINK3_CHOP_CLK),
	PMIC_ENTRY(PMIC_DA_ISINK3_STEP),
	PMIC_ENTRY(PMIC_DRIVER_BL_ELR_LEN),
	PMIC_ENTRY(PMIC_RG_ISINK_TRIM_BIAS),
	PMIC_ENTRY(PMIC_DRIVER_DL_ANA_ID),
	PMIC_ENTRY(PMIC_DRIVER_DL_DIG_ID),
	PMIC_ENTRY(PMIC_DRIVER_DL_ANA_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_DL_ANA_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_DL_DIG_MINOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_DL_DIG_MAJOR_REV),
	PMIC_ENTRY(PMIC_DRIVER_DL_DSN_CBS),
	PMIC_ENTRY(PMIC_DRIVER_DL_DSN_BIX),
	PMIC_ENTRY(PMIC_DRIVER_DL_DSN_ESP),
	PMIC_ENTRY(PMIC_DRIVER_DL_DSN_FPI),
	PMIC_ENTRY(PMIC_EN0_GPIO_SEL),
	PMIC_ENTRY(PMIC_BIAS0_GPIO_SEL),
	PMIC_ENTRY(PMIC_STEP0_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHOP0_GPIO_SEL),
	PMIC_ENTRY(PMIC_ISINK_CH0_STEP),
	PMIC_ENTRY(PMIC_EN1_GPIO_SEL),
	PMIC_ENTRY(PMIC_BIAS1_GPIO_SEL),
	PMIC_ENTRY(PMIC_STEP1_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHOP1_GPIO_SEL),
	PMIC_ENTRY(PMIC_ISINK_CH1_STEP),
	PMIC_ENTRY(PMIC_EN2_GPIO_SEL),
	PMIC_ENTRY(PMIC_BIAS2_GPIO_SEL),
	PMIC_ENTRY(PMIC_STEP2_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHOP2_GPIO_SEL),
	PMIC_ENTRY(PMIC_ISINK_CH2_STEP),
	PMIC_ENTRY(PMIC_EN3_GPIO_SEL),
	PMIC_ENTRY(PMIC_BIAS3_GPIO_SEL),
	PMIC_ENTRY(PMIC_STEP3_GPIO_SEL),
	PMIC_ENTRY(PMIC_CHOP3_GPIO_SEL),
	PMIC_ENTRY(PMIC_ISINK_CH3_STEP),
	PMIC_ENTRY(PMIC_ISINK_CHOP3_EN),
	PMIC_ENTRY(PMIC_ISINK_CHOP2_EN),
	PMIC_ENTRY(PMIC_ISINK_CHOP1_EN),
	PMIC_ENTRY(PMIC_ISINK_CHOP0_EN),
	PMIC_ENTRY(PMIC_ISINK_CH3_BIAS_EN),
	PMIC_ENTRY(PMIC_ISINK_CH2_BIAS_EN),
	PMIC_ENTRY(PMIC_ISINK_CH1_BIAS_EN),
	PMIC_ENTRY(PMIC_ISINK_CH0_BIAS_EN),
	PMIC_ENTRY(PMIC_ISINK_CH3_EN),
	PMIC_ENTRY(PMIC_ISINK_CH2_EN),
	PMIC_ENTRY(PMIC_ISINK_CH1_EN),
	PMIC_ENTRY(PMIC_ISINK_CH0_EN),
	PMIC_ENTRY(PMIC_ISINK_DIM_DUTY_RESERVE_SEL),
};
