/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Copyright (c) 2019 MediaTek Inc.
 * Author: Joey Pan <joey.pan@mediatek.com>
 */

#ifndef _DDP_REG_OVL_H_
#define _DDP_REG_OVL_H_

#define DISP_REG_OVL_STA				(0x000UL)
	#define STA_FLD_RUN				REG_FLD_MSB_LSB(0, 0)
	#define STA_FLD_RDMA0_IDLE			REG_FLD_MSB_LSB(1, 1)
	#define STA_FLD_RDMA1_IDLE			REG_FLD_MSB_LSB(2, 2)
	#define STA_FLD_RDMA2_IDLE			REG_FLD_MSB_LSB(3, 3)
	#define STA_FLD_RDMA3_IDLE			REG_FLD_MSB_LSB(4, 4)

#define DISP_REG_OVL_INTEN				(0x004UL)
	#define INTEN_FLD_REG_CMT_INTEN			REG_FLD_MSB_LSB(0, 0)
	#define INTEN_FLD_FME_CPL_INTEN			REG_FLD_MSB_LSB(1, 1)
	#define INTEN_FLD_FME_UND_INTEN			REG_FLD_MSB_LSB(2, 2)
	#define INTEN_FLD_FME_SWRST_DONE_INTEN		REG_FLD_MSB_LSB(3, 3)
	#define INTEN_FLD_FME_HWRST_DONE_INTEN		REG_FLD_MSB_LSB(4, 4)
	#define INTEN_FLD_RDMA0_EOF_ABNORMAL_INTEN	REG_FLD_MSB_LSB(5, 5)
	#define INTEN_FLD_RDMA1_EOF_ABNORMAL_INTEN	REG_FLD_MSB_LSB(6, 6)
	#define INTEN_FLD_RDMA2_EOF_ABNORMAL_INTEN	REG_FLD_MSB_LSB(7, 7)
	#define INTEN_FLD_RDMA3_EOF_ABNORMAL_INTEN	REG_FLD_MSB_LSB(8, 8)
	#define INTEN_FLD_RDMA0_SMI_UNDERFLOW_INTEN	REG_FLD_MSB_LSB(9, 9)
	#define INTEN_FLD_RDMA1_SMI_UNDERFLOW_INTEN	REG_FLD_MSB_LSB(10, 10)
	#define INTEN_FLD_RDMA2_SMI_UNDERFLOW_INTEN	REG_FLD_MSB_LSB(11, 11)
	#define INTEN_FLD_RDMA3_SMI_UNDERFLOW_INTEN	REG_FLD_MSB_LSB(12, 12)
	#define INTEN_FLD_ABNORMAL_SOF			REG_FLD_MSB_LSB(13, 13)
	#define INTEN_FLD_START_INTEN			REG_FLD_MSB_LSB(14, 14)

#define DISP_REG_OVL_INTSTA				(0x008UL)
	#define INTSTA_FLD_REG_CMT_INTSTA		REG_FLD_MSB_LSB(0, 0)
	#define INTSTA_FLD_FME_CPL_INTSTA		REG_FLD_MSB_LSB(1, 1)
	#define INTSTA_FLD_FME_UND_INTSTA		REG_FLD_MSB_LSB(2, 2)
	#define INTSTA_FLD_FME_SWRST_DONE_INTSTA	REG_FLD_MSB_LSB(3, 3)
	#define INTSTA_FLD_FME_HWRST_DONE_INTSTA	REG_FLD_MSB_LSB(4, 4)
	#define INTSTA_FLD_RDMA0_EOF_ABNORMAL_INTSTA	REG_FLD_MSB_LSB(5, 5)
	#define INTSTA_FLD_RDMA1_EOF_ABNORMAL_INTSTA	REG_FLD_MSB_LSB(6, 6)
	#define INTSTA_FLD_RDMA2_EOF_ABNORMAL_INTSTA	REG_FLD_MSB_LSB(7, 7)
	#define INTSTA_FLD_RDMA3_EOF_ABNORMAL_INTSTA	REG_FLD_MSB_LSB(8, 8)
	#define INTSTA_FLD_RDMA0_SMI_UNDERFLOW_INTSTA	REG_FLD_MSB_LSB(9, 9)
	#define INTSTA_FLD_RDMA1_SMI_UNDERFLOW_INTSTA	REG_FLD_MSB_LSB(10, 10)
	#define INTSTA_FLD_RDMA2_SMI_UNDERFLOW_INTSTA	REG_FLD_MSB_LSB(11, 11)
	#define INTSTA_FLD_RDMA3_SMI_UNDERFLOW_INTSTA	REG_FLD_MSB_LSB(12, 12)
	#define INTSTA_FLD_ABNORMAL_SOF			REG_FLD_MSB_LSB(13, 13)
	#define INTSTA_FLD_START_INTEN			REG_FLD_MSB_LSB(14, 14)

#define DISP_REG_OVL_EN					(0x00CUL)
	#define EN_FLD_OVL_EN				REG_FLD_MSB_LSB(0, 0)
	#define EN_FLD_OP_8BIT_MODE			REG_FLD_MSB_LSB(4, 4)
	#define EN_FLD_OP_10BIT_MODE			REG_FLD_MSB_LSB(5, 5)
	#define EN_FLD_ARB_16F_NO_RND			REG_FLD_MSB_LSB(7, 7)
	#define EN_FLD_HG_FOVL_CK_ON			REG_FLD_MSB_LSB(8, 8)
	#define EN_FLD_HG_FSMI_CK_ON			REG_FLD_MSB_LSB(9, 9)
	#define EN_FLD_HF_FOVL_CK_ON			REG_FLD_MSB_LSB(10, 10)
	#define EN_FLD_IGNORE_ABN_SOF			REG_FLD_MSB_LSB(16, 16)
	#define EN_FLD_BLOCK_EXT_ULTRA			REG_FLD_MSB_LSB(18, 18)
	#define EN_FLD_BLOCK_EXT_PREULTRA		REG_FLD_MSB_LSB(19, 19)
	#define EN_FLD_NO_FORM_HDR_ULTRA		REG_FLD_MSB_LSB(28, 28)
	#define EN_FLD_NO_FORM_HDR_PREULTRA		REG_FLD_MSB_LSB(29, 29)

#define DISP_REG_OVL_TRIG				(0x010UL)
	#define TRIG_FLD_SW_TRIG			REG_FLD_MSB_LSB(0, 0)
	#define TRIG_FLD_CRC_EN				REG_FLD_MSB_LSB(8, 8)
	#define TRIG_FLD_CRC_CLR			REG_FLD_MSB_LSB(9, 9)

#define DISP_REG_OVL_RST				(0x014UL)
#define DISP_REG_OVL_ROI_SIZE				(0x020UL)
	#define ROI_SIZE_FLD_ROI_W			REG_FLD_MSB_LSB(12, 0)
	#define ROI_SIZE_FLD_ROI_H			REG_FLD_MSB_LSB(28, 16)

#define DISP_REG_OVL_DATAPATH_CON			(0x024UL)
	#define DATAPATH_CON_FLD_LAYER_SMI_ID_EN	REG_FLD_MSB_LSB(0, 0)
	#define DATAPATH_CON_FLD_RANDOM_BGCLR_EN	REG_FLD_MSB_LSB(1, 1)
	#define DATAPATH_CON_FLD_BGCLR_IN_SEL		REG_FLD_MSB_LSB(2, 2)
	#define DATAPATH_CON_FLD_OUTPUT_NO_RND		REG_FLD_MSB_LSB(3, 3)
	#define DATAPATH_CON_FLD_L0_FBDC_EN		REG_FLD_MSB_LSB(4, 4)
	#define DATAPATH_CON_FLD_L1_FBDC_EN		REG_FLD_MSB_LSB(5, 5)
	#define DATAPATH_CON_FLD_L2_FBDC_EN		REG_FLD_MSB_LSB(6, 6)
	#define DATAPATH_CON_FLD_L3_FBDC_EN		REG_FLD_MSB_LSB(7, 7)
	#define DATAPATH_CON_FLD_LX_FBDC_EN		REG_FLD_MSB_LSB(7, 4)
	#define DATAPATH_CON_FLD_L0_GPU_MODE		REG_FLD_MSB_LSB(8, 8)
	#define DATAPATH_CON_FLD_L1_GPU_MODE		REG_FLD_MSB_LSB(9, 9)
	#define DATAPATH_CON_FLD_L2_GPU_MODE		REG_FLD_MSB_LSB(10, 10)
	#define DATAPATH_CON_FLD_L3_GPU_MODE		REG_FLD_MSB_LSB(11, 11)
	#define DATAPATH_CON_FLD_ADOBE_MODE		REG_FLD_MSB_LSB(12, 12)
	#define DATAPATH_CON_FLD_ADOBE_LAYER		REG_FLD_MSB_LSB(14, 13)
	#define DATAPATH_CON_FLD_OVL_GAMMA_OUT		REG_FLD_MSB_LSB(15, 15)
	#define DATAPATH_CON_FLD_PQ_OUT_SEL		REG_FLD_MSB_LSB(18, 16)
	#define DATAPATH_CON_FLD_PQ_OUT_EN		REG_FLD_MSB_LSB(19, 19)
	#define DATAPATH_CON_FLD_RDMA0_OUT_SEL		REG_FLD_MSB_LSB(20, 20)
	#define DATAPATH_CON_FLD_RDMA1_OUT_SEL		REG_FLD_MSB_LSB(21, 21)
	#define DATAPATH_CON_FLD_RDMA2_OUT_SEL		REG_FLD_MSB_LSB(22, 22)
	#define DATAPATH_CON_FLD_PQ_OUT_OPT		REG_FLD_MSB_LSB(23, 23)
	#define DATAPATH_CON_FLD_GCLAST_EN		REG_FLD_MSB_LSB(24, 24)
	#define DATAPATH_CON_FLD_HDR_GCLAST_EN		REG_FLD_MSB_LSB(25, 25)
	#define DATAPATH_CON_FLD_OUTPUT_CLAMP		REG_FLD_MSB_LSB(26, 26)
	#define DATAPATH_CON_FLD_OUTPUT_INTERLACE	REG_FLD_MSB_LSB(27, 27)

#define DISP_REG_OVL_ROI_BGCLR				(0x028UL)
	#define ROI_BGCLR_FLD_BLUE			REG_FLD_MSB_LSB(7, 0)
	#define ROI_BGCLR_FLD_GREEN			REG_FLD_MSB_LSB(15, 8)
	#define ROI_BGCLR_FLD_RED			REG_FLD_MSB_LSB(23, 16)
	#define ROI_BGCLR_FLD_ALPHA			REG_FLD_MSB_LSB(31, 24)

#define DISP_REG_OVL_SRC_CON				(0x02CUL)
	#define SRC_CON_FLD_L0_EN			REG_FLD_MSB_LSB(0, 0)
	#define SRC_CON_FLD_L1_EN			REG_FLD_MSB_LSB(1, 1)
	#define SRC_CON_FLD_L2_EN			REG_FLD_MSB_LSB(2, 2)
	#define SRC_CON_FLD_L3_EN			REG_FLD_MSB_LSB(3, 3)
	#define SRC_CON_FLD_LC_EN			REG_FLD_MSB_LSB(4, 4)
	#define SRC_CON_FLD_L_EN			REG_FLD_MSB_LSB(3, 0)
	#define SRC_CON_FORCE_RELAY_MODE		REG_FLD_MSB_LSB(8, 8)
	#define SRC_CON_RELAY_MODE_EN			REG_FLD_MSB_LSB(9, 9)

#define DISP_REG_OVL_L0_CON				(0x030UL)
	#define L_CON_FLD_APHA				REG_FLD_MSB_LSB(7, 0)
	#define L_CON_FLD_AEN				REG_FLD_MSB_LSB(8, 8)
	#define L_CON_FLD_VIRTICAL_FLIP			REG_FLD_MSB_LSB(9, 9)
	#define L_CON_FLD_HORI_FLIP			REG_FLD_MSB_LSB(10, 10)
	#define L_CON_FLD_EXT_MTX_EN			REG_FLD_MSB_LSB(11, 11)
	#define L_CON_FLD_CFMT				REG_FLD_MSB_LSB(15, 12)
	#define L_CON_FLD_MTX				REG_FLD_MSB_LSB(19, 16)
	#define L_CON_FLD_EN_3D				REG_FLD_MSB_LSB(20, 20)
	#define L_CON_FLD_EN_LANDSCAPE			REG_FLD_MSB_LSB(21, 21)
	#define L_CON_FLD_EN_R_FIRST			REG_FLD_MSB_LSB(22, 22)
	#define L_CON_FLD_CLRFMT_MAN			REG_FLD_MSB_LSB(23, 23)
	#define L_CON_FLD_BTSW				REG_FLD_MSB_LSB(24, 24)
	#define L_CON_FLD_RGB_SWAP			REG_FLD_MSB_LSB(25, 25)
	#define L_CON_FLD_MTX_AUTO_DIS			REG_FLD_MSB_LSB(26, 26)
	#define L_CON_FLD_MTX_EN			REG_FLD_MSB_LSB(27, 27)
	#define L_CON_FLD_LSRC				REG_FLD_MSB_LSB(29, 28)
	#define L_CON_FLD_SKEN				REG_FLD_MSB_LSB(30, 30)
	#define L_CON_FLD_DKEN				REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_L0_SRCKEY				(0x034UL)
#define DISP_REG_OVL_L0_SRC_SIZE			(0x038UL)
	#define SRC_SIZE_FLD_SRC_W			REG_FLD_MSB_LSB(12, 0)
	#define SRC_SIZE_FLD_SRC_H			REG_FLD_MSB_LSB(28, 16)

#define DISP_REG_OVL_L0_OFFSET				(0x03CUL)
	#define OFFSET_FLD_XOFF				REG_FLD_MSB_LSB(12, 0)
	#define OFFSET_FLD_YOFF				REG_FLD_MSB_LSB(28, 16)

#define DISP_REG_OVL_L0_ADDR				(0xf40UL)
#define DISP_REG_OVL_L0_PITCH_MSB			(0x040UL)
#define DISP_REG_OVL_L0_PITCH				(0x044UL)
	#define L_PITCH_FLD_SRC_PITCH			REG_FLD_MSB_LSB(15, 0)
	#define L_PITCH_FLD_SA_SEL			REG_FLD_MSB_LSB(17, 16)
	#define L_PITCH_FLD_SRGB_SEL			REG_FLD_MSB_LSB(19, 18)
	#define L_PITCH_FLD_DA_SEL			REG_FLD_MSB_LSB(21, 20)
	#define L_PITCH_FLD_DRGB_SEL			REG_FLD_MSB_LSB(23, 22)
	#define L_PITCH_FLD_CONST_BLD			REG_FLD_MSB_LSB(28, 28)
	#define L_PITCH_FLD_BLEND_RND_SHT		REG_FLD_MSB_LSB(30, 30)
	#define L_PITCH_FLD_SURFL_EN			REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_L0_TILE				(0x048UL)
#define DISP_REG_OVL_L0_CLIP				(0x04CUL)
	#define OVL_L_CLIP_FLD_LEFT			REG_FLD_MSB_LSB(7, 0)
	#define OVL_L_CLIP_FLD_RIGHT			REG_FLD_MSB_LSB(15, 8)
	#define OVL_L_CLIP_FLD_TOP			REG_FLD_MSB_LSB(23, 16)
	#define OVL_L_CLIP_FLD_BOTTOM			REG_FLD_MSB_LSB(31, 24)

#define DISP_REG_OVL_L1_CON				(0x050UL)
#define DISP_REG_OVL_L1_SRCKEY				(0x054UL)
#define DISP_REG_OVL_L1_SRC_SIZE			(0x058UL)
#define DISP_REG_OVL_L1_OFFSET				(0x05CUL)
#define DISP_REG_OVL_L1_ADDR				(0xf60UL)
#define DISP_REG_OVL_L1_PITCH_MSB			(0x060UL)
#define DISP_REG_OVL_L1_PITCH				(0x064UL)
#define DISP_REG_OVL_L1_TILE				(0x068UL)
#define DISP_REG_OVL_L1_CLIP				(0x06CUL)

#define DISP_REG_OVL_L2_CON				(0x070UL)
#define DISP_REG_OVL_L2_SRCKEY				(0x074UL)
#define DISP_REG_OVL_L2_SRC_SIZE			(0x078UL)
#define DISP_REG_OVL_L2_OFFSET				(0x07CUL)
#define DISP_REG_OVL_L2_ADDR				(0xf80UL)
#define DISP_REG_OVL_L2_PITCH_MSB			(0x080UL)
#define DISP_REG_OVL_L2_PITCH				(0x084UL)
#define DISP_REG_OVL_L2_TILE				(0x088UL)
#define DISP_REG_OVL_L2_CLIP				(0x08CUL)

#define DISP_REG_OVL_L3_CON				(0x090UL)
#define DISP_REG_OVL_L3_SRCKEY				(0x094UL)
#define DISP_REG_OVL_L3_SRC_SIZE			(0x098UL)
#define DISP_REG_OVL_L3_OFFSET				(0x09CUL)
#define DISP_REG_OVL_L3_ADDR				(0xfA0UL)
#define DISP_REG_OVL_L3_PITCH_MSB			(0x0A0UL)
#define DISP_REG_OVL_L3_PITCH				(0x0A4UL)
#define DISP_REG_OVL_L3_TILE				(0x0A8UL)
#define DISP_REG_OVL_L3_CLIP				(0x0ACUL)

#define DISP_REG_OVL_RDMA0_CTRL				(0x0C0UL)
	#define RDMA0_CTRL_FLD_RDMA_EN			REG_FLD_MSB_LSB(0, 0)
	#define RDMA0_CTRL_FLD_RDMA_INTERLACE		REG_FLD_MSB_LSB(4, 4)
	#define RDMA0_CTRL_FLD_RMDA_FIFO_USED_SZ	REG_FLD_MSB_LSB(27, 16)

#define DISP_REG_OVL_RDMA0_MEM_GMC_SETTING		(0x0C8UL)
	#define FLD_OVL_RDMA_MEM_GMC_ULTRA_THRESHOLD	REG_FLD_MSB_LSB(9, 0)
	#define FLD_OVL_RDMA_MEM_GMC_PRE_ULTRA_THRESHOLD REG_FLD_MSB_LSB(25, 16)
	#define FLD_OVL_RDMA_MEM_GMC_ULTRA_THRESHOLD_HIGH_OFS \
							REG_FLD_MSB_LSB(28, 28)
	#define FLD_OVL_RDMA_MEM_GMC_PRE_ULTRA_THRESHOLD_HIGH_OFS \
							REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_RDMA0_MEM_SLOW_CON			(0x0CCUL)
#define DISP_REG_OVL_RDMA0_FIFO_CTRL			(0x0D0UL)
	#define FLD_OVL_RDMA_FIFO_THRD			REG_FLD_MSB_LSB(9, 0)
	#define FLD_OVL_RDMA_FIFO_SIZE			REG_FLD_MSB_LSB(27, 16)
	#define FLD_OVL_RDMA_FIFO_UND_EN		REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_RDMA1_CTRL				(0x0E0UL)
#define DISP_REG_OVL_RDMA1_MEM_GMC_SETTING		(0x0E8UL)
#define DISP_REG_OVL_RDMA1_MEM_SLOW_CON			(0x0ECUL)
#define DISP_REG_OVL_RDMA1_FIFO_CTRL			(0x0F0UL)

#define DISP_REG_OVL_RDMA2_CTRL				(0x100UL)
#define DISP_REG_OVL_RDMA2_MEM_GMC_SETTING		(0x108UL)
#define DISP_REG_OVL_RDMA2_MEM_SLOW_CON			(0x10CUL)
#define DISP_REG_OVL_RDMA2_FIFO_CTRL			(0x110UL)

#define DISP_REG_OVL_RDMA3_CTRL				(0x120UL)
#define DISP_REG_OVL_RDMA3_MEM_GMC_SETTING		(0x128UL)
#define DISP_REG_OVL_RDMA3_MEM_SLOW_CON			(0x12CUL)
#define DISP_REG_OVL_RDMA3_FIFO_CTRL			(0x130UL)

#define DISP_REG_OVL_L0_Y2R_PARA_R0			(0x134UL)
#define DISP_REG_OVL_L0_Y2R_PARA_R1			(0x138UL)
#define DISP_REG_OVL_L0_Y2R_PARA_G0			(0x13CUL)
#define DISP_REG_OVL_L0_Y2R_PARA_G1			(0x140UL)
#define DISP_REG_OVL_L0_Y2R_PARA_B0			(0x144UL)
#define DISP_REG_OVL_L0_Y2R_PARA_B1			(0x148UL)
#define DISP_REG_OVL_L0_Y2R_PARA_YUV_A_0		(0x14CUL)
#define DISP_REG_OVL_L0_Y2R_PARA_YUV_A_1		(0x150UL)
#define DISP_REG_OVL_L0_Y2R_PARA_RGB_A_0		(0x154UL)
#define DISP_REG_OVL_L0_Y2R_PARA_RGB_A_1		(0x158UL)

#define DISP_REG_OVL_L1_Y2R_PARA_R0			(0x15CUL)
#define DISP_REG_OVL_L1_Y2R_PARA_R1			(0x160UL)
#define DISP_REG_OVL_L1_Y2R_PARA_G0			(0x164UL)
#define DISP_REG_OVL_L1_Y2R_PARA_G1			(0x168UL)
#define DISP_REG_OVL_L1_Y2R_PARA_B0			(0x16CUL)
#define DISP_REG_OVL_L1_Y2R_PARA_B1			(0x170UL)
#define DISP_REG_OVL_L1_Y2R_PARA_YUV_A_0		(0x174UL)
#define DISP_REG_OVL_L1_Y2R_PARA_YUV_A_1		(0x178UL)
#define DISP_REG_OVL_L1_Y2R_PARA_RGB_A_0		(0x17CUL)
#define DISP_REG_OVL_L1_Y2R_PARA_RGB_A_1		(0x180UL)

#define DISP_REG_OVL_L2_Y2R_PARA_R0			(0x184UL)
#define DISP_REG_OVL_L2_Y2R_PARA_R1			(0x188UL)
#define DISP_REG_OVL_L2_Y2R_PARA_G0			(0x18CUL)
#define DISP_REG_OVL_L2_Y2R_PARA_G1			(0x190UL)
#define DISP_REG_OVL_L2_Y2R_PARA_B0			(0x194UL)
#define DISP_REG_OVL_L2_Y2R_PARA_B1			(0x198UL)
#define DISP_REG_OVL_L2_Y2R_PARA_YUV_A_0		(0x19CUL)
#define DISP_REG_OVL_L2_Y2R_PARA_YUV_A_1		(0x1A0UL)
#define DISP_REG_OVL_L2_Y2R_PARA_RGB_A_0		(0x1A4UL)
#define DISP_REG_OVL_L2_Y2R_PARA_RGB_A_1		(0x1A8UL)

#define DISP_REG_OVL_L3_Y2R_PARA_R0			(0x1ACUL)
#define DISP_REG_OVL_L3_Y2R_PARA_R1			(0x1B0UL)
#define DISP_REG_OVL_L3_Y2R_PARA_G0			(0x1B4UL)
#define DISP_REG_OVL_L3_Y2R_PARA_G1			(0x1B8UL)
#define DISP_REG_OVL_L3_Y2R_PARA_B0			(0x1BCUL)
#define DISP_REG_OVL_L3_Y2R_PARA_B1			(0x1C0UL)
#define DISP_REG_OVL_L3_Y2R_PARA_YUV_A_0		(0x1C4UL)
#define DISP_REG_OVL_L3_Y2R_PARA_YUV_A_1		(0x1C8UL)
#define DISP_REG_OVL_L3_Y2R_PARA_RGB_A_0		(0x1CCUL)
#define DISP_REG_OVL_L3_Y2R_PARA_RGB_A_1		(0x1D0UL)

#define DISP_REG_OVL_DEBUG_MON_SEL			(0x1D4UL)
#define DISP_REG_OVL_RDMA0_MEM_GMC_S2			(0x1E0UL)
	#define FLD_OVL_RDMA_MEM_GMC2_ISSUE_REQ_THRES	REG_FLD_MSB_LSB(11, 0)
	#define FLD_OVL_RDMA_MEM_GMC2_ISSUE_REQ_THRES_URG \
							REG_FLD_MSB_LSB(27, 16)
	#define FLD_OVL_RDMA_MEM_GMC2_REQ_THRES_PREULTRA REG_FLD_MSB_LSB(28, 28)
	#define FLD_OVL_RDMA_MEM_GMC2_REQ_THRES_ULTRA	REG_FLD_MSB_LSB(29, 29)
	#define FLD_OVL_RDMA_MEM_GMC2_FORCE_REQ_THRES	REG_FLD_MSB_LSB(30, 30)

#define DISP_REG_OVL_RDMA1_MEM_GMC_S2			(0x1E4UL)
#define DISP_REG_OVL_RDMA2_MEM_GMC_S2			(0x1E8UL)
#define DISP_REG_OVL_RDMA3_MEM_GMC_S2			(0x1ECUL)

#define DISP_REG_OVL_RDMA_BURST_CON0			(0x1F0UL)
#define DISP_REG_OVL_RDMA_BURST_CON1			(0x1F4UL)
	#define FLD_RDMA_BURST_CON1_BURST16_EN		REG_FLD_MSB_LSB(28, 28)

#define DISP_REG_OVL_RDMA_GREQ_NUM			(0x1F8UL)
	#define FLD_OVL_RDMA_GREQ_LAYER0_GREQ_NUM	REG_FLD_MSB_LSB(3, 0)
	#define FLD_OVL_RDMA_GREQ_LAYER1_GREQ_NUM	REG_FLD_MSB_LSB(7, 4)
	#define FLD_OVL_RDMA_GREQ_LAYER2_GREQ_NUM	REG_FLD_MSB_LSB(11, 8)
	#define FLD_OVL_RDMA_GREQ_LAYER3_GREQ_NUM	REG_FLD_MSB_LSB(15, 12)
	#define FLD_OVL_RDMA_GREQ_OSTD_GREQ_NUM		REG_FLD_MSB_LSB(23, 16)
	#define FLD_OVL_RDMA_GREQ_GREQ_DIS_CNT		REG_FLD_MSB_LSB(26, 24)
	#define FLD_OVL_RDMA_GREQ_STOP_EN		REG_FLD_MSB_LSB(27, 27)
	#define FLD_OVL_RDMA_GREQ_GRP_END_STOP		REG_FLD_MSB_LSB(28, 28)
	#define FLD_OVL_RDMA_GREQ_GRP_BRK_STOP		REG_FLD_MSB_LSB(29, 29)
	#define FLD_OVL_RDMA_GREQ_IOBUF_FLUSH_PREULTRA	REG_FLD_MSB_LSB(30, 30)
	#define FLD_OVL_RDMA_GREQ_IOBUF_FLUSH_ULTRA	REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_RDMA_GREQ_URG_NUM			(0x1FCUL)
	#define FLD_OVL_RDMA_GREQ_LAYER0_GREQ_URG_NUM	REG_FLD_MSB_LSB(3, 0)
	#define FLD_OVL_RDMA_GREQ_LAYER1_GREQ_URG_NUM	REG_FLD_MSB_LSB(7, 4)
	#define FLD_OVL_RDMA_GREQ_LAYER2_GREQ_URG_NUM	REG_FLD_MSB_LSB(11, 8)
	#define FLD_OVL_RDMA_GREQ_LAYER3_GREQ_URG_NUM	REG_FLD_MSB_LSB(15, 12)
	#define FLD_OVL_RDMA_GREQ_ARG_GREQ_URG_TH	REG_FLD_MSB_LSB(25, 16)
	#define FLD_OVL_RDMA_GREQ_ARG_URG_BIAS		REG_FLD_MSB_LSB(28, 28)
	#define FLD_OVL_RDMA_GREQ_NUM_SHT_VAL		REG_FLD_MSB_LSB(29, 29)

#define DISP_REG_OVL_DUMMY_REG				(0x200UL)
#define DISP_REG_OVL_GDRDY_PRD				(0x208UL)
#define DISP_REG_OVL_RDMA_ULTRA_SRC			(0x20CUL)
	#define FLD_OVL_RDMA_PREULTRA_BUF_SRC		REG_FLD_MSB_LSB(1, 0)
	#define FLD_OVL_RDMA_PREULTRA_SMI_SRC		REG_FLD_MSB_LSB(3, 2)
	#define FLD_OVL_RDMA_PREULTRA_ROI_END_SRC	REG_FLD_MSB_LSB(5, 4)
	#define FLD_OVL_RDMA_PREULTRA_RDMA_SRC		REG_FLD_MSB_LSB(7, 6)
	#define FLD_OVL_RDMA_ULTRA_BUF_SRC		REG_FLD_MSB_LSB(9, 8)
	#define FLD_OVL_RDMA_ULTRA_SMI_SRC		REG_FLD_MSB_LSB(11, 10)
	#define FLD_OVL_RDMA_ULTRA_ROI_END_SRC		REG_FLD_MSB_LSB(13, 12)
	#define FLD_OVL_RDMA_ULTRA_RDMA_SRC		REG_FLD_MSB_LSB(15, 14)

#define DISP_REG_OVL_RDMAn_BUF_LOW(layer)		(0x210UL + ((layer)<<2))
	#define FLD_OVL_RDMA_BUF_LOW_ULTRA_TH		REG_FLD_MSB_LSB(11, 0)
	#define FLD_OVL_RDMA_BUF_LOW_PREULTRA_TH	REG_FLD_MSB_LSB(23, 12)

#define DISP_REG_OVL_RDMAn_BUF_HIGH(layer)		(0x220UL + ((layer)<<2))
	#define FLD_OVL_RDMA_BUF_HIGH_PREULTRA_TH	REG_FLD_MSB_LSB(23, 12)
	#define FLD_OVL_RDMA_BUF_HIGH_PREULTRA_DIS	REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_RDMA0_BUF_LOW			(0x210UL)
#define DISP_REG_OVL_RDMA1_BUF_LOW			(0x214UL)
#define DISP_REG_OVL_RDMA2_BUF_LOW			(0x218UL)
#define DISP_REG_OVL_RDMA3_BUF_LOW			(0x21cUL)

#define DISP_REG_OVL_SMI_DBG				(0x230UL)
#define DISP_REG_OVL_GREQ_LAYER_CNT			(0x234UL)
#define DISP_REG_OVL_GDRDY_PRD_NUM			(0x238UL)
#define DISP_REG_OVL_DEBUG_FLAG				(0x23CUL)
	#define FLD_FBDC0_SIZE_NG			REG_FLD_MSB_LSB(24, 24)
	#define FLD_FBDC1_SIZE_NG			REG_FLD_MSB_LSB(25, 25)
	#define FLD_FBDC2_SIZE_NG			REG_FLD_MSB_LSB(26, 26)
	#define FLD_FBDC3_SIZE_NG			REG_FLD_MSB_LSB(27, 27)
	#define FLD_DEBUG_FLAG_CLR			REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_FLOW_CTRL_DBG			(0x240UL)
#define DISP_REG_OVL_ADDCON_DBG				(0x244UL)
	#define ADDCON_DBG_FLD_ROI_X			REG_FLD_MSB_LSB(12, 0)
	#define ADDCON_DBG_FLD_L0_WIN_HIT		REG_FLD_MSB_LSB(14, 14)
	#define ADDCON_DBG_FLD_L1_WIN_HIT		REG_FLD_MSB_LSB(15, 15)
	#define ADDCON_DBG_FLD_ROI_Y			REG_FLD_MSB_LSB(28, 16)
	#define ADDCON_DBG_FLD_L2_WIN_HIT		REG_FLD_MSB_LSB(30, 30)
	#define ADDCON_DBG_FLD_L3_WIN_HIT		REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_RDMA0_DBG				(0x24CUL)
	#define RDMA0_DBG_FLD_RDMA0_WRAM_RST_CS		REG_FLD_MSB_LSB(2, 0)
	#define RDMA0_DBG_FLD_RDMA0_LAYER_GREQ          REG_FLD_MSB_LSB(3, 3)
	#define RDMA0_DBG_FLD_RDMA0_OUT_DATA		REG_FLD_MSB_LSB(27 4)
	#define RDMA0_DBG_FLD_RDMA0_OUT_READY		REG_FLD_MSB_LSB(28, 28)
	#define RDMA0_DBG_FLD_RDMA0_OUT_VALID		REG_FLD_MSB_LSB(29, 29)
	#define RDMA0_DBG_FLD_RDMA0_SMI_BUSY		REG_FLD_MSB_LSB(30, 30)
	#define RDMA0_DBG_FLD_RDMA0_SMI_GREQ		REG_FLD_MSB_LSB(31, 31)

#define DISP_REG_OVL_RDMA1_DBG				(0x250UL)
#define DISP_REG_OVL_RDMA2_DBG				(0x254UL)
#define DISP_REG_OVL_RDMA3_DBG				(0x258UL)

#define DISP_REG_OVL_L0_CLR				(0x25cUL)
#define DISP_REG_OVL_L1_CLR				(0x260UL)
#define DISP_REG_OVL_L2_CLR				(0x264UL)
#define DISP_REG_OVL_L3_CLR				(0x268UL)
#define DISP_REG_OVL_LC_CLR				(0x26cUL)

#define DISP_REG_OVL_CRC				(0x270UL)
#define DISP_REG_OVL_LC_CON				(0x280UL)
#define DISP_REG_OVL_LC_SRCKEY				(0x284UL)
#define DISP_REG_OVL_LC_SRC_SIZE			(0x288UL)
	#define FLD_OVL_LC_SRC_W			REG_FLD_MSB_LSB(12, 0)
	#define FLD_OVL_LC_SRC_H			REG_FLD_MSB_LSB(28, 16)
#define DISP_REG_OVL_LC_OFFSET				(0x28cUL)
	#define FLD_OVL_LC_XOFF				REG_FLD_MSB_LSB(11, 0)
	#define FLD_OVL_LC_YOFF				REG_FLD_MSB_LSB(27, 16)
#define DISP_REG_OVL_LC_SRC_SEL				(0x290UL)
	#define LC_SRC_SEL_FLD_L_SEL			REG_FLD_MSB_LSB(2, 0)
#define DISP_REG_OVL_BANK_CON				(0x29cUL)
#define DISP_REG_OVL_FUNC_DCM0				(0x2a0UL)
#define DISP_REG_OVL_FUNC_DCM1				(0x2a4UL)

#define DISP_REG_OVL_DVFS_L0_ROI			(0x2B0UL)
#define DISP_REG_OVL_DVFS_L1_ROI			(0x2B4UL)
#define DISP_REG_OVL_DVFS_L2_ROI			(0x2B8UL)
#define DISP_REG_OVL_DVFS_L3_ROI			(0x2BCUL)
#define DISP_REG_OVL_DVFS_EL0_ROI			(0x2C0UL)
#define DISP_REG_OVL_DVFS_EL1_ROI			(0x2C4UL)
#define DISP_REG_OVL_DVFS_EL2_ROI			(0x2C8UL)

#define DISP_REG_OVL_CLRFMT_EXT				(0x2D0UL)
	#define FLD_Ln_CLRFMT_NB(n)	REG_FLD_MSB_LSB((n)*4+1, (n)*4)
	#define FLD_ELn_CLRFMT_NB(n)	REG_FLD_MSB_LSB((n)*4+17, (n)*4+16)
	#define FLD_L0_CLRFMT_NB			REG_FLD_MSB_LSB(1, 0)
	#define FLD_L1_CLRFMT_NB			REG_FLD_MSB_LSB(5, 4)
	#define FLD_L2_CLRFMT_NB			REG_FLD_MSB_LSB(9, 8)
	#define FLD_L3_CLRFMT_NB			REG_FLD_MSB_LSB(13, 12)
	#define FLD_EL0_CLRFMT_NB			REG_FLD_MSB_LSB(17, 16)
	#define FLD_EL1_CLRFMT_NB			REG_FLD_MSB_LSB(21, 20)
	#define FLD_EL2_CLRFMT_NB			REG_FLD_MSB_LSB(25, 24)

#define DISP_REG_OVL_WCG_CFG0				(0x2D4UL)
	#define FLD_L0_Y2R_CLAMP			REG_FLD_MSB_LSB(0, 0)
	#define FLD_L1_Y2R_CLAMP			REG_FLD_MSB_LSB(1, 1)
	#define FLD_L2_Y2R_CLAMP			REG_FLD_MSB_LSB(2, 2)
	#define FLD_L3_Y2R_CLAMP			REG_FLD_MSB_LSB(3, 3)
	#define FLD_EL0_Y2R_CLAMP			REG_FLD_MSB_LSB(4, 4)
	#define FLD_EL1_Y2R_CLAMP			REG_FLD_MSB_LSB(5, 5)
	#define FLD_EL2_Y2R_CLAMP			REG_FLD_MSB_LSB(6, 6)
	#define FLD_PQ_OUT_CLAMP			REG_FLD_MSB_LSB(8, 8)
	#define FLD_BGCLR_OUT_CLAMP			REG_FLD_MSB_LSB(9, 9)
	#define FLD_BLGCLR_OUT_GAMMA_EN			REG_FLD_MSB_LSB(16, 16)

#define DISP_REG_OVL_WCG_CFG1				(0x2D8UL)
	#define FLD_Ln_IGAMMA_EN(n)	REG_FLD_MSB_LSB((n)*4, (n)*4)
	#define FLD_Ln_CSC_EN(n)	REG_FLD_MSB_LSB((n)*4+1, (n)*4+1)
	#define FLD_Ln_GAMMA_EN(n)	REG_FLD_MSB_LSB((n)*4+2, (n)*4+2)
	#define FLD_ELn_IGAMMA_EN(n)	REG_FLD_MSB_LSB((n)*4+16, (n)*4+16)
	#define FLD_ELn_CSC_EN(n)	REG_FLD_MSB_LSB((n)*4+17, (n)*4+17)
	#define FLD_ELn_GAMMA_EN(n)	REG_FLD_MSB_LSB((n)*4+18, (n)*4+18)
	#define FLD_L0_IGAMMA_EN			REG_FLD_MSB_LSB(0, 0)
	#define FLD_L0_CSC_EN				REG_FLD_MSB_LSB(1, 1)
	#define FLD_L0_GAMMA_EN				REG_FLD_MSB_LSB(2, 2)
	#define FLD_L1_IGAMMA_EN			REG_FLD_MSB_LSB(4, 4)
	#define FLD_L1_CSC_EN				REG_FLD_MSB_LSB(5, 5)
	#define FLD_L1_GAMMA_EN				REG_FLD_MSB_LSB(6, 6)
	#define FLD_L2_IGAMMA_EN			REG_FLD_MSB_LSB(8, 8)
	#define FLD_L2_CSC_EN				REG_FLD_MSB_LSB(9, 9)
	#define FLD_L2_GAMMA_EN				REG_FLD_MSB_LSB(10, 10)
	#define FLD_L3_IGAMMA_EN			REG_FLD_MSB_LSB(12, 12)
	#define FLD_L3_CSC_EN				REG_FLD_MSB_LSB(13, 13)
	#define FLD_L3_GAMMA_EN				REG_FLD_MSB_LSB(14, 14)
	#define FLD_EL0_IGAMMA_EN			REG_FLD_MSB_LSB(16, 16)
	#define FLD_EL0_CSC_EN				REG_FLD_MSB_LSB(17, 17)
	#define FLD_EL0_GAMMA_EN			REG_FLD_MSB_LSB(18, 18)
	#define FLD_EL1_IGAMMA_EN			REG_FLD_MSB_LSB(20, 20)
	#define FLD_EL1_CSC_EN				REG_FLD_MSB_LSB(21, 21)
	#define FLD_EL1_GAMMA_EN			REG_FLD_MSB_LSB(22, 22)
	#define FLD_EL2_IGAMMA_EN			REG_FLD_MSB_LSB(24, 24)
	#define FLD_EL2_CSC_EN				REG_FLD_MSB_LSB(25, 25)
	#define FLD_EL2_GAMMA_EN			REG_FLD_MSB_LSB(26, 26)
	#define FLD_LC_IGAMMA_EN			REG_FLD_MSB_LSB(28, 28)
	#define FLD_LC_CSC_EN				REG_FLD_MSB_LSB(29, 29)
	#define FLD_LC_GAMMA_EN				REG_FLD_MSB_LSB(30, 30)

#define DISP_REG_OVL_WCG_CFG2				(0x2DCUL)
	#define FLD_Ln_IGAMMA_SEL(n)	REG_FLD_MSB_LSB((n)*4+1, (n)*4)
	#define FLD_Ln_GAMMA_SEL(n)	REG_FLD_MSB_LSB((n)*4+3, (n)*4+2)
	#define FLD_ELn_IGAMMA_SEL(n)	REG_FLD_MSB_LSB((n)*4+17, (n)*4+16)
	#define FLD_ELn_GAMMA_SEL(n)	REG_FLD_MSB_LSB((n)*4+19, (n)*4+18)
	#define FLD_L0_IGAMMA_SEL			REG_FLD_MSB_LSB(1, 0)
	#define FLD_L0_GAMMA_SEL			REG_FLD_MSB_LSB(3, 2)
	#define FLD_L1_IGAMMA_SEL			REG_FLD_MSB_LSB(5, 4)
	#define FLD_L1_GAMMA_SEL			REG_FLD_MSB_LSB(7, 6)
	#define FLD_L2_IGAMMA_SEL			REG_FLD_MSB_LSB(9, 8)
	#define FLD_L2_GAMMA_SEL			REG_FLD_MSB_LSB(11, 10)
	#define FLD_L3_IGAMMA_SEL			REG_FLD_MSB_LSB(13, 12)
	#define FLD_L3_GAMMA_SEL			REG_FLD_MSB_LSB(15, 14)
	#define FLD_EL0_IGAMMA_SEL			REG_FLD_MSB_LSB(17, 16)
	#define FLD_EL0_GAMMA_SEL			REG_FLD_MSB_LSB(19, 18)
	#define FLD_EL1_IGAMMA_SEL			REG_FLD_MSB_LSB(21, 20)
	#define FLD_EL1_GAMMA_SEL			REG_FLD_MSB_LSB(23, 22)
	#define FLD_EL2_IGAMMA_SEL			REG_FLD_MSB_LSB(25, 24)
	#define FLD_EL2_GAMMA_SEL			REG_FLD_MSB_LSB(27, 26)
	#define FLD_LC_IGAMMA_SEL			REG_FLD_MSB_LSB(29, 28)
	#define FLD_LC_GAMMA_SEL			REG_FLD_MSB_LSB(31, 30)

#define DISP_REG_OVL_DATAPATH_EXT_CON			(0x324UL)
	#define FLD_EL0_EN				REG_FLD_MSB_LSB(0, 0)
	#define FLD_EL1_EN				REG_FLD_MSB_LSB(1, 1)
	#define FLD_EL2_EN				REG_FLD_MSB_LSB(2, 2)
	#define FLD_EL0_FBDC_EN				REG_FLD_MSB_LSB(4, 4)
	#define FLD_EL1_FBDC_EN				REG_FLD_MSB_LSB(5, 5)
	#define FLD_EL2_FBDC_EN				REG_FLD_MSB_LSB(6, 6)
	#define FLD_EL0_GPU_MODE			REG_FLD_MSB_LSB(8, 8)
	#define FLD_EL1_GPU_MODE			REG_FLD_MSB_LSB(9, 9)
	#define FLD_EL2_GPU_MODE			REG_FLD_MSB_LSB(10, 10)
	#define FLD_EL0_LAYER_SEL			REG_FLD_MSB_LSB(18, 16)
	#define FLD_EL1_LAYER_SEL			REG_FLD_MSB_LSB(22, 20)
	#define FLD_EL2_LAYER_SEL			REG_FLD_MSB_LSB(26, 24)

#define DISP_REG_OVL_EL0_CON				(0x330UL)
#define DISP_REG_OVL_EL0_SRCKEY				(0x334UL)
#define DISP_REG_OVL_EL0_SRC_SIZE			(0x338UL)
#define DISP_REG_OVL_EL0_OFFSET				(0x33CUL)
#define DISP_REG_OVL_EL0_ADDR				(0xFB0UL)
#define DISP_REG_OVL_EL0_PITCH_MSB			(0x340UL)
#define DISP_REG_OVL_EL0_PITCH				(0x344UL)
#define DISP_REG_OVL_EL0_TILE				(0x348UL)
#define DISP_REG_OVL_EL0_CLIP				(0x34CUL)

#define DISP_REG_OVL_EL1_CON				(0x350UL)
#define DISP_REG_OVL_EL1_SRCKEY				(0x354UL)
#define DISP_REG_OVL_EL1_SRC_SIZE			(0x358UL)
#define DISP_REG_OVL_EL1_OFFSET				(0x35CUL)
#define DISP_REG_OVL_EL1_ADDR				(0xFB4UL)
#define DISP_REG_OVL_EL1_PITCH_MSB			(0x360UL)
#define DISP_REG_OVL_EL1_PITCH				(0x364UL)
#define DISP_REG_OVL_EL1_TILE				(0x368UL)
#define DISP_REG_OVL_EL1_CLIP				(0x36CUL)

#define DISP_REG_OVL_EL2_CON				(0x370UL)
#define DISP_REG_OVL_EL2_SRCKEY				(0x374UL)
#define DISP_REG_OVL_EL2_SRC_SIZE			(0x378UL)
#define DISP_REG_OVL_EL2_OFFSET				(0x37CUL)
#define DISP_REG_OVL_EL2_ADDR				(0xFB8UL)
#define DISP_REG_OVL_EL2_PITCH_MSB			(0x380UL)
#define DISP_REG_OVL_EL2_PITCH				(0x384UL)
#define DISP_REG_OVL_EL2_TILE				(0x388UL)
#define DISP_REG_OVL_EL2_CLIP				(0x38CUL)

#define DISP_REG_OVL_EL0_CLR				(0x390UL)
#define DISP_REG_OVL_EL1_CLR				(0x394UL)
#define DISP_REG_OVL_EL2_CLR				(0x398UL)

#define DISP_REG_OVL_SBCH				(0x3a0UL)
	#define SBCH_FLD_L0_SBCH_UPDATE			REG_FLD_MSB_LSB(0, 0)
	#define SBCH_FLD_L1_SBCH_UPDATE			REG_FLD_MSB_LSB(4, 4)
	#define SBCH_FLD_L2_SBCH_UPDATE			REG_FLD_MSB_LSB(8, 8)
	#define SBCH_FLD_L3_SBCH_UPDATE			REG_FLD_MSB_LSB(12, 12)
	#define SBCH_FLD_L0_SBCH_TRANS_EN		REG_FLD_MSB_LSB(16, 16)
	#define SBCH_FLD_L0_SBCH_CNST_EN		REG_FLD_MSB_LSB(17, 17)
	#define SBCH_FLD_L1_SBCH_TRANS_EN		REG_FLD_MSB_LSB(20, 20)
	#define SBCH_FLD_L1_SBCH_CNST_EN		REG_FLD_MSB_LSB(21, 21)
	#define SBCH_FLD_L2_SBCH_TRANS_EN		REG_FLD_MSB_LSB(24, 24)
	#define SBCH_FLD_L2_SBCH_CNST_EN		REG_FLD_MSB_LSB(25, 25)
	#define SBCH_FLD_L3_SBCH_TRANS_EN		REG_FLD_MSB_LSB(28, 28)
	#define SBCH_FLD_L3_SBCH_CNST_EN		REG_FLD_MSB_LSB(29, 29)
#define DISP_REG_OVL_SBCH_EXT				(0x3a4UL)
	#define SBCH_EXT_FLD_EL0_SBCH_UPDATE		REG_FLD_MSB_LSB(0, 0)
	#define SBCH_EXT_FLD_EL1_SBCH_UPDATE		REG_FLD_MSB_LSB(4, 4)
	#define SBCH_EXT_FLD_EL2_SBCH_UPDATE		REG_FLD_MSB_LSB(8, 8)
	#define SBCH_EXT_FLD_EL0_SBCH_TRANS_EN		REG_FLD_MSB_LSB(16, 16)
	#define SBCH_EXT_FLD_EL0_SBCH_CNST_EN		REG_FLD_MSB_LSB(17, 17)
	#define SBCH_EXT_FLD_EL1_SBCH_TRANS_EN		REG_FLD_MSB_LSB(20, 20)
	#define SBCH_EXT_FLD_EL1_SBCH_CNST_EN		REG_FLD_MSB_LSB(21, 21)
	#define SBCH_EXT_FLD_EL2_SBCH_TRANS_EN		REG_FLD_MSB_LSB(24, 24)
	#define SBCH_EXT_FLD_EL2_SBCH_CNST_EN		REG_FLD_MSB_LSB(25, 25)
#define DISP_REG_OVL_SBCH_STS				(0x3A8UL)
	#define FLD_L0_SBCH_ALL_TRANS			REG_FLD_MSB_LSB(0, 0)
	#define FLD_L0_SBCH_ALL_OPAQUE			REG_FLD_MSB_LSB(1, 1)
	#define FLD_L0_SBCH_ALL_CNST			REG_FLD_MSB_LSB(2, 2)
	#define FLD_L0_SBCH_TRANS_INVALID		REG_FLD_MSB_LSB(3, 3)
	#define FLD_L1_SBCH_ALL_TRANS			REG_FLD_MSB_LSB(4, 4)
	#define FLD_L1_SBCH_ALL_OPAQUE			REG_FLD_MSB_LSB(5, 5)
	#define FLD_L1_SBCH_ALL_CNST			REG_FLD_MSB_LSB(6, 6)
	#define FLD_L1_SBCH_TRANS_INVALID		REG_FLD_MSB_LSB(7, 7)
	#define FLD_L2_SBCH_ALL_TRANS			REG_FLD_MSB_LSB(8, 8)
	#define FLD_L2_SBCH_ALL_OPAQUE			REG_FLD_MSB_LSB(9, 9)
	#define FLD_L2_SBCH_ALL_CNST			REG_FLD_MSB_LSB(10, 10)
	#define FLD_L2_SBCH_TRANS_INVALID		REG_FLD_MSB_LSB(11, 11)
	#define FLD_L3_SBCH_ALL_TRANS			REG_FLD_MSB_LSB(12, 12)
	#define FLD_L3_SBCH_ALL_OPAQUE			REG_FLD_MSB_LSB(13, 13)
	#define FLD_L3_SBCH_ALL_CNST			REG_FLD_MSB_LSB(14, 14)
	#define FLD_L3_SBCH_TRANS_INVALID		REG_FLD_MSB_LSB(15, 15)
	#define FLD_EL0_SBCH_ALL_TRANS			REG_FLD_MSB_LSB(16, 16)
	#define FLD_EL0_SBCH_ALL_OPAQUE			REG_FLD_MSB_LSB(17, 17)
	#define FLD_EL0_SBCH_ALL_CNST			REG_FLD_MSB_LSB(18, 18)
	#define FLD_EL0_SBCH_TRANS_INVALID		REG_FLD_MSB_LSB(19, 19)
	#define FLD_EL1_SBCH_ALL_TRANS			REG_FLD_MSB_LSB(20, 20)
	#define FLD_EL1_SBCH_ALL_OPAQUE			REG_FLD_MSB_LSB(21, 21)
	#define FLD_EL1_SBCH_ALL_CNST			REG_FLD_MSB_LSB(22, 22)
	#define FLD_EL1_SBCH_TRANS_INVALID		REG_FLD_MSB_LSB(23, 23)
	#define FLD_EL2_SBCH_ALL_TRANS			REG_FLD_MSB_LSB(24, 24)
	#define FLD_EL2_SBCH_ALL_OPAQUE			REG_FLD_MSB_LSB(25, 25)
	#define FLD_EL2_SBCH_ALL_CNST			REG_FLD_MSB_LSB(26, 26)
	#define FLD_EL2_SBCH_TRANS_INVALID		REG_FLD_MSB_LSB(27, 27)
#define DISP_REG_OVL_SBCH_L0_STS_LSB			(0x3B0UL)
	#define FLD_L0_SBCH_MEM_TRANS_LSB		REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_SBCH_L0_STS_MSB			(0x3B4UL)
	#define FLD_L0_SBCH_MEM_TRANS_MSB		REG_FLD_MSB_LSB(11, 0)
#define DISP_REG_OVL_SBCH_L1_STS_LSB			(0x3B8UL)
	#define FLD_L1_SBCH_MEM_TRANS_LSB		REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_SBCH_L1_STS_MSB			(0x3BCUL)
	#define FLD_L1_SBCH_MEM_TRANS_MSB		REG_FLD_MSB_LSB(11, 0)
#define DISP_REG_OVL_SBCH_L2_STS_LSB			(0x3C0UL)
	#define FLD_L2_SBCH_MEM_TRANS_LSB		REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_SBCH_L2_STS_MSB			(0x3C4UL)
	#define FLD_L2_SBCH_MEM_TRANS_MSB		REG_FLD_MSB_LSB(11, 0)
#define DISP_REG_OVL_SBCH_L3_STS_LSB			(0x3C8UL)
	#define FLD_L3_SBCH_MEM_TRANS_LSB		REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_SBCH_L3_STS_MSB			(0x3CCUL)
	#define FLD_L3_SBCH_MEM_TRANS_MSB		REG_FLD_MSB_LSB(11, 0)
#define DISP_REG_OVL_MBIST_BSEL				(0x3FCUL)
	#define FLD_MBIST_BSEL				REG_FLD_MSB_LSB(15, 0)
#define DISP_REG_OVL_Ln_R2R_PARA(n)			(0x500UL+0x40*(n))
#define DISP_REG_OVL_L0_R2R_PARA_R0			(0x500UL)
	#define FLD_C_CF_RMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_R2R_PARA_R1			(0x504UL)
	#define FLD_C_CF_RMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_R2R_PARA_R2			(0x508UL)
	#define FLD_C_CF_RMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_R2R_PARA_G0			(0x50CUL)
	#define FLD_C_CF_GMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_R2R_PARA_G1			(0x510UL)
	#define FLD_C_CF_GMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_R2R_PARA_G2			(0x514UL)
	#define FLD_C_CF_GMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_R2R_PARA_B0			(0x518UL)
	#define FLD_C_CF_BMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_R2R_PARA_B1			(0x51CUL)
	#define FLD_C_CF_BMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_R2R_PARA_B2			(0x520UL)
	#define FLD_C_CF_BMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L0_Y2R_PARA_PRE_RGB_A_0		(0x524UL)
	#define FLD_C_CF_PRE_RA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L0_Y2R_PARA_PRE_RGB_A_1		(0x528UL)
	#define FLD_C_CF_PRE_GA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L0_Y2R_PARA_PRE_RGB_A_2		(0x52CUL)
	#define FLD_C_CF_PRE_BA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L0_Y2R_PARA_POST_RGB_A_0		(0x530UL)
	#define FLD_C_CF_POST_RA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L0_Y2R_PARA_POST_RGB_A_1		(0x534UL)
	#define FLD_C_CF_POST_GA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L0_Y2R_PARA_POST_RGB_A_2		(0x538UL)
	#define FLD_C_CF_POST_BA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L1_R2R_PARA_R0			(0x540UL)
	#define FLD_C_CF_RMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_R2R_PARA_R1			(0x544UL)
	#define FLD_C_CF_RMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_R2R_PARA_R2			(0x548UL)
	#define FLD_C_CF_RMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_R2R_PARA_G0			(0x54CUL)
	#define FLD_C_CF_GMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_R2R_PARA_G1			(0x550UL)
	#define FLD_C_CF_GMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_R2R_PARA_G2			(0x554UL)
	#define FLD_C_CF_GMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_R2R_PARA_B0			(0x558UL)
	#define FLD_C_CF_BMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_R2R_PARA_B1			(0x55CUL)
	#define FLD_C_CF_BMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_R2R_PARA_B2			(0x560UL)
	#define FLD_C_CF_BMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L1_Y2R_PARA_PRE_RGB_A_0		(0x564UL)
	#define FLD_C_CF_PRE_RA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L1_Y2R_PARA_PRE_RGB_A_1		(0x568UL)
	#define FLD_C_CF_PRE_GA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L1_Y2R_PARA_PRE_RGB_A_2		(0x56CUL)
	#define FLD_C_CF_PRE_BA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L1_Y2R_PARA_POST_RGB_A_0		(0x570UL)
	#define FLD_C_CF_POST_RA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L1_Y2R_PARA_POST_RGB_A_1		(0x574UL)
	#define FLD_C_CF_POST_GA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L1_Y2R_PARA_POST_RGB_A_2		(0x578UL)
	#define FLD_C_CF_POST_BA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L2_R2R_PARA_R0			(0x580UL)
	#define FLD_C_CF_RMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_R2R_PARA_R1			(0x584UL)
	#define FLD_C_CF_RMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_R2R_PARA_R2			(0x588UL)
	#define FLD_C_CF_RMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_R2R_PARA_G0			(0x58CUL)
	#define FLD_C_CF_GMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_R2R_PARA_G1			(0x590UL)
	#define FLD_C_CF_GMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_R2R_PARA_G2			(0x594UL)
	#define FLD_C_CF_GMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_R2R_PARA_B0			(0x598UL)
	#define FLD_C_CF_BMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_R2R_PARA_B1			(0x59CUL)
	#define FLD_C_CF_BMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_R2R_PARA_B2			(0x5A0UL)
	#define FLD_C_CF_BMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L2_Y2R_PARA_PRE_RGB_A_0		(0x5A4UL)
	#define FLD_C_CF_PRE_RA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L2_Y2R_PARA_PRE_RGB_A_1		(0x5A8UL)
	#define FLD_C_CF_PRE_GA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L2_Y2R_PARA_PRE_RGB_A_2		(0x5ACUL)
	#define FLD_C_CF_PRE_BA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L2_Y2R_PARA_POST_RGB_A_0		(0x5B0UL)
	#define FLD_C_CF_POST_RA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L2_Y2R_PARA_POST_RGB_A_1		(0x5B4UL)
	#define FLD_C_CF_POST_GA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L2_Y2R_PARA_POST_RGB_A_2		(0x5B8UL)
	#define FLD_C_CF_POST_BA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L3_R2R_PARA_R0			(0x5C0UL)
	#define FLD_C_CF_RMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_R2R_PARA_R1			(0x5C4UL)
	#define FLD_C_CF_RMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_R2R_PARA_R2			(0x5C8UL)
	#define FLD_C_CF_RMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_R2R_PARA_G0			(0x5CCUL)
	#define FLD_C_CF_GMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_R2R_PARA_G1			(0x5D0UL)
	#define FLD_C_CF_GMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_R2R_PARA_G2			(0x5D4UL)
	#define FLD_C_CF_GMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_R2R_PARA_B0			(0x5D8UL)
	#define FLD_C_CF_BMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_R2R_PARA_B1			(0x5DCUL)
	#define FLD_C_CF_BMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_R2R_PARA_B2			(0x5E0UL)
	#define FLD_C_CF_BMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_L3_Y2R_PARA_PRE_RGB_A_0		(0x5E4UL)
	#define FLD_C_CF_PRE_RA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L3_Y2R_PARA_PRE_RGB_A_1		(0x5E8UL)
	#define FLD_C_CF_PRE_GA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L3_Y2R_PARA_PRE_RGB_A_2		(0x5ECUL)
	#define FLD_C_CF_PRE_BA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L3_Y2R_PARA_POST_RGB_A_0		(0x5F0UL)
	#define FLD_C_CF_POST_RA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L3_Y2R_PARA_POST_RGB_A_1		(0x5F4UL)
	#define FLD_C_CF_POST_GA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_L3_Y2R_PARA_POST_RGB_A_2		(0x5F8UL)
	#define FLD_C_CF_POST_BA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_ELn_R2R_PARA(n)			(0x600UL+0x40*(n))
#define DISP_REG_OVL_EL0_R2R_PARA_R0			(0x600UL)
	#define FLD_C_CF_RMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_R2R_PARA_R1			(0x604UL)
	#define FLD_C_CF_RMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_R2R_PARA_R2			(0x608UL)
	#define FLD_C_CF_RMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_R2R_PARA_G0			(0x60CUL)
	#define FLD_C_CF_GMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_R2R_PARA_G1			(0x610UL)
	#define FLD_C_CF_GMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_R2R_PARA_G2			(0x614UL)
	#define FLD_C_CF_GMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_R2R_PARA_B0			(0x618UL)
	#define FLD_C_CF_BMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_R2R_PARA_B1			(0x61CUL)
	#define FLD_C_CF_BMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_R2R_PARA_B2			(0x620UL)
	#define FLD_C_CF_BMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL0_Y2R_PARA_PRE_RGB_A_0		(0x624UL)
	#define FLD_C_CF_PRE_RA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL0_Y2R_PARA_PRE_RGB_A_1		(0x628UL)
	#define FLD_C_CF_PRE_GA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL0_Y2R_PARA_PRE_RGB_A_2		(0x62CUL)
	#define FLD_C_CF_PRE_BA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL0_Y2R_PARA_POST_RGB_A_0		(0x630UL)
	#define FLD_C_CF_POST_RA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL0_Y2R_PARA_POST_RGB_A_1		(0x634UL)
	#define FLD_C_CF_POST_GA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL0_Y2R_PARA_POST_RGB_A_2		(0x638UL)
	#define FLD_C_CF_POST_BA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_R0			(0x640UL)
	#define FLD_C_CF_RMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_R1			(0x644UL)
	#define FLD_C_CF_RMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_R2			(0x648UL)
	#define FLD_C_CF_RMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_G0			(0x64CUL)
	#define FLD_C_CF_GMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_G1			(0x650UL)
	#define FLD_C_CF_GMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_G2			(0x654UL)
	#define FLD_C_CF_GMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_B0			(0x658UL)
	#define FLD_C_CF_BMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_B1			(0x65CUL)
	#define FLD_C_CF_BMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_R2R_PARA_B2			(0x660UL)
	#define FLD_C_CF_BMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL1_Y2R_PARA_PRE_RGB_A_0		(0x664UL)
	#define FLD_C_CF_PRE_RA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL1_Y2R_PARA_PRE_RGB_A_1		(0x668UL)
	#define FLD_C_CF_PRE_GA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL1_Y2R_PARA_PRE_RGB_A_2		(0x66CUL)
	#define FLD_C_CF_PRE_BA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL1_Y2R_PARA_POST_RGB_A_0		(0x670UL)
	#define FLD_C_CF_POST_RA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL1_Y2R_PARA_POST_RGB_A_1		(0x674UL)
	#define FLD_C_CF_POST_GA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL1_Y2R_PARA_POST_RGB_A_2		(0x678UL)
	#define FLD_C_CF_POST_BA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_R0			(0x680UL)
	#define FLD_C_CF_RMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_R1			(0x684UL)
	#define FLD_C_CF_RMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_R2			(0x688UL)
	#define FLD_C_CF_RMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_G0			(0x68CUL)
	#define FLD_C_CF_GMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_G1			(0x690UL)
	#define FLD_C_CF_GMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_G2			(0x694UL)
	#define FLD_C_CF_GMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_B0			(0x698UL)
	#define FLD_C_CF_BMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_B1			(0x69CUL)
	#define FLD_C_CF_BMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_R2R_PARA_B2			(0x6A0UL)
	#define FLD_C_CF_BMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_EL2_Y2R_PARA_PRE_RGB_A_0		(0x6A4UL)
	#define FLD_C_CF_PRE_RA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL2_Y2R_PARA_PRE_RGB_A_1		(0x6A8UL)
	#define FLD_C_CF_PRE_GA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL2_Y2R_PARA_PRE_RGB_A_2		(0x6ACUL)
	#define FLD_C_CF_PRE_BA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL2_Y2R_PARA_POST_RGB_A_0		(0x6B0UL)
	#define FLD_C_CF_POST_RA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL2_Y2R_PARA_POST_RGB_A_1		(0x6B4UL)
	#define FLD_C_CF_POST_GA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_EL2_Y2R_PARA_POST_RGB_A_2		(0x6B8UL)
	#define FLD_C_CF_POST_BA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_LC_R2R_PARA_R0			(0x6C0UL)
	#define FLD_C_CF_RMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_R2R_PARA_R1			(0x6C4UL)
	#define FLD_C_CF_RMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_R2R_PARA_R2			(0x6C8UL)
	#define FLD_C_CF_RMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_R2R_PARA_G0			(0x6CCUL)
	#define FLD_C_CF_GMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_R2R_PARA_G1			(0x6D0UL)
	#define FLD_C_CF_GMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_R2R_PARA_G2			(0x6D4UL)
	#define FLD_C_CF_GMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_R2R_PARA_B0			(0x6D8UL)
	#define FLD_C_CF_BMR				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_R2R_PARA_B1			(0x6DCUL)
	#define FLD_C_CF_BMG				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_R2R_PARA_B2			(0x6E0UL)
	#define FLD_C_CF_BMB				REG_FLD_MSB_LSB(22, 0)
#define DISP_REG_OVL_LC_Y2R_PARA_PRE_RGB_A_0		(0x6E4UL)
	#define FLD_C_CF_PRE_RA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_LC_Y2R_PARA_PRE_RGB_A_1		(0x6E8UL)
	#define FLD_C_CF_PRE_GA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_LC_Y2R_PARA_PRE_RGB_A_2		(0x6ECUL)
	#define FLD_C_CF_PRE_BA				REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_LC_Y2R_PARA_POST_RGB_A_0		(0x6F0UL)
	#define FLD_C_CF_POST_RA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_LC_Y2R_PARA_POST_RGB_A_1		(0x6F4UL)
	#define FLD_C_CF_POST_GA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_LC_Y2R_PARA_POST_RGB_A_2		(0x6F8UL)
	#define FLD_C_CF_POST_BA			REG_FLD_MSB_LSB(17, 0)
#define DISP_REG_OVL_FBDC_CFG0				(0x800UL)
	#define FLD_L0_FBDC_PXLFMT			REG_FLD_MSB_LSB(6, 0)
	#define FLD_L0_FBDC_PXLFMT_EN			REG_FLD_MSB_LSB(7, 7)
	#define FLD_L1_FBDC_PXLFMT			REG_FLD_MSB_LSB(14, 8)
	#define FLD_L1_FBDC_PXLFMT_EN			REG_FLD_MSB_LSB(15, 15)
	#define FLD_L2_FBDC_PXLFMT			REG_FLD_MSB_LSB(22, 16)
	#define FLD_L2_FBDC_PXLFMT_EN			REG_FLD_MSB_LSB(23, 23)
	#define FLD_L3_FBDC_PXLFMT			REG_FLD_MSB_LSB(30, 24)
	#define FLD_L3_FBDC_PXLFMT_EN			REG_FLD_MSB_LSB(31, 31)
#define DISP_REG_OVL_FBDC_CFG1				(0x804UL)
	#define FLD_EL0_FBDC_PXLFMT			REG_FLD_MSB_LSB(6, 0)
	#define FLD_EL0_FBDC_PXLFMT_EN			REG_FLD_MSB_LSB(7, 7)
	#define FLD_EL1_FBDC_PXLFMT			REG_FLD_MSB_LSB(14, 8)
	#define FLD_EL1_FBDC_PXLFMT_EN			REG_FLD_MSB_LSB(15, 15)
	#define FLD_EL2_FBDC_PXLFMT			REG_FLD_MSB_LSB(22, 16)
	#define FLD_EL2_FBDC_PXLFMT_EN			REG_FLD_MSB_LSB(23, 23)
	#define FLD_FBDC_8XE_MODE			REG_FLD_MSB_LSB(24, 24)
	#define FLD_FBDC_MODE_V3_1_EN			REG_FLD_MSB_LSB(25, 25)
	#define FLD_FBDC_FILTER_EN			REG_FLD_MSB_LSB(28, 28)
	#define FLD_FBDC_FILTER_CLEAR			REG_FLD_MSB_LSB(31, 29)
#define DISP_REG_OVL_FBDC_CFG2				(0x808UL)
	#define FLD_L0_FBDC_GB_SWAP			REG_FLD_MSB_LSB(0, 0)
	#define FLD_L1_FBDC_GB_SWAP			REG_FLD_MSB_LSB(1, 1)
	#define FLD_L2_FBDC_GB_SWAP			REG_FLD_MSB_LSB(2, 2)
	#define FLD_L3_FBDC_GB_SWAP			REG_FLD_MSB_LSB(3, 3)
	#define FLD_EL0_FBDC_GB_SWAP			REG_FLD_MSB_LSB(4, 4)
	#define FLD_EL1_FBDC_GB_SWAP			REG_FLD_MSB_LSB(5, 5)
	#define FLD_EL2_FBDC_GB_SWAP			REG_FLD_MSB_LSB(6, 6)
#define DISP_REG_OVL_L0_FBDC_CNST_CLR0			(0x810UL)
	#define FLD_CNST_CLR0				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L0_FBDC_CNST_CLR1			(0x814UL)
	#define FLD_CNST_CLR1				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L1_FBDC_CNST_CLR0			(0x818UL)
	#define FLD_CNST_CLR0				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L1_FBDC_CNST_CLR1			(0x81CUL)
	#define FLD_CNST_CLR1				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L2_FBDC_CNST_CLR0			(0x820UL)
	#define FLD_CNST_CLR0				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L2_FBDC_CNST_CLR1			(0x824UL)
	#define FLD_CNST_CLR1				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L3_FBDC_CNST_CLR0			(0x828UL)
	#define FLD_CNST_CLR0				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L3_FBDC_CNST_CLR1			(0x82CUL)
	#define FLD_CNST_CLR1				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL0_FBDC_CNST_CLR0			(0x830UL)
	#define FLD_CNST_CLR0				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL0_FBDC_CNST_CLR1			(0x834UL)
	#define FLD_CNST_CLR1				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL1_FBDC_CNST_CLR0			(0x838UL)
	#define FLD_CNST_CLR0				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL1_FBDC_CNST_CLR1			(0x83CUL)
	#define FLD_CNST_CLR1				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL2_FBDC_CNST_CLR0			(0x840UL)
	#define FLD_CNST_CLR0				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL2_FBDC_CNST_CLR1			(0x844UL)
	#define FLD_CNST_CLR1				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L0_HDR_ADDR			(0xF44UL)
	#define FLD_L0_HDR_ADDR				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L0_HDR_PITCH			(0xF48UL)
	#define FLD_L0_HDR_SRC_PITCH			REG_FLD_MSB_LSB(15, 0)
	#define FLD_L0_HDR_SRC_PITCH_LSB		REG_FLD_MSB_LSB(16, 16)
	#define FLD_L0_HDR_ADDR_LSB			REG_FLD_MSB_LSB(20, 20)
#define DISP_REG_OVL_L1_HDR_ADDR			(0xF64UL)
	#define FLD_L1_HDR_ADDR				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L1_HDR_PITCH			(0xF68UL)
	#define FLD_L1_HDR_SRC_PITCH			REG_FLD_MSB_LSB(15, 0)
	#define FLD_L1_HDR_SRC_PITCH_LSB		REG_FLD_MSB_LSB(16, 16)
	#define FLD_L1_HDR_ADDR_LSB			REG_FLD_MSB_LSB(20, 20)
#define DISP_REG_OVL_L2_HDR_ADDR			(0xF84UL)
	#define FLD_L2_HDR_ADDR				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L2_HDR_PITCH			(0xF88UL)
	#define FLD_L2_HDR_SRC_PITCH			REG_FLD_MSB_LSB(15, 0)
	#define FLD_L2_HDR_SRC_PITCH_LSB		REG_FLD_MSB_LSB(16, 16)
	#define FLD_L2_HDR_ADDR_LSB			REG_FLD_MSB_LSB(20, 20)
#define DISP_REG_OVL_L3_HDR_ADDR			(0xFA4UL)
	#define FLD_L3_HDR_ADDR				REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_L3_HDR_PITCH			(0xFA8UL)
	#define FLD_L3_HDR_SRC_PITCH			REG_FLD_MSB_LSB(15, 0)
	#define FLD_L3_HDR_SRC_PITCH_LSB		REG_FLD_MSB_LSB(16, 16)
	#define FLD_L3_HDR_ADDR_LSB			REG_FLD_MSB_LSB(20, 20)
#define DISP_REG_OVL_EL0_HDR_ADDR			(0xFD0UL)
	#define FLD_EL0_HDR_ADDR			REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL0_HDR_PITCH			(0xFD4UL)
	#define FLD_EL0_HDR_SRC_PITCH			REG_FLD_MSB_LSB(15, 0)
	#define FLD_EL0_HDR_SRC_PITCH_LSB		REG_FLD_MSB_LSB(16, 16)
	#define FLD_EL0_HDR_ADDR_LSB			REG_FLD_MSB_LSB(20, 20)
#define DISP_REG_OVL_EL1_HDR_ADDR			(0xFD8UL)
	#define FLD_EL1_HDR_ADDR			REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL1_HDR_PITCH			(0xFDCUL)
	#define FLD_EL1_HDR_SRC_PITCH			REG_FLD_MSB_LSB(15, 0)
	#define FLD_EL1_HDR_SRC_PITCH_LSB		REG_FLD_MSB_LSB(16, 16)
	#define FLD_EL1_HDR_ADDR_LSB			REG_FLD_MSB_LSB(20, 20)
#define DISP_REG_OVL_EL2_HDR_ADDR			(0xFE0UL)
	#define FLD_EL2_HDR_ADDR			REG_FLD_MSB_LSB(31, 0)
#define DISP_REG_OVL_EL2_HDR_PITCH			(0xFE4UL)
	#define FLD_EL2_HDR_SRC_PITCH			REG_FLD_MSB_LSB(15, 0)
	#define FLD_EL2_HDR_SRC_PITCH_LSB		REG_FLD_MSB_LSB(16, 16)
	#define FLD_EL2_HDR_ADDR_LSB			REG_FLD_MSB_LSB(20, 20)
#define DISP_REG_OVL_SECURE				(0xFC0UL)
	#define FLD_L0_SECURE				REG_FLD_MSB_LSB(0, 0)
	#define FLD_L1_SECURE				REG_FLD_MSB_LSB(1, 1)
	#define FLD_L2_SECURE				REG_FLD_MSB_LSB(2, 2)
	#define FLD_L3_SECURE				REG_FLD_MSB_LSB(3, 3)
	#define FLD_EL0_SECURE				REG_FLD_MSB_LSB(4, 4)
	#define FLD_EL1_SECURE				REG_FLD_MSB_LSB(5, 5)
	#define FLD_EL2_SECURE				REG_FLD_MSB_LSB(6, 6)
#define DISP_REG_OVL_DOMAIN				(0xFC4UL)
	#define FLD_L0_DOMAIN				REG_FLD_MSB_LSB(4, 0)
	#define FLD_L1_DOMAIN				REG_FLD_MSB_LSB(12, 8)
	#define FLD_L2_DOMAIN				REG_FLD_MSB_LSB(20, 16)
	#define FLD_L3_DOMAIN				REG_FLD_MSB_LSB(28, 24)
#define DISP_REG_OVL_DOMAIN_EXT				(0xFC8UL)
	#define FLD_EL0_DOMAIN				REG_FLD_MSB_LSB(4, 0)
	#define FLD_EL1_DOMAIN				REG_FLD_MSB_LSB(12, 8)
	#define FLD_EL2_DOMAIN				REG_FLD_MSB_LSB(20, 16)

enum GS_OVL_FLD {
	GS_OVL_RDMA_ULTRA_TH = 0,
	GS_OVL_RDMA_PRE_ULTRA_TH,
	GS_OVL_RDMA_FIFO_THRD,
	GS_OVL_RDMA_FIFO_SIZE,
	GS_OVL_RDMA_ISSUE_REQ_TH,
	GS_OVL_RDMA_ISSUE_REQ_TH_URG,
	GS_OVL_RDMA_REQ_TH_PRE_ULTRA,
	GS_OVL_RDMA_REQ_TH_ULTRA,
	GS_OVL_RDMA_FORCE_REQ_TH,
	GS_OVL_RDMA_GREQ_NUM, /* whole reg */
	GS_OVL_RDMA_GREQ_URG_NUM, /* whole reg */
	GS_OVL_RDMA_ULTRA_SRC, /* whole reg */
	GS_OVL_RDMA_ULTRA_LOW_TH,
	GS_OVL_RDMA_PRE_ULTRA_LOW_TH,
	GS_OVL_RDMA_PRE_ULTRA_HIGH_TH,
	GS_OVL_RDMA_PRE_ULTRA_HIGH_DIS,
	GS_OVL_BLOCK_EXT_ULTRA,
	GS_OVL_BLOCK_EXT_PRE_ULTRA,
	GS_OVL_FLD_NUM,
};

#endif /* _DDP_REG_OVL_H_ */
