// SPDX-License-Identifier: GPL-2.0
/*
 * Copyright (c) 2020 MediaTek Inc.
 */

#include <linux/arm-smccc.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/io.h>
#include <linux/kobject.h>
#include <linux/module.h>
#include <linux/printk.h>
#include <linux/soc/mediatek/mtk_sip_svc.h>
#include <linux/string.h>
#include <linux/sysfs.h>

static struct kobject *mtk_scdk_kobject;
#define SCDK_MAGIC 	13013

static void mtk_scdk_set_dl_mode(unsigned int seconds)
{
	struct arm_smccc_res res = {0};

	seconds &= 0x3FFF;
	if (!seconds)
		seconds = 1;
	pr_info("[%s] seconds:0x%x\n", __func__, seconds);

	arm_smccc_smc(MTK_SIP_KERNEL_MTK_SCDK, seconds, 0, 0, 0, 0, 0, 0, &res);
	if (res.a0)
		pr_err("[%s] smc set brom fail: 0x%x\n", __func__,
		       (unsigned int)res.a0);
}

static ssize_t mtk_scdk_store(struct kobject *kobj, struct kobj_attribute *attr,
			      const char *buf, size_t count)
{
	unsigned int user_input;
	unsigned int user_magic;
	int ret;

	ret = sscanf(buf, "%u %u", &user_magic, &user_input);
	if (ret != 2) {
		pr_err("[%s] fail to parse cmd: %d\n", __func__, ret);
		return -EINVAL;
	}
	if (user_magic != SCDK_MAGIC) {
		pr_err("[%s] fail to authenticate user, you shall not pass\n", __func__);
		return -EINVAL;
	}

	pr_info("[%s] user_input:%u\n", __func__, user_input);

	mtk_scdk_set_dl_mode(user_input);

	pr_debug("[%s] done\n", __func__);
	return count;
}

static struct kobj_attribute mtk_scdk_attr = {
	.attr = {.name = "mtk_scdk", .mode = 0644 },
	.store = mtk_scdk_store,
};

static int __init mtk_scdk_init(void)
{
	int error = 0;

	mtk_scdk_kobject = kobject_create_and_add("mtk_scdk", kernel_kobj);
	if (!mtk_scdk_kobject)
		return -ENOMEM;

	error = sysfs_create_file(mtk_scdk_kobject, &mtk_scdk_attr.attr);
	if (error)
		pr_err("failed to create the file in /sys/kernel/mtk_scdk\n");

	pr_info("[%s] done:%d\n", __func__, error);
	return error;
}

static void __exit mtk_scdk_exit(void)
{
	kobject_put(mtk_scdk_kobject);
	pr_info("[%s] done\n", __func__);
}

module_init(mtk_scdk_init);
module_exit(mtk_scdk_exit);

MODULE_LICENSE("GPL v2");
MODULE_DESCRIPTION("mtk scdk v1.0");
