#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <fcntl.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include "lynq_data.h"
#include <cutils/jstring.h>
#include <pthread.h>
#include "liblog/lynq_deflog.h"
#include <sys/time.h>
#include <include/lynq_uci.h>
#include <errno.h>
#include <vector>
#include "lynq_data_urc.h"

#define LYNQ_SERVICE_PORT 8088
#define LYNQ_REC_BUF 8192
#define LYNQ_REQUEST_PARAM_BUF 8192
#define LYQN_SEDN_BUF 1024*8+sizeof(int)*3
#define USER_LOG_TAG "LYNQ_DATA"

#define LYNQ_DATA_UCI_BUF 258

#define LYNQ_ADDRESS "127.0.0.1"

using ::android::Parcel;
typedef struct{
    int uToken;
    int request;
    int paramLen;
    char param[LYNQ_REQUEST_PARAM_BUF];
}lynq_client_t;
typedef enum{
    LYNQ_E_CARDSTATE_ERROR=8000,
    /* The voice service state is out of service*/
    LYNQ_E_STATE_OUT_OF_SERVICE=8001,
    /* The voice service state is EMERGENCY_ONLY*/
    LYNQ_E_STATE_EMERGENCY_ONLY=8002,
    /* The radio power is power off*/
    LYNQ_E_STATE_POWER_OFF=8003,
    LYNQ_E_TIME_OUT=8004,
    /*create or open sms DB fail */
    LYNQ_E_SMS_DB_FAIL=8005,
    /*Failed to execute sql statement*/
    LYNQ_E_SMS_SQL_FAIL = 8006,
    LYNQ_E_SMS_NOT_FIND = 8007,
    /* The logic conflict*/
    LYNQ_E_CONFLICT=9000,
    /*Null anomaly*/
    LYNQ_E_NULL_ANONALY=9001
}LYNQ_E;

int lynq_client_sockfd = 0;
int Global_uToken = 0;

int lynq_data_call_change_id = -1;
pthread_t lynq_data_tid =-1;
static pthread_mutex_t s_data_call_state_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_data_call_state_change_cond = PTHREAD_COND_INITIALIZER;

static pthread_mutex_t s_lynq_apn_change_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_lynq_apn_change_cond = PTHREAD_COND_INITIALIZER;
static pthread_mutex_t s_lynq_urc_vector_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t s_lynq_urc_vector_cond = PTHREAD_COND_INITIALIZER;
/**g_lynq_data_sendto_mutex
* @brief mark data send request mutex
*/
static pthread_mutex_t g_lynq_data_sendto_mutex;

static int data_waiting_status = 0;

static int data_invaild_error = 0;

/**g_lynq_data_init_flag
* @brief mark data initialization state
* 0:deinit status
* 1:init state
*/
static int g_lynq_data_init_flag = 0;
/**g_lynq_apn_result
* @brief temp of apn result info
*/
char g_lynq_apn_result[1024] = {};

static std::vector<int> s_data_urc_wait_list;

typedef struct
{
    char apn[LYNQ_APN_MAX_LEN];
    char apnType[LYNQ_APN_TYPE_MAX_LEN];
    char ifaceName[LYNQ_IFACE_NAME_MAX_LEN];
    int hasUsed;
    int hasTimeout;
}lynq_apn_t;
lynq_apn_t lynq_apn_table[LYNQ_APN_CHANNEL_MAX] = {};
lynq_data_call_response_v11_t lynq_data_call_lists[LYNQ_APN_CHANNEL_MAX] = {};
int lynq_data_call = 0;

int getLynqApnID(char apnType[])
{
    int ret = 0;
    int len = 0;
    for(ret;ret<LYNQ_APN_CHANNEL_MAX;ret++)
    {
        len = strlen(lynq_apn_table[ret].apnType)<strlen(apnType) ? strlen(lynq_apn_table[ret].apnType):strlen(apnType);
        if(strncmp(lynq_apn_table[ret].apnType,apnType,len)==0)
        {
            return ret;
        }
    }
    return -1;
}

void updateApnTable(lynq_apn_t *apn_table,char apn[],char apntype[],char ifaceName[])
{
    LYDBGLOG("[updateApnTable] apn:%s,apntype:%s,ifaceName:%s",apn,apntype,ifaceName);
    if(apn_table==NULL)
    {
        LYERRLOG("apn_table is null");
        return;
    }
    memcpy(apn_table->apn,apn,strlen(apn)+1);
    memcpy(apn_table->apnType,apntype,strlen(apntype)+1);
    memcpy(apn_table->ifaceName,ifaceName,strlen(ifaceName)+1);
    apn_table->hasTimeout = 0;
    apn_table->hasUsed = 1;
    return;
}

void cleanOnceApnTable(int apnId)
{
    LYDBGLOG("apn id:%d",apnId);
    if((apnId < 0) || (apnId > LYNQ_APN_CHANNEL_MAX-1))
    {
        LYERRLOG("apn id is invalid!!!");
        return;
    }
    lynq_apn_table[apnId].hasTimeout = 0;
    lynq_apn_table[apnId].hasUsed = 0;
    bzero(lynq_apn_table[apnId].apn,LYNQ_APN_MAX_LEN);
    //bzero(lynq_apn_table[apnId].apnType,LYNQ_APN_TYPE_MAX_LEN);
    bzero(lynq_apn_table[apnId].ifaceName,LYNQ_IFACE_NAME_MAX_LEN);
    return;
}
int getUnusedElement()
{
	if (lynq_apn_table == NULL)
	{
		LYERRLOG("get UnusedElemnt apn_table is null");
		return -1;
	}
    for(int i=0;i < LYNQ_APN_CHANNEL_MAX; i++)
    {
        if(lynq_apn_table[i].hasUsed!=1)
        {
            return i;
        }
    }
	LYERRLOG("None of get unused Element");
    return -1;
}
int updateApn(char apnType[])
{
    int ret = 0;
    ret = getUnusedElement();
    memcpy(lynq_apn_table[ret].apnType,apnType,strlen(apnType)+1);
    lynq_apn_table[ret].hasUsed = 1;
    return ret;
}

int handleCheck(int handle)
{
    if (lynq_apn_table[handle].hasUsed == 1)
    {
        return 0;
    }
    else 
    {
        return -1;
    }
}
int waitApnResult()
{
    int ret = 0;
    LYINFLOG("start wait apn result!!!");
    int sec = 0;
    int usec = 0;
    struct timeval now;
    struct timespec timeout;
    gettimeofday(&now, NULL);
    sec = 20000 / 1000;
    usec = 20000 % 1000;
    timeout.tv_sec = now.tv_sec + sec;
    timeout.tv_nsec = now.tv_usec * 1000 + usec * 1000000;
    pthread_mutex_lock(&s_lynq_apn_change_mutex);
    ret = pthread_cond_timedwait(&s_lynq_apn_change_cond, &s_lynq_apn_change_mutex, &timeout);
    pthread_mutex_unlock(&s_lynq_apn_change_mutex);
    return ret;
}

void sendSignalApnChange()
{
    LYINFLOG("start send Signal Apn Change");
    pthread_mutex_lock(&s_lynq_apn_change_mutex);
    pthread_cond_signal(&s_lynq_apn_change_cond);
    pthread_mutex_unlock(&s_lynq_apn_change_mutex);
    return;
}

int waitPdnChange()
{
    int ret = 0;
    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    ret = pthread_cond_wait(&s_lynq_urc_vector_cond,&s_lynq_urc_vector_mutex);
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    return ret;
}
int waitDataCallstateChange(int mtime)
{
    int ret = 0;
    int sec = 0;
    int usec = 0;
    struct timeval now;
    struct timespec timeout;
    gettimeofday(&now,NULL);
    sec = mtime/1000;
    usec = mtime%1000;
    timeout.tv_sec = now.tv_sec+sec;
    timeout.tv_nsec = now.tv_usec*1000+usec*1000000;
    pthread_mutex_lock(&s_data_call_state_change_mutex);
    ret = pthread_cond_timedwait(&s_data_call_state_change_cond,&s_data_call_state_change_mutex,&timeout);
    pthread_mutex_unlock(&s_data_call_state_change_mutex);
    return ret;
}
void sendSignalDataCallStateChange()
{
    pthread_mutex_lock(&s_data_call_state_change_mutex);
    pthread_cond_signal(&s_data_call_state_change_cond);
    pthread_mutex_unlock(&s_data_call_state_change_mutex);
    return;
}
void sendSignalPdnChange()
{
    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    pthread_cond_signal(&s_lynq_urc_vector_cond);
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    return;
}

int get_response(int sockfd,Parcel &p)
{
    int len = 0;
    char recvline[LYNQ_REC_BUF];
    bzero(recvline,LYNQ_REC_BUF);
    /* receive data from server */
    len = read(sockfd, recvline, LYNQ_REC_BUF);
    if(len == -1)
    {
        LYERRLOG("read error");
        return -1;
    }
    if (recvline != NULL) {
        p.setData((uint8_t *)recvline,len); // p.setData((uint8_t *) buffer, buflen);
        p.setDataPosition(0);
    }
    return 0;
}
int JumpHeader(Parcel &p,int *resp_type,int *request,int *slot_id,int *error)
{
    if(p.dataAvail() > 0)
    {
        p.readInt32(resp_type);
        p.readInt32(request);
        p.readInt32(slot_id);
        p.readInt32(error);
        return 0;
    }
    else
    {
        return -1;
    }
}
int send_request(int sockfd,lynq_client_t *client_tmp)
{
    int ret=0;
    ret = write(sockfd, client_tmp, LYQN_SEDN_BUF);
    if(ret==-1)
    {
        perror("write error");
        return -1;
    }
    return 0;
}
static char *strdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;
    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}
static char *strdupReadString_p(Parcel *p) {
    size_t stringlen;
    const char16_t *s16;
    s16 = p->readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

/*Warren add for T800 platform 2021/11/19 start*/
int lynq_socket_client_start()
{
    struct sockaddr_in lynq_data_socket_server_addr;
    /* init lynq_socket_server_addr */
    bzero(&lynq_data_socket_server_addr, sizeof(lynq_data_socket_server_addr));
    lynq_data_socket_server_addr.sin_family = AF_INET;
    lynq_data_socket_server_addr.sin_port = htons(LYNQ_SERVICE_PORT);
    lynq_data_socket_server_addr.sin_addr.s_addr = inet_addr(LYNQ_ADDRESS);
    /*
    if(inet_pton(AF_INET,"127.0.0.1", &lynq_socket_server_addr.sin_addr) <= 0)
    {
        printf("[%s] is not a valid IPaddress\n", argv[1]);
        exit(1);
    }
*/
    lynq_client_sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    struct timeval timeOut; 

    timeOut.tv_sec = 30;
    timeOut.tv_usec = 0; 

    if (setsockopt(lynq_client_sockfd, SOL_SOCKET, SO_RCVTIMEO, &timeOut, sizeof(timeOut)) < 0) 
    { 
    LYERRLOG("time out setting failed"); 
    } 
    if(connect(lynq_client_sockfd, (struct sockaddr *)&lynq_data_socket_server_addr, sizeof(lynq_data_socket_server_addr)) == -1)
    {
        perror("connect error");
        return -1;
    }
    return 0;
}

bool is_support_urc(int urc_id)
{
    switch(urc_id)
    {
        case LYNQ_URC_DATA_CALL_STATUS_IND:

        case LYNQ_URC_MODIFY_APNDB:
        case LYNQ_URC_RESET_APNDB:
            return true;                
        default:
            return false;
    }    
}

int printf_apn_table()
{
    int ret = 0;
	if (lynq_apn_table == NULL)
	{
		LYERRLOG("apn table is null");
		return -1;
	}	
    for(ret;ret<LYNQ_APN_CHANNEL_MAX;ret++)
    {
        LYINFLOG("[Typethree test info]apn=%s ;apntype=%s ;ifname=%s ;hasTimeout = %d ; hasUsed = %d", \
        lynq_apn_table[ret].apn,lynq_apn_table[ret].apnType,lynq_apn_table[ret].ifaceName, \
        lynq_apn_table[ret].hasTimeout,lynq_apn_table[ret].hasUsed);
    }
    return 0;
}


void urc_msg_process(Parcel *p)
{
    int len;
    int resp_type;
    int urcid;
    int slot_id;

    int pdnState = 0;
    char apn[LYNQ_APN_MAX_LEN];
    char apnType[LYNQ_APN_TYPE_MAX_LEN];
    char ifaceName[LYNQ_IFACE_NAME_MAX_LEN];
    char *urc_msg = NULL;

    int size = p->dataSize();
    p->readInt32(&resp_type);
    p->readInt32(&urcid);
    p->readInt32(&slot_id);
    LYINFLOG("data lib recv urc:resp_type=%d,urcid=%d,slot_id=%d,size=%d\n",resp_type,urcid,slot_id,size);
    switch(urcid)
    {
        case LYNQ_URC_DATA_CALL_STATUS_IND:
            p->readInt32(&pdnState);
            bzero(apn,LYNQ_APN_MAX_LEN);
            bzero(apnType,LYNQ_APN_TYPE_MAX_LEN);
            bzero(ifaceName,LYNQ_IFACE_NAME_MAX_LEN);
            if(pdnState!=4)//PDN_DISCONNECTED
            {
                urc_msg = strdupReadString_p(p);
                int len = strlen(urc_msg);
                if(len < LYNQ_APN_MAX_LEN-1)
                {
                    memcpy(apn,urc_msg,len+1);
                }
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_APN_TYPE_MAX_LEN-1)
                {
                    memcpy(apnType,urc_msg,len+1);
                }
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_IFACE_NAME_MAX_LEN-1)
                {
                    memcpy(ifaceName,urc_msg,strlen(urc_msg)+1);
                }
                //sendSignalDataCallStateChange();
                int apnId = getLynqApnID(apnType);
                LYINFLOG("URC apnType:%s,ifaceName:%s,apn:%s pdnState:%d",apnType,ifaceName,apn,pdnState);
                if(apnId >= 0)
                {
                    if(lynq_apn_table[apnId].hasTimeout==1)
                    {
                        /*whether timeout?,real or not,*/
                        printf_apn_table();
                        LYERRLOG("apn:%s has time out,deacive this apn",lynq_apn_table[apnId].apn);
                        if (NULL != lynq_apn_table[apnId].apn && NULL != lynq_apn_table[apnId].apnType && strlen(lynq_apn_table[apnId].apn)>0)
                        {
                            LYERRLOG("deactive this time out APN");
                            lynq_deactive_data_call(&apnId);
                        }
                        else
                        {
                            /*if apn lose,update apn and deactive all apn*/
                            LYERRLOG("this table is invalid update APN table");
                        }
                        break;
                    }
                    updateApnTable(&lynq_apn_table[apnId],apn,apnType,ifaceName);
                }
                /*To be completed*/
                else
                {
					data_invaild_error = 1;
                    printf_apn_table();
                    LYERRLOG("invalid apnId:%d",apnId);
                    break;
                }
                pthread_mutex_lock(&s_lynq_urc_vector_mutex);
                s_data_urc_wait_list.push_back(apnId);
                pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
                lynq_data_call_change_id = apnId;
                sendSignalPdnChange();
                LYDBGLOG("data call state:%d",lynq_data_call);
                if(lynq_data_call==1)
                {
                    sendSignalDataCallStateChange();
                    lynq_data_call = 0;
                }
            }
            else
            {
                urc_msg = strdupReadString_p(p);
                len = strlen(urc_msg);
                if(len < LYNQ_APN_TYPE_MAX_LEN-1)
                {
                    memcpy(apnType,urc_msg,len+1);
                }
                LYDBGLOG("[data thread_urc_recv] apntype:%s",apnType);
                int apnId = getLynqApnID(apnType);
                if(apnId >= 0)
                {
                    lynq_data_call_change_id = apnId;
                    bzero(lynq_apn_table[apnId].apnType,LYNQ_APN_TYPE_MAX_LEN);//async clean
                    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
                    s_data_urc_wait_list.push_back(apnId);
                    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
                    sendSignalPdnChange();
                }
                LYDBGLOG("data call state:%d",lynq_data_call);
                if(lynq_data_call==1)
                {
                    sendSignalDataCallStateChange();
                    lynq_data_call = 0;
                }
            }
            break;
        case LYNQ_URC_MODIFY_APNDB:
            urc_msg = strdupReadString_p(p);
            if (NULL == urc_msg)
            {
                LYERRLOG("error apn msg");
            }
            else
            {
                bzero(g_lynq_apn_result, 1024);
                strcpy(g_lynq_apn_result, urc_msg);
                sendSignalApnChange();
            }
            break;
        case LYNQ_URC_RESET_APNDB:
            {
                urc_msg = strdupReadString_p(p);
                if (NULL == urc_msg)
                {
                    LYERRLOG("error apn msg");
                }
                else
                {
                    bzero(g_lynq_apn_result, 1024);
                    strcpy(g_lynq_apn_result, urc_msg);
                    sendSignalApnChange();
                }
            }
        default:
            break;
    }
    
}

int create_urc_vector_signal_thread()
{
    int ret;
    pthread_mutex_init(&s_lynq_urc_vector_mutex,NULL);
    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    s_data_urc_wait_list.clear();
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    return 0;
}

int lynq_init_data(int uToken)
{
    if (g_lynq_data_init_flag == 1)
    {
        LYERRLOG("init twice is not allowed");
        return -1;
    }
    g_lynq_data_init_flag = 1;
    int result = 0;
    Global_uToken = uToken;
    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    result = lynq_socket_client_start();
    pthread_mutex_init(&g_lynq_data_sendto_mutex, NULL);
    if(result!=0)
    {
        LYERRLOG("init socket client fail!!!");
        return -1;
    }
    result = lynq_init_data_urc_thread();
    if(result!=0)
    {
        LYERRLOG("init socket urc fail!!!");
        return -1;
    }

    result = create_urc_vector_signal_thread();
    if(result!=0)
    {
        LYERRLOG("init socket urc fail!!!");
        return -1;
    }
    memset(lynq_apn_table,0,sizeof(lynq_apn_table));
    LYDBGLOG("lynq init call success!!!");
    return 0;

}
int lynq_deinit_data()
{
    int ret = -1;
    if (g_lynq_data_init_flag == 0)
    {
        LYERRLOG("deinit twice is not allowed");
        return ret;
    }
    g_lynq_data_init_flag = 0;
    for(int i =0;i<LYNQ_APN_CHANNEL_MAX;i++)
    {
        if(strlen(lynq_apn_table[i].apnType)!=0)
        {
            lynq_deactive_data_call(&i);
        }
    }
    if(lynq_client_sockfd>0)
    {
        close(lynq_client_sockfd);
    }
    ret = lynq_deinit_data_urc_thread();
    if (ret != 0)
    {
        LYERRLOG("lynq_deinit_data_urc_thread fail");
        return ret;
    }
    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    s_data_urc_wait_list.clear();
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    return 0;
}
int lynq_setup_data_call(int *handle)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int lynq_data_call_id = 0;
    if(handle==NULL)
    {
        LYERRLOG("handle is null!!!");
        return LYNQ_E_NULL_ANONALY;
    }
    client.uToken = Global_uToken;
    client.request = 27;//RIL_REQUEST_SETUP_DATA_CALL
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    lynq_data_call_id = updateApn("default");
    if (lynq_data_call_id < 0)
    {
        LYERRLOG("update apn table fail error id = %d",lynq_data_call_id);
        return -1;
    }
    lynq_data_call = 1;
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }
    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    if(error==0)
    {
        if (waitDataCallstateChange(60000) == ETIMEDOUT) // 60s
        {
            error = LYNQ_E_TIME_OUT;
            LYERRLOG("timeout:wait data Call state fail!!!");
            lynq_apn_table[lynq_data_call_id].hasTimeout = 1;
			if (data_invaild_error == 1)
			{
				data_invaild_error = 0;
				LYERRLOG("urc apn info error!!!");
				return 8085;
			}
            return error;
        }
        *handle = lynq_data_call_id;
    }
    return error;
}

int lynq_deactive_data_call(int *handle)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int lynq_data_call_id = -1;
    int ret = 0;
    if(handle==NULL)
    {
        LYERRLOG("handle is null!!!");
        return -1;
    }
    ret = handleCheck(*handle);
    if (ret != 0)
    {
        LYERRLOG("incomming handle is invalid");
        return -1;
    }
    lynq_data_call_id = *handle;
    client.uToken = Global_uToken;
    client.request = 41;//RIL_REQUEST_DEACTIVATE_DATA_CALL
    if(strcmp(lynq_apn_table[lynq_data_call_id].apnType,"default")==0)
    {
        client.paramLen = 0;
        bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    }
    else
    {
        client.paramLen = 1;
        bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param,"%s",lynq_apn_table[lynq_data_call_id].apnType);
    }
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }
    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    cleanOnceApnTable(lynq_data_call_id);
    return error;
}
int lynq_setup_data_call_sp(int *handle,char *apn,char *apnType,char *user,char *password,char *authType,char *normalProtocol,char *roamingProtocol)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    int lynq_data_call_id = -1;
    char *argv[10] = {};
    if(handle==NULL||apn==NULL||apnType==NULL)
    {
        LYERRLOG("handle ,apn or apntype is null!!!");
        return -1;
    }
    if(user==NULL)
    {
        argv[1] = "null";
    }
    else
    {
        argv[1] = user;
    }
    if(password==NULL)
    {
        argv[2] = "null";
    }
    else
    {
        argv[2] = password;
    }
    if(authType==NULL)
    {
        argv[3] = "null";
    }
    else
    {
        argv[3] = authType;
    }
    if(normalProtocol==NULL)
    {
        argv[4] = "null";
    }
    else
    {
        argv[4] = normalProtocol;
    }
    if(roamingProtocol==NULL)
    {
        argv[5] = "null";
    }
    else
    {
        argv[5] = roamingProtocol;
    }
    client.uToken = Global_uToken;
    client.request = 27;//RIL_REQUEST_SETUP_DATA_CALL
    client.paramLen = 7;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    sprintf(client.param,"%s %s %s %s %s %s %s",apn,apnType,argv[1],argv[2],argv[3],argv[4],argv[5]);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    lynq_data_call_id = updateApn(apnType);
    if (lynq_data_call_id < 0)
    {
        LYERRLOG("update apn table fail error id = %d",lynq_data_call_id);
        return -1;
    }
    lynq_data_call = 1;
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }
    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    if(error==0)
    {
        if(waitDataCallstateChange(60000)==ETIMEDOUT)//60s
        {
            error = LYNQ_E_TIME_OUT;
            LYERRLOG("timeout:wait data Call state fail!!!");
            lynq_apn_table[lynq_data_call_id].hasTimeout = 1;
			if (data_invaild_error == 1)
			{
				data_invaild_error = 0;
				LYERRLOG("urc apn info error!!!");
				return 8085;
			}
            return error;
        }
        *handle = lynq_data_call_id;
    }
    return error;
}
/*
int lynq_deactive_data_call_sp(int *handle,char *apnType)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int error = -1;
    if(handle==NULL||apnType==NULL)
    {
        LYERRLOG("handle is null!!!");
        return -1;
    }
    client.uToken = Global_uToken;
    client.request = 41;//RIL_REQUEST_DEACTIVATE_DATA_CALL
    client.paramLen = 1;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    sprintf(client.param,"%s",apnType);
    LYERRLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }
    get_response(lynq_client_sockfd,p);
    JumpHeader(p,&resp_type,&request,&slot_id,&error);
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    return error;
}
*/
int getDataCallLists(lynq_data_call_response_v11_t dataCallList[LYNQ_APN_CHANNEL_MAX],int *realNum)
{
    Parcel p;
    lynq_client_t client;
    int resp_type = -1;
    int token;
    int request = -1;    
    int slot_id = -1;
    int error = -1;
    int version =0;
    int num = 0;
    char *temp_char = NULL;
    if(dataCallList==NULL)
    {
        LYERRLOG("dataCallList is null!!!");
        return -1;
    }
    client.uToken = Global_uToken;
    client.request = 57;//RIL_REQUEST_DATA_CALL_LIST
    client.paramLen = 0;
    bzero(client.param,LYNQ_REQUEST_PARAM_BUF);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        perror("[LYNQ_DATA] send request fail:");
        return -1;
    }
    get_response(lynq_client_sockfd,p);
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    if(p.dataAvail() > 0)
    {
        p.readInt32(&resp_type);
        p.readInt32(&token);
        p.readInt32(&request);
        p.readInt32(&slot_id);
        p.readInt32(&error);
    }
    else
    {
        return -1;
    }
    LYINFLOG("resp_type=%d,request=%d,slot_id=%d,error_code=%d",resp_type,request,slot_id,error);
    p.readInt32(&version);
    if(version==11)
    {
        p.readInt32(&num);
        *realNum = num;
        for (int i = 0; i < num; i++)
        {
            p.readInt32(&dataCallList[i].status);
            p.readInt32(&dataCallList[i].suggestedRetryTime);
            p.readInt32(&dataCallList[i].cid);
            p.readInt32(&dataCallList[i].active);
            temp_char = strdupReadString(p);
            memcpy(dataCallList[i].type,temp_char,strlen(temp_char)+1);
            temp_char = strdupReadString(p);
            memcpy(dataCallList[i].ifname,temp_char,strlen(temp_char)+1);
            temp_char = strdupReadString(p);
            memcpy(dataCallList[i].addresses,temp_char,strlen(temp_char)+1);
            temp_char = strdupReadString(p);
            memcpy(dataCallList[i].dnses,temp_char,strlen(temp_char)+1);
            temp_char = strdupReadString(p);
            memcpy(dataCallList[i].gateways,temp_char,strlen(temp_char)+1);
            temp_char = strdupReadString(p);
            memcpy(dataCallList[i].pcscf,temp_char,strlen(temp_char)+1);
            p.readInt32(&dataCallList[i].mtu);
        }
    }
    return error;
}
int lynq_get_data_call_list(int *handle,lynq_data_call_response_v11_t *dataCallList)
{
    lynq_data_call_response_v11_t interDataCallList[LYNQ_APN_CHANNEL_MAX]={};
    int number = 0;
    int lynq_data_call_id = 0;
    int error = 0;
    lynq_data_call_id = *handle;
    if(handle==NULL)
    {
        LYERRLOG("handle is NULL");
        return LYNQ_E_NULL_ANONALY;
    }
    if (*handle<0 && handle>8)
    {
        LYERRLOG("handle value error");
    }
    LYINFLOG("incoming handle value: %d",*handle);
    memset(interDataCallList,0,sizeof(interDataCallList));
    error = getDataCallLists(interDataCallList,&number);
    if(error == 0)
    {
        for(int i = 0;i < number;i++)
        {
            if(strcmp(interDataCallList[i].ifname,lynq_apn_table[lynq_data_call_id].ifaceName)==0)
            {
                dataCallList->active = interDataCallList[i].active;
                dataCallList->suggestedRetryTime = interDataCallList[i].suggestedRetryTime;
                dataCallList->cid = interDataCallList[i].cid;
                dataCallList->status = interDataCallList[i].status;
                dataCallList->mtu = interDataCallList[i].mtu;
                memcpy(dataCallList->addresses,interDataCallList[i].addresses,sizeof(interDataCallList[i].addresses));
                memcpy(dataCallList->ifname,interDataCallList[i].ifname,sizeof(interDataCallList[i].ifname));
                memcpy(dataCallList->dnses,interDataCallList[i].dnses,sizeof(interDataCallList[i].dnses));
                memcpy(dataCallList->type,interDataCallList[i].type,sizeof(interDataCallList[i].type));
                memcpy(dataCallList->gateways,interDataCallList[i].gateways,sizeof(interDataCallList[i].gateways));
                memcpy(dataCallList->pcscf,interDataCallList[i].pcscf,sizeof(interDataCallList[i].pcscf));
                LYDBGLOG("ifname:%s,addr:%s",dataCallList->ifname,dataCallList->addresses);
            }
        }
    }
    return error;
}
int lynq_wait_data_call_state_change(int *handle)
{
    if (data_waiting_status == 1)
    {
        LYDBGLOG("some thread is waiting");
        return -3;
    }
    LYDBGLOG("is empty :%d",s_data_urc_wait_list.empty());
    if (s_data_urc_wait_list.empty())
    {
        LYDBGLOG("start wait");
        data_waiting_status = 1;
        waitPdnChange();
    }
    data_waiting_status = 0;
    std::vector<int>::iterator iter;

    pthread_mutex_lock(&s_lynq_urc_vector_mutex);
    iter = s_data_urc_wait_list.begin();
    if (iter != s_data_urc_wait_list.end())
    {
        *handle = *iter;
    }
    s_data_urc_wait_list.erase(iter);
    pthread_mutex_unlock(&s_lynq_urc_vector_mutex);
    
    LYINFLOG("lynq data call id:%d",*handle);
    return 0;
}
/*Warren add for T800 platform 2021/11/19 end*/

/*Typethree add for T800 platform 2022/04/21 start*/

int insert_apn_char(char *agc, char *id,char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier)
{
    char strtmp[10][32];
    if (id == NULL)
    {
        sprintf(strtmp[0], "id=;");
    }
    else
    {
        sprintf(strtmp[0], "id=%s;", id);
    }
    if (mcc == NULL)
    {
        sprintf(strtmp[1], "mcc=;");
    }
    else
    {
        sprintf(strtmp[1], "mcc=%s;", mcc);
    }
    if (mnc == NULL)
    {
        sprintf(strtmp[2], "mnc=;");
    }
    else
    {
        sprintf(strtmp[2], "mnc=%s;", mnc);
    }
    if (apn == NULL)
    {
        sprintf(strtmp[3], "apn=;");
    }
    else
    {
        sprintf(strtmp[3], "apn=%s;", apn);
    }
    if (apntype == NULL)
    {
        sprintf(strtmp[4], "apntype=;");
    }
    else
    {
        sprintf(strtmp[4], "apntype=%s;", apntype);
    }
    if (user == NULL)
    {
        sprintf(strtmp[5], "user=;");
    }
    else
    {
        sprintf(strtmp[5], "user=%s;", user);
    }
    if (password == NULL)
    {
        sprintf(strtmp[6], "password=;");
    }
    else
    {
        sprintf(strtmp[6], "password=%s;", password);
    }
    if (normalprotocol == NULL)
    {
        sprintf(strtmp[7], "normalprotocol=;");
    }
    else
    {
        sprintf(strtmp[7], "normalprotocol=%s;", normalprotocol);
    }
    if (roamingprotocol == NULL)
    {
        sprintf(strtmp[8], "roamingprotocol=;");
    }
    else
    {
        sprintf(strtmp[8], "roamingprotocol=%s;", roamingprotocol);
    }
    if (carrier == NULL)
    {
        sprintf(strtmp[9], "carrier=;");
    }
    else
    {
        sprintf(strtmp[9], "carrier=%s;", carrier);
    }
    sprintf(agc, "%s%s%s%s%s%s%s%s%s%s",strtmp[0], strtmp[1], strtmp[2], strtmp[3], strtmp[4], strtmp[5], strtmp[6], strtmp[7], strtmp[8], strtmp[9]);

    return 0;
}

int modify_apn_char(char *agc, char *id, char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier)
{
    char strtmp[10][32];
    if (id == NULL)
    {
        sprintf(strtmp[0], "id=;");
    }
    else
    {
        sprintf(strtmp[0], "id=%s;", id);
    }
    if (mcc == NULL)
    {
        sprintf(strtmp[1], "mcc=;");
    }
    else
    {
        sprintf(strtmp[1], "mcc=%s;", mcc);
    }
    if (mnc == NULL)
    {
        sprintf(strtmp[2], "mnc=;");
    }
    else
    {
        sprintf(strtmp[2], "mnc=%s;", mnc);
    }
    if (apn == NULL)
    {
        sprintf(strtmp[3], "apn=;");
    }
    else
    {
        sprintf(strtmp[3], "apn=%s;", apn);
    }
    if (apntype == NULL)
    {
        sprintf(strtmp[4], "apntype=;");
    }
    else
    {
        sprintf(strtmp[4], "apntype=%s;", apntype);
    }
    if (user == NULL)
    {
        sprintf(strtmp[5], "user=;");
    }
    else
    {
        sprintf(strtmp[5], "user=%s;", user);
    }
    if (password == NULL)
    {
        sprintf(strtmp[6], "password=;");
    }
    else
    {
        sprintf(strtmp[6], "password=%s;", password);
    }
    if (normalprotocol == NULL)
    {
        sprintf(strtmp[7], "normalprotocol=;");
    }
    else
    {
        sprintf(strtmp[7], "normalprotocol=%s;", normalprotocol);
    }
    if (roamingprotocol == NULL)
    {
        sprintf(strtmp[8], "roamingprotocol=;");
    }
    else
    {
        sprintf(strtmp[8], "roamingprotocol=%s;", roamingprotocol);
    }
    if (carrier == NULL)
    {
        sprintf(strtmp[9], "carrier=;");
    }
    else
    {
        sprintf(strtmp[9], "carrier=%s;", carrier);
    }
    sprintf(agc, "%s%s%s%s%s%s%s%s%s%s", strtmp[0], strtmp[1], strtmp[2], strtmp[3], strtmp[4], strtmp[5], strtmp[6], strtmp[7], strtmp[8], strtmp[9]);
    return 0;
}


int query_apn_char(char *agc, char *id, char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier)
{
    char strtmp[10][32];
    if (id == NULL)
    {
        sprintf(strtmp[0], "");
    }
    else
    {
        sprintf(strtmp[0], "id=%s;", id);
    }
    if (mcc == NULL)
    {
        sprintf(strtmp[1], "");
    }
    else
    {
        sprintf(strtmp[1], "mcc=%s;", mcc);
    }
    if (mnc == NULL)
    {
        sprintf(strtmp[2], "");
    }
    else
    {
        sprintf(strtmp[2], "mnc=%s;", mnc);
    }
    if (apn == NULL)
    {
        sprintf(strtmp[3], "");
    }
    else
    {
        sprintf(strtmp[3], "apn=%s;", apn);
    }
    if (apntype == NULL)
    {
        sprintf(strtmp[4], "");
    }
    else
    {
        sprintf(strtmp[4], "apntype=%s;", apntype);
    }
    if (user == NULL)
    {
        sprintf(strtmp[5], "");
    }
    else
    {
        sprintf(strtmp[5], "user=%s;", user);
    }
    if (password == NULL)
    {
        sprintf(strtmp[6], "");
    }
    else
    {
        sprintf(strtmp[6], "password=%s;", password);
    }
    if (normalprotocol == NULL)
    {
        sprintf(strtmp[7], "");
    }
    else
    {
        sprintf(strtmp[7], "normalprotocol=%s;", normalprotocol);
    }
    if (roamingprotocol == NULL)
    {
        sprintf(strtmp[8], "");
    }
    else
    {
        sprintf(strtmp[8], "roamingprotocol=%s;", roamingprotocol);
    }
    if (carrier == NULL)
    {
        sprintf(strtmp[9], "");
    }
    else
    {
        sprintf(strtmp[9], "carrier=%s;", carrier);
    }
    sprintf(agc, "%s%s%s%s%s%s%s%s%s%s", strtmp[0], strtmp[1], strtmp[2], strtmp[3], strtmp[4], strtmp[5], strtmp[6], strtmp[7], strtmp[8], strtmp[9]);
    return 0;
}

static char *lynqStrdupReadString(Parcel &p)
{
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

int lynq_modify_apn_db(const int cmd, char *id, char *mcc, char *mnc, char *apn, char *apntype, char *user, char *password, char *normalprotocol, char *roamingprotocol, char *carrier, char *out)
{
    if (NULL == id && NULL == mcc && NULL == mnc && NULL == apn && NULL == apntype && NULL == user && NULL == password && NULL == normalprotocol && NULL == roamingprotocol && NULL == carrier)
    {
        LYERRLOG("There are no valid parameters");
        return -1;
    }
    lynq_client_t client;
    char argc[512];
    int res = 0;
    Parcel p;
    if (cmd == 0) // insert apn db
    {
        res = insert_apn_char(argc, id, mcc, mnc, apn, apntype, user, password, normalprotocol, roamingprotocol, carrier);

        client.uToken = Global_uToken;
        client.request = 2000 + 193; // RIL_REQUEST_MODIFY_APN
        client.paramLen = 2;
        bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param, "%d %s", cmd, argc);
    }
    else if (cmd == 1) //delete apn db
    {
        if (NULL == id)
        {
            LYERRLOG("id is NULL!!!please input id: ");
        }
        sprintf(argc, "id=%s", id);
        client.uToken = Global_uToken;
        client.request = 2000 + 193; // RIL_REQUEST_MODIFY_APN
        client.paramLen = 2;
        bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param, "%d %s", cmd, argc);
    }
    else if (cmd == 2) //query apn db
    {
        query_apn_char(argc, id, mcc, mnc, apn, apntype, user, password, normalprotocol, roamingprotocol, carrier);
        client.uToken = Global_uToken;
        client.request = 2000 + 193; // RIL_REQUEST_MODIFY_APN
        client.paramLen = 2;
        bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param, "%d %s", cmd, argc);
    }
    else if (cmd == 3)  //modify apn db
    {
        modify_apn_char(argc, id, mcc, mnc, apn, apntype, user, password, normalprotocol, roamingprotocol, carrier);
        client.uToken = Global_uToken;
        client.request = 2000 + 193; // RIL_REQUEST_MODIFY_APN
        client.paramLen = 2;
        bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
        sprintf(client.param, "%d %s", cmd, argc);
    }
    else
    {
        LYERRLOG("incoming command is invalid");
        return -1;
    }
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s",client.uToken,client.request,client.paramLen,client.param);
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if(send_request(lynq_client_sockfd,&client)==-1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    waitApnResult();
    strcpy(out, g_lynq_apn_result);
    LYINFLOG(">>>>>output info:%s",out);
    return 0;
}

int lynq_reset_apn(char *result)
{
    Parcel p;
    lynq_client_t client;
    if (NULL == result)
    {
        LYERRLOG("incoming paramters error");
    }
    client.uToken = Global_uToken;
    client.request = 2000 + 194;
    client.paramLen = 0;
    bzero(client.param, LYNQ_REQUEST_PARAM_BUF);
    LYINFLOG("uToken=%d,request=%d,paralen=%d,param=%s", client.uToken, client.request, client.paramLen, client.param);
    pthread_mutex_lock(&g_lynq_data_sendto_mutex);
    if (send_request(lynq_client_sockfd, &client) == -1)
    {
        LYERRLOG("send request fail");
        return -1;
    }
    pthread_mutex_unlock(&g_lynq_data_sendto_mutex);
    waitApnResult();
    strcpy(result, g_lynq_apn_result);
    LYINFLOG(">>>>>result:%s",result);
    return 0;
}

/*Typethree add for T800 platform 2022/04/21 end*/
