/*
 * Decompiled with CFR 0.152.
 */
package com.android.signapk;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.DefaultApkSignerEngine;
import com.android.apksig.apk.ApkUtils;
import com.android.apksig.apk.MinSdkVersionException;
import com.android.apksig.util.DataSink;
import com.android.apksig.util.DataSources;
import com.android.apksig.zip.ZipFormatException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Console;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.conscrypt.OpenSSLProvider;

class SignApk {
    private static final String OTACERT_NAME = "META-INF/com/android/otacert";
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_HEADER_ID = -9931;
    private static final short ALIGNMENT_ZIP_EXTRA_DATA_FIELD_MIN_SIZE_BYTES = 6;
    private static final int USE_SHA1 = 1;
    private static final int USE_SHA256 = 2;

    SignApk() {
    }

    private static int getDigestAlgorithmForOta(X509Certificate cert) {
        String sigAlg = cert.getSigAlgName().toUpperCase(Locale.US);
        if ("SHA1WITHRSA".equals(sigAlg) || "MD5WITHRSA".equals(sigAlg)) {
            return 1;
        }
        if (sigAlg.startsWith("SHA256WITH")) {
            return 2;
        }
        throw new IllegalArgumentException("unsupported signature algorithm \"" + sigAlg + "\" in cert [" + cert.getSubjectDN());
    }

    private static String getJcaSignatureAlgorithmForOta(X509Certificate cert, int hash) {
        String sigAlgDigestPrefix;
        switch (hash) {
            case 1: {
                sigAlgDigestPrefix = "SHA1";
                break;
            }
            case 2: {
                sigAlgDigestPrefix = "SHA256";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown hash ID: " + hash);
            }
        }
        String keyAlgorithm = cert.getPublicKey().getAlgorithm();
        if ("RSA".equalsIgnoreCase(keyAlgorithm)) {
            return sigAlgDigestPrefix + "withRSA";
        }
        if ("EC".equalsIgnoreCase(keyAlgorithm)) {
            return sigAlgDigestPrefix + "withECDSA";
        }
        throw new IllegalArgumentException("Unsupported key algorithm: " + keyAlgorithm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate readPublicKey(File file) throws IOException, GeneralSecurityException {
        try (FileInputStream input = new FileInputStream(file);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(input);
            return x509Certificate;
        }
    }

    private static String readPassword(File keyFile) {
        Console console = System.console();
        if (console == null) {
            System.out.print("Enter password for " + keyFile + " (password will not be hidden): ");
            System.out.flush();
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            try {
                return stdin.readLine();
            }
            catch (IOException ex) {
                return null;
            }
        }
        char[] pwd = console.readPassword("[%s]", "Enter password for " + keyFile);
        if (pwd != null) {
            return String.valueOf(pwd);
        }
        return null;
    }

    private static PKCS8EncodedKeySpec decryptPrivateKey(byte[] encryptedPrivateKey, File keyFile) throws GeneralSecurityException {
        EncryptedPrivateKeyInfo epkInfo;
        try {
            epkInfo = new EncryptedPrivateKeyInfo(encryptedPrivateKey);
        }
        catch (IOException ex) {
            return null;
        }
        char[] password = SignApk.readPassword(keyFile).toCharArray();
        SecretKeyFactory skFactory = SecretKeyFactory.getInstance(epkInfo.getAlgName());
        SecretKey key = skFactory.generateSecret(new PBEKeySpec(password));
        Cipher cipher = Cipher.getInstance(epkInfo.getAlgName());
        cipher.init(2, (Key)key, epkInfo.getAlgParameters());
        try {
            return epkInfo.getKeySpec(cipher);
        }
        catch (InvalidKeySpecException ex) {
            System.err.println("signapk: Password for " + keyFile + " may be bad.");
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey readPrivateKey(File file) throws IOException, GeneralSecurityException {
        try (DataInputStream input = new DataInputStream(new FileInputStream(file));){
            PrivateKeyInfo pki;
            byte[] bytes = new byte[(int)file.length()];
            input.read(bytes);
            PKCS8EncodedKeySpec spec = SignApk.decryptPrivateKey(bytes, file);
            if (spec == null) {
                spec = new PKCS8EncodedKeySpec(bytes);
            }
            Serializable serializable = null;
            try (ASN1InputStream bIn = new ASN1InputStream(new ByteArrayInputStream(spec.getEncoded()));){
                pki = PrivateKeyInfo.getInstance(bIn.readObject());
            }
            catch (Throwable throwable) {
                serializable = throwable;
                throw throwable;
            }
            String algOid = pki.getPrivateKeyAlgorithm().getAlgorithm().getId();
            serializable = KeyFactory.getInstance(algOid).generatePrivate(spec);
            return serializable;
        }
    }

    private static void addOtacert(JarOutputStream outputJar, File publicKeyFile, long timestamp) throws IOException {
        int read;
        JarEntry je = new JarEntry(OTACERT_NAME);
        je.setTime(timestamp);
        outputJar.putNextEntry(je);
        FileInputStream input = new FileInputStream(publicKeyFile);
        byte[] b = new byte[4096];
        while ((read = input.read(b)) != -1) {
            outputJar.write(b, 0, read);
        }
        input.close();
    }

    private static void writeSignatureBlock(CMSTypedData data, X509Certificate publicKey, PrivateKey privateKey, int hash, OutputStream out) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>(1);
        certList.add(publicKey);
        JcaCertStore certs = new JcaCertStore(certList);
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        ContentSigner signer = new JcaContentSignerBuilder(SignApk.getJcaSignatureAlgorithmForOta(publicKey, hash)).build(privateKey);
        gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().build()).setDirectSignature(true).build(signer, publicKey));
        gen.addCertificates(certs);
        CMSSignedData sigData = gen.generate(data, false);
        try (ASN1InputStream asn1 = new ASN1InputStream(sigData.getEncoded());){
            DEROutputStream dos = new DEROutputStream(out);
            dos.writeObject(asn1.readObject());
        }
    }

    private static void addV1Signature(ApkSignerEngine apkSigner, ApkSignerEngine.OutputJarSignatureRequest v1Signature, JarOutputStream out, long timestamp) throws IOException {
        for (ApkSignerEngine.OutputJarSignatureRequest.JarEntry entry : v1Signature.getAdditionalJarEntries()) {
            String entryName = entry.getName();
            JarEntry outEntry = new JarEntry(entryName);
            outEntry.setTime(timestamp);
            out.putNextEntry(outEntry);
            byte[] entryData = entry.getData();
            out.write(entryData);
            ApkSignerEngine.InspectJarEntryRequest inspectEntryRequest = apkSigner.outputJarEntry(entryName);
            if (inspectEntryRequest == null) continue;
            inspectEntryRequest.getDataSink().consume(entryData, 0, entryData.length);
            inspectEntryRequest.done();
        }
    }

    private static void copyFiles(JarFile in, Pattern ignoredFilenamePattern, ApkSignerEngine apkSigner, JarOutputStream out, long timestamp, int defaultAlignment) throws IOException {
        int num;
        JarEntry outEntry;
        JarEntry inEntry;
        byte[] buffer = new byte[4096];
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<JarEntry> e = in.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            String entryName = entry.getName();
            if (ignoredFilenamePattern != null && ignoredFilenamePattern.matcher(entryName).matches()) continue;
            names.add(entryName);
        }
        Collections.sort(names);
        boolean firstEntry = true;
        long offset = 0L;
        ArrayList<String> remainingNames = new ArrayList<String>(names.size());
        for (String name : names) {
            inEntry = in.getJarEntry(name);
            if (inEntry.getMethod() != 0) {
                remainingNames.add(name);
                continue;
            }
            if (!SignApk.shouldOutputApkEntry(apkSigner, in, inEntry, buffer)) continue;
            outEntry = new JarEntry(inEntry);
            outEntry.setTime(timestamp);
            outEntry.setComment(null);
            outEntry.setExtra(null);
            int alignment = SignApk.getStoredEntryDataAlignment(name, defaultAlignment);
            offset += (long)(30 + outEntry.getName().length());
            if (firstEntry) {
                offset += 4L;
                firstEntry = false;
            }
            int extraPaddingSizeBytes = 0;
            if (alignment > 0) {
                long paddingStartOffset = offset + 6L;
                extraPaddingSizeBytes = (alignment - (int)(paddingStartOffset % (long)alignment)) % alignment;
            }
            byte[] extra = new byte[6 + extraPaddingSizeBytes];
            ByteBuffer extraBuf = ByteBuffer.wrap(extra);
            extraBuf.order(ByteOrder.LITTLE_ENDIAN);
            extraBuf.putShort((short)-9931);
            extraBuf.putShort((short)(2 + extraPaddingSizeBytes));
            extraBuf.putShort((short)alignment);
            outEntry.setExtra(extra);
            offset += (long)extra.length;
            out.putNextEntry(outEntry);
            ApkSignerEngine.InspectJarEntryRequest inspectEntryRequest = apkSigner != null ? apkSigner.outputJarEntry(name) : null;
            DataSink entryDataSink = inspectEntryRequest != null ? inspectEntryRequest.getDataSink() : null;
            try (InputStream data = in.getInputStream(inEntry);){
                while ((num = data.read(buffer)) > 0) {
                    out.write(buffer, 0, num);
                    if (entryDataSink != null) {
                        entryDataSink.consume(buffer, 0, num);
                    }
                    offset += (long)num;
                }
            }
            out.flush();
            if (inspectEntryRequest == null) continue;
            inspectEntryRequest.done();
        }
        for (String name : remainingNames) {
            inEntry = in.getJarEntry(name);
            if (!SignApk.shouldOutputApkEntry(apkSigner, in, inEntry, buffer)) continue;
            outEntry = new JarEntry(name);
            outEntry.setTime(timestamp);
            out.putNextEntry(outEntry);
            ApkSignerEngine.InspectJarEntryRequest inspectEntryRequest = apkSigner != null ? apkSigner.outputJarEntry(name) : null;
            DataSink entryDataSink = inspectEntryRequest != null ? inspectEntryRequest.getDataSink() : null;
            InputStream data = in.getInputStream(inEntry);
            while ((num = data.read(buffer)) > 0) {
                out.write(buffer, 0, num);
                if (entryDataSink == null) continue;
                entryDataSink.consume(buffer, 0, num);
            }
            out.flush();
            if (inspectEntryRequest == null) continue;
            inspectEntryRequest.done();
        }
    }

    private static boolean shouldOutputApkEntry(ApkSignerEngine apkSigner, JarFile inFile, JarEntry inEntry, byte[] tmpbuf) throws IOException {
        if (apkSigner == null) {
            return true;
        }
        ApkSignerEngine.InputJarEntryInstructions instructions = apkSigner.inputJarEntry(inEntry.getName());
        ApkSignerEngine.InspectJarEntryRequest inspectEntryRequest = instructions.getInspectJarEntryRequest();
        if (inspectEntryRequest != null) {
            SignApk.provideJarEntry(inFile, inEntry, inspectEntryRequest, tmpbuf);
        }
        switch (instructions.getOutputPolicy()) {
            case OUTPUT: {
                return true;
            }
            case SKIP: 
            case OUTPUT_BY_ENGINE: {
                return false;
            }
        }
        throw new RuntimeException("Unsupported output policy: " + (Object)((Object)instructions.getOutputPolicy()));
    }

    private static void provideJarEntry(JarFile jarFile, JarEntry jarEntry, ApkSignerEngine.InspectJarEntryRequest request, byte[] tmpbuf) throws IOException {
        DataSink dataSink = request.getDataSink();
        try (InputStream in = jarFile.getInputStream(jarEntry);){
            int chunkSize;
            while ((chunkSize = in.read(tmpbuf)) > 0) {
                dataSink.consume(tmpbuf, 0, chunkSize);
            }
            request.done();
        }
    }

    private static int getStoredEntryDataAlignment(String entryName, int defaultAlignment) {
        if (defaultAlignment <= 0) {
            return 0;
        }
        if (entryName.endsWith(".so")) {
            return 4096;
        }
        return defaultAlignment;
    }

    private static void signWholeFile(JarFile inputJar, File publicKeyFile, X509Certificate publicKey, PrivateKey privateKey, int hash, long timestamp, OutputStream outputStream) throws Exception {
        CMSSigner cmsOut = new CMSSigner(inputJar, publicKeyFile, publicKey, privateKey, hash, timestamp, outputStream);
        ByteArrayOutputStream temp = new ByteArrayOutputStream();
        byte[] message = "signed by SignApk".getBytes(StandardCharsets.UTF_8);
        temp.write(message);
        temp.write(0);
        cmsOut.writeSignatureBlock(temp);
        byte[] zipData = cmsOut.getSigner().getTail();
        if (zipData[zipData.length - 22] != 80 || zipData[zipData.length - 21] != 75 || zipData[zipData.length - 20] != 5 || zipData[zipData.length - 19] != 6) {
            throw new IllegalArgumentException("zip data already has an archive comment");
        }
        int total_size = temp.size() + 6;
        if (total_size > 65535) {
            throw new IllegalArgumentException("signature is too big for ZIP file comment");
        }
        int signature_start = total_size - message.length - 1;
        temp.write(signature_start & 0xFF);
        temp.write(signature_start >> 8 & 0xFF);
        temp.write(255);
        temp.write(255);
        temp.write(total_size & 0xFF);
        temp.write(total_size >> 8 & 0xFF);
        temp.flush();
        byte[] b = temp.toByteArray();
        for (int i = 0; i < b.length - 3; ++i) {
            if (b[i] != 80 || b[i + 1] != 75 || b[i + 2] != 5 || b[i + 3] != 6) continue;
            throw new IllegalArgumentException("found spurious EOCD header at " + i);
        }
        outputStream.write(total_size & 0xFF);
        outputStream.write(total_size >> 8 & 0xFF);
        temp.writeTo(outputStream);
    }

    private static void loadProviderIfNecessary(String providerClassName) {
        Object o;
        Class<?> klass;
        if (providerClassName == null) {
            return;
        }
        try {
            ClassLoader sysLoader = ClassLoader.getSystemClassLoader();
            klass = sysLoader != null ? sysLoader.loadClass(providerClassName) : Class.forName(providerClassName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        Constructor<?> constructor = null;
        for (Constructor<?> c : klass.getConstructors()) {
            if (c.getParameterTypes().length != 0) continue;
            constructor = c;
            break;
        }
        if (constructor == null) {
            System.err.println("No zero-arg constructor found for " + providerClassName);
            System.exit(1);
            return;
        }
        try {
            o = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
            return;
        }
        if (!(o instanceof Provider)) {
            System.err.println("Not a Provider class: " + providerClassName);
            System.exit(1);
        }
        Security.insertProviderAt((Provider)o, 1);
    }

    private static List<DefaultApkSignerEngine.SignerConfig> createSignerConfigs(PrivateKey[] privateKeys, X509Certificate[] certificates) {
        if (privateKeys.length != certificates.length) {
            throw new IllegalArgumentException("The number of private keys must match the number of certificates: " + privateKeys.length + " vs" + certificates.length);
        }
        ArrayList<DefaultApkSignerEngine.SignerConfig> signerConfigs = new ArrayList<DefaultApkSignerEngine.SignerConfig>();
        String signerNameFormat = privateKeys.length == 1 ? "CERT" : "CERT%s";
        for (int i = 0; i < privateKeys.length; ++i) {
            String signerName = String.format(Locale.US, signerNameFormat, i + 1);
            DefaultApkSignerEngine.SignerConfig signerConfig = new DefaultApkSignerEngine.SignerConfig.Builder(signerName, privateKeys[i], Collections.singletonList(certificates[i])).build();
            signerConfigs.add(signerConfig);
        }
        return signerConfigs;
    }

    private static ZipSections findMainZipSections(ByteBuffer apk) throws IOException, ZipFormatException {
        apk.slice();
        ApkUtils.ZipSections sections = ApkUtils.findZipSections(DataSources.asDataSource(apk));
        long centralDirStartOffset = sections.getZipCentralDirectoryOffset();
        long centralDirSizeBytes = sections.getZipCentralDirectorySizeBytes();
        long centralDirEndOffset = centralDirStartOffset + centralDirSizeBytes;
        long eocdStartOffset = sections.getZipEndOfCentralDirectoryOffset();
        if (centralDirEndOffset != eocdStartOffset) {
            throw new ZipFormatException("ZIP Central Directory is not immediately followed by End of Central Directory. CD end: " + centralDirEndOffset + ", EoCD start: " + eocdStartOffset);
        }
        apk.position(0);
        apk.limit((int)centralDirStartOffset);
        ByteBuffer beforeCentralDir = apk.slice();
        apk.position((int)centralDirStartOffset);
        apk.limit((int)centralDirEndOffset);
        ByteBuffer centralDir = apk.slice();
        apk.position((int)eocdStartOffset);
        apk.limit(apk.capacity());
        ByteBuffer eocd = apk.slice();
        apk.position(0);
        apk.limit(apk.capacity());
        ZipSections result = new ZipSections();
        result.beforeCentralDir = beforeCentralDir;
        result.centralDir = centralDir;
        result.eocd = eocd;
        return result;
    }

    private static final int getMinSdkVersion(JarFile apk) throws MinSdkVersionException {
        byte[] manifestBytes;
        JarEntry manifestEntry = apk.getJarEntry("AndroidManifest.xml");
        if (manifestEntry == null) {
            throw new MinSdkVersionException("No AndroidManifest.xml in APK");
        }
        try (InputStream manifestIn = apk.getInputStream(manifestEntry);){
            manifestBytes = SignApk.toByteArray(manifestIn);
        }
        catch (IOException e) {
            throw new MinSdkVersionException("Failed to read AndroidManifest.xml", e);
        }
        return ApkUtils.getMinSdkVersionFromBinaryAndroidManifest(ByteBuffer.wrap(manifestBytes));
    }

    private static byte[] toByteArray(InputStream in) throws IOException {
        int chunkSize;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buf = new byte[65536];
        while ((chunkSize = in.read(buf)) != -1) {
            result.write(buf, 0, chunkSize);
        }
        return result.toByteArray();
    }

    private static void usage() {
        System.err.println("Usage: signapk [-w] [-a <alignment>] [-providerClass <className>] [--min-sdk-version <n>] [--disable-v2] publickey.x509[.pem] privatekey.pk8 [publickey2.x509[.pem] privatekey2.pk8 ...] input.jar output.jar");
        System.exit(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block45: {
            if (args.length < 4) {
                SignApk.usage();
            }
            Security.insertProviderAt(new OpenSSLProvider(), 1);
            Security.addProvider(new BouncyCastleProvider());
            boolean signWholeFile = false;
            String providerClass = null;
            int alignment = 4;
            Integer minSdkVersionOverride = null;
            boolean signUsingApkSignatureSchemeV2 = true;
            int argstart = 0;
            while (argstart < args.length && args[argstart].startsWith("-")) {
                if ("-w".equals(args[argstart])) {
                    signWholeFile = true;
                    ++argstart;
                    continue;
                }
                if ("-providerClass".equals(args[argstart])) {
                    if (argstart + 1 >= args.length) {
                        SignApk.usage();
                    }
                    providerClass = args[++argstart];
                    ++argstart;
                    continue;
                }
                if ("-a".equals(args[argstart])) {
                    alignment = Integer.parseInt(args[++argstart]);
                    ++argstart;
                    continue;
                }
                if ("--min-sdk-version".equals(args[argstart])) {
                    String minSdkVersionString = args[++argstart];
                    try {
                        minSdkVersionOverride = Integer.parseInt(minSdkVersionString);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("--min-sdk-version must be a decimal number: " + minSdkVersionString);
                    }
                    ++argstart;
                    continue;
                }
                if ("--disable-v2".equals(args[argstart])) {
                    signUsingApkSignatureSchemeV2 = false;
                    ++argstart;
                    continue;
                }
                SignApk.usage();
            }
            if ((args.length - argstart) % 2 == 1) {
                SignApk.usage();
            }
            int numKeys = (args.length - argstart) / 2 - 1;
            if (signWholeFile && numKeys > 1) {
                System.err.println("Only one key may be used with -w.");
                System.exit(2);
            }
            SignApk.loadProviderIfNecessary(providerClass);
            String inputFilename = args[args.length - 2];
            String outputFilename = args[args.length - 1];
            ZipFile inputJar = null;
            FileOutputStream outputFile = null;
            try {
                int minSdkVersion;
                File firstPublicKeyFile = new File(args[argstart + 0]);
                X509Certificate[] publicKey = new X509Certificate[numKeys];
                try {
                    for (int i = 0; i < numKeys; ++i) {
                        int argNum = argstart + i * 2;
                        publicKey[i] = SignApk.readPublicKey(new File(args[argNum]));
                    }
                }
                catch (IllegalArgumentException e) {
                    System.err.println(e);
                    System.exit(1);
                }
                long timestamp = 1230768000000L;
                timestamp -= (long)TimeZone.getDefault().getOffset(timestamp);
                PrivateKey[] privateKey = new PrivateKey[numKeys];
                for (int i = 0; i < numKeys; ++i) {
                    int argNum = argstart + i * 2 + 1;
                    privateKey[i] = SignApk.readPrivateKey(new File(args[argNum]));
                }
                inputJar = new JarFile(new File(inputFilename), false);
                outputFile = new FileOutputStream(outputFilename);
                if (signWholeFile) {
                    int digestAlgorithm = SignApk.getDigestAlgorithmForOta(publicKey[0]);
                    SignApk.signWholeFile((JarFile)inputJar, firstPublicKeyFile, publicKey[0], privateKey[0], digestAlgorithm, timestamp, outputFile);
                    break block45;
                }
                if (minSdkVersionOverride != null) {
                    minSdkVersion = minSdkVersionOverride;
                } else {
                    try {
                        minSdkVersion = SignApk.getMinSdkVersion((JarFile)inputJar);
                    }
                    catch (MinSdkVersionException e) {
                        throw new IllegalArgumentException("Cannot detect minSdkVersion. Use --min-sdk-version to override", e);
                    }
                }
                try (DefaultApkSignerEngine apkSigner = new DefaultApkSignerEngine.Builder(SignApk.createSignerConfigs(privateKey, publicKey), minSdkVersion).setV1SigningEnabled(true).setV2SigningEnabled(signUsingApkSignatureSchemeV2).setOtherSignersSignaturesPreserved(false).setCreatedBy("1.0 (Android SignApk)").build();){
                    apkSigner.inputApkSigningBlock(null);
                    ByteArrayOutputStream v1SignedApkBuf = new ByteArrayOutputStream();
                    JarOutputStream outputJar = new JarOutputStream(v1SignedApkBuf);
                    outputJar.setLevel(9);
                    SignApk.copyFiles((JarFile)inputJar, null, apkSigner, outputJar, timestamp, alignment);
                    ApkSignerEngine.OutputJarSignatureRequest addV1SignatureRequest = apkSigner.outputJarEntries();
                    if (addV1SignatureRequest != null) {
                        SignApk.addV1Signature(apkSigner, addV1SignatureRequest, outputJar, timestamp);
                        addV1SignatureRequest.done();
                    }
                    outputJar.close();
                    ByteBuffer v1SignedApk = ByteBuffer.wrap(v1SignedApkBuf.toByteArray());
                    v1SignedApkBuf.reset();
                    ByteBuffer[] outputChunks = new ByteBuffer[]{v1SignedApk};
                    ZipSections zipSections = SignApk.findMainZipSections(v1SignedApk);
                    ApkSignerEngine.OutputApkSigningBlockRequest2 addV2SignatureRequest = apkSigner.outputZipSections2(DataSources.asDataSource(zipSections.beforeCentralDir), DataSources.asDataSource(zipSections.centralDir), DataSources.asDataSource(zipSections.eocd));
                    if (addV2SignatureRequest != null) {
                        int padding = addV2SignatureRequest.getPaddingSizeBeforeApkSigningBlock();
                        byte[] apkSigningBlock = addV2SignatureRequest.getApkSigningBlock();
                        ByteBuffer modifiedEocd = ByteBuffer.allocate(zipSections.eocd.remaining());
                        modifiedEocd.put(zipSections.eocd);
                        modifiedEocd.flip();
                        modifiedEocd.order(ByteOrder.LITTLE_ENDIAN);
                        ApkUtils.setZipEocdCentralDirectoryOffset(modifiedEocd, zipSections.beforeCentralDir.remaining() + padding + apkSigningBlock.length);
                        outputChunks = new ByteBuffer[]{zipSections.beforeCentralDir, ByteBuffer.allocate(padding), ByteBuffer.wrap(apkSigningBlock), zipSections.centralDir, modifiedEocd};
                        addV2SignatureRequest.done();
                    }
                    for (ByteBuffer outputChunk : outputChunks) {
                        outputFile.write(outputChunk.array(), outputChunk.arrayOffset() + outputChunk.position(), outputChunk.remaining());
                        outputChunk.position(outputChunk.limit());
                    }
                    outputFile.close();
                    outputFile = null;
                    apkSigner.outputDone();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            finally {
                try {
                    if (inputJar != null) {
                        inputJar.close();
                    }
                    if (outputFile != null) {
                        outputFile.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    private static class ZipSections {
        ByteBuffer beforeCentralDir;
        ByteBuffer centralDir;
        ByteBuffer eocd;

        private ZipSections() {
        }
    }

    private static class CMSSigner
    implements CMSTypedData {
        private final JarFile inputJar;
        private final File publicKeyFile;
        private final X509Certificate publicKey;
        private final PrivateKey privateKey;
        private final int hash;
        private final long timestamp;
        private final OutputStream outputStream;
        private final ASN1ObjectIdentifier type;
        private WholeFileSignerOutputStream signer;
        private static final Pattern STRIP_PATTERN = Pattern.compile("^(META-INF/((.*)[.](SF|RSA|DSA|EC)|com/android/otacert))|(" + Pattern.quote("META-INF/MANIFEST.MF") + ")$");

        public CMSSigner(JarFile inputJar, File publicKeyFile, X509Certificate publicKey, PrivateKey privateKey, int hash, long timestamp, OutputStream outputStream) {
            this.inputJar = inputJar;
            this.publicKeyFile = publicKeyFile;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            this.hash = hash;
            this.timestamp = timestamp;
            this.outputStream = outputStream;
            this.type = new ASN1ObjectIdentifier(CMSObjectIdentifiers.data.getId());
        }

        @Override
        public Object getContent() {
            return this;
        }

        @Override
        public ASN1ObjectIdentifier getContentType() {
            return this.type;
        }

        @Override
        public void write(OutputStream out) throws IOException {
            try {
                this.signer = new WholeFileSignerOutputStream(out, this.outputStream);
                JarOutputStream outputJar = new JarOutputStream(this.signer);
                SignApk.copyFiles(this.inputJar, CMSSigner.STRIP_PATTERN, null, outputJar, this.timestamp, 0);
                SignApk.addOtacert(outputJar, this.publicKeyFile, this.timestamp);
                this.signer.notifyClosing();
                outputJar.close();
                this.signer.finish();
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }

        public void writeSignatureBlock(ByteArrayOutputStream temp) throws IOException, CertificateEncodingException, OperatorCreationException, CMSException {
            SignApk.writeSignatureBlock(this, this.publicKey, this.privateKey, this.hash, temp);
        }

        public WholeFileSignerOutputStream getSigner() {
            return this.signer;
        }
    }

    private static class WholeFileSignerOutputStream
    extends FilterOutputStream {
        private boolean closing = false;
        private ByteArrayOutputStream footer = new ByteArrayOutputStream();
        private OutputStream tee;

        public WholeFileSignerOutputStream(OutputStream out, OutputStream tee) {
            super(out);
            this.tee = tee;
        }

        public void notifyClosing() {
            this.closing = true;
        }

        public void finish() throws IOException {
            this.closing = false;
            byte[] data = this.footer.toByteArray();
            if (data.length < 2) {
                throw new IOException("Less than two bytes written to footer");
            }
            this.write(data, 0, data.length - 2);
        }

        public byte[] getTail() {
            return this.footer.toByteArray();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.closing) {
                this.footer.write(b, off, len);
            } else {
                this.out.write(b, off, len);
                this.tee.write(b, off, len);
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.closing) {
                this.footer.write(b);
            } else {
                this.out.write(b);
                this.tee.write(b);
            }
        }
    }
}

