#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/gpio.h>
#include <linux/of.h>
#include <linux/of_gpio.h>
#include <linux/kobject.h>
#include <linux/platform_device.h>
#include <linux/device.h> 
#include <linux/string.h> 
#include <linux/sysfs.h> 
#include <linux/stat.h> 
#include <linux/slab.h>

#include "../pinctrl/mediatek/pinctrl-mtk-common-v2_debug.h"
#include "../pinctrl/mediatek/pinctrl-mtk-common-v2.h"

#define GPIO_NODE_NUM 15
#define LOG_SIZE 8192
#define ERROR_SIZE 1024 

struct gpio_node{
    int gpio_num;
	int gpio_mode;
	int gpio_dir;
	int gpio_dout;
	int gpio_din;
};

//struct gpio_node *gpio_test;

struct mtk_pinctrl *hw = NULL;
const struct mtk_pin_desc *desc = NULL;

struct kobject kobj;
struct kobject kobj_log;
int node_num = 0;
struct gpio_node gpio_node_list[GPIO_NODE_NUM];

char log_info[LOG_SIZE];
int log_offset = 0;
char error_info[ERROR_SIZE];
int error_offset = 0;
 
ssize_t kobj_test_show(struct kobject *kobject, struct attribute *attr,char *buf);
ssize_t kobj_log_show(struct kobject *kobject, struct attribute *attr,char *buf);
int set_gpio(struct device_node *gpio_node, int num);

struct attribute gpio_attr = { 
	.name = "gpio_init", 
	.mode = S_IRUGO, 
}; 
struct attribute gpio_attr_log = { 
	.name = "gpio_init_log", 
	.mode = S_IRUGO, 
}; 
static struct attribute *def_attrs[] = { 
	&gpio_attr, 
	NULL, 
}; 
static struct attribute *def_attrs_log[] = { 
	&gpio_attr_log, 
	NULL, 
}; 

struct sysfs_ops obj_test_sysops = 
{ 
	.show = kobj_test_show, 
}; 
 
struct sysfs_ops gpio_log_sysops = 
{ 
	.show = kobj_log_show, 
}; 
 
struct kobj_type ktype =  
{ 
	.sysfs_ops=&obj_test_sysops, 
	.default_attrs=def_attrs, 
};
 
struct kobj_type ktype_log =  
{ 
	.sysfs_ops=&gpio_log_sysops, 
	.default_attrs=def_attrs_log, 
};
 
/*cat /sys/lynq_gpio/gpio_init*/ 
ssize_t kobj_test_show(struct kobject *kobject, struct attribute *attr,char *buf)
{
    int show;
    int i;
	printk("gpio config show.\n"); 
	printk("attrname:%s, node_num: %d.\n", attr->name, node_num); 
	show = sprintf(buf,"%s, node_num: %d\n",attr->name, node_num);
    show += sprintf(buf + show, "%s", error_info);
    show += sprintf(buf + show, "NUM\tMODE\tDIR\tDOUT\tDIN\n");
    for(i = 0; i < node_num; i++)
    {
        show += sprintf(buf + show, "%d\t%d\t%d\t%d\t%d\n", gpio_node_list[i].gpio_num, gpio_node_list[i].gpio_mode, gpio_node_list[i].gpio_dir, gpio_node_list[i].gpio_dout, gpio_node_list[i].gpio_din);
        printk("%d\t%d\t%d\t%d\t%d\n", gpio_node_list[i].gpio_num, gpio_node_list[i].gpio_mode, gpio_node_list[i].gpio_dir, gpio_node_list[i].gpio_dout, gpio_node_list[i].gpio_din);
    }
    return strlen(buf);
}
/*cat /sys/lynq_log/gpio_init_log*/
ssize_t kobj_log_show(struct kobject *kobject, struct attribute *attr,char *buf)
{
	printk("gpio init log show.\n"); 
    sprintf(buf,"SHOW LOG\n%s", log_info);
    return strlen(buf);
}
int set_gpio(struct device_node *gpio_node, int num)
{
    int ret = 0;
    unsigned int gpio_num, gpio_mode, gpio_dir, gpio_dout, gpio_din;
    int read_mode = -1;

    gpio_node_list[num].gpio_num = -1;
    gpio_node_list[num].gpio_mode = -1;
    gpio_node_list[num].gpio_dir = -1;
    gpio_node_list[num].gpio_din = -1;
    gpio_node_list[num].gpio_dout = -1;

    //get the gpio hw
    ret = of_property_read_u32(gpio_node, "gpio_num", &gpio_num);
    if(ret == -EINVAL || ret == -ENODATA)
    {
        printk("no value or no node");
        log_offset += sprintf(log_info + log_offset,"No gpio num\n");
        return 0;
    }
    else if(ret < 0)
    {
        printk("GPIO_INIT:READ ERROR: %d", ret);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: read num ERROR: %d\n", ret);
        return ret;
    }

    gpio_node_list[num].gpio_num = (int)gpio_num;
    printk("GPIO_INIT: the gpio_num is %u", gpio_num);
    log_offset += sprintf(log_info + log_offset, "GPIO_INIT: the gpio_num is %u\n", gpio_num);

    hw = mtk_gpio_find_mtk_pinctrl_dev_hw();
    if(hw == NULL)
    {
        printk("GPIO_INIT: GET HW ERROR!");
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: can not find this gpiochip!\n");
        return -1;
    }
	if (gpio_num > hw->soc->npins)
    {
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: ERROR: over the max gpio num!\n");
        error_offset += sprintf(error_info + error_offset, "GPIO_INIT: ERROR: over the max gpio num!\n");
        return -1;
    }
    desc = (const struct mtk_pin_desc *)&hw->soc->pins[gpio_num];
    //end of get gpio hw   

//set gpio mode
    ret = of_property_read_u32(gpio_node, "gpio_mode", &gpio_mode);
    if(ret == -EINVAL || ret == -ENODATA)
    {
        printk("no value or no node");
        log_offset += sprintf(log_info + log_offset, "no value or no node\n");
    }
    else if(ret < 0)
    {
        printk("GPIO_INIT:READ ERROR: %d", ret);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: read num ERROR: %d\n", ret);
        return ret;
    }
    else
    {
        gpio_node_list[num].gpio_mode = (int)gpio_mode;
        printk("GPIO_INIT: the gpio_mode is %u", gpio_mode);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: the gpio_mode is %u\n", gpio_mode);
        if(gpio_mode >= 0 && gpio_mode <= 7)
        {
            ret = mtk_hw_set_value(hw, desc, PINCTRL_PIN_REG_MODE, gpio_mode);
            if(ret == 0)
            {
                ret = mtk_hw_get_value(hw, desc, PINCTRL_PIN_REG_MODE, &read_mode);
                log_offset += sprintf(log_info + log_offset, "GPIO_INIT: Mode SET %d\n", read_mode);
                printk("GPIO_INIT: modify successfully"); 
            }
            else
            {
                printk("GPIO_INIT: SET REEOR %d", ret);
                log_offset += sprintf(log_info + log_offset, "GPIO_INIT: SET REEOR %d\n", ret);
                return ret;
            }
        }
        else
        {
            log_offset += sprintf(log_info + log_offset, "GPIO_INIT: mode: %u out of the range 0-7\n", gpio_mode);
            error_offset += sprintf(error_info + error_offset, "GPIO_INIT: mode: %u out of the range 0-7\n", gpio_mode);
        }
    }
//set gpio dir
    ret = of_property_read_u32(gpio_node, "gpio_dir", &gpio_dir);
    if(ret == -EINVAL || ret == -ENODATA)
    {
        printk("no value or no node");
        log_offset += sprintf(log_info + log_offset, "no value or no node\n");
    }
    else if(ret < 0)
    {
        printk("GPIO_INIT:READ ERROR: %d", ret);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: read num ERROR: %d\n", ret);
        return ret;
    }
    else
    {
        gpio_node_list[num].gpio_dir = (int)gpio_dir;
        printk("GPIO_INIT: the gpio_dir is %u", gpio_dir);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: the gpio_dir is %u\n", gpio_dir);
        if(gpio_dir == 0 || gpio_dir == 1)
        {
            ret = mtk_hw_set_value(hw, desc, PINCTRL_PIN_REG_DIR, gpio_dir);
            if(ret == 0)
            {
                printk("GPIO_INIT: modify successfully"); 
            }
            else
            {
                printk("GPIO_INIT: SET REEOR %d", ret);
                log_offset += sprintf(log_info + log_offset, "GPIO_INIT: SET REEOR %d\n", ret);
                return ret;
            }
        }
        else
        {
            log_offset += sprintf(log_info + log_offset, "GPIO_INIT: dir: %u out of the range 0-1\n", gpio_dir);
            error_offset += sprintf(error_info + error_offset, "GPIO_INIT: dir: %u out of the range 0-1\n", gpio_dir);
        }
	    
    }    
//set gpio dout
    ret = of_property_read_u32(gpio_node, "gpio_dout", &gpio_dout);
    if(ret == -EINVAL || ret == -ENODATA)
    {
        printk("no value or no node");
        log_offset += sprintf(log_info + log_offset, "no value or no node\n");
    }
    else if(ret < 0)
    {
        printk("GPIO_INIT:READ ERROR: %d", ret);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: read num ERROR: %d\n", ret);
        return ret;
    }
    else
    {
        gpio_node_list[num].gpio_dout = (int)gpio_dout;
        printk("GPIO_INIT: the gpio_dout is %u", gpio_dout);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: the gpio_dout is %u\n", gpio_dout);
        if(gpio_dout == 0 || gpio_dout == 1)
        {
            ret = mtk_hw_set_value(hw, desc, PINCTRL_PIN_REG_DO, gpio_dout);
            if(ret == 0)
            {
                printk("GPIO_INIT: modify successfully"); 
            }
            else
            {
                printk("GPIO_INIT: SET REEOR %d", ret);
                log_offset += sprintf(log_info + log_offset, "GPIO_INIT: SET REEOR %d\n", ret);
                return ret;
            }
        }
        else
        {
            log_offset += sprintf(log_info + log_offset, "GPIO_INIT: dout: %u out of the range 0-1\n", gpio_dout);
            error_offset += sprintf(error_info + error_offset, "GPIO_INIT: dout: %u out of the range 0-1\n", gpio_dout);
        }
    }
//set gpio din
    ret = of_property_read_u32(gpio_node, "gpio_din", &gpio_din);
    if(ret == -EINVAL || ret == -ENODATA)
    {
        printk("no value or no node");
        log_offset += sprintf(log_info + log_offset, "no value or no node\n");
    }
    else if(ret < 0)
    {
        printk("GPIO_INIT:READ ERROR: %d", ret);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: read num ERROR: %d\n", ret);
        return ret;
    }
    else
    {
        gpio_node_list[num].gpio_din = (int)gpio_din;
        printk("GPIO_INIT: the gpio_din is %u", gpio_din);
        log_offset += sprintf(log_info + log_offset, "GPIO_INIT: the gpio_din is %u\n", gpio_din);
        if(gpio_din == 0 || gpio_din == 1)
        {
            ret = mtk_hw_set_value(hw, desc, PINCTRL_PIN_REG_DI, gpio_din);
            if(ret == 0)
            {
                printk("GPIO_INIT: modify successfully"); 
            }
            else
            {
                printk("GPIO_INIT: SET REEOR %d", ret);
                log_offset += sprintf(log_info + log_offset, "GPIO_INIT: SET REEOR %d\n", ret);
                return ret;
            }
        }
        else
        {
            log_offset += sprintf(log_info + log_offset, "GPIO_INIT: din: %u out of the range 0-1\n", gpio_din);
            error_offset += sprintf(error_info + error_offset, "GPIO_INIT: din: %u out of the range 0-1\n", gpio_din);
        }
    }
    return ret;
}
