#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/of.h>
#include <linux/fs.h>
#include <linux/platform_device.h>
#include <asm/uaccess.h>
#include "lynq_bootctrl.h"
#include <linux/string.h> 
#include <linux/slab.h>
#include <linux/mtd/mtd.h>

int bootctrl_read_metadata(AvbABData *bctrl);
int bootctrl_write_metadata(AvbABData *bctrl);

const char *mtd_name = "misc";
int current_slot = -1;
int current_slot_init = 0;

int bootctrl_write_metadata(AvbABData *bctrl)
{
    int err;
    ssize_t sz, size;
    char *buf = (char *)bctrl;
    struct mtd_info *mtd = NULL;
    loff_t pos = OFFSETOF_SLOT_SUFFIX;

    if(bctrl == NULL)
    {
        printk("ERROR: null pointer");
        return -1;
    }
    err = IS_ERR(bctrl);
    if(err != 0)
    {
        printk("ERROR: pointer: %d.", err);
        return err;
    }
    mtd = get_mtd_device_nm(mtd_name);
    err = IS_ERR(mtd);
    if(err != 0)
    {
        printk("ERROR: pointer: %d.", err);
        return err;
    }

    size = sizeof(AvbABData);

    do {
        err = mtd_write(mtd, pos, size, &sz, buf);

        if (err == 0) 
        {
            break;
        }
        else if (err < 0)
        {
            printk("Error Writing metadata file\n");
            return err;
        }
        size -= sz;
        buf += sz;
    } while(size > 0);
    printk("BOOTCTRL:write new info to metadata\n");
    return 0;
}

int bootctrl_get_active_slot(void)
{
    int slot = 0, ret = -1;
    AvbABData metadata;

    ret = bootctrl_read_metadata(&metadata);
    if(ret < 0)
    {
        printk("BOOTCTRL:read metadata error: %d", ret);
    }
    slot = (metadata.slots[0].priority >= metadata.slots[1].priority) ? 0 : 1;
    printk("the slot is %d", slot);
    return slot;
}
EXPORT_SYMBOL(bootctrl_get_active_slot);

int bootctrl_read_metadata(AvbABData *bctrl)
{
    int ret, err;
    loff_t pos = OFFSETOF_SLOT_SUFFIX;
    size_t sz, size;
    char *buf = (char *)bctrl;
    struct mtd_info *mtd = NULL;

    if(bctrl == NULL)
    {
        printk("ERROR: null pointer");
        return -1;
    }
    err = IS_ERR(bctrl);
    if(err != 0)
    {
        printk("ERROR: pointer: %d.", err);
        printk("error: %ld", PTR_ERR(mtd));
        return err;
    }
    mtd = get_mtd_device_nm(mtd_name);
    ret = IS_ERR(mtd);
    if(ret != 0)
    {
        printk("ERROR: pointer: %d.", ret);
        printk("error: %ld", PTR_ERR(mtd));
        return ret;
    }

    size = sizeof(AvbABData);
    do {
        ret = mtd_read(mtd, pos, size, &sz, buf);
        if (sz == 0)
        {
            break;
        }
        else if (sz < 0)
        {
            printk("BOOTCTRL:Error reading metadata file: %ld\n", sz);
            return sz;
        }
        size -= sz;
        buf += sz;
    } while(size > 0);

    /* Check bootctrl magic number */
    if (memcmp(bctrl->magic , AVB_AB_MAGIC, AVB_AB_MAGIC_LEN) != 0)
    {
        printk("BOOTCTRL:metadata is not initialised or corrupted %s.\n", bctrl->magic);
        return -EIO;
    }
    return 0;
}
EXPORT_SYMBOL(bootctrl_read_metadata);

int bootctrl_mark_boot_unsuccessful(void)
{
    int ret;
    int slot = 0;
    AvbABData metadata;
    AvbABSlotData *slotp;

    if(current_slot_init != 1)
    {
        printk("BOOTCTRL: current slot has not been init");
        return 0;
    }
    printk("BOOTCTRL:boot control bootctrl_mark_boot_unsuccessful\n");
    ret = bootctrl_read_metadata(&metadata);
    if (ret < 0) 
    {
        printk("BOOTCTRL: read metadata error");
        return ret;
    }

    slot = current_slot;

    slotp = &metadata.slots[slot];
    printk("BOOTCTRL: currentslot = %d, retry time = %u",slot, slotp->tries_remaining);
    slotp->successful_boot = 0;

    return bootctrl_write_metadata(&metadata);
}
EXPORT_SYMBOL(bootctrl_mark_boot_unsuccessful);

static int __init drv_init(void)
{
    printk("BOOTCTRL: get current slot");
    current_slot = bootctrl_get_active_slot();
    if (current_slot < 0)
    {
        printk("bootctrl_get_active_slot fail , slot = %d\n", current_slot);
        return current_slot;
    }
    current_slot_init = 1;
    return 0;
}

module_init(drv_init);
MODULE_AUTHOR("Mobiletek");
MODULE_DESCRIPTION("driver for bootctrl");
MODULE_LICENSE("GPL");

