#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/stat.h>
#include<sys/types.h>
#include <errno.h>

#include "liblog/lynq_deflog.h"
#include "include/iot_rock.h"

#define USER_LOG_TAG "LOGROTATE_SERVICE"
#define MCU_LOG_ADDR "/var/log/mculog.log"

int lynq_write_mculog_file(char *mculog_data, int mculog_data_len)//lt add @2021.7.28 for write mcu log to /var/log/cmulog.log
{
    int fd, err;
    int write_len = 0;
    fd = open(MCU_LOG_ADDR,O_WRONLY |O_CREAT |O_APPEND,S_IRWXU);
    if(fd < 0)
    {
        return fd;
    }
	
    do {
        write_len = write(fd,mculog_data,mculog_data_len);
        if (write_len == 0) 
        {
            break;
        } 
        else if (write_len < 0) 
        {
            if (errno == EINTR) 
            {
                continue;
            }
            err = -errno;
            close(fd);
            return err;
        }
        mculog_data_len -= write_len;
        mculog_data += write_len;
    } while(mculog_data_len > 0);

    close(fd);
    return write_len;   
}

/**
 * @brief check syslogd exist or no
 * 
 * @param void 
 * @return 0:exist -1:no
 */
static int lynq_check_syslogd(void)
{
    FILE *fp;
    char *lynq_get_syslogd_cmd = "ps -ef | grep syslogd";
    char lynq_syslogd_deploy_buf[128] ={0};
    char *lynq_syslogd_deploy_raw = "/sbin/syslogd";
    
    fp=popen(lynq_get_syslogd_cmd,"r");
    if(NULL == fp)
    {
        return -1;
    }
    while (NULL != fgets(lynq_syslogd_deploy_buf,sizeof(lynq_syslogd_deploy_buf),fp))
    {
        printf("syslogd:%s\n",lynq_syslogd_deploy_buf);
        if(NULL != strstr(lynq_syslogd_deploy_buf,lynq_syslogd_deploy_raw))
        {
            pclose(fp);
            return 0;
        }
    }
    pclose(fp);
    return -1;
}

/**
 * @brief monitor syslogcof
 * 
 * @param void 
 * @return 0:success -1:fail
 */
static int lynq_monitor_syslogcof(void)
{
    FILE *fp;
    char *lynq_get_syslog_deploy = "/etc/syslog/syslog.conf";
    char lynq_syslog_deploy_buf[128] ={0};
    char *lynq_syslog_deploy_raw = "/var/log/syslog.log";
    
    fp=fopen(lynq_get_syslog_deploy,"r");
    if(NULL == fp)
    {
        return -1;
    }
    if((sizeof(lynq_syslog_deploy_buf)) > (fread(lynq_syslog_deploy_buf,sizeof(char),sizeof(lynq_syslog_deploy_buf),fp)))
    {
        if(ferror(fp))
        {
            fclose(fp);
            return -1;
        }
        printf("syslog:%s\n",lynq_syslog_deploy_buf);
    }
    fclose(fp);

    if(NULL == strstr(lynq_syslog_deploy_buf,lynq_syslog_deploy_raw))
    {
        system("cp /bin/syslog.conf /etc/syslog/");
        system("syslogctl restart");
        for(int j = 0; j < 3; j++) //Check whether syslogd exists and does not exist 3 times
        {
            if(-1 == lynq_check_syslogd())
            {
                system("syslogctl restart");
                printf("syslogctl restart again\n");
            }
            else
            {
                printf("syslogctl restart success\n");
                return 0;
            }
        }
        return -1;
    }
    return 0;
}

int main()
{
    char muclog[1024] = {0};
    LYLOGEINIT(USER_LOG_TAG);
    LYLOGSET(4);
    if(-1 == lynq_monitor_syslogcof())
    {
        printf("lynq monitor syslogcof popen fail\n");
    }
    system("/usr/bin/lynq-default");
    system("systemctl stop ntpd");

    if(access("/etc/firmware/catcher_filter_5_SuperSlim.bin",0) && access("/data_backup/catcher_filter_5_SuperSlim.bin",0) == 0 )    
    {
           system("cp /data_backup/catcher_filter_5_SuperSlim.bin /etc/firmware/catcher_filter_5_SuperSlim.bin");
           sleep(2);
           system("killall emdlogger1");
           sleep(2);         
    }

    lynq_fota_func();
//    while(1)
//    {
        //receive mcu log
        //memset(muclog,1,1024);
        //lynq_write_mculog_file(muclog,1024);//lt add @2021.7.28 for test mculog

        //system("logrotate /etc/logrotate.d/syslog");
        //system("logrotate /etc/logrotate.d/mculog");//lt add @2021.7.28 for start mculog logrotate
        //system("logrotate /etc/logrotate.d/mtklog");//lt add @2021.7.28 for start mculog mtklog
        //sleep(1);
//    }
}

