/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SSLP_COMMANDS_COMMANDBODY_H_
#define SSLP_COMMANDS_COMMANDBODY_H_

#include <cstdint>
#include <string>
#include <vector>
#include <memory>

#include "../ecall/EcallUtils.h"
#include "CmdUtils.h"

//p39, table 30
class CommandBody {
public:
    CommandBody();
    virtual ~CommandBody();
    int decodeCmdDt();
    std::uint8_t getAct() const;
    void setAct(std::uint8_t act);
    std::uint16_t getAdr() const;
    void setAdr(std::uint16_t adr);
    std::uint16_t getCcd() const;
    void setCcd(std::uint16_t ccd);
    const std::string& getDt() const;
    void setDt(const std::string dt);
    std::uint8_t getSz() const;
    void setSz(std::uint8_t sz);
    std::uint8_t getSzAct() const;
    void setSzAct(std::uint8_t szAct);
    bool isIncludedCmdCode(std::uint16_t cmd);
    bool isNeedNewSms();
    int getEcallReqPara();
private:
    std::shared_ptr<CmdUtils> deCmdUtils;
    std::shared_ptr<EcallUtils> deEcallUtils;

    std::uint16_t ADR;

    //8bit
    std::uint8_t SzAct;
    std::uint8_t SZ; //4bit
    std::uint8_t ACT; //4bit

    std::uint16_t CCD;
    std::string DT;  //O
    //std::vector<std::uint8_t> DT; //O

    //ACT(action)
    static constexpr std::uint8_t COMMAND_PARA = 0;
    static constexpr std::uint8_t QUERY_VALUE = 1;
    static constexpr std::uint8_t SET_VALUE = 2;
    static constexpr std::uint8_t ADD_NEW_PARA = 3;
    static constexpr std::uint8_t REMOVE_EXIST_PARA = 4;
};

#endif /* SSLP_COMMANDS_COMMANDBODY_H_ */
