//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include  "common.h"
#include "em/em.h"
#include "Radio_capability_switch_util.h"
#include "WorldPhoneUtil.h"
#include "../util/AtLine.h"
#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_HSPA"

char *hspa_info_mode_array_td[] = {
    "HSDPA off\n",
    "HSDPA on\nHSUPA off\n",
    "HSDPA on\nHSUPA on\n",
    "HSDPA on\nHSUPA on\n",
};

char *hspa_info_mode_array_fd[] = {
    "HSDPA off\n",
    "HSDPA on\nHSUPA off\n",
    "HSDPA on\nHSUPA on\nHSPA+ off\n",
    "HSDPA on\nHSUPA on\nHSPA+ on\n",
};

char *ca_info_state_array[] = {
    "0 CA_CONFIGURED: NW configure CA\n",
    "1 CA_NOT_CONFIGURED: NW remove CA configuration or CA configured is invalid\n",
    "2 CA_ACTIVATED: Lower layer use CA to transfer data\n",
    "3 CA_DEACTIVATED: Lower layer does not use CA to transfer data\n",
};

const int EVENT_HSPA_INFO = 1;
//const int EVENT_DC_HSPA_INFO = 2;
const int EVENT_SET_HSPA = 3;
const int EVENT_CA_INFO = 4;

#define HSPA_QUERY_CMD "AT+EHSM?"
#define HSPA_SET_CMD "AT+EHSM="
#define HSPA_RESPONSE_CMD "+EHSM:"
int mCurrentFlag = 0;
int hspamode = 0;
int intput_index = 0;

#define ECAINFO_QUERY_CMD "AT+ECAINFO?"
#define ECAINFO_RESPONSE_CMD "+ECAINFO:"

void  sendATCommand_ehspa(const char *cmd,int msg)
{
    mCurrentFlag = msg;
    emSendATCommand(cmd, Radio_capability_switch_util::get_main_capability_phone_id());
    return ;
}

void showHspa(int mode) {
    std::string str;
    RLOGD("showHspa, mode=%d", mode);

    if (mode < 0 || mode >= 4) {
        RLOGD("Modem return invalid mode: %d", mode);
        android::emResultNotify(RET_STRING_HSPA_FAIL);
        return;
    }
    if (WorldPhoneUtil::getModemType() == WorldPhoneUtil::MODEM_TD) {
        str = hspa_info_mode_array_td[mode];
    } else {
        str = hspa_info_mode_array_fd[mode];
    }
    str += "\ndone\n";
    android::emResultNotify(str.c_str());
}

void parseHspaAtCmd(const char* line) {
    if (strstr(line, HSPA_RESPONSE_CMD) != NULL) {
        AtLine* atLine = new AtLine(line, NULL);
        int err;
        atLine->atTokStart(&err);
        if (err < 0) {
            RLOGW("this is not a valid response string");
            delete atLine;
            return;
        }
        int mode = atLine->atTokNextint(&err);
        if (err < 0) {
            RLOGW("parse rat fail");
            delete atLine;
            return;
        }
        showHspa(mode);
        delete atLine;
    }
}

void parseCAInfoAtCmd(const char* line) {
    AtLine* atLine = new AtLine(line, NULL);
    int err, ca_info, pcell_bw, scell_bw1, scell_bw2, scell_bw3, scell_bw4;
    char cainfo_str[1024] = {0};

    atLine->atTokStart(&err);
    if (err < 0) {
        RLOGW("this is not a valid response string");
        goto invalid;
    }

    //+ECAINFO: <ca_info>,<pcell_bw>,<scell_bw1>, <scell_bw2>,<scell_bw3>,<scell_bw4>
    ca_info = atLine->atTokNextint(&err);
    if (err < 0) {
        RLOGW("parse ca_info fail");
        goto invalid;
    }
    if (ca_info < 0 || ca_info >= 4) {
        RLOGW("ca_info return invalid state: %d", ca_info);
        goto invalid;
    }
    pcell_bw = atLine->atTokNextint(&err);
    if (err < 0) {
        RLOGW("parse pcell_bw fail");
        goto invalid;
    }
    scell_bw1 = atLine->atTokNextint(&err);
    if (err < 0) {
        RLOGW("parse scell_bw1 fail");
        goto invalid;
    }
    scell_bw2 = atLine->atTokNextint(&err);
    if (err < 0) {
        RLOGW("parse scell_bw2 fail");
        goto invalid;
    }
    scell_bw3 = atLine->atTokNextint(&err);
    if (err < 0) {
        RLOGW("parse scell_bw3 fail");
        goto invalid;
    }
    scell_bw4= atLine->atTokNextint(&err);
    if (err < 0) {
        RLOGW("parse scell_bw4 fail");
        goto invalid;
    }

    sprintf(cainfo_str, "\n%s\npcell_bw=%d\nscell_bw1=%d\nscell_bw2=%d\nscell_bw3=%d\nscell_bw4=%d\ndone\n",
            ca_info_state_array[ca_info], pcell_bw, scell_bw1, scell_bw2, scell_bw3, scell_bw4);
    android::emResultNotify(cainfo_str);
    delete atLine;
    return;

invalid:
    android::emResultNotify(RET_STRING_HSPA_FAIL);
    delete atLine;
}


void emAtCmdHandle(char*response, int responselen) {
    switch (mCurrentFlag) {
        case EVENT_HSPA_INFO:
        {
            //parse hspa mode.
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("EVENT_HSPA_INFO response: %s\n",response);
                parseHspaAtCmd(response);
            }
            else {
                android::emResultNotify(RET_STRING_HSPA_FAIL);
                RLOGD("send fail ");
            }
            break;
        }
        case EVENT_SET_HSPA:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("EVENT_SET_HSPA success: %s.\n",response);
            }
            else {
                RLOGD("send fail ");
            }
            break;
        }
        case EVENT_CA_INFO:
        {
            if ((responselen > 0) && (response != NULL)) {
                RLOGD("+ECAINFO response: %s\n",response);
                parseCAInfoAtCmd(response);
            }
            else {
                android::emResultNotify(RET_STRING_HSPA_FAIL);
                RLOGD("send fail ");
            }
        }
        default:
            break;
    }
}


//create thread to send command
void * emHspaThread(void* arg)
{
    // HSPA
    if (intput_index == 0) {
        RLOGD("emHspaThread, query HSPA");

        //char cmd_str[32] = {0};
        //sprintf(cmd_str,"%s%d,0", HSPA_SET_CMD,hspamode);
        //sendATCommand_ehspa(cmd_str,EVENT_SET_HSPA);
        sendATCommand_ehspa(HSPA_QUERY_CMD,EVENT_HSPA_INFO);
        //android::unregisterNetwork();
        //android::emResultNotify(RET_STRING_HSPA_SUCCESS);

    // Send AT+ECAINFO
    } else if (intput_index == 1) {
        RLOGD("emHspaThread, query CA information");
        sendATCommand_ehspa(ECAINFO_QUERY_CMD, EVENT_CA_INFO);
    }

    pthread_exit(0);
}

int emHspaStart(int argc, int *item)
{
    RLOGD("emHspaStart called");
    if(argc < 1)
    {
        RLOGD("emHspaStart: please select mode to test: \
                0: off, 2: on");
        android::emResultNotify(RET_STRING_HSPA_FAIL);
        return -1;
    }

    intput_index = item[0];
    RLOGD("emHspaStart, intput_index=%d", intput_index);
    if((intput_index > 1 ) || (intput_index < 0)){
        RLOGD("emHspaStart: invalid parameter %d", intput_index);
        android::emResultNotify(RET_STRING_HSPA_FAIL);
        return -1;
    }

    //int modemapping[2] = {0,2};
    mCurrentFlag = 0;
    //hspamode = modemapping[item[0]];
    android::registerForATcmdResponse(emAtCmdHandle);
    pthread_t emhspa_thread;
    pthread_create(&emhspa_thread,NULL, emHspaThread, NULL);
    return (0);
}
#endif

