// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef RFDESENSETXTESTNR_H_
#define RFDESENSETXTESTNR_H_

#include <string>
#include <vector>
#include <map>
#include <memory>
#include <mutex>

#include "util/utils.h"

class RfDesenseTxTestNr {
public:
    RfDesenseTxTestNr();
    virtual ~RfDesenseTxTestNr();

    static std::shared_ptr<RfDesenseTxTestNr> get_instance();

    void show_default();
    std::string get_command();
    std::string get_band();
    std::string get_power();
    std::string get_ant_mode();

    bool set_tx_mode(int mode);
    bool set_band_idx(int bandidx);
    bool set_bandwith_idx(int bandwidthidx);
    bool set_freq(std::string freq);
    bool set_vrb_start(std::string start);
    bool set_vrb_length(std::string length);
    bool set_mcs(int mcs);
    bool set_scs(int scs);
    bool set_power(std::string power);
    bool set_tdd_slot_config(std::string config);

    void show_freq();
    void show_start();
    void show_length();
    void show_power();
    void show_config();

private:
    static std::shared_ptr<RfDesenseTxTestNr> m_instance;
    static std::mutex mutex;
    std::string command;

    static const int INDEX_TX_MODE;
    static const int INDEX_BAND;
    static const int INDEX_BAND_WIDTH;
    static const int INDEX_FREQ;
    static const int INDEX_VRB_START;
    static const int INDEX_VRB_LENGTH;
    static const int INDEX_MCS;
    static const int INDEX_SCS;
    static const int INDEX_POWER;
    static const int INDEX_TDD_SLOT_CONFIG;
    static const int INDEX_ANT_MODE;

    static std::string DEFAULT_TX_MODE;
    static int DEFAULT_BAND_IDX;
    static std::string DEFAULT_BAND;
    static int DEFAULT_BAND_WIDTH_IDX;
    static std::string DEFAULT_BAND_WIDTH;//40MHZ
    static std::string DEFAULT_NR_FREQ;
    static std::string DEFAULT_VRB_START;
    static std::string DEFAULT_VRB_LENGTH;
    static std::string DEFAULT_MCS;
    static std::string DEFAULT_SCS_CONFIG;
    static std::string DEFAULT_POWER;
    static std::string DEFAULT_TDD_SLOT_CONFIG;
    static int DEFAULT_ANT_MODE;

    static std::string mTxMode;
    static int mBandIdx;
    static std::string mBand;
    static int mBandWidthIdx;
    static std::string mBandWidth;
    static std::string mFreq;
    static std::string mVrbStart;
    static std::string mVrbLength;
    static std::string mMcs;
    static std::string mScs;
    static std::string mPower;
    static std::string mTddSlotConfig;
    static int mAntMode;

    static const std::vector<std::string> mBandMapping;
    static const std::vector<std::string> mBandWidthMapping;
};

#endif /* RFDESENSETXTESTNR_H_ */
