#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <string.h>
#include <unistd.h>
#include <binder/Parcel.h>
#include <log/log.h>
#include <cutils/jstring.h>
#include <pthread.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <errno.h>
#include "lynq_timer.h"
#include <include/lynq_uci.h>

#include <stdlib.h>
#include <fcntl.h>
#include <assert.h>

#define DEST_PORT 8088
#define DSET_IP_ADDRESS  "127.0.0.1"
#define RIL_REQUEST_DEVICE_IDENTITY 98
#define MAX_LEN 1024
#define TIMER 30
#define LOG_UCI_FILE "lynq_uci"
#define LOG_UCI_MODULE "debug_mode"

using ::android::Parcel;

static pthread_mutex_t g_lynq_sim_sendto_mutex;

typedef struct{
    int uToken;
    int request;
    int paramLen;
    char param[MAX_LEN];
}lynq_client_t;

int num = 0;

static int get_md_sta(void)
{
    FILE *fp;
    char buffer[64]={};
    fp = popen("cat /sys/kernel/ccci/boot","r");
    if(fp == NULL)
    {
        RLOGD("function %s fp is null\n", __FUNCTION__);
        return 0;
    }
    fgets(buffer,sizeof(buffer),fp);
    if(!strlen(buffer))
    {
        RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
        pclose(fp);
        return 0;
    }
    if(buffer[4] == '4')
    {
        pclose(fp);
        return 1;
    }
    RLOGD("function %s line %d\n", __FUNCTION__, __LINE__);
    pclose(fp);
    return 0;
}

static int check_service(const char *service)
{
    FILE *fp;
    char buffer[1024]={};
    if(!strcmp(service, "/usr/sbin/mtkfusionrild"))
    {
        fp = popen("ps -ef|grep rild","r");
    }
    else if(!strcmp(service, "lynq-ril-service"))
    {
        fp = popen("ps -ef|grep ril-service","r");
    }
    if(fp == NULL)
    {
        RLOGD("function %s fp is null\n", __FUNCTION__);
        return 0;
    }
    while(NULL != fgets(buffer,sizeof(buffer),fp))
    {
        if(strstr(buffer,service))
        {
            pclose(fp);
            RLOGD("check_service 1\n");
            return 1;
        }
    }
    RLOGD("check_service 0\n");
    pclose(fp);
    return 0;
}

/**
 * @brief find partition zhengshu for exzample 5.7M,get value 5
 * 
 * @param arg 
 * @return  
 */
static void removeSpaces(char* str) 
{
    char* dest = str;  
    while (*str) {
        if (*str != ' ') {
            *dest++ = *str;  
        }
        str++;  
    }
    *dest = '\0';
	return ;
}

/**
 * @brief 30s request imei
 * 
 * @param arg 
 * @return void* 
 */
void * timer_request_imei(void * arg)
{
    FILE *fp1 = NULL;
    char buf[8] = {0};
    int ucivalue = 0;
    int nread = 0;
    int sock_fd = socket(AF_INET, SOCK_DGRAM, 0);
    if (-1 == sock_fd)
    {
        RLOGD("__FUNCTION__ %s create  sock_fd failed %s\n", __FUNCTION__, strerror(errno));
        /*set uci*/
        /*socket abnormal*/
        system("uci set lynq_uci.sdk_ready='3'");
        /*set uci*/
        return NULL;
    }
    struct sockaddr_in liblynq_data_socket;
    bzero(&liblynq_data_socket, sizeof(liblynq_data_socket));
    //set this lib socket config 
    liblynq_data_socket.sin_family = AF_INET;
    liblynq_data_socket.sin_addr.s_addr = inet_addr(DSET_IP_ADDRESS);
    int ret = bind(sock_fd, (struct sockaddr *)&liblynq_data_socket, sizeof(liblynq_data_socket));
    if (-1 == ret)
    {
        RLOGE("liblynq_data_socket bind fail,errno:%d",errno);
        return NULL;
    }
    
    struct timeval timeOut;
    timeOut.tv_sec = 3;//timeout time 3s
    timeOut.tv_usec = 0;
    if (setsockopt(sock_fd, SOL_SOCKET, SO_RCVTIMEO, &timeOut, sizeof(timeOut)) < 0) 
    {
        RLOGD("__FUNCTION__ %s time out setting failed %s\n", __FUNCTION__, strerror(errno));
        /*set uci*/
        /*socket abnormal*/
        system("uci set lynq_uci.sdk_ready='3'");
        /*set uci*/
        return NULL;
    }
    struct sockaddr_in addr_serv;
    memset(&addr_serv, 0, sizeof(addr_serv));  
    addr_serv.sin_family = AF_INET;  
    addr_serv.sin_addr.s_addr = inet_addr(DSET_IP_ADDRESS);  
    addr_serv.sin_port = htons(DEST_PORT);  
    int len_addr_serv = sizeof(addr_serv);
    int send_num = -1;
    int recv_num = -1;
    int resp_type = -1;
    int request = -1;
    int slot_id = -1;
    int token = -1;
    int res_error = -1;
    lynq_client_t client_t;
    char res_data[MAX_LEN] = {0};
    client_t.request = RIL_REQUEST_DEVICE_IDENTITY;
    client_t.paramLen = 0;
    client_t.uToken = 999;
    memset(client_t.param, 0, sizeof(client_t.param));
    while (1)
    {
        bzero(res_data, MAX_LEN);
        pthread_mutex_lock(&g_lynq_sim_sendto_mutex);
        send_num = sendto(sock_fd, &client_t, sizeof(client_t), 0, (struct sockaddr *)&addr_serv, len_addr_serv);
        RLOGD("send_num %d\n", send_num);
        if(send_num == 0)  
        {
            RLOGD("__FUNCTION__ %s Close to end %s\n", __FUNCTION__, strerror(errno));
            //unknow
            system("uci set lynq_uci.sdk_ready='4'");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;
        }
        if(send_num < 0)  
        {  
            RLOGD("__FUNCTION__ %s sendto error %s\n", __FUNCTION__, strerror(errno));
            //unknow
            system("uci set lynq_uci.sdk_ready='4'");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;
        }
        //get data msg
        recv_num = recvfrom(sock_fd,res_data,sizeof(char)*MAX_LEN,0,(struct sockaddr *)&addr_serv,(socklen_t*)&len_addr_serv);
        RLOGD("recv_num %d\n", recv_num);
        if(recv_num == 0)
        {
            RLOGD("__FUNCTION__ %s Close to end\n", __FUNCTION__);
            //unknow
            system("uci set lynq_uci.sdk_ready='4'");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;;
        }
        if(recv_num == -1 && errno == EAGAIN)
        {
            RLOGD("__FUNCTION__ %srecvfrom fail because timeout\n", __FUNCTION__);
            /*set uci*/
            if(!get_md_sta())
            {
                system("uci set lynq_uci.sdk_ready='1'");
            }
            else
            {
                if(check_service("/usr/sbin/mtkfusionrild"))//rild work
                {
                    if(!check_service("lynq-ril-service"))//not find,must be socket error
                    {
                        system("uci set lynq_uci.sdk_ready='3'");
                    }
                    else
                    {
                        //unknow error
                        system("uci set lynq_uci.sdk_ready='4'");
                    }
                    
                }
                else//rild no work
                {
                    //unknow
                    system("uci set lynq_uci.sdk_ready='4'");
                }
            }
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;;
        }
        if(recv_num < 0)
        {
            RLOGD("__FUNCTION__ %srecvfrom fail %s\n", __FUNCTION__, strerror(errno));
            //unknow
            system("uci set lynq_uci.sdk_ready='4'");
            pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
            continue;;
        }
        Parcel p;
        p.setData((uint8_t *)res_data,sizeof(char)*recv_num);
        p.setDataPosition(0);
        if(p.dataAvail() > 0)
        {
            p.readInt32(&resp_type);
            p.readInt32(&token);
            p.readInt32(&request);
            p.readInt32(&slot_id);
            p.readInt32(&res_error);
        }
        /*judge the res_error*/
        if(!res_error)
        {
            fp1 = popen("uci get lynq_uci.sdk_ready","r");
            if(fp1 == NULL)
            {
                RLOGD("Failed to run uci get lynq_uci.sdk_ready\n");
                continue;
            }
            memset(buf, 0, sizeof(buf));
            nread = fread(buf,1,8,fp1);
            pclose(fp1);
            ucivalue = atoi(buf);

            if((0 != ucivalue)&&(5 != ucivalue)&&(6 != ucivalue))
            {
                system("uci set lynq_uci.sdk_ready='0'");
            }
        }
        else
        {
            system("uci set lynq_uci.sdk_ready='2'"); //Md configurations are inconsistent with AP configurations
        }
        RLOGD("__FUNCTION__ %s res_error %d\n", __FUNCTION__, res_error);
        /*judge the res_error*/
        pthread_mutex_unlock(&g_lynq_sim_sendto_mutex);
        sleep(TIMER);
    }
    return NULL;
}


void delete_enter(char data[])
{
    char *find = strchr(data, '\n');
    if(find)
        *find = '\0';
    return ;
}


void *check(void * arg)
{

    char pid[200][8];
    char ffd[200][4];
    char buf[64];
    char check_time[4];
    char timebuf[32];
    int num = 1;
    int i=0;
    int j;
    FILE *fp,*fp_1;
    int ret;

    RLOGD("check cpu/pid/interrupts/fd!!!\n");
    system("mkdir /media/check_file");
    system("touch /media/check_time");
    fp_1 = popen("cat /media/check_time","r");
    if(fgets(check_time, 4, fp_1) != NULL)
    {
        num = atoi(check_time);
    }
    pclose(fp_1);
    while(1)
    {
        i = 0;
        system("date >>/media/check_file/cpu_moniter.txt");
        ret = system("top -b |head -n 25 >>/media/check_file/cpu_moniter.txt");
        RLOGD("cpu ret %d", ret);
        system("date >>/media/check_file/inter_moniter.txt");
        ret = system("cat /proc/interrupts |grep -v \":          0          0\" >>/media/check_file/inter_moniter.txt");
        RLOGD("interrupts ret %d", ret);

        system("date >>/media/check_file/pid_moniter.txt");
        ret = system("ps -eo \"%p %a\" | grep -v \"\\[\" >>/media/check_file/pid_moniter.txt");
        RLOGD("pid ret %d", ret);

        system("date >>/media/check_file/meminfo_moniter.txt");
        ret = system("cat /proc/meminfo >>/media/check_file/meminfo_moniter.txt");
        RLOGD("meminfo ret %d", ret);

        system("date >>/media/check_file/buddyinfo_moniter.txt");
        ret = system("cat /proc/buddyinfo >>/media/check_file/buddyinfo_moniter.txt");
        RLOGD("buddyinfo ret %d", ret);

        system("date >>/media/check_file/ps_auxw_moniter.txt");
        ret = system("ps -auxw|grep -v \"0.0  0.0\"|grep -v \"0.1  0.0\"|grep -v \"0.0  0.1\" >>/media/check_file/ps_auxw_moniter.txt");
        RLOGD("ps_auxw ret %d", ret);

        system("date >>/media/check_file/cur_freq_moniter.txt");
        ret = system("cat /sys/devices/system/cpu/cpufreq/policy0/scaling_cur_freq >>/media/check_file/cur_freq_moniter.txt");
        RLOGD("cur_freq ret %d", ret);

        system("date >>/media/check_file/available_frequencies_moniter.txt");
        ret = system("cat /sys/devices/system/cpu/cpufreq/policy0/scaling_available_frequencies >>/media/check_file/available_frequencies_moniter.txt");
        RLOGD("available_frequencies ret %d", ret);

        system("date >>/media/check_file/fd_moniter.txt");
        fp = popen("ps -eo \"%p %a\" | grep -v \"\\[\"|awk '{print $1}'","r");
        while(fgets(pid[i], 8, fp) != NULL)
        {
             delete_enter(pid[i]);
             i++;
        }
        pclose(fp);

        for(j=1;j<i;j++)
        {
            sprintf(buf, "ls /proc/%s/fd | wc -l", pid[j]);
            fp = popen(buf, "r");
            fgets(ffd[j], 4, fp);
            sprintf(buf,"echo \"pid: %s, fd_num: %s\" >>/media/check_file/fd_moniter.txt",pid[j], ffd[j]);
            system(buf);
            pclose(fp);
        }

        if(num > 228)
        {
            system("cp /media/check_file/cpu_moniter.txt /media/check_file/cpu_moniter_1.txt");
            system("cp /media/check_file/inter_moniter.txt /media/check_file/inter_moniter_1.txt");
            system("cp /media/check_file/pid_moniter.txt /media/check_file/pid_moniter_1.txt");
            system("cp /media/check_file/fd_moniter.txt /media/check_file/fd_moniter_1.txt");
            system("cp /media/check_file/fd_moniter.txt /media/check_file/meminfo_moniter_1.txt");
            system("cp /media/check_file/fd_moniter.txt /media/check_file/buddyinfo_moniter_1.txt");
            system("cp /media/check_file/fd_moniter.txt /media/check_file/ps_auxw_moniter_1.txt");
            system("cp /media/check_file/fd_moniter.txt /media/check_file/cur_freq_moniter_1.txt");
            system("cp /media/check_file/fd_moniter.txt /media/check_file/available_frequencies_moniter_1.txt");


            system("rm -rf /media/check_file/cpu_moniter.txt");
            system("rm -rf /media/check_file/inter_moniter.txt");
            system("rm -rf /media/check_file/pid_moniter.txt");
            system("rm -rf /media/check_file/fd_moniter.txt");
            system("rm -rf /media/check_file/meminfo_moniter.txt");
            system("rm -rf /media/check_file/buddyinfo_moniter.txt");
            system("rm -rf /media/check_file/ps_auxw_moniter.txt");
            system("rm -rf /media/check_file/cur_freq_moniter.txt");
            system("rm -rf /media/check_file/available_frequencies_moniter.txt");

            num = 0;
        }
        num++;
        sprintf(timebuf, "echo \"%d\" >/media/check_time", num);
        ret = system(timebuf);
        sleep(300);
    }
    return NULL;

}


void *check_uci(void * arg)
{
    int ret[6];
    int result = 0;
    int flag = 0;

    char uci_0[]="/etc/config/lynq_uci";
    char uci_1[]="/etc/config/lynq_uci_ro";
    char uci_2[]="/etc/config/mdlog";
    char uci_3[]="/etc/config/radio_property";
    char uci_4[]="/etc/config/service";
    char uci_5[]="/etc/config/usb";
    RLOGD("start check uci\n");
    while(num++ < 4)
    {
        RLOGD("@@@@@@@num=%d\n", num);
        flag = 0;
        ret[0] = system("uci show | grep \"lynq_uci.lynq_ril\" > /dev/null");
        if(ret[0] != 0)
        {
            RLOGD("lynq_uci unload\n");
            flag = 1;
        }

        ret[1] = system("uci show | grep \"^lynq_uci_ro\.\" > /dev/null");
        if(ret[1] != 0)
        {
            RLOGD("lynq_uci_ro unload\n");
            flag = 1;
        }

        ret[2] = system("uci show | grep \"^mdlog\.\"");
        if(ret[2] != 0)
        {
            RLOGD("mdlog unload\n");
            flag = 1;
        }

        ret[3] = system("uci show | grep \"^radio_property\.\" > /dev/null");
        if(ret[3] != 0)
        {
            RLOGD("radio_property unload\n");
            flag = 1;
        }

        ret[4] = system("uci show | grep \"^service\.\" > /dev/null");
        if(ret[4] != 0)
        {
            RLOGD("service unload\n");
            flag = 1;
        }

        ret[5] = system("uci show | grep \"^usb\.\" > /dev/null");
        if(ret[5] != 0)
        {
            RLOGD("usb unload\n");
            flag = 1;
        }

        RLOGD("flag=%d\n",flag);
        if(flag != 0)
        {
            RLOGD("config reload\n");
            result = chdir("/data_backup/");
            result =system("tar -zxvf userdata.tar.gz -C /STATE/ >/dev/null");
            if(result!= 0)
            {
                RLOGD("cp config fail\n");
            }
            if(ret[0] != 0)
            {
                lynq_load_config(uci_0);
                RLOGD("reload lynq_uci\n");
                system("systemctl start autosuspend");
            }
            if(ret[1] != 0)
            {
                lynq_load_config(uci_1);
                RLOGD("reload lynq_uci_ro\n");
            }
            if(ret[2] != 0)
            {
                lynq_load_config(uci_2);
                RLOGD("reload mdlog\n");
            }
            if(ret[3] != 0)
            {
                lynq_load_config(uci_3);
                RLOGD("reload radio_property\n");
                system("systemctl restart mtkfusionrild");
            }
            if(ret[4] != 0)
            {
                lynq_load_config(uci_4);
                RLOGD("reload service\n");
            }
            if(ret[5] != 0)
            {
                lynq_load_config(uci_5);
                RLOGD("reload usb\n");
            }
        }
        else
        {
            RLOGD("uci check success, exit check!\n");
            break;
        }
        sleep(2);
    }
    return NULL;
}

static void *delete_partition(void  *arg)
{
    char buf[64] = {0};
    char tmp[64] = {0};
    char ucibuf[8] = {0};
    FILE *fp = NULL;
    FILE *fp1 = NULL;
    char *result1 = NULL;
    int nread = 0;
    int nnread = 0;
    int count1 = 0;
    int q = 22;
    int qWarnValue = 10;
    int ubisize = 0;
    int uciValue = 0;

    while(1)
    {

    sleep(300);

    fp = popen("df -lh| grep '/data$' | awk '{print $3}'","r");

    if(fp == NULL)
    {
       RLOGD("Failed to run command\n");
       continue;
    }

    memset(buf, 0, sizeof(buf));
    nread = fread(buf,1,64,fp);

    if(nread != 64)
    {
        pclose(fp);
        RLOGD("Read file failed!\n");	
        continue;
    }
    if (pclose(fp) == -1) 
    {
        RLOGD("close fp file failed!\n");
        continue;
     }

    removeSpaces(buf);

    result1 = strchr(buf, 'M');

   if(result1 != NULL)
   {
      count1 = result1 - buf;

      memset(tmp,0,sizeof(tmp));

      if(strncpy(tmp,buf,count1) == NULL)
      {
          RLOGD("copy buf failed!\n");
          continue;
      }
      else
      {
          RLOGD("copy buf success!\n");
          ubisize = atoi(tmp);
      }

     if((ubisize > qWarnValue)&&(ubisize < q))
       {	
         fp1 = popen("uci get lynq_uci.sdk_ready","r");
         if(fp1 == NULL)
         {
             RLOGD("Failed to run uci get lynq_uci.sdk_ready\n");
             continue;
         }

        memset(ucibuf, 0, sizeof(ucibuf));
        nnread = fread(ucibuf,1,8,fp1);
        pclose(fp1);
        uciValue = atoi(ucibuf);
        
        if(0x0 == uciValue)
        {
           system("uci set lynq_uci.sdk_ready='5'");
           RLOGD(">set ready 5,userdata size is %d M\n",ubisize);
        }
        else
        {
           RLOGD("userdata size is %d M,uciValue is %d\n",ubisize,uciValue);
        }
     }
     else if(ubisize >= q)
     {
        fp1 = popen("uci get lynq_uci.sdk_ready","r");
        if(fp1 == NULL)
        {
          RLOGD("Failed to run uci get lynq_uci.sdk_ready\n");
          continue;
        }

        memset(ucibuf, 0, sizeof(ucibuf));
        nnread = fread(ucibuf,1,8,fp1);
        pclose(fp1);
        uciValue = atoi(ucibuf);

        if(0x0 == uciValue)
        {
           RLOGD(">set ready 6,userdata size is %d M\n",ubisize);
           system("uci set lynq_uci.sdk_ready='6'"); 
        }
     else
     {
        RLOGD("userdata size is %d M,uciValue is %d\n",ubisize,uciValue);
     }
    } 
    else
    {
        RLOGD("userdata size is %d M\n",ubisize);
    }

  }
  else
  {
     RLOGD("userdata partition size is kb!\n");
  }


  }

return (void *)0;
}

void start_timer_request(void)
{
    pthread_t thid,thid_1,thid_2,thid_3;
    pthread_attr_t a;
    pthread_attr_init(&a);
    pthread_attr_setdetachstate(&a, PTHREAD_CREATE_DETACHED);

    char tmp[20];
    int debug_mode;
    int ret;
    int ret3;
    
    ret = pthread_create(&thid, &a, timer_request_imei, NULL);
    if(ret != 0){
        RLOGD("pthread_create error!!!");
        return;
    }
    sleep(20);
    ret = lynq_get_value(LOG_UCI_FILE, LOG_UCI_MODULE, "sysinfo_debug_status", tmp);
    RLOGD("ret =%d, tmp is %s\n", ret, tmp);
    debug_mode=atoi(tmp);
    RLOGD("debug_mode is %d!!!\n", debug_mode);
    if(debug_mode == 1)
    {
        RLOGD("debug_mode is 1, pthread_create start!!!\n");
        ret = pthread_create(&thid_1, NULL, check, NULL);
        if(ret != 0)
        {
            RLOGD("pthread_create error!!!");
            return;
        }

    }

    ret = pthread_create(&thid_2,NULL,check_uci,NULL);
    if(ret != 0){
        RLOGD("pthread_create error!!!");
        return;
    }
    pthread_detach(thid_2);

    sleep(1);

    ret3 = pthread_create(&thid_3,NULL,delete_partition,NULL);
    if(ret3 != 0)
     { 
        RLOGD("pthread_create error!!!");
        return;
     }

    return;
}

