#include <log/log.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
extern "C" {
#include <gio/gio.h>
#include "liblog/lynq_deflog.h"
#include <glib.h>
}
#include "other/other_service.h"
#define LOG_TAG "OTHER_SERVICE"

#define TEST_SERVICE "test.lynq" /*well-known bus name */
#define TEST_DATA_INTERFACE "test.lynq.Data" /*interface name*/
#define TEST_DATA_PATH "/test/lynq/data" /*object name*/
static GDBusNodeInfo *introspection_data_test = NULL;

static const gchar introspection_test_xml[] =
        "<node>"
        "  <interface name='test.lynq.Data'>"
        "    <method name='add'>"
        "      <arg name='a' type='i' direction='in'/>"
        "      <arg name='b' type='i' direction='in'/>"
        "      <arg name='addresponse' type='i' direction='out'/>"
        "    </method>"
        "    <method name='reduce'>"
        "      <arg name='a' type='i' direction='in'/>"
        "      <arg name='b' type='i' direction='in'/>"
        "      <arg name='reduceresponse' type='i' direction='out'/>"
        "    </method>"
        "  </interface>"
        "</node>";
static GMutex g_mutex;
static GHashTable *hashTable = NULL;
static GAsyncQueue *queue;	



static void
add_contorl (GDBusConnection       *connection,
                    const gchar           *sender,
                    const gchar           *object_path,
                    const gchar           *interface_name,
                    const gchar           *method_name,
                    GVariant              *parameters,
                    GDBusMethodInvocation *invocation,
                    gpointer               user_data)
{
    if (g_strcmp0 (method_name, "add") == 0){ 
     	GVariant *result = NULL;
        gint32 getResult = 888;
		gint32 getResult1 = 888;
        guint a;
        guint b;
        const gchar *mode;
        g_variant_get (parameters, "(ii)", &a, &b);
        LYDBGLOG("set test parameters is mode111:  %d %d",a,b );
		if(b == 1)
		sleep(11);
		g_dbus_method_invocation_return_value (invocation,
                                         g_variant_new ("(i)", a+b));
    }
	else if (g_strcmp0 (method_name, "reduce") == 0){
        guint a;
        guint b;
        g_variant_get (parameters, "(ii)", &a, &b);
        LYDBGLOG("set reduce:  %d %d",a,b );
		g_dbus_method_invocation_return_value (invocation,
                                         g_variant_new ("(i)", a-b));
	}
	else
		g_assert_not_reached ();

}

static const GDBusInterfaceVTable interface_test_vtable =
{
  add_contorl,
  NULL,
  NULL
};		

static void
on_bus_test_acquired (GDBusConnection *connection,
                                      const gchar     *name,
                                      gpointer         user_data)
{
    guint registration_id;
    LYDBGLOG("Acquired a message bus connection");
    registration_id = g_dbus_connection_register_object (connection,
                                                         TEST_DATA_PATH,
                                                         introspection_data_test->interfaces[0],
                                                         &interface_test_vtable,
                                                         NULL,  /* user_data */
                                                         NULL,  /* user_data_free_func */
                                                         NULL); /* GError** */
    g_assert (registration_id > 0);
}

static void
on_test_name_acquired (GDBusConnection *connection,
                                          const gchar     *name,
                                          gpointer         user_data)
{
    LYDBGLOG("Acquired the name %s", name);
}

static void
on_test_name_lost(GDBusConnection *connection,
                                         const gchar     *name,
                                         gpointer user_data)
{
    LYDBGLOG("Lost the name %s", name);
}

static void
on_test_name_appeared (GDBusConnection *connection,
                  const gchar     *name,
                  const gchar     *name_owner,
                  gpointer         user_data)
{
    LYDBGLOG("Name %s on %s is owned by %s\n",name,"the system bus",name_owner);

}
static gpointer
test_dbus_service_cb (gpointer data){
   
    GMainLoop *loop;
    guint id;
    guint watcher_id;
   // sleep(1);
  //   printf("%s, %s, %d", __FILE__, __FUNCTION__, __LINE__);
    introspection_data_test = g_dbus_node_info_new_for_xml (introspection_test_xml, NULL);
    g_assert (introspection_data_test != NULL);
    hashTable = g_hash_table_new_full(g_int_hash, g_int_equal, NULL, g_free);
    queue = g_async_queue_new();
    loop = g_main_loop_new(NULL, FALSE);
    id = g_bus_own_name(G_BUS_TYPE_SYSTEM,
                           TEST_SERVICE,
                           GBusNameOwnerFlags(G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT |
                           G_BUS_NAME_OWNER_FLAGS_REPLACE),
                           on_bus_test_acquired,
                           on_test_name_acquired,
                           on_test_name_lost,
                           loop,
                           NULL);
    g_main_loop_run(loop);
    g_bus_unown_name(id);
    g_main_loop_unref(loop);
    g_async_queue_unref(queue);
    g_dbus_node_info_unref (introspection_data_test);
    return NULL;
}
void register_other_service(){
	GError *error = NULL;
    GThread *thead = g_thread_try_new("test_dbus_service", test_dbus_service_cb, NULL, &error);
    g_assert_no_error(error);
    if(error!=NULL)
    {
        LYDBGLOG("initGDbus free error pointer %P", error);
        g_error_free(error);
    }
}
