
/*============================================================================= 
#     FileName: lynq_at.h
#     Desc: about AT_EXTENSION_API
#     Author:lei
#     Version: V1.0
#     LastChange: 2022-03-28 
#     History: 
=============================================================================*/

#ifndef __LYNQ_AT__
#define __LYNQ_AT__
#ifdef __cplusplus
extern "C" {
#endif

/**
 * @brief
 * @param input type:in
 * @param output type:out
 * @param out_max_size type:in
 */
typedef void (*LYNQ_AT_CALLBACK)(char input[], char output[], int out_max_size);

/**
 * @brief Register the AT command to the server and print the function execution finger on the AT port
 * 
 * @param ext_at type:in at command
 * @param callback type:in callback
 * @return int 
 */
int lynq_reg_third_at(const char *ext_at, LYNQ_AT_CALLBACK callback);

#ifdef __cplusplus
}
#endif

#endif