#include <stdio.h>
#include <stdint.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <log/log.h>
#include <include/lynq_sim.h>
#include <stdlib.h>
#include <pthread.h>
#include <liblog/lynq_deflog.h>
#include "lynq_qser_sim.h"

#define USER_LOG_TAG "LYNQ_QSER_SIM"

sim_client_handle_type h_sim = 0;

int qser_sim_client_init(sim_client_handle_type  *ph_sim)
{
    if(NULL == ph_sim)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    *ph_sim = (sim_client_handle_type)getpid();
    //*ph_sim = (sim_client_handle_type)53234323;
    h_sim = *ph_sim;
    return lynq_sim_init(*ph_sim);
}

int qser_sim_client_deinit(sim_client_handle_type h_sim)
{
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_sim_deinit();
}

int qser_sim_getimsi(sim_client_handle_type h_sim, QSER_SIM_APP_ID_INFO_T *pt_info, char *imsi, size_t imsiLen)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(NULL == imsi)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_get_imsi(imsi);
}

int qser_sim_geticcid(sim_client_handle_type h_sim, QSER_SIM_SLOT_ID_TYPE_T simId, char *iccid, size_t iccidLen)
{
    if(NULL == iccid)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_get_iccid(iccid);
}

int qser_sim_getphonenumber(sim_client_handle_type h_sim, QSER_SIM_APP_ID_INFO_T *pt_info,  char *phone_num, size_t phoneLen)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(NULL == phone_num)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_query_phone_number(phone_num);
}

int qser_sim_verifypin(sim_client_handle_type h_sim, QSER_SIM_VERIFY_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_verify_pin(pt_info->pin_value);
}

int qser_sim_changepin(sim_client_handle_type h_sim,QSER_SIM_CHANGE_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_change_pin(pt_info->old_pin_value, pt_info->new_pin_value);
}

int qser_sim_unblockpin(sim_client_handle_type h_sim, QSER_SIM_UNBLOCK_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_unlock_pin(pt_info->puk_value, pt_info->new_pin_value);
}

int qser_sim_enablepin(sim_client_handle_type h_sim, QSER_SIM_ENABLE_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_enable_pin(pt_info->pin_value);
}

int qser_sim_disablepin(sim_client_handle_type h_sim, QSER_SIM_DISABLE_PIN_INFO_T *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_disable_pin(pt_info->pin_value);
}

int qser_sim_getcardstatus(sim_client_handle_type h_sim,QSER_SIM_SLOT_ID_TYPE_T simId, QSER_SIM_CARD_STATUS_INFO_T   *pt_info)
{
    if(NULL == pt_info)
    {
        LYERRLOG("input  error\n");
        return E_QSER_ERROR_BADPARM;
    }
    if(h_sim == 0)
    {
        LYERRLOG("not init\n");
        return E_QSER_ERROR_BADPARM;
    }
    return lynq_get_sim_status((int*)&pt_info->e_card_state);
}