#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <log/log.h>
#include <unistd.h>
#include <pthread.h>

#include "lynq_rtp.h"
#include "liblog/lynq_deflog.h"
#include "liblynq-codec/lynq_codec.h"

#define USER_LOG_TAG "LYNQ_RTP"

char server_cmd[MAX_CMD_SIZE];

char client_cmd[MAX_CMD_SIZE];

typedef struct
{
    LYNQ_Rtp_Mode mode;
    char ip[128];
    int port;
    int clockrate;
    char address[128];
    int latency;
    int channels;
}lynq_rtp_info;

lynq_rtp_info lynq_rtp_client_info;
lynq_rtp_info lynq_rtp_server_info;

int g_lynq_rtp_mode;

int g_lynq_rtp_pid;

pthread_t lynq_rtp_server_pid = 0;

int get_pid(char *name) 
{
    char buf[256] = "";
    char cmd[30] = ""; 
    int  pid = -1;
    sprintf(cmd, "pidof %s", name);
 
    FILE *pFd = popen(cmd, "r");
    if (pFd != NULL) 
    {
        while (fgets(buf, sizeof(buf), pFd)) 
        {
            pid = atoi(buf);
            break;
        }
        pclose(pFd);
    }
    return pid;
}

int lynq_set_rtp_mode_media_play(const LYNQ_Rtp_Mode rtp_mode)
{
    if (rtp_mode == 0)
    {
        lynq_rtp_client_info.mode = 0;
    }
    else if (rtp_mode == 1)
    {
        lynq_rtp_server_info.mode = 1;
    }
    g_lynq_rtp_mode = rtp_mode;

    LYLOGSET(LOG_INFO);
    LYLOGEINIT(USER_LOG_TAG);
    return 0;
}

int lynq_set_rtp_ip_media_play(LYNQ_Rtp_Mode rtp_mode,const char* ip,const int ip_length)
{
    if (NULL == ip)
    {
        LYERRLOG("ip is NULL!!!");
        return -1;
    }
    if (ip_length != strlen(ip))
    {
        LYERRLOG("incoming ip length error");
        return -1;
    }

    if (rtp_mode == 1)
    {
        bzero(lynq_rtp_server_info.ip,MAX_IP_LENGTH);
        strcpy(lynq_rtp_server_info.ip,ip);
    }
    else if (rtp_mode == 0)
    {
        bzero(lynq_rtp_client_info.ip,MAX_IP_LENGTH);
        strcpy(lynq_rtp_client_info.ip,ip);
    }
    return 0;
}

int lynq_set_rtp_port_media_play(LYNQ_Rtp_Mode rtp_mode,const int port)
{
    if (port < 0)
    {
        LYERRLOG("invalid port number");
        return -1;
    }
    if (rtp_mode == 0)
    {
        lynq_rtp_client_info.port = port;
    }
    else if (rtp_mode == 1)
    {
        lynq_rtp_server_info.port = port;
    }
    return 0;
}

int lynq_set_rtp_param_media_play(LYNQ_Rtp_Mode rtp_mode,char *file_address,const int clock_rate,const int channels,const int latency)
{
    if (NULL == file_address)
    {
        LYERRLOG("file address is NULL");
        return -1;
    }
    if (rtp_mode == 0)
    {
        lynq_rtp_client_info.clockrate = clock_rate;
        lynq_rtp_client_info.channels = channels;
        lynq_rtp_client_info.latency = latency;
    }
    if (rtp_mode == 1)
    {
        strcpy(lynq_rtp_server_info.address,file_address);
    }
    return 0;
}

void* lynq_pthread_rtp_system()
{
    int ret = 0;
    ret = pthread_setcancelstate(PTHREAD_CANCEL_ENABLE,NULL);
    if (g_lynq_rtp_mode == 0)
    {
        set_codec(LYNQ_RTP, CODEC_OPEN);
        bzero(client_cmd,MAX_CMD_SIZE);

        sprintf(client_cmd,"gst-launch-1.0 udpsrc port=%d caps=\'application/x-rtp, media=(string)audio, clock-rate=(int)%d, channel=(int)%d\' ! rtpjitterbuffer latency=%d ! rtppcmadepay ! pulsesink",   \
        lynq_rtp_client_info.port,lynq_rtp_client_info.clockrate,lynq_rtp_client_info.channels,lynq_rtp_client_info.latency);
        system(client_cmd);
    }
    else if (g_lynq_rtp_mode == 1)
    {
        bzero(server_cmd,MAX_CMD_SIZE);
        
        sprintf(server_cmd,"gst-launch-1.0 -v filesrc location=\"%s\" ! decodebin ! audioconvert ! audioresample ! alawenc ! rtppcmapay ! udpsink host=%s auto-multicast=true port=%d", \
        lynq_rtp_server_info.address, lynq_rtp_server_info.ip,lynq_rtp_server_info.port);

        system(server_cmd);
    }
}

int lynq_start_rtp_server_media_play()
{
    int ret = 0;
    pthread_attr_t attr;

    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    ret = pthread_create(&lynq_rtp_server_pid,&attr,lynq_pthread_rtp_system,0);
    if(ret <0)
    {
        LYERRLOG("urc pthread create error");
        return -1;
    }
    return ret;
}

int lynq_stop_rtp_server_media_play()
{
    int ret = 0;
    if(lynq_rtp_server_pid != 0)
    {
        ret = pthread_cancel(lynq_rtp_server_pid);
        LYINFLOG("pthread cancel ret = %d",ret);
        ret = pthread_join(lynq_rtp_server_pid,NULL);
        LYINFLOG("pthread join ret = %d",ret);
	
        if (g_lynq_rtp_mode == 0)
        {
            set_codec(LYNQ_RTP, CODEC_CLOSE);
        }

    }
    else 
    {
        LYERRLOG("rtp stop error");
        return -1;
    }
    return 0;
}


/*query part*/
int lynq_get_rtp_ip_media_play(const LYNQ_Rtp_Mode rtp_mode, char* ip, const int ip_length)
{
    if (NULL == ip)
    {
        LYERRLOG("incoming ip is NULL!!!");
        return -1;
    }
    if (rtp_mode == 0)
    {
        bzero(ip,ip_length);
        strcpy(ip,lynq_rtp_client_info.ip);
    }
    else if (rtp_mode == 1)
    {
        bzero(ip,ip_length);
        strcpy(ip,lynq_rtp_server_info.ip);
    }
    return 0;
}

int lynq_get_rtp_port_media_play(LYNQ_Rtp_Mode rtp_mode,int* port)
{
    if (rtp_mode == 0)
    {
        *port = lynq_rtp_client_info.port;
    }
    else if (rtp_mode == 1)
    {
        *port = lynq_rtp_server_info.port;
    }
    return 0;
}

int lynq_get_rtp_param_media_play(LYNQ_Rtp_Mode rtp_mode,char *file_address,int* clock_rate,int* channels,int* latency)
{
    if (NULL == file_address)
    {
        LYERRLOG("file address is NULL");
        return -1;
    }
    if (rtp_mode == 0)
    {
        *clock_rate = lynq_rtp_client_info.clockrate;
        *channels = lynq_rtp_client_info.channels ;
        *latency = lynq_rtp_client_info.latency;
    }
    if (rtp_mode == 1)
    {
        strcpy(file_address,lynq_rtp_server_info.address);
    }
    return 0;
}
