//ATCI Service  atcmd
#ifndef _ATCI_COMMON_H_
#define _ATCI_COMMON_H_

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <sys/un.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <pthread.h>
#include <fcntl.h>
#include <termios.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#ifndef  ATCI_UT
#include "log/log.h"
//#include <sncfg/sncfg.h>
#include <cutils/properties.h>
#endif
#define SYS_SUCC                    0
#define SYS_FAIL                    -1
#define INVALIDE_FD                 -1
#define MAX_CMD_BUF_LENGTH          4096
#define MAX_RESP_BUF_LENGTH         4096
#define MUX_APP_NUM                 5
#define MAX_CMD_HANDLER_MODULE_NUM  20
#define MAX_CMD_PREFIX_LENGTH       64
#undef  LOG_TAG
#define LOG_TAG                     "ATCI"

typedef enum {
  ATCI_SPACE = ' ',
  ATCI_EQUAL = '=',
  ATCI_COMMA = ',',
  ATCI_SEMICOLON = ';',
  ATCI_COLON = ':',
  ATCI_AT = '@',
  ATCI_HAT = '^',
  ATCI_MONEY = '$',
  ATCI_DOUBLE_QUOTE = '"',
  ATCI_QUESTION_MARK = '?',
  ATCI_EXCLAMATION_MARK = '!',
  ATCI_FORWARD_SLASH = '/',
  ATCI_L_ANGLE_BRACKET = '<',
  ATCI_R_ANGLE_BRACKET = '>',
  ATCI_R_BRACKET = ')',
  ATCI_L_BRACKET = '(',
  ATCI_L_SQ_BRACKET = '[',
  ATCI_R_SQ_BRACKET = ']',
  ATCI_L_CURLY_BRACKET = '{',
  ATCI_R_CURLY_BRACKET = '}',
  ATCI_CHAR_STAR = '*',
  ATCI_CHAR_POUND = '#',
  ATCI_CHAR_AMPSAND = '&',
  ATCI_CHAR_PERCENT = '%',
  ATCI_CHAR_PLUS = '+',
  ATCI_CHAR_MINUS = '-',
  ATCI_CHAR_DOT = '.',
  ATCI_CHAR_ULINE = '_',
  ATCI_CHAR_TILDE = '~',
  ATCI_CHAR_REVERSE_SOLIDUS = '\\',
  ATCI_CHAR_VERTICAL_LINE = '|',
  ATCI_END_CHAR = '\0',
  ATCI_CR = '\r',
  ATCI_LF = '\n',
  ATCI_CHAR_0 = '0',
  ATCI_CHAR_1 = '1',
  ATCI_CHAR_2 = '2',
  ATCI_CHAR_3 = '3',
  ATCI_CHAR_4 = '4',
  ATCI_CHAR_5 = '5',
  ATCI_CHAR_6 = '6',
  ATCI_CHAR_7 = '7',
  ATCI_CHAR_8 = '8',
  ATCI_CHAR_9 = '9',
  ATCI_CHAR_A = 'A',
  ATCI_CHAR_B = 'B',
  ATCI_CHAR_C = 'C',
  ATCI_CHAR_D = 'D',
  ATCI_CHAR_E = 'E',
  ATCI_CHAR_F = 'F',
  ATCI_CHAR_G = 'G',
  ATCI_CHAR_H = 'H',
  ATCI_CHAR_I = 'I',
  ATCI_CHAR_J = 'J',
  ATCI_CHAR_K = 'K',
  ATCI_CHAR_L = 'L',
  ATCI_CHAR_M = 'M',
  ATCI_CHAR_N = 'N',
  ATCI_CHAR_O = 'O',
  ATCI_CHAR_P = 'P',
  ATCI_CHAR_Q = 'Q',
  ATCI_CHAR_R = 'R',
  ATCI_CHAR_S = 'S',
  ATCI_CHAR_T = 'T',
  ATCI_CHAR_U = 'U',
  ATCI_CHAR_V = 'V',
  ATCI_CHAR_W = 'W',
  ATCI_CHAR_X = 'X',
  ATCI_CHAR_Y = 'Y',
  ATCI_CHAR_Z = 'Z',
  ATCI_CHAR_a = 'a',
  ATCI_CHAR_b = 'b',
  ATCI_CHAR_c = 'c',
  ATCI_CHAR_d = 'd',
  ATCI_CHAR_e = 'e',
  ATCI_CHAR_f = 'f',
  ATCI_CHAR_g = 'g',
  ATCI_CHAR_h = 'h',
  ATCI_CHAR_i = 'i',
  ATCI_CHAR_j = 'j',
  ATCI_CHAR_k = 'k',
  ATCI_CHAR_l = 'l',
  ATCI_CHAR_m = 'm',
  ATCI_CHAR_n = 'n',
  ATCI_CHAR_o = 'o',
  ATCI_CHAR_p = 'p',
  ATCI_CHAR_q = 'q',
  ATCI_CHAR_r = 'r',
  ATCI_CHAR_s = 's',
  ATCI_CHAR_t = 't',
  ATCI_CHAR_u = 'u',
  ATCI_CHAR_v = 'v',
  ATCI_CHAR_w = 'w',
  ATCI_CHAR_x = 'x',
  ATCI_CHAR_y = 'y',
  ATCI_CHAR_z = 'z',
} atci_char_enum;

typedef enum {
  AT_WRONG_MODE, AT_SET_MODE, //Ex: at+eample=xxx
  AT_READ_MODE, //Ex: at+eample?
  AT_TEST_MODE, //Ex: at+eample=?
  AT_ACTIVE_MODE //Ex: at+eample
} atci_cmd_mode_e;

typedef enum {
  TARGET_TELEPHONY = 0,
  /*if need send to new app, add target_type */
  TARGET_UNKNOWN = MUX_APP_NUM,
  TARGET_RIL,
  TARGET_GENERIC,
  TARGET_PLATFORM,
  TARGET_BATTERY,
  TARGET_AUDIO,
  TARGET_EXTERNAL
} atci_target_e;

#define ATCI_LOWER_TO_UPPER(alpha_char) (((alpha_char >= ATCI_CHAR_a)&&(alpha_char <= ATCI_CHAR_z)) ?  (alpha_char-32): (alpha_char))
#define ATCI_UPPER_TO_LOWER(alpha_char) (((alpha_char >= ATCI_CHAR_A)&&(alpha_char <= ATCI_CHAR_Z)) ?  (alpha_char+32): (alpha_char))
#define ATCI_IS_CAHR(input ,alpha_char) ((alpha_char == input)? 1 : 0)

#define SysMsg(f,a...) RLOGI("( %s, %d: )" f "\n",__FUNCTION__, __LINE__,## a)
#define DbgMsg(f,a...) RLOGD("( %s, %d: )" f "\n",__FUNCTION__, __LINE__,## a)
#define ErrMsg(f,a...) RLOGE("( %s, %d: )" f "\n",__FUNCTION__, __LINE__,## a)

#endif
