#include <vendor-ril/telephony/ril.h>
#include <string.h>
#include <log/log.h>

#include "ATCI.h"
#include "atci_util.h"
#include "atci_at_util.h"
#include <unistd.h>
#include <linux/reboot.h>
#include <sys/syscall.h>

#undef LOG_TAG
#define LOG_TAG "DEMO_ATCI_SYS"
#define  RESTART_WAITING_TIME 5*1000*1000
#define  RESTART_REASON       "AT%RESTART"

int atci_sys_ims_enable_hdlr(char *cmd, int op_mode, int target, char *response) {
    int ret = SYS_FAIL;
    int ims_enable;
    char *p_out = NULL;
    atci_data_req_t req;
    //check parameter
    switch (op_mode) {
    case AT_SET_MODE:
    case AT_READ_MODE:
    case AT_ACTIVE_MODE:
    case AT_TEST_MODE: {
      //paser parameter
      //send to target handle
      //ex: at@example=string1,2,3,4
      RLOGD("input cmd[%s]", cmd);
      if (SYS_FAIL == atci_at_to_equal(&cmd)) {
        //input error
        RLOGD("input cmd[%s]", cmd);
        ret = SYS_FAIL;
        break;
      }
      RLOGD("reamin data is[%s]", cmd);

      // get int
      if (SYS_FAIL == atci_at_hasmore(&cmd)) {
        ret = SYS_FAIL;
        break;
      }
      if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &ims_enable)) {
        ret = SYS_FAIL;
        break;
      }
      if (!((ims_enable == 1) || (ims_enable == 0))) {
        ret = SYS_FAIL;
        RLOGD("ims enable mode value set fail by user ims_enable = %d",
            ims_enable);
        break;
      }
      if (SYS_SUCC == atci_at_get_next_key(&cmd, &p_out)) {
        ret = SYS_FAIL;
        RLOGD("Fail because reamin data is[%s]", cmd);
        break;
      }
      //wrire data to target if need

      //input data
      req.request_id = RIL_REQUEST_SET_IMS_ENABLE;
      req.data_len = sizeof(ims_enable);
      req.data = &ims_enable;
      RLOGD("input req data %d", ims_enable);
      int argc = 1;
      char* cPoint;
      char parser_buf[SOCKET_BUF_SIZE] = { 0 };
      char reqStr[RIL_REQUEST_STRING_LENGTH];
      cPoint = parser_buf;
      memcpy(reqStr, request2RILStr(req.request_id),
          strlen(request2RILStr(req.request_id)) + 1);
      char* argv[2] = { 0 };
      argv[0] = reqStr;

      //cmd parameter sequence: mode.
      argv[1] = cPoint;  //flightModeOn
      sprintf(argv[1], "%d", (ims_enable == 1 ? 1 : 0));

      argc += 1;
      RLOGD("RIL_REQUEST_SET_IMS_ENABLE IMS Mode is %s-->(%s)",
          (ims_enable == 1 ? "on" : "off"), argv[1]);
      sendAtciRequest(req.request_id, reqStr, argc, argv);
      RLOGD("call atci_write_data complete %d", ims_enable);
      ret = SYS_SUCC;
      //generate response string
      break;
    }
    default: {
      ret = SYS_FAIL;
      break;
    }
    }
    if (SYS_SUCC == ret) {
      return SYS_SUCC;
    } else {
      return SYS_FAIL;
    }
}

int
atci_sys_flight_hdlr(char *cmd, int op_mode, int target, char *response) {
  int ret = SYS_FAIL;
  int flight_mode;
  char *p_out = NULL;
  atci_data_req_t req;
  //check parameter
  switch (op_mode) {
  case AT_SET_MODE:
  case AT_READ_MODE:
  case AT_ACTIVE_MODE:
  case AT_TEST_MODE: {
    //paser parameter
    //send to target handle
    //ex: at@example=string1,2,3,4
    RLOGD("input cmd[%s]", cmd);
    if (SYS_FAIL == atci_at_to_equal(&cmd)) {
      //input error
      RLOGD("input cmd[%s]", cmd);
      ret = SYS_FAIL;
      break;
    }
    RLOGD("reamin data is[%s]", cmd);

    // get int
    if (SYS_FAIL == atci_at_hasmore(&cmd)) {
      ret = SYS_FAIL;
      break;
    }
    if (SYS_FAIL == atci_at_get_nexthexint(&cmd, &flight_mode)) {
      ret = SYS_FAIL;
      break;
    }
    if (!((flight_mode == 1) || (flight_mode == 0))) {
      ret = SYS_FAIL;
      RLOGD("flight mode value set fail by user flight_mode = %d",
          flight_mode);
      break;
    }
    if (SYS_SUCC == atci_at_get_next_key(&cmd, &p_out)) {
      ret = SYS_FAIL;
      RLOGD("Fail because reamin data is[%s]", cmd);
      break;
    }
    //wrire data to target if need

    //input data
    req.request_id = RIL_REQUEST_RADIO_POWER;
    req.data_len = sizeof(flight_mode);
    req.data = &flight_mode;
    RLOGD("input req data %d", flight_mode);
    int argc = 1;
    char* cPoint;
    char parser_buf[SOCKET_BUF_SIZE] = { 0 };
    char reqStr[RIL_REQUEST_STRING_LENGTH];
    cPoint = parser_buf;
    memcpy(reqStr, request2RILStr(req.request_id),
        strlen(request2RILStr(req.request_id)) + 1);
    char* argv[2] = { 0 };
    argv[0] = reqStr;

    //cmd parameter sequence: mode.
    argv[1] = cPoint;  //flightModeOn
    sprintf(argv[1], "%d", (flight_mode == 1 ? 0 : 1));

    argc += 1;
    RLOGD("RIL_REQUEST_RADIO_POWER flight Mode is %s-->(%s)",
        (flight_mode == 1 ? "On" : "Off"), argv[1]);
    sendAtciRequest(req.request_id, reqStr, argc, argv);
    RLOGD("call atci_write_data complete %d", flight_mode);
    ret = SYS_SUCC;
    //generate response string
    break;
  }
  default: {
    ret = SYS_FAIL;
    break;
  }
  }
  if (SYS_SUCC == ret) {
    return SYS_SUCC;
  } else {
    return SYS_FAIL;
  }
}

static void* atci_sys_restart_routine(void *arg){

    usleep(RESTART_WAITING_TIME);
    sync(); /*Force the changes to disk.*/

    RLOGD("RESTART require restart, ByeBye!!!");

    syscall(SYS_reboot,LINUX_REBOOT_MAGIC1, LINUX_REBOOT_MAGIC2, LINUX_REBOOT_CMD_RESTART2, RESTART_REASON);

    return 0;
}

int atci_sys_invoke_restart(){
    int             ret;
    pthread_attr_t  attr;
    pthread_t       restart_thread;

    pthread_attr_init(&attr);

    RLOGD("create the restart thread");
    ret = pthread_create(&restart_thread, &attr, atci_sys_restart_routine, NULL);
    if(0 != ret){
        RLOGD("failed to create the restart thread");
    }

    return ret;
}

int atci_sys_restart_hdlr (char *cmd,int op_mode,int target,char *response){
    int ret;
    //check parameter

    RLOGD("atci_sys_restart_hdlr input cmd[%s]",cmd);
    switch(op_mode){
        case AT_SET_MODE:
        case AT_READ_MODE:
        case AT_ACTIVE_MODE:
        case AT_TEST_MODE:{
            //paser parameter
            //send to target handle
            //ex: at@example=string1,2,3,4

            ret = atci_sys_invoke_restart();
            break;
        }
        default:{
            ret = SYS_FAIL;
            RLOGD("Op mode error");
            break;
        }
    }

    ATCIResponse(0, ret, NULL, 0);

    if(0 == ret){
        RLOGD("Restart SUCC");
        return  SYS_SUCC;
    } else{
        RLOGD("Restart Fail");
        return SYS_FAIL;
    }
}

atci_cmd_type_t atci_sys_cmd_table[] = {
      //cmd_name          target_type                 handler
    { "AT%FLIGHT", TARGET_TELEPHONY, atci_sys_flight_hdlr },
//    { "AT%RESTART",TARGET_PLATFORM, atci_sys_restart_hdlr },
    { "AT%IMSENABLE", TARGET_TELEPHONY, atci_sys_ims_enable_hdlr },
    { NULL, TARGET_UNKNOWN, NULL }
};

int atci_sys_init(void *arg) {
  int ret;
  ret = atci_cmd_register(atci_sys_cmd_table);
  RLOGD("Init the atci sys");
  return ret;
}

