#include "common.h"
#include "lynq_common.h"
#include "lynq_data.h"
#include "lynq_network.h"
#include "stateManager/stateManager.h"
#include <string.h>
#include <stdlib.h>
#undef LOG_TAG
#define LOG_TAG "LYNQ_DATA"
#define DATA_CALL_LIST_MAX 10
//ww add @2020.7.23 for add Data api

void copyDataCallList(LYNQ_Data_Call_Response_v11 *newMsg,const RIL_Data_Call_Response_v11 oldMsg);

RIL_Data_Call_Response_v11 *
checkParcelDataCallInfo(dataCallMsg* msg,int32_t token,int time)
{
    int time_sim =time;
    int num;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    RIL_Data_Call_Response_v11 *list = NULL;
    while(time_sim--)
    {
         millli_sleep_with_restart(10);
         temp=LynqQueueHead;
         if(temp==NULL)
         {
             LYDBGLOG("Queue head is NULL, maybe malloc fail!");
             continue;
         }
         node = searchTokeninQueue(token, temp);
         if(node ==NULL)
         {
            return NULL;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             LYDBGLOG("get data call list fail, the error code is %d",node->t_Errno);
             msg->e=node->t_Errno;
             return NULL;
         }
         else
         {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {

                node->parcel.readInt32(&num);
                list = (RIL_Data_Call_Response_v11 *) calloc(1, sizeof(RIL_Data_Call_Response_v11) * num);
                for(int i =0;i<num;i++)
                {
                    node->parcel.readInt32(&list[i].status);
                    node->parcel.readInt32(&list[i].suggestedRetryTime);
                    node->parcel.readInt32(&list[i].cid);
                    node->parcel.readInt32(&list[i].active);
                    list[i].type = lynqStrdupReadString(node->parcel);
                    list[i].ifname = lynqStrdupReadString(node->parcel);
                    list[i].addresses = lynqStrdupReadString(node->parcel);
                    list[i].dnses = lynqStrdupReadString(node->parcel);
                    list[i].gateways = lynqStrdupReadString(node->parcel);
                    list[i].pcscf = lynqStrdupReadString(node->parcel);
                    node->parcel.readInt32(&list[i].mtu);

                }
                msg->e=node->t_Errno;
                msg->status = 0;
                msg->num = num;
                return list;
             }
             else
             {
               continue;
             }
         }
    }
    //printf("time_sim is %d\n",time_sim);
    return NULL;
}
//enable_data.sh 
int lynq_data_enable_data(int* PdnState) 
{
    char* mdata_apn[MAX_STRING_LEN];
    int param_num=8;
    int res=-1;
    int32_t token=0;
    int32_t tokenTemp=0;
    RIL_Data_Call_Response_v11 *list = NULL;
    dataCallMsg msg;
    msg.e=-1;
    msg.num=-1;
    msg.status=-1;
    //lynq_query_network_selection_mode();
    token = lynqNoneParame("RIL_REQUEST_SETUP_DATA_CALL");
    millli_sleep_with_restart(150);
    tokenTemp = lynqNoneParame("RIL_REQUEST_DATA_CALL_LIST");
    list = checkParcelDataCallInfo(&msg,tokenTemp,100);
    if(list==NULL)
    {
        *PdnState = -1;
    }
    else
    {
        *PdnState = 0;
        for (int i = 0; i < msg.num; i++) 
        {
            free(list[i].type);
            free(list[i].ifname);
            free(list[i].addresses);
            free(list[i].dnses);
            free(list[i].gateways);
            free(list[i].pcscf);
        }
        free(list);
    }
    lynqDeQueue(tokenTemp);
    return token;
}

//disable_data.sh
int lynq_data_dectivate_data_call(int *PdnState)
{
    //printf("ww--lynq_data_dectivate_data_call--111\r\n");
    int32_t token=0;
    int32_t tokenTemp=0;
    RIL_Data_Call_Response_v11 *list = NULL;
    dataCallMsg msg;
    token = lynqNoneParame("RIL_REQUEST_DEACTIVATE_DATA_CALL");
    //millli_sleep_with_restart(100);
    tokenTemp = lynqNoneParame("RIL_REQUEST_DATA_CALL_LIST");
    list = checkParcelDataCallInfo(&msg,tokenTemp,100);
    if(list==NULL)
    {
        *PdnState = 0;
    }
    else
    {
        *PdnState = -1;
        for (int i = 0; i < msg.num; i++) 
        {
            free(list[i].type);
            free(list[i].ifname);
            free(list[i].addresses);
            free(list[i].dnses);
            free(list[i].gateways);
            free(list[i].pcscf);
        }
        free(list);
    }
    lynqDeQueue(tokenTemp);
    return token;
}
//the max of data call list number is 10;
int lynq_get_data_call_list(LYNQ_Data_Call_Response_v11 **dataCallList,const int listNum,int *realNum)
{
    if(listNum>DATA_CALL_LIST_MAX)
    {
        LYDBGLOG("the list number is more than 10");
        return -1;
    }
    int32_t token=0;
    RIL_Data_Call_Response_v11 *list = NULL;
    dataCallMsg msg;
    token = lynqNoneParame("RIL_REQUEST_DATA_CALL_LIST");
    list = checkParcelDataCallInfo(&msg,token,100);
    if(list==NULL)
    {
        //dataCallList=NULL;
        return token;
    }
    if(listNum<msg.num)
    {
        msg.num=listNum;
        LYDBGLOG("listNum<msg.num!");
    }
    *realNum=msg.num;
    //dataCallList = (RIL_Data_Call_Response_v11 *) calloc(1, sizeof(RIL_Data_Call_Response_v11) * msg.num);
    for(int i=0;i<msg.num;i++)
    {
        copyDataCallList(dataCallList[i], list[i]);
    }
    for (int i = 0; i < msg.num; i++) 
    {
        free(list[i].type);
        free(list[i].ifname);
        free(list[i].addresses);
        free(list[i].dnses);
        free(list[i].gateways);
        free(list[i].pcscf);
    }
    free(list);
    lynqDeQueue(token);
    /*
    for(int i=0;i<msg.num;i++)
    {
        printf("test status is %d\n",dataCallList[i]->status);
        printf("test suggested is %d\n",dataCallList[i]->suggestedRetryTime);
        printf("test cid is %d\n",dataCallList[i]->cid);
        printf("test active is %d\n",dataCallList[i]->active);
        printf("test mtu is %d\n",dataCallList[i]->mtu);
        printf("test string is %s\n",dataCallList[i]->type);
        printf("test string is %s\n",dataCallList[i]->ifname);
        printf("test string is %s\n",dataCallList[i]->addresses);
        printf("test string is %s\n",dataCallList[i]->dnses);
        printf("test string is %s\n",dataCallList[i]->gateways);
        printf("test string is %s\n",dataCallList[i]->pcscf);
    }
    */
    /*
    for(int i=0;i<msg.num;i++)
    {
        printf("test status is %d\n",dataCallList[i].status);
        printf("test suggested is %d\n",dataCallList[i].suggestedRetryTime);
        printf("test cid is %d\n",dataCallList[i].cid);
        printf("test active is %d\n",dataCallList[i].active);
        printf("test mtu is %d\n",dataCallList[i].mtu);
        printf("test string is %s\n",dataCallList[i].type);
        printf("test string is %s\n",dataCallList[i].ifname);
        printf("test string is %s\n",dataCallList[i].addresses);
        printf("test string is %s\n",dataCallList[i].dnses);
        printf("test string is %s\n",dataCallList[i].gateways);
        printf("test string is %s\n",dataCallList[i].pcscf);
    }
    */
    return token;

}
void copyDataCallList(LYNQ_Data_Call_Response_v11 *newMsg,const RIL_Data_Call_Response_v11 oldMsg)
{
    newMsg->status = oldMsg.status;
    LYDBGLOG("test dataCallList status is %d,list status is %d\n",newMsg->status,oldMsg.status);
    newMsg->suggestedRetryTime = oldMsg.suggestedRetryTime;
    LYDBGLOG("test %d\n",oldMsg.suggestedRetryTime);
    newMsg->cid = oldMsg.cid;
    LYDBGLOG("test %d\n",oldMsg.cid);
    newMsg->active = oldMsg.active;
    LYDBGLOG("test %d\n",oldMsg.active);
    newMsg->mtu = oldMsg.mtu;
    LYDBGLOG("test %d\n",oldMsg.mtu);
    memcpy(newMsg->type,oldMsg.type,strlen(oldMsg.type)+1);
    LYDBGLOG("test string is %s\n",oldMsg.type);
    memcpy(newMsg->ifname,oldMsg.ifname,strlen(oldMsg.ifname)+1);
    LYDBGLOG("test string is %s\n",oldMsg.ifname);
    memcpy(newMsg->addresses,oldMsg.addresses,strlen(oldMsg.addresses)+1);
    LYDBGLOG("test string is %s\n",oldMsg.addresses);
    memcpy(newMsg->dnses,oldMsg.dnses,strlen(oldMsg.dnses)+1);
    LYDBGLOG("test string is %s\n",oldMsg.dnses);
    memcpy(newMsg->gateways,oldMsg.gateways,strlen(oldMsg.gateways)+1);
    LYDBGLOG("test string is %s\n",oldMsg.gateways);
    memcpy(newMsg->pcscf,oldMsg.pcscf,strlen(oldMsg.pcscf)+1);
    LYDBGLOG("test string is %s\n",oldMsg.pcscf);

}

