/*============================================================================= 
#     FileName: lynq_sim.cpp
#     Desc: about SIM API
#     Author: mobiletek 
#     Version: V1.0
#     LastChange: 2020-07-29 
#     History: 
=============================================================================*/
#include <dlfcn.h>
#include <string.h>
#include <stdint.h>
#include <unistd.h>
#include <fcntl.h>
#include "lynq_common.h"
#include "lynq_sim.h"
#include <stateManager/stateManager.h>

#undef LOG_TAG
#define LOG_TAG "LYNQ_SIM"
simInfoLink *simInfoLinkHead=NULL;


/*Initialize SIM infomation queue for lynq_sim API.*/
int init_sim()
{
    simInfoLinkHead=createSimInfoLink();
    if(simInfoLinkHead==NULL)
    {
        RLOGD("init sim info link head fail!");
        return -1;
    }
    RLOGD("init sim info link head success!");
    millli_sleep_with_restart(300);//The premise of obtaining imsi is that aid_ptr has been obtained
    return 0;

}
simStatus *parceToSimInfo(Parcel &p,int &len)
{
    int32_t res;
    int num=0;
    simStatus *msg=(simStatus *)malloc(sizeof(simStatus));
    p.setDataPosition(0);
    if (p.dataAvail() > 0) 
    {
        p.readInt32(&res);
        msg->card_status = (RIL_CardState)res;
        p.readInt32(&num);
        len = num;
        LYDBGLOG("[%s] num is%d\n ",__FUNCTION__,num);
        for (int i = 0; i < num; i++) //for future.
        {
            p.readInt32(&res);
            msg->card_type = (RIL_AppType)res;
            p.readInt32(&res);
            msg->pin_state = (RIL_PinState)res;
        }
        return msg;
    }
   return NULL;
}
int checkParcelSimInfo(simStatus *msg,int32_t token)
{
    int time_sim =300;//3 s.
    enum{RUN,EXIT}state;
    state=RUN;
    int length=0;
    lynqQueue *node=NULL;
    simStatus *temp=NULL;
    while(time_sim--)
    {
         millli_sleep_with_restart(10);
         node=LynqQueueHead;
         if(node==NULL)
         {
             LYDBGLOG("[%s][%d][%s] Queue head is NULL, maybe malloc fail!",__FUNCTION__,__LINE__,__FILE__);
             continue;
         }
         node = searchTokeninQueue(token, node);
         if(node ==NULL)
         {
             msg->card_status=-1;
             msg->card_type=-1;
             msg->pin_state=-1;
             msg->base.e=-1;
            return -1;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             RLOGD("get sim status fail, the error code is %d",node->t_Errno);
             msg->base.e=node->t_Errno;
             msg->card_status=-1;
             msg->card_type=-1;
             msg->pin_state=-1;
             return -1;
         }
         else
         {
             temp = parceToSimInfo(node->parcel,length);
             if(temp ==NULL )
             {
                 continue;
             }
             else
             {
                  msg->card_status=temp->card_status;
                  msg->card_type=temp->card_type;
                  msg->pin_state=temp->pin_state;
                  msg->base.e=node->t_Errno;
                  free(temp);
                  temp=NULL;
                  return 0;
             }
         }
    }
    printf("time_sim is %d\n",time_sim);
    msg->base.e=-1;
    msg->card_status=-1;
    msg->card_type=-1;
    msg->pin_state=-1;
    return -1;
}
/*return 0:success ,1:fail*/
int checkSimInfo(simStatus *msg,int32_t token)
{
    int time_sim =300;//3 s.
    enum{RUN,EXIT}state;
    state=RUN;
    printf("check sim Info start\n");
    simInfoLink *temp;
    while(time_sim--)
    {
     millli_sleep_with_restart(10);
     temp=simInfoLinkHead;
     if(temp==NULL)
     {
         RLOGD("sim info link head is NULL, maybe malloc fail!");
         continue;
     }
     do
     {
       if((temp->simInfoLen!=0)&&(temp->token==token))
       {
           if(temp->Error_tok!=RIL_E_SUCCESS)
           {
               RLOGD("get sim status fail, the error code is %d",temp->Error_tok);
               msg->base.e=temp->Error_tok;
               msg->card_status=-1;
               msg->card_type=-1;
               msg->pin_state=-1;
               return 1;
           }
           else
           {
              msg->card_status=temp->card_status;
              msg->card_type=temp->card_type;
              msg->pin_state=temp->pin_state;
              msg->base.e=temp->Error_tok;
              return 0;
           }
         }
       temp=temp->next;
     }while(temp!=NULL);
    }
    printf("time_sim is %d\n",time_sim);
    msg->card_status=-1;
    msg->card_type=-1;
    msg->pin_state=-1;
    msg->base.e=-1;
    return 0;
}
/*return 0:success ,1:fail*/
int checkParcelImsiInfo(simImsi *msg,int32_t token)
{
    int time_sim =300;//3 s.
    enum{RUN,EXIT}state;
    int num;
    state=RUN;
    printf("check IMSI Info start\n");
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    while(time_sim--)
    {
         millli_sleep_with_restart(10);
         temp=LynqQueueHead;
         if(temp==NULL)
         {
             RLOGD("sim info link head is NULL, maybe malloc fail!");
             continue;
         }
         node = searchTokeninQueue(token, temp);
         if(node ==NULL)
         {
            memset(msg->imsi,0,sizeof(msg->imsi));
            msg->base.e=-1;
            return -1;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             RLOGD("get sim status fail, the error code is %d",node->t_Errno);
             msg->base.e=node->t_Errno;
             memset(msg->imsi,0,sizeof(msg->imsi));
             return -1;
         }
         else
         {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {

                node->parcel.readInt32(&num);
                for(int i =0;i<num;i++)
                {
                   char * str=lynqStrdupReadString(node->parcel);
                   memcpy(msg->imsi,str,strlen(str)+1);
                   msg->base.e=node->t_Errno;
                }
                return 0;
             }
             else
             {
               continue;
             }
         }
    }
    printf("time_sim is %d\n",time_sim);
    msg->base.e=-1;
    memset(msg->imsi,0,sizeof(msg->imsi));
    return 0;
}
int checkImsiInfo(simImsi *msg,int32_t token)
{
    int time_sim =300;//3 s.
    enum{RUN,EXIT}state;
    state=RUN;
    printf("check IMEI Info start\n");
    simInfoLink *temp;
    while(time_sim--)
    {
     millli_sleep_with_restart(10);
     temp=simInfoLinkHead;
     if(temp==NULL)
     {
         RLOGD("sim info link head is NULL, maybe malloc fail!");
         continue;
     }
     do
     {
       if((temp->simInfoLen!=0)&&(temp->token==token))
       {
           if(temp->Error_tok!=RIL_E_SUCCESS)
           {
               RLOGD("get sim status fail, the error code is %d",temp->Error_tok);
               msg->base.e=temp->Error_tok;
               //msg->imsi = NULL;
               memset(msg->imsi,0,sizeof(msg->imsi));
               msg->base.token=token;
               return 1;
           }
           else
           {
              msg->base.e=temp->Error_tok;
              memcpy(msg->imsi,temp->imsi,strlen(temp->imsi)+1);
              //msg->imsi = temp->imsi;
              msg->base.token=token;
              return 0;
           }
         }
       temp=temp->next;
     }while(temp!=NULL);
    }
    memset(msg->imsi,0,sizeof(msg->imsi));
    //msg->imsi = NULL;
    msg->base.token=token;
    msg->base.e=-1;
    return 0;
}

/*If you need to use any API under lynq_sim, you mustfirst call the init_sim() function to initialize these functions.*/
int lynq_get_sim_status(simStatus *msg)
{
    int32_t token=0;
    int length=0;
    lynqQueue *node = NULL;
    int timeout = 500; //timeout is 5s.
    RIL_Errno err = -1;
    simStatus *temp =NULL;
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_GET_SIM_STATUS"};
    if(token = lynqNoneParame(requestStr))
    {
        msg->base.token=token;
        msg->base.request = RIL_REQUEST_GET_SIM_STATUS;
        node = commonUpdateEstatus(token,timeout,err);
        msg->base.e = err;
        if(err != RIL_E_SUCCESS)
        {
            LYDBGLOG("[%s] error code is %d!",__FUNCTION__,err);
            msg->card_status=-1;
            msg->card_type=-1;
            msg->pin_state=-1;
            lynqDeQueue(token);
            return token;
        }
        if(node)
        {
            temp = parceToSimInfo(node->parcel,length);
            if(length ==0)//it means sim card absent
            {
                msg->card_status = 0;
                msg->card_type = 0;
                msg->pin_state = 0;
            }
            else
            {
                msg->card_status=temp->card_status;
                msg->card_type=temp->card_type;
                msg->pin_state=temp->pin_state;
            }
            free(temp);
            temp = NULL;
        }
        lynqDeQueue(token);
    }
    return token;
}
/*AT> AT+CIMI     AT< IMSI*/
int lynq_get_imsi(simImsi * msg)
{
    int32_t token = 0;
    lynqQueue *node = NULL;
    int timeout = 500; //timeout is 5s.
    RIL_Errno err = -1;
    int num = 0;
    //memset(msg,0,sizeof(simImsi));
    const char requestStr[MAX_LEN] = {"RIL_REQUEST_GET_IMSI"};
    if(token = lynqNoneParame(requestStr))
    {
        msg->base.request = RIL_REQUEST_GET_IMSI;
        msg->base.token = token;
        node = commonUpdateEstatus(token,timeout,err);
        msg->base.e = err;
        if(err != RIL_E_SUCCESS)
        {
            LYDBGLOG("[%s] error code is %d!",__FUNCTION__,err);
            memset(msg->imsi,0,sizeof(msg->imsi));
            lynqDeQueue(token);
            return token;
        }
        if(node)
        {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {
                node->parcel.readInt32(&num);
                for(int i =0;i<num;i++)//for DSDS.
                {
                   char * str=lynqStrdupReadString(node->parcel);
                   memcpy(msg->imsi,str,strlen(str)+1);
                }
             }
        }
        lynqDeQueue(token);
    }
    return token;
}



