/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#ifndef YOCTO_SMS_H
#define YOCTO_SMS_H 1

#include <vendor-ril/telephony/ril.h>
#include  "common.h"

//for auto save sms to sim    
typedef struct {
    int charset;
    int sendStatus;
    char num[16];
    char sms[512];
    char smsc[16];
}smsSaveInfo;

//RIL_REQUEST_SEND_SMS
int sendSMS(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//RIL_REQUEST_SEND_SMS_EXPECT_MORE
int sendSMSExpectMore(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//RIL_REQUEST_IMS_SEND_SMS
int sendImsGsmSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int sendImsCdmaSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
/*int sendImsCdmaSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);*/
//RIL_REQUEST_WRITE_SMS_TO_SIM
int writeSmsToSim(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//RIL_REQUEST_DELETE_SMS_ON_SIM
int deleteSmsOnSim(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//RIL_REQUEST_SMS_ACKNOWLEDGE
int acknowledgeLastIncomingGsmSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//RIL_REQUEST_ACKNOWLEDGE_INCOMING_GSM_SMS_WITH_PDU
int acknowledgeIncomingGsmSmsWithPdu(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//RIL_REQUEST_REPORT_SMS_MEMORY_STATUS
int reportSmsMemoryStatus(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//RIL_REQUEST_SET_SMSC_ADDRESS
int setSmscAddress(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//RIL_REQUEST_GET_SMSC_ADDRESS
int getSmscAddress(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
void sendSMSACK(RIL_SOCKET_ID soc_id);
int responseNewSMS(const char *data, size_t datalen, int soc_id,int32_t unsol);

//#ifdef C2K_SUPPORT
int getCdmaBroadcastConfig(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int deleteSmsOnRUIM(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setCdmaBroadcastConfig(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setCdmaBroadcastActivation(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int writeSmsToRuim(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int sendCdmaSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int acknowledgeLastIncomingCdmaSms(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
//#endif /*C2K_SUPPORT*/
int getGsmBroadcastConfig(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setGsmBroadcastConfig(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setGsmBroadcastActivation(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int getSmsSimMemStatus(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setAutoSaveSmsToSimFlag(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setSimSmsStorageFullFlag(bool enable);
int autoWriteSmsToSim(smsSaveInfo *smsInfo, int id);
int saveSendedSmsInfo(int charset, char* num, char* msg, char* smsc);
int sendStatusWriteSmsToSim(int socket_id);
int unreadStatusWriteSMSToSim(const char *data, size_t datalen, int soc_id);
int gostSendSmsForMsd(int id, char *num, char *msd);
int getGsmBroadcastLanguage(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
int setGsmBroadcastLanguage(int argc, char **argv, RIL_SOCKET_ID socket_id, RequestInfo *pRI);
#endif
