#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <lynq_uci.h>
#include <log/log.h>


int lynq_del(char *option)
{
    int ret;
    char buf[LYNQ_UCI_MAX_LEN];
    struct uci_context *ctx = uci_alloc_context();
    struct uci_ptr ptr;

    sprintf(buf, "%s", option);
    if(uci_lookup_ptr(ctx, &ptr, buf, true) == UCI_OK)
    {
        uci_delete(ctx, &ptr);
        uci_save(ctx, ptr.p);
        ret = LYNQ_UCI_SUCCESS;
    }
    else
        ret = LYNQ_UCI_ERROR;

    uci_free_context(ctx);
    return ret;
}

static int uci_get_value(struct uci_option *o, char *out_buf)
{
	struct uci_element *e;
	const char *delimiter = " ";
	int lynq_uci_flag = 0;
	
	switch(o->type) {
		case UCI_TYPE_STRING:
			strcpy(out_buf, o->v.string);
			break;
		case UCI_TYPE_LIST:
			uci_foreach_element(&o->v.list, e) 
			{
				if(lynq_uci_flag)
					strcat(out_buf, delimiter);
				
				strcat(out_buf, e->name);
				lynq_uci_flag = 1;
			}
			break;
		default:
			return UCI_ERR_INVAL;
		break;
	}
    	return UCI_OK;
}

int lynq_uci_get(const char *arg, char *out_buf)
{
	struct uci_context *ctx;
	struct uci_element *e;
	struct uci_ptr ptr;
	
	int ret = UCI_OK;
	char *para_name = NULL;
	
	if(arg == NULL || out_buf == NULL) return UCI_ERR_INVAL;

    	para_name = strdup(arg);
    	if(para_name == NULL) return UCI_ERR_INVAL;
	
    	ctx = uci_alloc_context();
	if (!ctx) {
        	free(para_name);
			return UCI_ERR_MEM;
	}

	if (uci_lookup_ptr(ctx, &ptr, para_name, true) != UCI_OK) {
		uci_free_context(ctx);
		free(para_name);
		return UCI_ERR_NOTFOUND;
	}

	if(UCI_LOOKUP_COMPLETE & ptr.flags)
	{
		e = ptr.last;
		switch(e->type)
		{
		    case UCI_TYPE_SECTION:
		        ret = UCI_ERR_INVAL;
		    break;
		    case UCI_TYPE_OPTION:
		        ret = uci_get_value(ptr.o, out_buf);
		    break;
		    default:
		        ret = UCI_ERR_NOTFOUND;
		    break;
		}
	}
	else
		ret = UCI_ERR_NOTFOUND;

	uci_free_context(ctx);
	free(para_name);
	return ret;
}

int lynq_uci_set(const char *arg)
{
	struct uci_context *ctx;
	struct uci_element *e;
	struct uci_ptr ptr;
	int ret = UCI_OK;
	char *name = NULL;
	
	if(arg == NULL) return UCI_ERR_INVAL;

	name = strdup(arg);
	if(name == NULL) return UCI_ERR_MEM;

	ctx = uci_alloc_context();
	if (!ctx) {
		free(name);
		return UCI_ERR_MEM;
	}

	if (uci_lookup_ptr(ctx, &ptr, name, true) != UCI_OK) {
		uci_free_context(ctx);
		free(name);
		return UCI_ERR_NOTFOUND;
	}

	ret = uci_set(ctx, &ptr);
	if(ret != UCI_OK)
	{
	    uci_free_context(ctx);
	    free(name);
	    return ret;
	}
	
	ret = uci_save(ctx, ptr.p);
	if(ret != UCI_OK)
	{
		uci_free_context(ctx);
		free(name);
		return ret;
	}

	ret = uci_commit(ctx, &ptr.p, false);
	if(ret != UCI_OK)
	{
		uci_free_context(ctx);
		free(name);
		return ret;
	}

	uci_free_context(ctx);
	free(name);
	return ret;
}

int lynq_add_section(char *section_type, char *section)//rita add @2021.7.30 for adding section
{
	char buf[128] = "";
	sprintf(buf,"lynq_uci.%s=%s", section, section_type);
	//printf("[%s-%d] buf = %s\n", __FUNCTION__, __LINE__, buf);
	int ret = lynq_uci_set(buf);

	return ret;
}

int lynq_set_value(char *section, char *key, char *value)//rita add @2021.7.30 for setting value
{
	char buf[LYNQ_UCI_MAX_LEN] = "";

	sprintf(buf,"%s.%s.%s=%s", LYNQ_UCI_FILE, section, key, value);
	//printf("[%s-%d] buf = %s\n", __FUNCTION__, __LINE__, buf);
	int ret = lynq_uci_set(buf);
	
	return ret;
}

int lynq_get_value(char *file, char *section, char *key, char *tmp)//rita add @2021.7.30 for getting value
{
	char buf[LYNQ_UCI_MAX_LEN] = "";
	int ret = 0;
	
	if(strcmp(file, LYNQ_UCI_RO_FILE) && strcmp(file, LYNQ_UCI_FILE))
	{
		printf("[%s-%d] invalid file %s!!!\n", __FUNCTION__, __LINE__, file);
		return LYNQ_UCI_ERROR;
	}
	
	sprintf(buf,"%s.%s.%s", file, section, key);
	//printf("[%s-%d] buf = %s\n", __FUNCTION__, __LINE__, buf);
	
	ret = lynq_uci_get(buf, tmp);
	return ret;
}

int lynq_load_config(char *filename)
{
    struct uci_context * ctx = NULL;
    struct uci_element *e;
    struct uci_package * pkg = NULL;
    ctx = uci_alloc_context();
    RLOGD("uci load start \n");
    if (UCI_OK != uci_load(ctx, filename, &pkg))
    {
        RLOGD("uci config fail !!!\n");
        uci_free_context(ctx);
        ctx = NULL;
        return -1;
    }
    uci_unload(ctx, pkg);
    uci_free_context(ctx);
    RLOGD("uci config success !!!\n");
    ctx = NULL;
    return 0;
}


