#include <stdio.h>
#include <sys/types.h>    
#include <sys/stat.h>    
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include<stdlib.h>
#include "include/lynq_sim.h"
#ifdef __cplusplus
extern "C" {
#endif
#define MAX_ARGS 20
static const char *usb3_speed = "super-speed";
static const char *usb2_speed = "high-speed";
static const char *switch_info = "switching card,please waiting 10s";
static const char *switch_compelete_info = "switching card complete";
static const char *gpio_start = "starting GPIO";
static const char *end = "TO BE END";
static const char *sink = "staring sink";
static const char *adc = "staring adc";
static const char *sim = "staring sim";

static int parse_buf(char *buf,float pre,float bey,char *flag){
    float num = atoi(buf)/1000.0;
    if(num < pre || num > bey){
        printf("\033[47;31m%s FAILED\033[0m\n",flag);
    }
    return 0;
}

int lynq_dispose_factory_adc(int lynq_adc_num)
{   
    float pre = 0.89;
    float bey = 0.91;
    char *flag = "ADC";
    FILE *fp;
    char lynq_adc_dev[512] = {0};
    char lynq_adc_buf[512];
    char lynq_adc_log_buf[512];
    bzero(lynq_adc_buf, 512);
    bzero(lynq_adc_dev,512);
    bzero(lynq_adc_log_buf,512);
    if(lynq_adc_num == 0)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage0_input  2>&1");
    }
    else if(lynq_adc_num == 1)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage1_input  2>&1");
    }
    else if(lynq_adc_num == 2)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage2_input  2>&1");
    }
    else if(lynq_adc_num == 3)
    {
        sprintf(lynq_adc_dev,"cat /sys/bus/iio/devices/iio:device1/in_voltage3_input  2>&1");
    }
    else
    {
        printf("[adc][errror]:no adc device \n");
        return 0;
    }
    fp=popen(lynq_adc_dev, "r");
    fgets(lynq_adc_buf,sizeof(lynq_adc_buf),fp);    
    if(strlen(lynq_adc_buf) > 0)
    {
        sprintf(lynq_adc_log_buf,"[adc%d][result]:%s\n",lynq_adc_num,lynq_adc_buf);
        parse_buf(lynq_adc_buf,pre,bey,flag);
    }
    else
    {
        sprintf(lynq_adc_log_buf,"[adc%d][result]:error\n",lynq_adc_num);
    }
    printf("%s\n",lynq_adc_log_buf);
    pclose(fp);
    return 1;
}

int test_RGMII(void){
    printf("Testing RGMII\n");
    FILE *fp;
    fp=popen("ping -c 4 baidu.com 2>&1", "r");
    if(NULL == fp){
        printf("popen error");
        return 0;
    }
    char lynq_factory_buf[1024] = {0};
    if(NULL == fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp)){
        printf("UNKONE ERROR\n");
        pclose(fp);
        return 0;
    }
    else{
        printf("%s\n",lynq_factory_buf);
        if(strstr(lynq_factory_buf, "bad"))
            return 0;
    }
    while (NULL != fgets(lynq_factory_buf,sizeof(lynq_factory_buf),fp))
    {
        printf("%s\n",lynq_factory_buf);
    }
    pclose(fp);
    printf("%s\n",end);
    return 0;
}

int lynq_check_emmc()
{
    FILE *fp;
    char emmc_buf[100] = {0};
    char buf[100] = {0};
    sprintf(emmc_buf, "ls /dev | grep mmcblk0  2>&1");
    fp=popen(emmc_buf, "r");
    if(!fp){
        printf("\n+CME: POPEN ERROR\n");
        return -1;
    }
    while(fgets(buf, sizeof(buf), fp) != NULL){
        printf("[EMMC] EMMC OK \n"); 
        pclose(fp);
        return 0;   
    }
    printf("\033[47;31m[EMMC] NO EMMC\033[0m\n");
    pclose(fp);
    return 0;
}

int lynq_check_gpio()
{
    #if 0
    FILE *fp;
    int lynq_gpio_arr[88] = {6,230,231,232,233,234,102,104,103,101,186,188,187,185,194,196,195,193,205,204,203,202,199,200,201,190,192,191,189,173,174,175,176,170,169,184,183,182,181,24,25,23,25,157,158,155,156,143,144,140,141,153,154,180,179,29,30,178,177,7,5,4,113,112,116,115,114,107,108,105,106,100,99,98,97,94,93,92,91,1,130,41,67,69,68,63};
    char lynq_show_gpio_state[64] = {0};
    char lynq_set_gpio_arr[256] = {0};
    char lynq_get_gpio_state[512] = {0};
    int lynq_gpio_low = 0;
    int lynq_gpio_hig = 0;
    int i = 0;
    for(i = 0; i < 58; i++)
    {
        lynq_gpio_low = 0;
        lynq_gpio_hig = 0;
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo mode %d 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio & echo dir %d 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio & echo out %d 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio",lynq_gpio_arr[i],lynq_gpio_arr[i],lynq_gpio_arr[i]);
        system(lynq_set_gpio_arr);
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio |grep %03d",lynq_gpio_arr[i]);
        fp=popen(lynq_set_gpio_arr, "r");
        bzero(lynq_get_gpio_state, 512);
        fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
        pclose(fp);
        if(lynq_get_gpio_state[6] == '0')
        {
            lynq_gpio_low = 1;
        }
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"echo mode %d 0 >/sys/devices/platform/10005000.pinctrl/mt_gpio & echo dir %d 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio & echo out %d 1 >/sys/devices/platform/10005000.pinctrl/mt_gpio",lynq_gpio_arr[i],lynq_gpio_arr[i],lynq_gpio_arr[i]);
        system(lynq_set_gpio_arr);
        bzero(lynq_set_gpio_arr, 256);
        sprintf(lynq_set_gpio_arr,"cat /sys/devices/platform/10005000.pinctrl/mt_gpio |grep %03d:",lynq_gpio_arr[i]);
        fp=popen(lynq_set_gpio_arr, "r");
        bzero(lynq_get_gpio_state, 512);
        fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
        pclose(fp);
        if(lynq_get_gpio_state[6] == '1')
        {
            lynq_gpio_hig = 1;
        }
        bzero(lynq_show_gpio_state, 64);
        if((lynq_gpio_low == 1) && (lynq_gpio_hig == 1))
        {
            sprintf(lynq_show_gpio_state,"[gpio%d][result]:PASS \n",lynq_gpio_arr[i]);
        }
        else
        {
            sprintf(lynq_show_gpio_state,"[gpio%d][result]:FAIL \n",lynq_gpio_arr[i]);
        }
        printf("%s\n",lynq_show_gpio_state);
    }
    #endif
    FILE *fp;
    char lynq_usb_dev[52] = {0};
    sprintf(lynq_usb_dev,"source /data/test/T800_GPIO_TEST.sh  2>&1");
    fp=popen(lynq_usb_dev, "r");
    char lynq_usb_buf[512];
    if(NULL == fp){
        printf("popen errorn");
        return 0;
    }
    while(NULL != fgets(lynq_usb_buf,sizeof(lynq_usb_buf),fp)){
       printf("%s\n",lynq_usb_buf);
    }
    pclose(fp);
   return 0;
}

int lynq_dispose_factory_usb()
{
    FILE *fp;
    char lynq_usb_dev[512] = {0};
    char lynq_usb_buf[512];
    bzero(lynq_usb_buf, 512);
    bzero(lynq_usb_dev,512);
    sprintf(lynq_usb_dev,"cat /sys/devices/platform/11201000.usb/udc/11201000.usb/current_speed  2>&1");

    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_usb_buf,sizeof(lynq_usb_buf),fp);
    if(!strncmp(lynq_usb_buf,usb3_speed,strlen(usb3_speed)))
    {   
        printf("[usb][result],3.0 \n");
    }
    else if(!strncmp(lynq_usb_buf,usb2_speed,strlen(usb2_speed)))
    {
        printf("[usb][result],2.0 \n");
    }
    else
    {
        printf("[usb][rat][UNKNOWN] \n");
    }
    pclose(fp);
    return 1;
}



int lynq_test_sink(){
    float pre;
    float bey;
    char *flag = "SINK";
    FILE *fp;
    char lynq_usb_dev[512] = {0};
    char lynq_usb_buf[512] = {0};
    char buf[512] = {0};
    int sink[3][3] = {{255,0,0},{0,255,0},{0,0,255}};
    char dev_buf[][40]={{"green:cellular-radio/brightness"},{"green:cellular-quality/brightness"},{"red:system/brightness"}};
    int i;
    int j;
    int k = 15;
    int cnt = 1;
    for(i = 0;i < 3;i++){
        if(i == 0){
            pre = 0.9;
            bey = 1.3;
        }
        if(i == 1){
            pre = 0.8;
            bey = 1.3;
        }
        if(i == 2){
            pre = 0.9;
            bey = 1.2;
        }
        bzero(lynq_usb_buf, 512);
        bzero(buf, 512);
        k = 15;
        for(j = 0;j < 3;j++){
            bzero(lynq_usb_dev, 512);
            sprintf(lynq_usb_dev,"echo %d >  /sys/class/leds/led95%d:%s  2>&1", sink[i][j], k++, dev_buf[j]);
            fp=popen(lynq_usb_dev, "r");
        }
        sprintf(lynq_usb_buf,"cat /sys/bus/iio/devices/iio:device1/in_voltage4_input  2>&1");
        fp=popen(lynq_usb_buf, "r");
        fgets(buf,sizeof(buf),fp);
        parse_buf(buf,pre,bey,flag);
        printf("[sink%d] %s\n",cnt++,buf);
    }
    pclose(fp);
    return 1;
}

int lynq_judge_sim_state(int *state){
    int res = lynq_get_sim_status(state);
    if(!res){
        if(*state == 1){
            printf("[SIM]:SUCCESS\n");
            printf("[SIM]:CARD STATE:%d\n",*state);
        }
        else{
            printf("\033[47;31m[SIM]:FAILED\033[0m\n");
            printf("[SIM]:CARD STATE:%d\n",*state);
        }
        return res;
    }
    else{
        printf("\033[47;31m[SIM]:FAILED\033[0m\n");
        return res;
    }
}

int lynq_gps_start(void){
    system("echo \"EPO_enabled=1\">/etc/gnss/mnl.pro");
    system("echo \"debug.dbg2file=1\">/etc/gnss/mnl.prop");
    system("mnld_test start &");
    return 0;
}

int lynq_gps_close(void){
    system("killall mnld_test");
    sleep(1);
    system("cat /etc/gnss/*.nma");
    return 0;
}

int print_info(int second){
    int i = 0;
    char bar[200] = {0};
    char *lab = "-\\|/";
    int cnt = 0;
    while (i <= 100)
    {
        printf("[%-101s][%d%%][%c]\r",bar,cnt,lab[i%4]);
        cnt+=second;
        fflush(stdout);
        sleep(1);
        for(int j = 0;j < second;j++){
            bar[i++]='#';
            bar[i] = '\0';
        }
    }
    printf("\n");
    return 0;
}

int lynq_check_pcie(void){
    FILE *fp;
    char lynq_usb_dev[128] = {0};
    char lynq_get_gpio_state[512] = {0};
    sprintf(lynq_usb_dev,"cat sys/devices/platform/10005000.pinctrl/mt_gpio |grep 097  2>&1");
    fp=popen(lynq_usb_dev, "r");
    fgets(lynq_get_gpio_state,sizeof(lynq_get_gpio_state),fp);
    pclose(fp);
    if(lynq_get_gpio_state[6] == '1')
    {
        printf("PCIE SUCCESS\n");
    }
    else{
        printf("\033[47;31mPCIE FAILED\033[0m\n");
    }
    return 0;
}

int main(void){
    printf("GPS is open\n");
    lynq_gps_start();
    int utoken = 123;
    int x = -1;
    int y = -1;
    int res = -1;
    int *state = &x;
    char imsi[21] = {0};
    lynq_sim_init(utoken);
    sleep(1);
    char imei[32] = {0};
    lynq_get_imei(imei);
    printf("IMEI: %s\n", imei);
    lynq_judge_sim_state(state);
    print_info(50);
    int slot = 1;
    res = lynq_switch_card(slot);
    printf("%s\n",switch_info);
    print_info(10);
    printf("%s\n",switch_compelete_info);
    int *card_sim = &y;
    bzero(imsi,21);
    lynq_judge_sim_state(card_sim);
    printf("PCIE Testing\n");
    print_info(50);
    lynq_check_pcie();
    printf("GPIO Testing\n");
    print_info(50);
    lynq_check_gpio();
    printf("ADC Testing\n");
    print_info(50);
    for(int i = 0;i < 4;i++){
        lynq_dispose_factory_adc(i);
    }
    printf("RGMII/SGMII Testing\n");
    print_info(50);
    test_RGMII();
    printf("SINK Testing\n");
    print_info(50);
    lynq_test_sink();
    printf("USB Testing\n");
    print_info(50);
    lynq_dispose_factory_usb();
    printf("EMMC Testing\n");
    print_info(50);
    lynq_check_emmc();
    sleep(1);
    printf("Factory test is done,starting output nema,please waiting 100s\n");
    print_info(1);
    lynq_gps_close();
    return 0;
}
#ifdef __cplusplus
}
#endif 