#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <strings.h>
#include<stdlib.h>
#include "liblog/liblog.h"
#include "liblog/lynq_deflog.h"

#define USER_LOG_TAG "TCPCLI"
#define SA struct sockaddr
#define BUF_LEN 128
#define ERR_CMDVALID  2	
#define ERR_SOCK  3

int main(int argc, const char *argv[])
{
	int sockfd;
	char buf[BUF_LEN];
	int ret_con;
	
	LYLOGEINIT(USER_LOG_TAG);    
	if(argc<3)
	{
		LYDBGLOG("arg is wrong, please input ip and port\n");
		LYVERBLOG("+[tcpcli]: error num = %d\n", ERR_CMDVALID);
		return ERR_CMDVALID;
	}

	sockfd=socket(AF_INET,SOCK_STREAM,0);

	if(sockfd<0)
	{
		LYDBGLOG("fail to socket\n");
		return ERR_SOCK;
	}
	struct sockaddr_in seraddr;
	seraddr.sin_family=AF_INET;
	seraddr.sin_port=htons(atoi(argv[2]));
	seraddr.sin_addr.s_addr=inet_addr(argv[1]);


	while(1)
	{
		ret_con=connect(sockfd,(SA *)&seraddr,sizeof(seraddr));
		if(ret_con<0)
		{
			LYDBGLOG("fail to connect\n");
			return ERR_SOCK;
		}
		while(1)
		{
			bzero(buf,sizeof(buf));
			fgets(buf,sizeof(buf),stdin);

			send(sockfd,buf,sizeof(buf),0);

			bzero(buf,sizeof(buf));
			recv(sockfd,buf,sizeof(buf),0);

			LYVERBLOG("+[tcpcli]: cli_rcv = %s\n",buf);
		}
	}
	
	return 0;
}
