/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SSLP_ECALL_ECALLUTILS_H_
#define SSLP_ECALL_ECALLUTILS_H_

#include <cstdint>
#include <string>

class EcallUtils {
public:
    EcallUtils();
    virtual ~EcallUtils();
    const std::string& getEcallMsdReq() const;
    void setEcallMsdReq(const std::string ecallMsdReq);
    std::uint8_t getEcallReq() const;
    void setEcallReq(std::uint8_t ecallReq);
    std::int32_t getMid() const;
    void setMid(std::int32_t mid);
    std::uint8_t getTransport() const;
    void setTransport(std::uint8_t transport);

    int decodeECallCmd(std::uint16_t cmd, const std::string& data);

    static bool isEcallCmd(std::uint16_t cmd);
    const std::string& getNumber() const;
    void setNumber(const std::string number);
    bool isNeedNewSms();
    int getEcallReqPara();
public:

    //EGTS_ECALL_SERVICE  7.2 47page , accident emergency response service
    static constexpr std::uint8_t EGTS_SR_RECORD_RESPONSE=0; // EGTS_PT_APPDATA_type
    static constexpr std::uint8_t  EGTS_SR_ACCEL_DATA = 20; //GPRS transfer
    static constexpr std::uint8_t EGTS_SR_RAW_MSD_DATA = 40;
    static constexpr std::uint8_t EGTS_SR_RAW_TRACK_DATA = 62; //GPRS transfer

private:
    //EGTS_ECALL_REQ
    std::uint8_t ecallReq = 0;

    //EGTS_ECALL_MSD_REQ
    std::string ecallMsdReq = "";
    std::int32_t mid = 0;
    std::uint8_t transport = 2;

    //EGTS_ECALL_SMS_FALLBACK_NUMBER
    std::string number = "112";

    int decodeMsgReq(const std::string& data);
    int decodeReq(const std::string& data);

public:
    //List of commands sent to IVDS table46 p52.
    //parameters. uint8_t , 0 - manual call; 1-automatic call
    static constexpr std::uint16_t EGTS_ECALL_REQ = 0x0112;
    //parameters. int32_t MID: message identifier of the requested MSD.
    //            uint8_t TRANSPORT: 0-any, to be selected by the IVDS, 2-SMS
    static constexpr std::uint16_t EGTS_ECALL_MSD_REQ = 0x0113;
    static constexpr std::uint16_t EGTS_ACCEL_DATA = 0x0114;
    static constexpr std::uint16_t EGTS_TRACK_DATA = 0x0115;
    static constexpr std::uint16_t EGTS_ECALL_DEREGISTRATION = 0x116;

    //list of IVDS parameters.table47 p52

    ///General-purpose settings
    static constexpr std::uint16_t EGTS_ECALL_TEST_NUMBER = 0x020D;

    //service configuration and configuration data. Base Service of Road Accident Emergency Response System.
    static constexpr std::uint16_t EGTS_ECALL_ON = 0x0210;
    static constexpr std::uint16_t EGTS_ECALL_CRASH_SIGNAL_INTERNAL = 0x0211;
    static constexpr std::uint16_t EGTS_ECALL_CRASH_SIGNAL_EXTERNAL = 0x0212;
    static constexpr std::uint16_t EGTS_ECALL_SOS_BUTTON_TIME = 0x0213;
    static constexpr std::uint16_t EGTS_ECALL_NO_AUTOMATIC_TRIGGERING = 0x0214;
    static constexpr std::uint16_t EGTS_ASI15_TRESHOLD = 0x0215;
    static constexpr std::uint16_t EGTS_ECALL_MODE_PIN = 0x0216;
    static constexpr std::uint16_t EGTS_ECALL_CCFT = 0x0217;
    static constexpr std::uint16_t EGTS_ECALL_INVITATION_SIGNAL_DURATION = 0x0218;
    static constexpr std::uint16_t EGTS_ECALL_SEND_MSG_PERIOD = 0x0219;
    static constexpr std::uint16_t EGTS_ECALL_AL_ACK_PERIOD = 0x021A;
    static constexpr std::uint16_t EGTS_ECALL_MSD_MAX_TRANSMISSON_TIME = 0x021B;
    static constexpr std::uint16_t EGTS_ECALL_NAD_DEREGISTRATION_TIMER = 0x021D;
    static constexpr std::uint16_t EGTS_ECALL_DIAL_DURATION = 0x021E;
    static constexpr std::uint16_t EGTS_ECALL_AUTO_DIAL_ATTEMPTS = 0x021F;
    static constexpr std::uint16_t EGTS_ECALL_MANUAL_DIAL_ATTEMPTS = 0x0220;
    static constexpr std::uint16_t EGTS_ECALL_MANUAL_CAN_CANCEL = 0x0222;
    static constexpr std::uint16_t EGTS_ECALL_SMS_FALLBACK_NUMBER = 0x0223;

    //Acceleration profile recording in case of road accidents
    static constexpr std::uint16_t IGNITION_OFF_FOLLOW_UP_TIME1 = 0x0224;
    static constexpr std::uint16_t IGNITION_OFF_FOLLOW_UP_TIME2 = 0x0225;
    static constexpr std::uint16_t EGTS_CRASH_RECORD_TIME = 0x0251;
    static constexpr std::uint16_t EGTS_CRASH_RECORD_RESOLUTION = 0x0252;
    static constexpr std::uint16_t EGTS_CRASH_PRE_RECORD_TIME = 0x0253;
    static constexpr std::uint16_t EGTS_CRASH_PRE_RECORD_RESOLUTION = 0x0254;
    static constexpr std::uint16_t EGTS_TRACK_RECORD_TIME = 0x025A;
    static constexpr std::uint16_t EGTS_TRACK_PRE_RECORD_TIME = 0x025B;
    static constexpr std::uint16_t EGTS_TRACK_RECORD_RESOLUTION = 0x025C;

    //vehicle parameters
    static constexpr std::uint16_t EGTS_VEHICLE_VIN = 0x0311;
    static constexpr std::uint16_t EGTS_VEHICLE_PROPULSION_STORAGE_TYPE = 0x0313;
    static constexpr std::uint16_t EGTS_VEHICLE_TYPE = 0x0312;

};

#endif /* SSLP_ECALL_ECALLUTILS_H_ */
