/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SRC_EM_NETWORKINFO_NETWORKINFOURCPARSER_H_
#define SRC_EM_NETWORKINFO_NETWORKINFOURCPARSER_H_

#include <string>
#include <vector>
class NetworkInfoUrcParser {
public:
    NetworkInfoUrcParser();
    virtual ~NetworkInfoUrcParser();
private:
    static const int DATA_OFFSET_2;
    static const int DATA_OFFSET_4;
    static const int DATA_OFFSET_6;
    static const int DATA_OFFSET_8;
    static const int DATA_FORMAT;
    static const int MAX_DATA_PER_LINE;

    static const int TYPE_UINT8;
    static const int TYPE_UINT16;
    static const int TYPE_UINT32;
    static const int TYPE_INT8;
    static const int TYPE_INT16;
    static const int TYPE_INT32;
    static const int TYPE_LONG;
    static const int TYPE_FLOAT;
    static const int TYPE_ALIGNMENT;
    static const int TYPE_STRING;

    static const bool ALIGN_MENT_ENABLE;
    static const bool GPRS_MODE_ENABLE;
    static const bool AMR_SUPPORT_ENABLE;
    static const bool FWPNC_LAI_INFO_ENABLE;
    static const bool UMTS_R8;
    static const bool WISDOM_EM;
    static const bool ADVANCED_EM;
    static const bool IS_MOLY;

    static const int MODEM_FDD;
    static const int MODEM_TD;

    std::string mRawString;
    std::string mResult;
    int mOffset;
    std::vector<std::string> mRawValues;
    std::vector<std::string>  mLabels;
    int mColumn;
    int mType;
private:
    /**
     * @param data
     *            the value of the bit
     * @param start
     *            the integer of the start position
     * @param signed
     *            the boolean of the signed is false
     * @return the value of the String for every item
     */
    std::string getValueFrom4Byte(std::string data, int start, bool sig);
    /**
     * @param data
     *            the String of the network item information
     * @param start
     *            the value of the network item start position bit
     * @param dataLength
     *            the block total bit
     * @param signed
     *            the define value is false
     * @return the block value to display
     */
    std::string oneBlockFrom4Byte(std::string label, std::string data, int start,bool sig, int dataLength);
    /**
     * @param data
     *            the value of the bit
     * @param start
     *            the integer of the start position
     * @param signed
     *            the boolean of the signed is false
     * @return the value of the String for every item
     */
    std::string getValueFrom2Byte(std::string data, int start, bool sig);
    /**
     * @param data
     *            the String of the network item information
     * @param start
     *            the value of the network item start position bit
     * @param dataLength
     *            the block total bit
     * @param signed
     *            the define value is false
     * @return the block value to display
     */
    std::string oneBlockFrom2Byte(std::string label, std::string data, int start,bool sig, int dataLength);
    /**
     * @param data
     *            the value of the bit
     * @param start
     *            the integer of the start position
     * @param signed
     *            the boolean of the signed is false
     * @return the value of the String for every item
     */
    std::string getValueFromByte(std::string data, int start, bool sig);
    /**
     * @param data
     *            the String of the network item information
     * @param start
     *            the value of the network item start position bit
     * @param dataLength
     *            the block total bit
     * @param signed
     *            the define value is false
     * @return the block value to display
     */
    std::string oneBlockFromByte(std::string label, std::string data, int start,bool sig, int dataLength);
    std::string parseElement(int type, std::string label);
    std::string parseElement(int type, std::string label, int count);
    int readIntegerFromByte();
    int readIntegerFrom2Byte();
    /*
     * Modem will encode mcc/mnc before sending to AP, so decode it.
     * Encoding algorithm:
     * Suppose MCC is "abc", then encoded MCC will be:
     * 100 * (a == 0 ? 10 : a) + 10 * (b == 0 ? 10 : b) + (c == 0 ? 10 : c) - 111;
     * Suppose MNC is "ab", then encoded MNC will be:
     * 10 * (a == 0 ? 10 : a) + (b == 0 ? 10 : b) - 11;
     */
    std::string decodeMcc(int value);
    std::string decodeMnc(int value);
    std::vector<std::vector<std::string>> parseCommonCdmaInfo();
    std::vector<std::vector<std::string>> parseCellInfo();
    std::vector<std::vector<std::string>> parse1xRttServing();
    std::string nextValue();

public:
    /**
     * @param type
     *            the integer of the network item to view
     * @return the value of the network item to display
     */
    std::string parseInfo(int type, std::string info, int simType);
    /**
     * @return the cellSel information (rr_em_cell_select_para_info_struct)
     */
    std::string getCellSelInfo();
    /**
     * @return the ChDscr information (rr_em_channel_descr_info_struct)
     */
    std::string getChDscrInfo();
    /**
     * @return the RACHCtrl information (rr_em_rach_ctrl_para_info_struct)
     */
    std::string getRACHCtrlInfo();
    /**
     * @return the LAI information
     */
    std::string getLAIInfo();
    /**
     * @return the Radio Link information (rr_em_radio_link_counter_info_struct)
     */
    std::string getRadioLinkInfo();
    /**
     * @return the MeasRep information (rr_em_measurement_report_info_struct)
     */
    std::string getMeasRepInfo();
    /**
     * @return the Calist information (rr_em_ca_list_info_struct)
     */
    std::string getCaListInfo();
    /**
     * @return the ControlMsg information (rr_em_control_msg_info_struct)
     */
    std::string getControlMsgInfo();
    /**
     * @return the SI2Q information (rr_em_si2q_info_struct)
     */
    std::string getSI2QInfo();
    /**
     * @return the MI information (rr_em_mi_info_struct)
     */
    std::string getMIInfo();
    /**
     * @return the BLK information (rr_em_blk_info_struct)
     */
    std::string getBLKInfo();
    /**
     * @return the TBF information (rr_em_tbf_status_struct)
     */
    std::string getTBFInfo();
    /**
     * @return the GPRS GEN information (rr_em_gprs_general_info_struct)
     */
    std::string getGPRSGenInfo();
    std::string get3GGeneralInfo();
    /**
     * @return the slce voice information
     */
    std::string getSlceVoiceInfo();
    /**
     * @return the slce voice information
     */
    std::string getSecurityConfigInfo();
    /**
     * @return the 3G memory information (mm_em_info_struct)
     */
    std::string get3GMmEmInfo();
    std::string getSmEmInfo();
    std::string getGmmEmInfo();
    /**
     * @return the 3G Tcm information (tcm_mmi_em_info_struct)
     */
    std::string get3GTcmMmiEmInfo();
    /**
     * @return the 3G CsceEMServCellSStatusInd information (csce_em_serv_cell_s_status_ind_struct)
     */
    std::string get3GCsceEMServCellSStatusInd(bool isTdd);
    /**
     * @return the 3G CsceEmInfoMultiPlmn information (csce_em_info_multiple_plmn_struct)
     */
    std::string get3GCsceEmInfoMultiPlmn();

    /**
     * @return the 3G MemeEmInfoUmtsCellStatus information (meme_em_info_umts_cell_status_struct)
     */
    std::string get3GMemeEmInfoUmtsCellStatus();
    /**
     * @return the 3G MemeEmPeriodicBlerReport information (ul2_em_periodic_bler_report_ind)
     */
    std::string get3GMemeEmPeriodicBlerReportInd();
    /**
     * @return the 3G UrrUmtsSrnc information (urr_umts_srnc_id_struct)
     */
    std::string get3GUrrUmtsSrncId();
    /**
     * @return the 3G SlceEmPsDataRateStatus information (slce_em_ps_data_rate_status_ind_struct)
     */
    std::string get3GSlceEmPsDataRateStatusInd();
    /**
     * @return the 3G MemeEmInfoHServCell information (meme_em_info_h_serving_cell_ind_struct)
     */
    std::string get3GMemeEmInfoHServCellInd();
    /**
     * @return the 3G HandoverSequence information (uas_em_handover_status)
     */
    std::string get3GHandoverSequenceIndStuct();
    /**
     * @return the Control channel information (rr_em_ctrl_channel_descr_info_struct)
     */
    std::string getCtrlchanInfo();
    /**
     * @return the 3G Ul2EmAdmPoolStatus information (ul2_em_adm_pool_status_ind_struct)
     */
    std::string get3GUl2EmAdmPoolStatusIndStruct();
    /**
     * @param isTdd
     *            is tdd or not
     *
     * @return the 3G CsceEMNeighCellSStatus information (csce_em_neigh_cell_s_status_ind_struct)
     */
    std::string getxGCsceEMNeighCellSStatusIndStructSize(bool isTdd);

    /**
     * @return the 3G Ul2EmPsDataRateStatus information (ul2_em_ps_data_rate_status_ind_struct)
     */
    std::string get3GUl2EmPsDataRateStatusIndStruct();
    /**
     * @return the 3G ul2EmHsdschReconfigStatus information
     *         (ul2_em_hsdsch_reconfig_status_ind_struct)
     */
    std::string get3Gul2EmHsdschReconfigStatusIndStruct();
    /**
     * @return the 3G Ul2EmUrlcEventStatus information (ul2_em_urlc_event_status_ind_struct)
     */
    std::string get3GUl2EmUrlcEventStatusIndStruct();
    /**
     * @return the 3G Ul2EmPeriodicBlerReport information (ul2_em_periodic_bler_report_ind)
     */
    std::string get3GUl2EmPeriodicBlerReportInd();
    std::vector<std::string> parseSecurityStatus(int type, std::string info);
    std::vector<std::string> parseAntennaDiversity(int type, std::string info);
    /**
     * Parse CDMA info.
     *
     * @param type
     *            info type
     * @param info
     *            info content
     * @return formated info
     */
    std::vector<std::vector<std::string>> parseCdmaInfo(int type, std::string info);

};

#endif /* SRC_EM_NETWORKINFO_NETWORKINFOURCPARSER_H_ */
