#include "common.h"
#include "lynq_common.h"
#include "lynq_data.h"
#include <pthread.h>
#include "lynq_network.h"
#include "stateManager/stateManager.h"
#include <string.h>
#include <sys/time.h>

#include <stdlib.h>
#undef LOG_TAG
#define LOG_TAG "LYNQ_DATA"
#define DATA_CALL_LIST_MAX 10
//Warren add @2020.7.23 for add Data api

void copyDataCallList(LYNQ_Data_Call_Response_v11 *newMsg,const RIL_Data_Call_Response_v11 oldMsg);
typedef struct{
    int status;//pdn connect status.
    //int addr;//ccmnil addr.
    int num;
    RIL_Errno e;
}dataCallMsg;

RIL_Data_Call_Response_v11 *
checkParcelDataCallInfo(dataCallMsg* msg,int32_t token,int time)
{
    int time_sim =time;
    int num;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    RIL_Data_Call_Response_v11 *list = NULL;
    while(time_sim--)
    {
         millli_sleep_with_restart(10);
         temp=LynqQueueHead;
         if(temp==NULL)
         {
             LYDBGLOG("Queue head is NULL, maybe malloc fail!");
             continue;
         }
         node = searchTokeninQueue(token, temp);
         if(node ==NULL)
         {
            return NULL;
         }
         if(node->t_Errno!=RIL_E_SUCCESS)
         {
             LYDBGLOG("get data call list fail, the error code is %d",node->t_Errno);
             msg->e=node->t_Errno;
             return NULL;
         }
         else
         {
            node->parcel.setDataPosition(0);
            if (node->parcel.dataAvail() > 0) 
            {

                node->parcel.readInt32(&num);
                list = (RIL_Data_Call_Response_v11 *) calloc(1, sizeof(RIL_Data_Call_Response_v11) * num);
                for(int i =0;i<num;i++)
                {
                    node->parcel.readInt32(&list[i].status);
                    node->parcel.readInt32(&list[i].suggestedRetryTime);
                    node->parcel.readInt32(&list[i].cid);
                    node->parcel.readInt32(&list[i].active);
                    list[i].type = lynqStrdupReadString(node->parcel);
                    list[i].ifname = lynqStrdupReadString(node->parcel);
                    list[i].addresses = lynqStrdupReadString(node->parcel);
                    list[i].dnses = lynqStrdupReadString(node->parcel);
                    list[i].gateways = lynqStrdupReadString(node->parcel);
                    list[i].pcscf = lynqStrdupReadString(node->parcel);
                    node->parcel.readInt32(&list[i].mtu);

                }
                msg->e=node->t_Errno;
                msg->status = 0;
                msg->num = num;
                return list;
             }
             else
             {
               continue;
             }
         }
    }
    //printf("time_sim is %d\n",time_sim);
    return NULL;
}
/*Warren add for T800 platform start 2021/11/10*/
int lynq_init_data(lynq_data_call_state_cb data_cb)
{
    if(data_cb==NULL)
    {
       RLOGD("data cb is null!!!");
       return -1;
    }
    lynqp_thread_cond_init();
    dataCb=data_cb;
    return 0;
}
int lynq_attch_network(int *handle,RIL_Errno *err_code)
{
    int ret = 0;
    char argv[2] = {};
    if(handle==NULL)
    {
        return -1;
    }
    argv[0] = "RIL_REQUEST_ALLOW_DATA";
    argv[1] = "1";
    return 0;
}
int lynq_deattch_network(int *handle,RIL_Errno *err_code)
{
    return 0;
}
int lynq_setup_data_call(int *handle,char ifaceName[],RIL_Errno *err_code)
{
    int ret = 0;
    char apn[100] = {};
    char apnType[50] = {};
    char iface[50] = {};
    if(ifaceName==NULL||handle==NULL||err_code==NULL)
    {
        return -1;
    }
    *handle = lynqNoneParame("RIL_REQUEST_SETUP_DATA_CALL");
    ret = lynqWaitRespWithTime(LYNQ_EVENT_WAIT_TIME_MAX);
    if(ret==ETIMEDOUT)
    {
        *err_code = (RIL_Errno)LYNQ_E::LYNQ_E_TIME_OUT;
        //lynqNoneParame("RIL_REQUEST_DEACTIVATE_DATA_CALL");
        return 0;
    }
    for(int i = 0;i < LYNQ_APN_LEN_MAX;i++)
    {
        if(strcmp(apn_table[i].apntype,"default")==0)
        {
            memcpy(ifaceName,apn_table[i].ifaceName,strlen(apn_table[i].ifaceName)+1);
            break;
        }
    }
    printf("[lynq_setup_data_call] test 001\n");
    *err_code = RIL_Errno::RIL_E_SUCCESS;
    return 0;
}
int lynq_deactive_data_call(int *handle,RIL_Errno *err_code)
{
    int ret = 0;
    if(handle==NULL||err_code==NULL)
    {
        return -1;
    }
    *handle = lynqNoneParame("RIL_REQUEST_DEACTIVATE_DATA_CALL");
    ret = lynqWaitRespWithTime(LYNQ_EVENT_WAIT_TIME_MAX);
    if(ret==ETIMEDOUT)
    {
        *err_code = (RIL_Errno)LYNQ_E::LYNQ_E_TIME_OUT;
        return 0;
    }
    *err_code = RIL_Errno::RIL_E_SUCCESS;
    return 0;
}
int lynq_setup_data_call_sp(int *handle,char *apn,char *apnType,char *user,char *password,char *authType,char *normalProtocol,char *roamingProtocol,char ifaceName[],RIL_Errno *err_code)
{
    int ret = 0;
    char apn_t[100] = {};
    char apnType_t[50] = {};
    char iface_t[50] = {};
    char *argv[10] = {};
    char *tigger_argv[2] = {};
    if(handle==NULL||apn==NULL||apnType==NULL||ifaceName==NULL||err_code==NULL)
    {
        return -1;
    }
    argv[0] = "RIL_REQUEST_SETUP_DATA_CALL";
    argv[1] = apn;
    argv[2] = apnType;
    if(user==NULL)
    {
        argv[3] = "null";
    }
    else
    {
        argv[3] = user;
    }
    if(password==NULL)
    {
        argv[4] = "null";
    }
    else
    {
        argv[4] = password;
    }
    if(authType==NULL)
    {
        argv[5] = "null";
    }
    else
    {
        argv[5] = authType;
    }
    if(normalProtocol==NULL)
    {
        argv[6] = "null";
    }
    else
    {
        argv[6] = normalProtocol;
    }
    if(roamingProtocol==NULL)
    {
        argv[7] = "null";
    }
    else
    {
        argv[7] = roamingProtocol;
    }
    *handle = android::getRequestData(argv,8);
    ret = lynqWaitRespWithTime(LYNQ_EVENT_WAIT_TIME_MAX);
    if(ret==ETIMEDOUT)
    {
        *err_code = (RIL_Errno)LYNQ_E::LYNQ_E_TIME_OUT;
        //tigger_argv[0] = "RIL_REQUEST_DEACTIVATE_DATA_CALL";
        //tigger_argv[1] = apnType;
        //android::getRequestData(tigger_argv,2);
        return 0;
    }
    for(int i = 0;i < LYNQ_APN_LEN_MAX;i++)
    {
        if(strcmp(apn_table[i].apntype,apnType)==0)
        {
            memcpy(ifaceName,apn_table[i].ifaceName,strlen(apn_table[i].ifaceName)+1);
            break;
        }
    }
    *err_code = RIL_Errno::RIL_E_SUCCESS;
    return 0;
}
int lynq_deactive_data_call_sp(int *handle,char *apnType,RIL_Errno *err_code)
{
    int ret = 0;
    char apn_t[100] = {};
    char apnType_t[50] = {};
    char iface_t[50] = {};
    char *argv[10];
    if(handle==NULL||apnType==NULL||err_code==NULL)
    {
        return -1;
    }
    argv[0] = "RIL_REQUEST_DEACTIVATE_DATA_CALL";
    argv[1] = apnType;
    *handle = android::getRequestData(argv,2);
    ret = lynqWaitRespWithTime(LYNQ_EVENT_WAIT_TIME_MAX);
    if(ret==ETIMEDOUT)
    {
        *err_code = (RIL_Errno)LYNQ_E::LYNQ_E_TIME_OUT;
        return 0;
    }
    *err_code = RIL_Errno::RIL_E_SUCCESS;
    return 0;
}
/*Warren add for T800 platform end 2021/11/10*/
//the max of data call list number is 10;
int lynq_get_data_call_list(LYNQ_Data_Call_Response_v11 **dataCallList,const int listNum,int *realNum)
{
    if(listNum>DATA_CALL_LIST_MAX)
    {
        LYDBGLOG("the list number is more than 10");
        return -1;
    }
    int32_t token=0;
    RIL_Data_Call_Response_v11 *list = NULL;
    dataCallMsg msg;
    token = lynqNoneParame("RIL_REQUEST_DATA_CALL_LIST");
    list = checkParcelDataCallInfo(&msg,token,100);
    if(list==NULL)
    {
        //dataCallList=NULL;
        return token;
    }
    if(listNum<msg.num)
    {
        msg.num=listNum;
        LYDBGLOG("listNum<msg.num!");
    }
    *realNum=msg.num;
    //dataCallList = (RIL_Data_Call_Response_v11 *) calloc(1, sizeof(RIL_Data_Call_Response_v11) * msg.num);
    for(int i=0;i<msg.num;i++)
    {
        copyDataCallList(dataCallList[i], list[i]);
    }
    for (int i = 0; i < msg.num; i++) 
    {
        free(list[i].type);
        free(list[i].ifname);
        free(list[i].addresses);
        free(list[i].dnses);
        free(list[i].gateways);
        free(list[i].pcscf);
    }
    free(list);
    lynqDeQueue(token);
    /*
    for(int i=0;i<msg.num;i++)
    {
        printf("test status is %d\n",dataCallList[i]->status);
        printf("test suggested is %d\n",dataCallList[i]->suggestedRetryTime);
        printf("test cid is %d\n",dataCallList[i]->cid);
        printf("test active is %d\n",dataCallList[i]->active);
        printf("test mtu is %d\n",dataCallList[i]->mtu);
        printf("test string is %s\n",dataCallList[i]->type);
        printf("test string is %s\n",dataCallList[i]->ifname);
        printf("test string is %s\n",dataCallList[i]->addresses);
        printf("test string is %s\n",dataCallList[i]->dnses);
        printf("test string is %s\n",dataCallList[i]->gateways);
        printf("test string is %s\n",dataCallList[i]->pcscf);
    }
    */
    /*
    for(int i=0;i<msg.num;i++)
    {
        printf("test status is %d\n",dataCallList[i].status);
        printf("test suggested is %d\n",dataCallList[i].suggestedRetryTime);
        printf("test cid is %d\n",dataCallList[i].cid);
        printf("test active is %d\n",dataCallList[i].active);
        printf("test mtu is %d\n",dataCallList[i].mtu);
        printf("test string is %s\n",dataCallList[i].type);
        printf("test string is %s\n",dataCallList[i].ifname);
        printf("test string is %s\n",dataCallList[i].addresses);
        printf("test string is %s\n",dataCallList[i].dnses);
        printf("test string is %s\n",dataCallList[i].gateways);
        printf("test string is %s\n",dataCallList[i].pcscf);
    }
    */
    return token;

}
void copyDataCallList(LYNQ_Data_Call_Response_v11 *newMsg,const RIL_Data_Call_Response_v11 oldMsg)
{
    newMsg->status = oldMsg.status;
    LYDBGLOG("test dataCallList status is %d,list status is %d\n",newMsg->status,oldMsg.status);
    newMsg->suggestedRetryTime = oldMsg.suggestedRetryTime;
    LYDBGLOG("test %d\n",oldMsg.suggestedRetryTime);
    newMsg->cid = oldMsg.cid;
    LYDBGLOG("test %d\n",oldMsg.cid);
    newMsg->active = oldMsg.active;
    LYDBGLOG("test %d\n",oldMsg.active);
    newMsg->mtu = oldMsg.mtu;
    LYDBGLOG("test %d\n",oldMsg.mtu);
    memcpy(newMsg->type,oldMsg.type,strlen(oldMsg.type)+1);
    LYDBGLOG("test string is %s\n",oldMsg.type);
    memcpy(newMsg->ifname,oldMsg.ifname,strlen(oldMsg.ifname)+1);
    LYDBGLOG("test string is %s\n",oldMsg.ifname);
    memcpy(newMsg->addresses,oldMsg.addresses,strlen(oldMsg.addresses)+1);
    LYDBGLOG("test string is %s\n",oldMsg.addresses);
    memcpy(newMsg->dnses,oldMsg.dnses,strlen(oldMsg.dnses)+1);
    LYDBGLOG("test string is %s\n",oldMsg.dnses);
    memcpy(newMsg->gateways,oldMsg.gateways,strlen(oldMsg.gateways)+1);
    LYDBGLOG("test string is %s\n",oldMsg.gateways);
    memcpy(newMsg->pcscf,oldMsg.pcscf,strlen(oldMsg.pcscf)+1);
    LYDBGLOG("test string is %s\n",oldMsg.pcscf);

}

