//#include "common.h"
#include "lynq_common.h"
#include "lynq_network.h"
//#include <stateManager/stateManager.h>
#define CELL_LIST_MAX 10
#undef LOG_TAG
#define LOG_TAG "LYNQ_NETWORK"
/*Warren add for T800 platform 2021/11/23 start*/
int lynq_signal_strength_change_cb(lynq_signal_strength_change_ind signalStrength_cb)
{
    if(signalStrength_cb==NULL)
    {
       RLOGD("signal Strength cb is null!!!");
       return -1;
    }
    sigStrengthChangeCb=signalStrength_cb;
    return 0;
}
int lynq_voice_network_state_change_cb(lynq_voice_network_state_change_ind voiceChange_cb)
{
    if(voiceChange_cb==NULL)
    {
       RLOGD("voice change cb is null!!!");
       return -1;
    }
    voiceChangeCb=voiceChange_cb;
    return 0;
}

/*Warren add for T800 platform 2021/11/23 end*/

//moblietek add @2020.12.for add Network api
int copyCellInfoList(Parcel &p,cellInfoList *cellinfo)
{
    int32_t v=0;
    int64_t v6=0;
    int32_t num = 0;
    p.readInt32(&v);
    cellinfo->cellinfo.cellInfoType = RIL_CellInfoType(v);
    p.readInt32(&cellinfo->cellinfo.registered);
    p.readInt32(&v);
    cellinfo->cellinfo.timeStampType = RIL_TimeStampType(v);
    p.readInt64(&v6);
    cellinfo->cellinfo.timeStamp = v6;
    switch(cellinfo->cellinfo.cellInfoType) {
        case RIL_CELL_INFO_TYPE_GSM: {
            p.readInt32(&cellinfo->cellinfo.CellInfo.gsm.cellIdentityGsm.mcc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.gsm.cellIdentityGsm.mnc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.gsm.cellIdentityGsm.lac);
            p.readInt32(&cellinfo->cellinfo.CellInfo.gsm.cellIdentityGsm.cid);
            p.readInt32(&cellinfo->cellinfo.CellInfo.gsm.signalStrengthGsm.signalStrength);
            p.readInt32(&cellinfo->cellinfo.CellInfo.gsm.signalStrengthGsm.bitErrorRate);
            p.readInt32(&cellinfo->cellinfo.CellInfo.gsm.signalStrengthGsm.timingAdvance);
            break;
        }
        case RIL_CELL_INFO_TYPE_WCDMA: {
            p.readInt32(&cellinfo->cellinfo.CellInfo.wcdma.cellIdentityWcdma.mcc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.wcdma.cellIdentityWcdma.mnc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.wcdma.cellIdentityWcdma.lac);
            p.readInt32(&cellinfo->cellinfo.CellInfo.wcdma.cellIdentityWcdma.cid);
            p.readInt32(&cellinfo->cellinfo.CellInfo.wcdma.cellIdentityWcdma.psc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.wcdma.signalStrengthWcdma.signalStrength);
            p.readInt32(&cellinfo->cellinfo.CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);
            break;
        }
        case RIL_CELL_INFO_TYPE_CDMA: {
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.cellIdentityCdma.networkId);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.cellIdentityCdma.systemId);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.cellIdentityCdma.basestationId);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.cellIdentityCdma.longitude);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.cellIdentityCdma.latitude);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.signalStrengthCdma.dbm);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.signalStrengthCdma.ecio);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.signalStrengthEvdo.dbm);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.signalStrengthEvdo.ecio);
            p.readInt32(&cellinfo->cellinfo.CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);

            break;
        }
        case RIL_CELL_INFO_TYPE_LTE: {
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.cellIdentityLte.mcc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.cellIdentityLte.mnc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.cellIdentityLte.ci);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.cellIdentityLte.pci);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.cellIdentityLte.tac);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.signalStrengthLte.signalStrength);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.signalStrengthLte.rsrp);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.signalStrengthLte.rsrq);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.signalStrengthLte.rssnr);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.signalStrengthLte.cqi);
            p.readInt32(&cellinfo->cellinfo.CellInfo.lte.signalStrengthLte.timingAdvance);
            break;
        }
        case RIL_CELL_INFO_TYPE_TD_SCDMA: {
            p.readInt32(&cellinfo->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.mcc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.mnc);
            p.readInt32(&cellinfo->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.lac);
            p.readInt32(&cellinfo->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.cid);
            p.readInt32(&cellinfo->cellinfo.CellInfo.tdscdma.cellIdentityTdscdma.cpid);
            p.readInt32(&cellinfo->cellinfo.CellInfo.tdscdma.signalStrengthTdscdma.rscp);
            break;
        }
    }
    return 0;
}
int checkRespErrno(const int32_t token,const int time,RIL_Errno & err)
{
    int time_net = time;
    int status=0;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    while(time_net--)
    {
        millli_sleep_with_restart(10);
        temp=LynqQueueHead;
        if(temp==NULL)
        {
            LYDBGLOG("[%s][%d][%s] Queue head is NULL, maybe malloc fail!\n",__FUNCTION__,__LINE__,__FILE__);
            continue;
        }
        node = searchTokeninQueue(token, temp);
        if(node ==NULL)
        {
            LYDBGLOG("[%s][%d][%s] can not find token %x\n",__FUNCTION__,__LINE__,__FILE__,token);
            err=-1;
            return -1;
        }
        node->parcel.setDataPosition(0);
        if (node->parcel.dataAvail() > 0) 
        {
            node->parcel.readInt32(&status);
            LYDBGLOG("[%s][%d][%s] message number is %d\n",__FUNCTION__,__LINE__,__FILE__,status);
            if(status!=0)
            {
                if(node->t_Errno!=RIL_E_SUCCESS)
                {
                    LYDBGLOG("[%s][%d][%s] get err success,but the event is fail,the error code is %d\n",__FUNCTION__,__LINE__,__FILE__,node->t_Errno);
                    err=node->t_Errno;
                    return -1;
                }
                else
                {
                    LYDBGLOG("[%s][%d][%s] get success, the error code is %d",__FUNCTION__,__LINE__,__FILE__,node->t_Errno);
                    err=node->t_Errno;
                    return 0;
                }
            }
         }
         else
         {
           continue;
         }
    }
    if(time_net<0)
    {
        LYDBGLOG("[%s][%d][%s] time out,can not find network selection mode  message!",__FUNCTION__,__LINE__,__FILE__);
        err=-1;
    }
    return -1;
}
int checkNetworkSelectionMode(const int32_t token,const int time,networkSelecttionMode *netselMode)
{
    int time_net = time;
    int num=0;
    //int status =0;
    Parcel parcel;
    RIL_Errno err;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    node = commonFindParcelmsg(token,time,err);
    if(node!=NULL)
    {
        node->parcel.readInt32(&num);
        LYDBGLOG("[%s][%d][%s] message number is %d",__FUNCTION__,__LINE__,__FILE__,num);
        node->parcel.readInt32(&netselMode->mode);
        netselMode->base.e=err;
        return 0;
    }
    netselMode->base.e=err;
    return -1;
}
int updateRegStateInfo(int32_t request,int32_t token,registrationStateInfo *regStateInfo)
{
    RIL_Errno err;
    Parcel parcel;
    int res = 0;
    int num=0;
    lynqQueue *node=NULL;
    regStateInfo->base.request=request;
    regStateInfo->base.token = token;
    switch(request)
    {
        case RIL_REQUEST_VOICE_REGISTRATION_STATE:
        {
            node = commonFindParcelmsg(token, 500,err);
            if (node != NULL)
            {
                node->parcel.setDataPosition(0);
                node->parcel.readInt32(&num);
                LYDBGLOG("[RIL_REQUEST_DATA_REGISTRATION_STATE] the num is %d\n",num);
                if(num==15)
                {
                    regStateInfo->regState = atoi(lynqStrdupReadString(node->parcel));
                    lynqStrdupReadString(node->parcel);
                    lynqStrdupReadString(node->parcel);
                    regStateInfo->netType =atoi( lynqStrdupReadString(node->parcel));
                }
            }
            regStateInfo->base.e=err;
            break;
        }
        case RIL_REQUEST_DATA_REGISTRATION_STATE:
        {
            node = commonFindParcelmsg(token, 500,err);
            if (node != NULL)
            {
                node->parcel.setDataPosition(0);
                node->parcel.readInt32(&num);
                //char * temp=NULL;
                LYDBGLOG("[RIL_REQUEST_DATA_REGISTRATION_STATE] the num is %d\n",num);
                if(num==11)
                {
                    regStateInfo->regState = atoi(lynqStrdupReadString(node->parcel));
                    regStateInfo->LAC = lynqStrdupReadString(node->parcel);
                    regStateInfo->CID = lynqStrdupReadString(node->parcel);
                    regStateInfo->netType =atoi( lynqStrdupReadString(node->parcel));
                }
            }
            regStateInfo->base.e=err;
            break;
        }
        case RIL_REQUEST_IMS_REGISTRATION_STATE:
        {
            node = commonFindParcelmsg(token, 500,err);
            if (node != NULL)
            {
                node->parcel.setDataPosition(0);
                node->parcel.readInt32(&num);
                //char * temp=NULL;
                LYDBGLOG("[RIL_REQUEST_DATA_REGISTRATION_STATE] the num is %d\n",num);
                if(num==2)
                {
                    node->parcel.readInt32(&regStateInfo->imsRegState);
                    node->parcel.readInt32(&res);
                    regStateInfo->radioTechFam = (RIL_RadioTechnologyFamily)res;
                }
            }
            regStateInfo->base.e=err;
            break;
        }
        default:
            break;
    }
	return 0;
}
int lynq_query_operater(operatorInfo * currentOperator)
{
    int32_t token = 0;
    int time_net =100;
    int num=0;
    lynqQueue *node = NULL;
    RIL_Errno err = -1;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_OPERATOR"};
    if(token = lynqNoneParame(requestStr))
    {
        currentOperator->base.request = RIL_REQUEST_OPERATOR;
        currentOperator->base.token=token;
        node = commonUpdateEstatus(token, time_net, err);
        currentOperator->base.e = err;
        if(err!=RIL_E_SUCCESS)
        {
            currentOperator->OperatorFN = NULL;
            currentOperator->OperatorSH = NULL;
            currentOperator->MccMnc = NULL;
            lynqDeQueue(token);
            return token;
        }
        node->parcel.setDataPosition(0);
        if (node->parcel.dataAvail() > 0) 
        {
            node->parcel.readInt32(&num);
            LYDBGLOG("[%s][%d][%s] Message number is %d",__FUNCTION__,__LINE__,__FILE__,num);
            if(num == 3)
            {
                currentOperator->OperatorFN = lynqStrdupReadString(node->parcel);
                currentOperator->OperatorSH = lynqStrdupReadString(node->parcel);
                currentOperator->MccMnc = lynqStrdupReadString(node->parcel);
            }
        }
        lynqDeQueue(token);
    }
    return token;
}

int lynq_query_network_selection_mode(networkSelecttionMode *netselMode)
{
    int32_t token=0;
    int time_net = 100;//1s
    //int num=0;
    //lynqQueue *node = NULL;
    //lynqQueue *temp =NULL;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE"};
    token=lynqNoneParame(requestStr);
    netselMode->base.token=token;
    netselMode->base.request=RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE;
    checkNetworkSelectionMode(token,time_net,netselMode);
    lynqDeQueue(token);
    return token;
}
int lynq_set_network_selection_mode(const char *mode,const char* mccmnc,lynqBase *base)//0:auto selection 1:manual selection
{
    const char *argv[MAX_LEN] = {};
    int32_t token=0;
    RIL_Errno err;
    lynqQueue * node = NULL;
    int time_net = 100;//1s
    char mccmncStr[MAX_QUEST_LEN] = "";
    if(!strcmp(mode,"Auto"))
    {
        //printf("--------->[%s,%d] Auto!!! \n",__FUNCTION__,__LINE__);
        argv[0] = "RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC";
        argv[1] = "Auto";
        if(token = android::getRequestData(argv, 1))
        {
            base->request=RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC;
            base->token = token;
            node = commonFindParcelmsg(token,time_net,err);
            base->e=err;
            lynqDeQueue(token);
        }
        return token;
    }else if(!strcmp(mode,"Manual")){
        //printf("--------->[%s,%d] manual,mccmnc=%d \n",__FUNCTION__,__LINE__,mccmnc);
        //sprintf(mccmncStr, "%d", mccmnc);
        argv[0] = "RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL";
        argv[1] = mccmnc;
        //argv[2] = mccmnc;
        if(token = android::getRequestData(argv, 2))
        {
            base->request=RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL;
            base->token = token;
            node = commonFindParcelmsg(token,time_net,err);
            base->e=err;
            lynqDeQueue(token);
        }
        return token;
    }
}

int lynq_query_available_network(availableNetwork *availNet)
{
    int32_t token;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_QUERY_AVAILABLE_NETWORKS"};
    int time_net =6000;//60second
    int num=0;//the number of available network data
    int range = 0;/*response is const char ** that should be an array of n*4 strings, where "range" is the number of available networks*/
    RIL_Errno err = -1;
    lynqQueue *node = NULL;
    lynqQueue *temp =NULL;
    if(token = lynqNoneParame(requestStr))
    {
        availNet->base.request = RIL_REQUEST_OPERATOR;
        availNet->base.token=token;
        node = commonFindParcelmsg(token, time_net, err);
        availNet->base.e=err;
        if (node !=NULL)
        {
            node->parcel.readInt32(&num);
            LYDBGLOG("[%s][%d] message number is %d\n",__FUNCTION__,__LINE__,num);
            if((num/4)>0 &&(num%4)==0)//Integer multiples of 4
            {
                range = num/4;
                /*Temporary plan.the real situation should be for(int i=0;i<range;i++)*/
                availNet->OperatorFN = lynqStrdupReadString(node->parcel);
                availNet->OperatorSH = lynqStrdupReadString(node->parcel);
                availNet->MccMnc = lynqStrdupReadString(node->parcel);
                availNet->NetStatus = lynqStrdupReadString(node->parcel);
            }
            else
            {
                if(num/4>0)
                {
                    availNet->OperatorFN = lynqStrdupReadString(node->parcel);
                    availNet->OperatorSH = lynqStrdupReadString(node->parcel);
                    availNet->MccMnc = lynqStrdupReadString(node->parcel);
                    availNet->NetStatus = lynqStrdupReadString(node->parcel);
                }
            }
        }
        lynqDeQueue(token);
    }
    return 0;
}

//network state
int lynq_query_registration_state(const char *type,registrationStateInfo *regStateInfo)//type:vioce/data/ims
{
    char requestStr[MAX_LEN]="";
    int32_t request=0;
    int32_t token=0;
    char str[10];
    if (strlen(type)>10)
    {
        LYERRLOG("[%s]the parameter is inavaliable !\n",__FUNCTION__);
        return -1;
    }
    memcpy(str,type,strlen(type)+1);
    strUpper(str);
    //printf("upper str is %s\n",str);
    if(!strcmp(str,"VOICE")){
        strcpy(requestStr,"RIL_REQUEST_VOICE_REGISTRATION_STATE");
        request=RIL_REQUEST_VOICE_REGISTRATION_STATE;
    }else if(!strcmp(str,"DATA")){
        strcpy(requestStr,"RIL_REQUEST_DATA_REGISTRATION_STATE");
        request= RIL_REQUEST_DATA_REGISTRATION_STATE;
    }else if(!strcmp(str,"IMS")){
        strcpy(requestStr,"RIL_REQUEST_IMS_REGISTRATION_STATE");
        request = RIL_REQUEST_IMS_REGISTRATION_STATE;
    }else{    
        LYERRLOG("[%s,%d] query ims registration state about voice, data, and ims!!! \n",__FUNCTION__,__LINE__);
        return -1;
    }
    token = lynqNoneParame(requestStr);
    updateRegStateInfo(request,token,regStateInfo);
    lynqDeQueue(token);
    return token;
}
//preferred network
int lynq_query_prefferred_networktype(prefferredNetworkType * preNetType)
{
    int32_t token=0;
    lynqQueue *node =NULL;
    RIL_Errno err=-1;
    int num =0;
    int res = 0;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE"};
    token = lynqNoneParame(requestStr);
    preNetType->base.request = RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE;
    preNetType->base.token=token;
    node = commonFindParcelmsg(token, 500, err);
    if (node !=NULL)
    {
        node->parcel.readInt32(&num);
        node->parcel.readInt32(&res);
        preNetType->pnt=res;
    }
    preNetType->base.e=err;
    lynqDeQueue(token);
    return token;
}

int lynq_set_prefferred_networktype(const int preffertype,lynqBase * base)//preffertype:0~22
{
    char *argv[MAX_LEN] = {};
    char preffertypeStr[MAX_QUEST_LEN] = "";
    int32_t token=0;
    int status = 0;
    RIL_Errno err=-1;
    lynqQueue * node = NULL;

    sprintf(preffertypeStr, "%d", preffertype);
    argv[0] = "RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE";
    argv[1] = preffertypeStr;
    if(token = android::getRequestData(argv, 2))
    {
        base->request = RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE;
        base->token=token;
        node = commonFindParcelmsg(token,500,err);
        base->e=err;
        lynqDeQueue(token);
    }
    return token;
}

//cell info
int lynq_query_cell_info(cellInfoList ** cellinfo,const int listNum,int *realNum)
{
    int32_t token = 0;
    lynqQueue *node = NULL;
    RIL_Errno err = -1;
    int num = 0;
    *realNum = 0;
    if(listNum>CELL_LIST_MAX)
    {
        LYERRLOG("the list number is more than 10\n");
        return -1;
    }
    char requestStr[MAX_LEN] = {"RIL_REQUEST_GET_CELL_INFO_LIST"};
    if(token = lynqNoneParame(requestStr))
    {
        cellinfo[0]->base.request=RIL_REQUEST_GET_CELL_INFO_LIST;
        cellinfo[0]->base.token = token;
        //node = commonFindParcelmsg(token,500,err);
        if(node = commonFindParcelmsg(token,500,err))
        {
            node->parcel.readInt32(&num);
            if (listNum<num)
            {
                num=listNum;
                LYDBGLOG("[%s,%d]listNum<num!",__FUNCTION__,__LINE__);
            }
            *realNum = num;
            for(int i = 0;i<num;i++)
            {
                copyCellInfoList(node->parcel,cellinfo[i]);
                //cellinfo[i]->base.request=RIL_REQUEST_GET_CELL_INFO_LIST;
                //cellinfo[i]->base.token = token;
            }
        }
        cellinfo[0]->base.e=err;
        lynqDeQueue(token);
    }
    cellinfo[0]->base.e=err;
    return token;
}

int lynq_set_unsol_cell_info_listrate(const int rate,lynqBase * base) //rate:0<=rate<=0x7fffffff, minimum time in milliseconds
{
    int32_t token=0;
    char *argv[MAX_LEN] = {};
    char rateStr[MAX_QUEST_LEN] = "";
    int status = 0;
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    sprintf(rateStr, "%d", rate);
    argv[0] = "RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE";
    argv[1] = rateStr;
    if(token = android::getRequestData(argv, 2))
    {
        base->request = RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE;
        base->token=token;
        node = commonFindParcelmsg(token,500,err);
        base->e=err;
        lynqDeQueue(token);
    }
    return token;
}

int lynq_query_neighboring_cellids(neighboringCellIDs **neiCeIDs,const int listNum,int *realNum)
{
    int32_t token = 0;
    lynqQueue *node = NULL;
    RIL_Errno err = -1;
    int num = 0;
    int res=0;
    *realNum = 0;
    if(listNum>CELL_LIST_MAX)
    {
        LYERRLOG("the list number is more than 10\n");
        return -1;
    }
    char requestStr[MAX_LEN] = {"RIL_REQUEST_GET_NEIGHBORING_CELL_IDS"};
    if(token = lynqNoneParame(requestStr))
    {
        neiCeIDs[0]->base.request=RIL_REQUEST_GET_NEIGHBORING_CELL_IDS;
        neiCeIDs[0]->base.token = token;
        //node = commonFindParcelmsg(token,500,err);
        if(node = commonFindParcelmsg(token,500,err))
        {
            node->parcel.readInt32(&num);
            if (listNum<num)
            {
                num=listNum;
                LYDBGLOG("[%s,%d]listNum<num!",__FUNCTION__,__LINE__);
            }
            *realNum = num;
            for(int i = 0;i<num;i++)
            {
                neiCeIDs[i]->cid = lynqStrdupReadString(node->parcel);
                node->parcel.readInt32(&res);
                neiCeIDs[i]->rssi = res;
            }
        }
        neiCeIDs[0]->base.e=err;
        lynqDeQueue(token);
    }
    neiCeIDs[0]->base.e=err;
    return token;
}

//band mode
int lynq_set_band_mode(const int bandmode,lynqBase *base)//bandmode:0~18
{
    char *argv[MAX_LEN] = {};
    int32_t token=0;
    char bandmodeStr[MAX_QUEST_LEN] = "";
    int status = 0;
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    sprintf(bandmodeStr, "%d", bandmode);
    argv[0] = "RIL_REQUEST_SET_BAND_MODE";
    argv[1] = bandmodeStr;
    token = android::getRequestData(argv, 2);
    base->request=RIL_REQUEST_SET_BAND_MODE;
    base->token = token;
    node = commonFindParcelmsg(token,1000,err);
    base->e=err;
    lynqDeQueue(token);
    return token;
}

int lynq_query_available_bandmode(availableBandMode*availBanMode)
{
    int32_t token = 0;
    RIL_Errno err=-1;
    lynqQueue * node = NULL;
    int num = 0;
    int res = 0;
    char requestStr[MAX_LEN] = {"RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE"};
    token = lynqNoneParame(requestStr);
    availBanMode->base.request = RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE;
    availBanMode->base.token = token;
    node = commonFindParcelmsg(token,500,err);
    for(int i = 0;i<20;i++)
    {
        availBanMode->bandmode[i]=0;
    }
    if (node!=NULL)
    {
        node->parcel.readInt32(&num);
        availBanMode->bandmode[0]=num;
        LYDBGLOG("[%s] available band mode num is %d\n",__FUNCTION__,num);
        for(int i=1;i<=num;i++)
        {
            node->parcel.readInt32(&res);
            availBanMode->bandmode[i]=res;
        }
    }
    availBanMode->base.e=err;
    lynqDeQueue(token);
    return 0;
}

//radio power  
int lynq_radio_on(const int data,lynqBase *base)//0:off  other:on
{
    char *argv[MAX_LEN] = {};
    char dataStr[MAX_QUEST_LEN] = "";
    int32_t token = 0;
    lynqQueue *node = NULL;
    RIL_Errno err=-1;
    sprintf(dataStr, "%d", data);
    argv[0] = "RIL_REQUEST_RADIO_POWER";
    argv[1] = dataStr;
    if(token = android::getRequestData(argv, 2))
    {
        base->request=RIL_REQUEST_RADIO_POWER;
        base->token = token;
        node = commonFindParcelmsg(token,500,err);
        base->e=err;
        lynqDeQueue(token);
    }
    return token;
}

//radio tech
int lynq_query_radio_tech(radioTechnology *radioTech)
{
    char requestStr[MAX_LEN] = {"RIL_REQUEST_VOICE_RADIO_TECH"};
    int32_t token=0;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int num = 0;
    int res = 0;
    token = lynqNoneParame(requestStr);
    radioTech->base.request = RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE;
    radioTech->base.token=token;
    node = commonFindParcelmsg(token, 500, err);
    if (node !=NULL)
    {
        node->parcel.readInt32(&num);
        node->parcel.readInt32(&res);
        radioTech->radioTech=res;
    }
    radioTech->base.e=err;
    lynqDeQueue(token);
    return token;
}

//signal strength
int lynq_solicited_signal_strength(solicitedSignalStrength *solSigStren)
{
    char requestStr[MAX_LEN] = {"RIL_REQUEST_SIGNAL_STRENGTH"};
    int32_t token=0;
    RIL_Errno err=-1;
    lynqQueue *node =NULL;
    int num = 0;
    int res = 0;
    token = lynqNoneParame(requestStr);
    solSigStren->base.request = RIL_REQUEST_SIGNAL_STRENGTH;
    solSigStren->base.token=token;
    node = commonFindParcelmsg(token, 500, err);
    solSigStren->base.e=err;
    if (node !=NULL)
    {
        node->parcel.readInt32(&num);
        if(num ==0)
        {
            LYDBGLOG("[%s] the signal strength is null!\n",__FUNCTION__);
            if(err==RIL_E_SUCCESS)
            {
                solSigStren->base.e=-1;
            }
            lynqDeQueue(token);
            return token;
        }
        node->parcel.readInt32(&solSigStren->signalStrength.GW_SignalStrength.signalStrength);
        node->parcel.readInt32(&solSigStren->signalStrength.GW_SignalStrength.bitErrorRate);
        node->parcel.readInt32(&solSigStren->signalStrength.GW_SignalStrength.timingAdvance);
        node->parcel.readInt32(&solSigStren->signalStrength.CDMA_SignalStrength.dbm);
        node->parcel.readInt32(&solSigStren->signalStrength.CDMA_SignalStrength.ecio);
        node->parcel.readInt32(&solSigStren->signalStrength.EVDO_SignalStrength.dbm);
        node->parcel.readInt32(&solSigStren->signalStrength.EVDO_SignalStrength.ecio);
        node->parcel.readInt32(&solSigStren->signalStrength.EVDO_SignalStrength.signalNoiseRatio);
        node->parcel.readInt32(&solSigStren->signalStrength.LTE_SignalStrength.signalStrength);
        node->parcel.readInt32(&solSigStren->signalStrength.LTE_SignalStrength.rsrp);
        node->parcel.readInt32(&solSigStren->signalStrength.LTE_SignalStrength.rsrq);
        node->parcel.readInt32(&solSigStren->signalStrength.LTE_SignalStrength.rssnr);
        node->parcel.readInt32(&solSigStren->signalStrength.LTE_SignalStrength.cqi);
        node->parcel.readInt32(&solSigStren->signalStrength.LTE_SignalStrength.timingAdvance);
        node->parcel.readInt32(&solSigStren->signalStrength.TD_SCDMA_SignalStrength.signalStrength);
        node->parcel.readInt32(&solSigStren->signalStrength.TD_SCDMA_SignalStrength.bitErrorRate);
        node->parcel.readInt32(&solSigStren->signalStrength.TD_SCDMA_SignalStrength.rscp);
        node->parcel.readInt32(&solSigStren->signalStrength.WCDMA_SignalStrength.signalStrength);
        node->parcel.readInt32(&solSigStren->signalStrength.WCDMA_SignalStrength.bitErrorRate);
        node->parcel.readInt32(&solSigStren->signalStrength.WCDMA_SignalStrength.rscp);
        node->parcel.readInt32(&solSigStren->signalStrength.WCDMA_SignalStrength.ecno);
#ifdef TELEMATIC_5G_SUPPORT
        node->parcel.readInt32(&solSigStren->signalStrength.NR_SignalStrength.ssRsrp);
        node->parcel.readInt32(&solSigStren->signalStrength.NR_SignalStrength.ssRsrq);
        node->parcel.readInt32(&solSigStren->signalStrength.NR_SignalStrength.ssSinr);
        node->parcel.readInt32(&solSigStren->signalStrength.NR_SignalStrength.csiRsrp);
        node->parcel.readInt32(&solSigStren->signalStrength.NR_SignalStrength.csiRsrq);
        node->parcel.readInt32(&solSigStren->signalStrength.NR_SignalStrength.csiSinr);
#endif
    }
    lynqDeQueue(token);
    return token;

}

//modem
int lynq_modem_on(const int data,lynqBase *base)//data: 0:off,other:on
{
    char *argv[MAX_LEN] = {};
    char dataStr[MAX_QUEST_LEN] = "";
    argv[0] = data == 0 ? "RIL_REQUEST_MODEM_POWEROFF" : "RIL_REQUEST_MODEM_POWERON" ;
    sprintf(dataStr, "%d", data);
    argv[1] = dataStr;
    int32_t token = 0;
    lynqQueue *node = NULL;
    RIL_Errno err=-1;
    if(token = android::getRequestData(argv, 2))
    {
        base->request=(data == 0 ? RIL_REQUEST_MODEM_POWEROFF:RIL_REQUEST_MODEM_POWERON );
        base->token = token;
        node = commonFindParcelmsg(token,500,err);
        base->e=err;
        lynqDeQueue(token);
    }
    return token;
}

#if 0
int  lynq_enter_network_depersonalization(char *code)//code:network/depersonalization code
{
    char *argv[MAX_LEN] = {};
    char dataStr[MAX_QUEST_LEN] = "";
    
    argv[0] = "RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION"; 
    argv[1] = code;
    
    return  android::getRequestData(argv, 2);
}
#endif
