#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "query $type registration state"
upper2lower(){
    value="$(echo $1 | tr '[:upper:]' '[:lower:]')"
    echo $value
}

if [ "$1" == "-h" ]
then
	echo -E "query ims registration state about voice, data, and ims."
	echo -E "Usage: QueryRegistrationState.sh voice | data | ims"
	exit 0
fi

echo "The query type is: $#"
if [ -z $1 ]
then
echo -n "please input type: "
read type
else
type=$1
fi

type=$(upper2lower $type)

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
if [ $type == "voice" ]
then
	echo "RIL_REQUEST_VOICE_REGISTRATION_STATE" >&9
elif [ $type == "data" ]
then
	echo "RIL_REQUEST_DATA_REGISTRATION_STATE" >&9
elif [ $type == "ims" ]
then
	echo "RIL_REQUEST_IMS_REGISTRATION_STATE" >&9
else
	echo -E "parameter is invaild"
	echo -E "input QueryRegistrationState.sh -h for more details "
	exit 1
fi

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
