#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "set unsolicited cell info informed rate"
if [ ! -n "$1" ]
then
        echo -E "Error:"
        echo -E "please input parameter, you can input 'SetUnsolCellInfoListRate -h' for more details"
        exit 1
fi

if [ "$1" == "-h" ]
then
	echo -E "set unsolicited cell info informed rate."
	echo -E "Usage: SetUnsolCellInfoListRate rate"
	echo -E "where 0<=rate<=0x7fffffff, minimum time in milliseconds"
	echo -E " 0, /* means invoke RIL_UNSOL_CELL_INFO_LIST when any of the reported information changes. Setting the value to INT_MAX(0x7fffffff) means never issue0 */ "
	echo -E " 0x7fffffff, /* INT_MAX(0x7fffffff) means never issue */ "
 	exit 0
fi
rate=$1

#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE $rate" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0