/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include <bitset>

#include "IndividualSubRecord.h"
#include "../utils/GostEcallUtils.h"
#include "./commands/CmdUtils.h"
#include "./ecall/EcallUtils.h"

using namespace std;

#undef LOG_TAG
#define LOG_TAG "DEMO_EGOST_IndividualSubRecord"


IndividualSubRecord::IndividualSubRecord(uint8_t sst, uint8_t rst) {
    SRT = UINT8_MAX;
    SRL = 0;
    SRD = ""; //o, 0-65495;
    mSst = sst;
    mRst = rst;

}

IndividualSubRecord::~IndividualSubRecord() {
    // TODO Auto-generated destructor stub
}

const std::string& IndividualSubRecord::getSrd() const {
    return SRD;
}

void IndividualSubRecord::setSrd(const std::string srd) {
    SRD = srd;
}

std::uint16_t IndividualSubRecord::getSrl() const {
    return SRL;
}

void IndividualSubRecord::setSrl(std::uint16_t srl) {
    SRL = srl;
}

std::uint8_t IndividualSubRecord::getSrt() const {
    return SRT;
}

void IndividualSubRecord::setSrt(std::uint8_t srt) {
    SRT = srt;
}

std::string IndividualSubRecord::encodeAck(std::uint8_t subType, std::uint16_t cmd, bool ack) {
    if(subType == CmdUtils::EGTS_SR_COMMAND_DATA) {
        if(!mDeSrComDtFmt) {
            MTK_RLOGW("sub command data is null");
            return "";
        }
        //encode SRT
        std::string srt = encodeValue(subType, 2, "SRT");
        MTK_RLOGD("encode SRT(0X%02X) result: %s",subType, srt.c_str());

        //encode SRL and SRD
        std::string srd = mDeSrComDtFmt->encode(cmd, ack);
        if(srd.empty()) {
            MTK_RLOGW("encode  cmd(0X%04X) is empty", cmd);
        }
        MTK_RLOGD("encode SRD(cmd: 0X%04X) result: %s",cmd, srd.c_str());
        //SRL
        std::string srl =  encodeValue((srd.size()/2), 4, "SRL");
        MTK_RLOGD("encode SRL(0X%04X) result: %s",srd.size()/2, srl.c_str());
        return srt + srl + srd;
    }
    MTK_RLOGW("encodeAck fail ,don't support subtype(%u)", subType);
    return "";
}

int IndividualSubRecord::decodeComService() {
    uint32_t index = 0;
    int64_t ret = 0;
    if (SRT == CmdUtils::EGTS_SR_COMMAND_DATA) {
        mDeSrComDtFmt = std::make_shared<SrComDataFormat>();
        //decode srComDtFmt->type
        ret = decodeValue(SRD, index, 2, "srComDtFmt->type");
        if (ret == -1) {
            MTK_RLOGW("decode type fail");
            return -1;
        }
        MTK_RLOGD("index: %d, type: 0X%02x", index, (uint8_t )ret);
        mDeSrComDtFmt->setType((uint8_t) (ret));
        bitset<8> tmp(mDeSrComDtFmt->getType());
        mDeSrComDtFmt->setCt(
                (tmp[7] << 3) | (tmp[6]) << 2 | (tmp[5] << 1) | tmp[4]);
        mDeSrComDtFmt->setCct(
                (tmp[3] << 3) | (tmp[2]) << 2 | (tmp[1] << 1) | tmp[0]);
        MTK_RLOGD("index: %d, ct=0X%02X, cct=0X%02X", index, mDeSrComDtFmt->getCt(),
                mDeSrComDtFmt->getCct());
        //decode CID(command identifier)
        ret = decodeValue(SRD, index, 8, "CID(command identifier)");
        if (ret == -1) {
            MTK_RLOGW("decode CID fail");
            return -1;
        }
        MTK_RLOGD("index: %d, CID: 0X%08x", index, (uint32_t )ret);
        mDeSrComDtFmt->setCid((uint32_t) (ret));
        //decode SID(source identifier)
        ret = decodeValue(SRD, index, 8, "SID(source identifier)");
        if (ret == -1) {
            MTK_RLOGW("decode SID fail");
            return -1;
        }
        MTK_RLOGD("index: %d, SID: 0X%08x", index, (uint32_t )ret);
        mDeSrComDtFmt->setSid((uint32_t) (ret));
        //decode srComDtFmt->fileExs
        ret = decodeValue(SRD, index, 2, "srComDtFmt->fileExs");
        if (ret == -1) {
            MTK_RLOGW("decode fileExs fail");
            return -1;
        }
        MTK_RLOGD("index: %d, fileExs: 0X%02x", index, (uint8_t )ret);
        mDeSrComDtFmt->setFileExs((uint8_t) (ret));
        bitset<8> tp(mDeSrComDtFmt->getFileExs());
        mDeSrComDtFmt->setAcfe(tp[1]);
        mDeSrComDtFmt->setChsfe(tp[0]);
        MTK_RLOGD("index: %d, acfe=0X%02X, chsfe=0X%02X", index, mDeSrComDtFmt->getAcfe(),
                mDeSrComDtFmt->getChsfe());
        //decode CHS(charset)
        if (mDeSrComDtFmt->getChsfe()) {
            ret = decodeValue(SRD, index, 2, "CHS(charset)");
            if (ret == -1) {
                MTK_RLOGW("decode CHS fail");
                return -1;
            }
            MTK_RLOGD("index: %d, CHS: 0X%02x", index, (uint8_t )ret);
            mDeSrComDtFmt->setChs((uint8_t) (ret));
        }
        //decode ACL(Authorisation Code Length)
        if (mDeSrComDtFmt->getAcfe()) {
            ret = decodeValue(SRD, index, 2, "ACL(Authorisation Code Length)");
            if (ret == -1) {
                MTK_RLOGW("decode ACL fail");
                return -1;
            }
            MTK_RLOGD("index: %d, ACL: 0X%02x", index, (uint8_t )ret);
            mDeSrComDtFmt->setAcl((uint8_t) (ret));
        }
        //decode AC(Authorisation Code)
        if (mDeSrComDtFmt->getAcl()) {
            std::string sub = decodeData(SRD, mDeSrComDtFmt->getAcl(),
                    "AC(Authorisation Code)", index);
            if (sub.empty()) {
                MTK_RLOGW("decode AC fail");
                return -1;
            }
            MTK_RLOGD("index: %d, AC: %s", index, sub.c_str());
            mDeSrComDtFmt->setAc(sub);
        }
        //decode CD(Command Data)
        if (index < SRD.size()) {
            std::string sub = SRD.substr(index);
            mDeSrComDtFmt->setCd(sub);
            ret = mDeSrComDtFmt->decodeSrCmomDt();
            if (ret == -1) {
                MTK_RLOGW("decode decodeSrCmomDt fail");
                return -1;
            }
        } else {
            MTK_RLOGW("decode CD fail");
            return -1;
        }
    } else if (SRT == CmdUtils::EGTS_SR_RECORD_RESPONSE) {
    } else {
    }
    return 0;
}

int IndividualSubRecord::decodeAllService() {
    //TBD,
    //need check other conditions. maybe response.
    if(SRL == 0 || SRD.empty()) {
        MTK_RLOGW("SRD don't exist. don't need decode");
        return 0;
    }
    MTK_RLOGD("sst=%d, rst =%d, srt = %d, %s", mSst, mRst, SRT, SRD.c_str());
//    uint32_t index = 0;
//    int64_t ret = 0;
    if(mSst == service_support_layer_protocol::EGTS_COMMANDS_SERVICE) { //TBD. is this condition right ?
        int ret = decodeComService();
        if(ret == -1) {
            MTK_RLOGW("decode decodeComService fail");
            return -1;
        }
    } else {
        MTK_RLOGW("don't support, just return");
    }
    return 0;


}

std::string IndividualSubRecord::encodeAllService(std::string msd) {
    if(SRT == EcallUtils::EGTS_SR_RAW_MSD_DATA) {
        //encode SRT
        std::string srt = encodeValue(SRT, 2, "SRT");
        MTK_RLOGD("srt encode result: %s", srt.c_str());
        if(srt.empty()) {
            MTK_RLOGW("encode SRT fail");
            return "";
        }

        mSrRawMsdDt = std::make_shared<SrRawMsdData>();
        mSrRawMsdDt->setFm(1); // 1: packe encoding as per GOST 33464;
        mSrRawMsdDt->setMsd(msd);

        //encode SRD
        std::string srd = mSrRawMsdDt->encode();
        MTK_RLOGD("srd encode result: %s", srd.c_str());
        if(srd.empty()) {
            MTK_RLOGW("encode srd fail");
            return "";
        }

        //encode SRL
        std::string srl = encodeValue((srd.length()/2), 4, "SRL");
        MTK_RLOGD("SRL encode result: %s", srl.c_str());
        if(srl.empty()) {
            MTK_RLOGW("encode SRL fail");
            return "";
        }
        return srt + srl + srd;
    }
    MTK_RLOGW("don't support this SRT(%d) encode", SRT);
    return "";
}

bool IndividualSubRecord::isIncludedCmdCode(std::uint16_t cmd) {
    MTK_RLOGD("cmd=0X%04X", cmd);
    if(!mDeSrComDtFmt) {
        MTK_RLOGW("no decode command sub records");
        return false;
    }
    return mDeSrComDtFmt->isIncludedCmdCode(cmd);
}

bool IndividualSubRecord::isNeedNewSms() {
    if(!mDeSrComDtFmt) {
        MTK_RLOGW("no decode command sub records");
        return false;
    }
    return mDeSrComDtFmt->isNeedNewSms();
}

int IndividualSubRecord::getEcallReqPara() {
    if(!mDeSrComDtFmt) {
        MTK_RLOGW("no decode command sub records");
        return 0;
    }
    return mDeSrComDtFmt->getEcallReqPara();
}
