// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
#include <vendor-ril/telephony/ril.h>
#include <stdlib.h>
#include <stdio.h>
#include <cutils/jstring.h>
#include <log/log.h>
#include <unistd.h>
#include <math.h>
#include <vector>
#include <string>
#include <stdexcept>
#include  "common.h"
#include "em/em.h"
#include "ModemCategory.h"
#include "Radio_capability_switch_util.h"
#include "../util/utils.h"

#if EM_MODE_SUPPORT

#undef LOG_TAG
#define LOG_TAG "EM_ANTENNA"

static const int MSG_QUERY_ANTENNA_MODE = 1;
static const int MSG_SET_ANTENNA_MODE = 2;
static const int MSG_QUERY_ANTENNA_MODE_C2K = 4;
static const int MSG_QUERY_ANTENNA_EGMC_4G = 5;
static const int MSG_SET_ANTENNA_EGMC_4G = 6;
static const int MSG_INIT_ANTENNA_EGMC_4G = 7;
static const int MSG_QUERY_ANTENNA_EGMC_NR = 8;
static const int MSG_SET_ANTENNA_EGMC_NR = 9;

static const int MODE_INDEX_BASE_3G = 10;
static const int MODE_INDEX_BASE_2G = 20;
static const int MODE_EPCM_VALID = 0xFF;
static const int CELL_2RX_LENGTH = 2;
static const int CELL_4RX_LENGTH = 4;

static int RAT_4G  = 0;
#ifdef C2K_SUPPORT
static int RAT_3G  = 1;
static int RAT_C2K = 2;
static int RAT_NR  = 3;
#else
static int RAT_3G  = -1;
static int RAT_C2K = -1;
static int RAT_NR  = 1;
#endif

static const std::string CMD_INIT_EGMC_4G = "AT+EGMC=1,\"rx_path\",1,0,3,15,3,15";
static const std::string CMD_SET_EGMC_4G = "AT+EGMC=1,\"rx_path\"";
static const std::string CMD_SET_EGMC_NR = "AT+EGMC=1,\"nr_rx_path\"";
static const std::string CMD_SAME_EGMC = "+EGMC:";

int mCurrentEmantennaFlag = 0;
bool fgAntennaRead = true;
int mAntennaMode = 0;
char antennaretstring[128] = {0};
int inputRat = -1;
std::vector<int> gEgmcParam;

static const std::vector<std::string> antenna_modes_egmc_4rx {
    "None",             // 0
    "RX1",              // 1
    "RX2",              // 2
    "RX1&RX2",          // 3
    "RX3",              // 4
    "RX1&RX3",          // 5
    "RX2&RX3",          // 6
    "RX1&RX2&RX3",      // 7
    "RX4",              // 8
    "RX1&RX4",          // 9
    "RX2&RX4",          // 10
    "RX1&RX2&RX4",      // 11
    "RX3&RX4",          // 12
    "RX1&RX3&RX4",      // 13
    "RX2&RX3&RX4",      // 14
    "RX1&RX2&RX3&RX4",  // 15
};

static const std::vector<std::string> antenna_modes_egmc_2rx {
    "None",
    "RX1",
    "RX2",
    "RX1&RX2",
};

static const std::vector<std::string> antenna_modes_4g {
    "RX1&RX2",
    "RX1",
    "RX2"
};

static const std::vector<std::string> antenna_modes_3g {
    "Please select a mode:",
    "RX1",
    "RX2",
    "RX1&RX2",
    "Resume default setting"
};

static const std::vector<std::string> antenna_modes_c2k_mode {
    "Resume default setting",
    "RX1",
    "RX2",
    "RX1&RX2"
};

static void  sendATCommand(const char *cmd,int msg)
{
    mCurrentEmantennaFlag = msg;
    emSendATCommand(cmd, Radio_capability_switch_util::get_main_capability_phone_id());
    return ;
}

static void queryEgmcAntNR() {
    char cmd_str[32] = {0};
    sprintf(cmd_str,"%s","AT+EGMC=0,\"nr_rx_path\"");
    sendATCommand(cmd_str, MSG_QUERY_ANTENNA_EGMC_NR);
}

static void queryEgmcAnt4G() {
    char cmd_str[32] = {0};
    sprintf(cmd_str,"%s","AT+EGMC=0,\"rx_path\"");
    sendATCommand(cmd_str, MSG_QUERY_ANTENNA_EGMC_4G);
}

static void queryCurrentMode() {
    char cmd_str[32] = {0};
    sprintf(cmd_str,"%s","AT+ERXPATH?");
    sendATCommand(cmd_str, MSG_QUERY_ANTENNA_MODE);
}

void queryCurrentCdmaMode() {
    if (utils::is93Modem()) {
        sendATCommand("AT+ERXTESTMODE?", MSG_QUERY_ANTENNA_MODE_C2K);
    } else {
        android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
        RLOGD("don't support");
    }
}

static void initEgmcAnt4G() {
    sendATCommand(CMD_INIT_EGMC_4G.c_str(), MSG_INIT_ANTENNA_EGMC_4G);
}

static void setEgmcAnt4G(int force_mode, int scc_follow_pcc, int pcell_2rx, int pcell_4rx, int scell_2rx, int scell_4rx) {
    char cmd_str[64] = {0};
    sprintf(cmd_str,"%s,%d,%d,%d,%d,%d,%d",
        CMD_SET_EGMC_4G.c_str(), force_mode, scc_follow_pcc, pcell_2rx, pcell_4rx, scell_2rx, scell_4rx);
    RLOGD("setEgmcAnt4G, cmd:%s", cmd_str);
    sendATCommand(cmd_str, MSG_SET_ANTENNA_EGMC_4G);
}

static void setEgmcAntNR(int force_mode, int scc_follow_pcc, int pcell_2rx, int pcell_4rx, int scell_2rx, int scell_4rx) {
    char cmd_str[64] = {0};
    sprintf(cmd_str,"%s,%d,%d,%d,%d,%d,%d",
        CMD_SET_EGMC_NR.c_str(), force_mode, scc_follow_pcc, pcell_2rx, pcell_4rx, scell_2rx, scell_4rx);
    RLOGD("setEgmcAntNR, cmd:%s", cmd_str);
    sendATCommand(cmd_str, MSG_SET_ANTENNA_EGMC_NR);
}

static void setMode(int mode) {
    char cmd_str[32] = {0};
    sprintf(cmd_str,"%s%d","AT+ERXPATH=",mode);
    sendATCommand(cmd_str, MSG_SET_ANTENNA_MODE);
}

static void setCdmaMode(int mode) {
    std::string str("AT+ERXTESTMODE=");
    str.append(std::to_string(mode));
    if (utils::is93Modem()) {
        sendATCommand(str.c_str(), MSG_SET_ANTENNA_MODE);
    } else {
        android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
        RLOGD("don't support");
    }
}

static void parseEgmcData(char* data) {
    RLOGD("parseEGMCData(rat=%d), data=%s", inputRat, data);
    std::vector<std::string> out;
    utils::tokenize(string(data), "\n", out);
    std::string str;
    str.clear();

    // 4G response: +EGMC: "rx_path",1,0,3,15,3,12
    // NR response: +EGMC: "nr_rx_path",3,15,3,12
    for(auto i: out) {
        if(i.find(CMD_SAME_EGMC) != std::string::npos) {
            std::string splitString = i.substr(std::string(CMD_SAME_EGMC).size());
            std::vector<std::string> getDigitalVal;
            utils::tokenize(string(splitString), ",\n", getDigitalVal);
            RLOGD("parseCurrentMode splitString: %s, getDigitalVal.size()=%d",
                    splitString.c_str(), getDigitalVal.size());

            if (getDigitalVal.size() < 5 &&
                !((inputRat == RAT_NR) && getDigitalVal.size() == 1)) {
                android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                RLOGD("Modem returned invalid getDigitalVal(%d): %s", getDigitalVal.size(), data);
                return ;
            }

            try {
                int idx_pcell_2rx = 3;
                // Show result
                if (inputRat == RAT_4G) {
                    str.append("4G:");

                } else if (inputRat == RAT_NR){
                    str.append("NR:");
                    idx_pcell_2rx = 1;
                }

                int pcell_2rx = 0, pcell_4rx = 0, scell_2rx = 0, scell_4rx = 0;
                if ((inputRat == RAT_NR) && (getDigitalVal.size() == 1)) {
                    pcell_2rx = 0;
                    pcell_4rx = 0;
                    scell_2rx = 0;
                    scell_4rx = 0;

                } else {
                    pcell_2rx = std::stoi(getDigitalVal[idx_pcell_2rx]);
                    pcell_4rx = std::stoi(getDigitalVal[++idx_pcell_2rx]);
                    scell_2rx = std::stoi(getDigitalVal[++idx_pcell_2rx]);
                    scell_4rx = std::stoi(getDigitalVal[++idx_pcell_2rx]);
                }

                RLOGD("pcell_2rx=%d, pcell_4rx=%d, scell_2rx=%d, scell_4rx=%d",
                        pcell_2rx, pcell_4rx, scell_2rx, scell_4rx);

                if (pcell_2rx >= 0 && pcell_2rx < antenna_modes_egmc_2rx.size()) {
                    str.append("\npcell_2rx: ");
                    str.append(antenna_modes_egmc_2rx[pcell_2rx]);
                }
                if (pcell_4rx >= 0 && pcell_4rx < antenna_modes_egmc_4rx.size()) {
                    str.append("\npcell_4rx: ");
                    str.append(antenna_modes_egmc_4rx[pcell_4rx]);
                }
                if (scell_2rx >= 0 && scell_2rx < antenna_modes_egmc_2rx.size()) {
                    str.append("\nscell_2rx: ");
                    str.append(antenna_modes_egmc_2rx[scell_2rx]);
                }
                if (scell_4rx >= 0 && scell_4rx < antenna_modes_egmc_4rx.size()) {
                    str.append("\nscell_4rx: ");
                    str.append(antenna_modes_egmc_4rx[scell_4rx]);
                }

            } catch (const out_of_range &e) {
                android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                RLOGD("out of range: %s", e.what());
                return;
            } catch (const invalid_argument &e) {
                android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                RLOGD("invalid argument: %s", e.what());
                return;
            }
        }
    }

    str.append("\ndone\n");
    RLOGD("result str=%s", str.c_str());
    android::emResultNotify(str.c_str());
}

static void parseCurrentMode(char* data) {
    RLOGD("parseCurrentMode(rat=%d), rsp=%s", inputRat, data);
    std::vector<std::string> out;
    utils::tokenize(string(data), "\n", out);
    std::string str;
    str.clear();

    if((inputRat == RAT_4G && !utils::is97Modem())|| inputRat == RAT_3G) {
        for(auto i: out) {
            if(i.find("+ERXPATH:") != std::string::npos) {
                try {
                    int mode = std::stoi(i.substr(std::string("+ERXPATH:").size()));
                    if (mode < 0 || (mode >= antenna_modes_4g.size()
                            && mode >= MODE_INDEX_BASE_3G + mode >= antenna_modes_4g.size()
                            &&  mode != MODE_EPCM_VALID)) {
                        android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                        RLOGD("Modem returned invalid mode(%d): %s",mode, data);
                        return ;
                    } else {
                        if (mode == MODE_EPCM_VALID) {
                            android::emResultNotify("Antenna test EPCM(255)\ndone\n");
                        } else if (mode >= MODE_INDEX_BASE_2G) {
                            RLOGD("Modem 2G mode (%d): %s",mode);
                        } else if (mode >= MODE_INDEX_BASE_3G) {
                            int pos = mode - MODE_INDEX_BASE_3G + 1;
                            RLOGD("parseCurrent3GMode is: %d", pos);
                            str.append("3G:");
                            str.append(antenna_modes_3g[pos]);
                            str.append(" ");
                        } else {
                            RLOGD("parseCurrentLteMode is: %d", mode);
                            str.append("4G:");
                            str.append(antenna_modes_4g[mode]);
                            str.append(" ");
                        }
                    }
                    str.append("\ndone\n");
                } catch (const out_of_range &e) {
                    android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                    RLOGD("out of range: %s", e.what());
                    return;
                } catch (const invalid_argument &e) {
                    android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                    RLOGD("invalid argument: %s", e.what());
                    return;
                }
            }
        }
        android::emResultNotify(str.c_str());

    } else if (inputRat == RAT_C2K) {
        for(auto i: out) {
            if(i.find("+ERXTESTMODE:") != std::string::npos) {
                try {
                    int mode = std::stoi(i.substr(std::string("+ERXTESTMODE:").size()));
                    if (mode < 0 || mode >= antenna_modes_c2k_mode.size()) {
                        android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                        RLOGD("Modem returned invalid mode(%d): %s",mode, data);
                        return;
                    } else {
                        RLOGD("parseCurrentC2KMode is: %d", mode);
                        str.append("CDMA:");
                        str.append(antenna_modes_c2k_mode[mode]);
                        str.append(" ");
                    }
                    str.append("\ndone\n");
                } catch (const out_of_range &e) {
                    android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                    RLOGD("out of range: %s", e.what());
                    return;
                } catch (const invalid_argument &e) {
                    android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
                    RLOGD("invalid argument: %s", e.what());
                    return;
                }
            }
        }
        android::emResultNotify(str.c_str());

    } else if (inputRat == RAT_4G && utils::is97Modem()) {
        parseEgmcData(data);

    } else if(inputRat == RAT_NR) {
        parseEgmcData(data);

    } else {
        RLOGE("error choose!!!");
        android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
    }
    return;
}


static void emAntennaAtCmdHandle(char*response, int responselen) {
    switch (mCurrentEmantennaFlag) {
    case MSG_QUERY_ANTENNA_MODE:
    case MSG_QUERY_ANTENNA_MODE_C2K:
    case MSG_QUERY_ANTENNA_EGMC_4G:
    case MSG_QUERY_ANTENNA_EGMC_NR:
        //parse antenna mode.
        if ((responselen > 0) && (response != NULL)) {
            RLOGD("Get response %s", response);
            parseCurrentMode(response);
        } else {
            RLOGD("Query antenna mode (rat=%d) failed.", inputRat);
            sprintf(antennaretstring, "%s%s (rat=%d)", ("Query antenna mode failed."),
            RET_STRING_ANTENNATEST_FAIL, inputRat);
            android::emResultNotify(antennaretstring);
        }
        android::unregisterNetwork();
        break;
    case MSG_INIT_ANTENNA_EGMC_4G:
        if ((responselen > 0) && (response != NULL)) {
            setEgmcAnt4G(gEgmcParam[0], gEgmcParam[1], gEgmcParam[2], gEgmcParam[3], gEgmcParam[4], gEgmcParam[5]);

        } else {
            RLOGD("Init EGMC antenna mode (rat=%d) failed.", inputRat);
            sprintf(antennaretstring, "%s%s (rat=%d)", ("Init antenna mode failed."),
            RET_STRING_ANTENNATEST_FAIL, inputRat);
            android::emResultNotify(antennaretstring);
        }

        break;
    case MSG_SET_ANTENNA_MODE:
    case MSG_SET_ANTENNA_EGMC_4G:
    case MSG_SET_ANTENNA_EGMC_NR:
        memset(antennaretstring, 0, sizeof(antennaretstring));
        if ((responselen > 0) && (response != NULL)) {
            RLOGD("Set successful.");
            sprintf(antennaretstring, "%s\n%s", ("Set successful."),
                    RET_STRING_ANTENNATEST_SUCCESS);
        } else {
            RLOGD("Set failed.");
            sprintf(antennaretstring, "%s\n%s", ("Set failed."),
                    RET_STRING_ANTENNATEST_FAIL);
        }
        android::emResultNotify(antennaretstring);
        break;
    default:
        RLOGD("error(%d)", mCurrentEmantennaFlag);
        break;
    }
}


//create thread to send command
static void * emAntennaTestThread(void* arg)
{
    if(fgAntennaRead){
        if(inputRat == RAT_4G) {
            if (ModemCategory::isLteSupport()) {
                if(utils::is97Modem()) {
                    queryEgmcAnt4G();

                } else {
                    queryCurrentMode();
                }

            } else {
                android::emResultNotify("Antenna test don't support for 4G \ndone\n");
            }

        } else if (inputRat == RAT_3G){
            if (ModemCategory::getModemType() == ModemCategory::MODEM_TD) {
                android::emResultNotify("Antenna test don't support for 3G \ndone\n");
            } else {
                queryCurrentMode();
            }

        } else if (inputRat == RAT_C2K) {
            if(ModemCategory::isCdma()) {
                queryCurrentCdmaMode();
            } else {
                android::emResultNotify("Antenna test don't support for C2K \ndone\n");
            }

        } else if(inputRat == RAT_NR) {
            if (ModemCategory::isNrSupport()) {
                queryEgmcAntNR();
            } else {
                android::emResultNotify("Antenna test don't support for NR \ndone\n");
            }

        } else {
            android::emResultNotify("Antenna test index error \ndone\n");
        }

    }else{
        if(inputRat == RAT_4G) {
            if (ModemCategory::isLteSupport()) {
                if(utils::is97Modem()) {
                    initEgmcAnt4G();
                } else {
                    setMode(mAntennaMode);
                }
            } else {
                android::emResultNotify("Antenna test don't support for 4G \ndone\n");
            }
        } else if (inputRat == RAT_3G){
            if (ModemCategory::getModemType() == ModemCategory::MODEM_TD) {
                android::emResultNotify("Antenna test don't support for 3G \ndone\n");
            } else {
                setMode(mAntennaMode);
            }
        } else if (inputRat == RAT_C2K) {
            if(ModemCategory::isCdma()) {
                setCdmaMode(mAntennaMode);
            } else {
                android::emResultNotify("Antenna test don't support for C2K \ndone\n");
            }
        } else if(inputRat == RAT_NR) {
            if (ModemCategory::isNrSupport() && gEgmcParam.size() == 6) {
                setEgmcAntNR(gEgmcParam[0], gEgmcParam[1], gEgmcParam[2], gEgmcParam[3], gEgmcParam[4], gEgmcParam[5]);
            } else {
                RLOGE("Antenna test don't support for NR or gEgmcParam size=%d", gEgmcParam.size());
                android::emResultNotify("Antenna test don't support for NR \ndone\n");
            }

        } else {
            android::emResultNotify("Antenna test index error \ndone\n");
        }
    }
    pthread_exit(0);
}

bool handleInputValue(int multilen, char *value[])
{
    if (multilen != 6) {
        RLOGE("error input parameter");
        android::emResultNotify("Antenna test parameter error, must count=6 \ndone\n");
        printf("Please reference AT+EGMC = 1,\"rx_path\"[,<force mode>,<scc follow pcc>,<pcell_2rx>,<pcell_4rx>,<scell_2rx>,<scell_4rx>]\n");
        printf("Example: 2 1 0 3 15 3 12\n");
        return false;
    }

    for(int i=0; i< multilen; i++) {
        printf("value[%d]=%d\n", i, atoi(value[i]));
        gEgmcParam.push_back(atoi(value[i]));
    }
    return true;
}

int emAntennaTestStart(int argc, int *item, int multilen,char *value[])
{
    RLOGD("emAntennaTestStart called");
    if(argc < 2){
        RLOGD("please select AntennaTest get or set :");
        return -1;
    }

    mCurrentEmantennaFlag = 0;
    gEgmcParam.clear();
    inputRat = item[0];
    int operatorid = item[1];
    bool ret = false;

    RLOGD("argc: %d, inputRat: %d, operatorid: %d\n", argc, inputRat, operatorid);

    if((inputRat != RAT_NR) && (inputRat != RAT_4G) && (inputRat != RAT_3G)
#ifdef C2K_SUPPORT
        && (inputRat != RAT_C2K)
#endif
        ){
        RLOGD("emAntennaTestStart: invalid inputRat %d, operatorid: %d", inputRat, operatorid);
        android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
        return -1;
    }

    switch(operatorid){
        case 0://get
        {
            fgAntennaRead = true;
            break;
        }
        case 1://set
        {
            printf("argc: %d, inputRat: %d, multilen: %d\n", argc, inputRat, multilen);

            if(inputRat == RAT_4G){
                if(utils::is97Modem()) {
                    if(!handleInputValue(multilen, value)) {
                        return (0);
                    }

                } else {
                    printf("itme[2]: %d\n", item[2]);
                    mAntennaMode = item[2];
                }

            } else if(inputRat == RAT_3G) {
                mAntennaMode = item[2]+ MODE_INDEX_BASE_3G;

            } else if (inputRat == RAT_C2K) {
                mAntennaMode = item[2];

            } else if(inputRat == RAT_NR){
                if(!handleInputValue(multilen, value)) {
                    return (0);
                }

            } else {
                RLOGE("error input rat");
                android::emResultNotify(RET_STRING_ANTENNATEST_FAIL);
            }
            fgAntennaRead = false;
            break;
        }
    }
    android::registerForATcmdResponse(emAntennaAtCmdHandle);
    pthread_t emantenna_thread;
    pthread_create(&emantenna_thread,NULL, emAntennaTestThread, NULL);
    return (0);
}
#endif

