/*============================================================================= 
**     FileName: lynq_send_log_data
**     Desc: send log data
**     Author: victor
**     Version: V1.0
**     LastChange: 2021-12-23
**     History: 
=============================================================================*/

#include "common.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include<unistd.h>

#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif

#include <log/log.h>
#include "lynq_rndis.h"

#define LYNQ_RNDIS_MALLOC_LEN 64

void lynq_rndis_response_ttyGS3(char *log_buf)
{
//    sprintf(log_buf,"LYNQ_GOTO_LOGS_REQ\n");
    write(ttyGS3_fd,log_buf,strlen(log_buf));
    return ;
}

int lynqParseRndisCommand(const char* cmd,char **argv)
{
    char test[1024];
    char *token;
    char *str = test;
    char *string;
    char *lynq_str_buf;
    char *parameter;
    int cnt = 0;
    memcpy(test, cmd, strlen(cmd));  
    if(strstr(cmd,"="))
    {
        token = strtok(str, "=");
        lynq_str_buf = strstr(token, "+");
    cnt++;
    if((strlen(lynq_str_buf)) <LYNQ_RNDIS_MALLOC_LEN)
        {
             bzero(argv[0], LYNQ_RNDIS_MALLOC_LEN);
             memcpy(argv[0],lynq_str_buf,strlen(lynq_str_buf));
        }   
    
        while (token != NULL)
        {
            string = token;
            token = strtok(NULL, "=");
        }
        parameter = strtok(string, ",");
        int i = 1;
        while (parameter != NULL)
        {
         if(((strlen(parameter)) <LYNQ_RNDIS_MALLOC_LEN) && (cnt < MAX_RNDIS_NUM))
             {
                 cnt++;
                     bzero(argv[i], LYNQ_RNDIS_MALLOC_LEN);
                 memcpy(argv[i++],parameter,strlen(parameter));
         }
            parameter = strtok(NULL, ",");
        }
    }
    if(cnt > MAX_RNDIS_NUM)
        return -1;
    return cnt;
}


int lynq_deal_with_rndis(int cmd_num,char **lynq_rndis_arr)
{
    FILE *fp;
    char lynq_rndis_dev[LYNQ_RNDIS_MALLOC_LEN+32] = {0};
    char lynq_rndis_buf[1024];
    char lynq_rndis_log_buf[256];
    int m = 1;
    if(0 == strcmp(lynq_rndis_arr[0], "+LRNDISHANDLE"))
    {
//            lynq_rndis_response_ttyGS3("##############\n");
        for(m = 1; m < cmd_num; m++)
        {
/*                bzero(lynq_rndis_log_buf, 256);
            sprintf(lynq_rndis_log_buf,"cmd_num:%d,m=%d:%s\n",cmd_num,m,lynq_rndis_arr[m]);
            lynq_rndis_response_ttyGS3(lynq_rndis_log_buf);
*/        
            bzero(lynq_rndis_buf, 1024);

            bzero(lynq_rndis_dev, (LYNQ_RNDIS_MALLOC_LEN+32));
            sprintf(lynq_rndis_dev,"%s  2>&1",lynq_rndis_arr[m]);
            fp=popen(lynq_rndis_dev, "r");
            usleep(500);
//                sleep(2);
            fgets(lynq_rndis_buf,sizeof(lynq_rndis_buf),fp);
            pclose(fp);
            if(strlen(lynq_rndis_buf) > 0)
            {
                lynq_rndis_response_ttyGS3(lynq_rndis_buf);
                lynq_rndis_response_ttyGS3("\n");
            }
        }

    }
    return 1;
}

int lynq_open_rndis(int cmd_num,char **lynq_argv)
{
    for(int j = 0;j<cmd_num;j++)
        {
            lynq_rndis_response_ttyGS3(lynq_argv[j]);
        lynq_rndis_response_ttyGS3("\n");
        }
    return 1;
}

int lynq_get_rndis_data(char *rndis_data)
{
    int lynq_argc_num = 0;
    char *lynq_str_argv[MAX_RNDIS_NUM];

for(int i = 0;i < MAX_RNDIS_NUM; i++)
{
    lynq_str_argv[i] = (char*)calloc(1,LYNQ_RNDIS_MALLOC_LEN); 
    if(lynq_str_argv[i] == NULL)
    {
        return -1;
    }    
}

    lynq_argc_num = lynqParseRndisCommand(rndis_data,lynq_str_argv);
//    lynq_open_rndis(lynq_argc_num,lynq_str_argv);
    lynq_deal_with_rndis(lynq_argc_num,lynq_str_argv);
for(int mm= 0;mm < MAX_RNDIS_NUM; mm++)
{
    if(lynq_str_argv[mm] != NULL)
    {
        free(lynq_str_argv[mm]);
        lynq_str_argv[mm] = NULL;
    }    
}
    return 1;
}

#ifdef __cplusplus
}
#endif
