/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef SRC_UTIL_RADIO_CAPABILITY_SWITCH_UTIL_H_
#define SRC_UTIL_RADIO_CAPABILITY_SWITCH_UTIL_H_

#include <string>
#include <utils/String8.h>

class Radio_capability_switch_util {
public:
    static const int SIM_OP_INFO_UNKNOWN;
    static const int SIM_OP_INFO_OVERSEA;
    static const int SIM_OP_INFO_OP01;
    static const int SIM_OP_INFO_OP02;
    static const int SIM_OP_INFO_OP09;
    static const int SIM_OP_INFO_OP18;

    static const int SIM_TYPE_SIM;
    static const int SIM_TYPE_USIM;
    static const int SIM_TYPE_OTHER;

    static const int OP01_6M_PRIORITY_OP01_USIM;
    static const int OP01_6M_PRIORITY_OP01_SIM;
    static const int OP01_6M_PRIORITY_OTHER;

    // sync to ril_oem.h for dsda
    static const int SIM_SWITCH_MODE_SINGLE_TALK_MDSYS;
    static const int SIM_SWITCH_MODE_SINGLE_TALK_MDSYS_LITE;
    static const int SIM_SWITCH_MODE_DUAL_TALK;
    static const int SIM_SWITCH_MODE_DUAL_TALK_SWAP;
    static const int ENHANCEMENT_T_PLUS_T;
    static const int ENHANCEMENT_T_PLUS_W;
    static const int ENHANCEMENT_T_PLUS_C;
    static const int ENHANCEMENT_W_PLUS_C;
    static const int ENHANCEMENT_W_PLUS_W;
    static const int ENHANCEMENT_W_PLUS_NA;

public:
    Radio_capability_switch_util();
    virtual ~Radio_capability_switch_util();
    std::string get_sim_app_type(int slot);
    static int get_main_capability_phone_id();
    static bool is_sim_inserted(int slot);
    static int get_max_raf_supported();
    static int get_min_rat_supported();
    static void set_default_data_slot(int slot);
    static bool isSkipCapabilitySwitch(int majorPhoneId, int phoneNum);
    static bool isSupportSimSwitchEnhancement(int simType);
    static bool isVolteEnabled(int phoneId);
    static bool isHVolteEnabled();
    static bool isCdmaCard(int phoneId, int opInfo);
    static bool isTPlusWSupport();
    static bool isPS2SupportLTE();
    static bool getSimInfo(std::vector<int> simOpInfo, std::vector<int>  simType, int insertedStatus);
    static void sendRadioCapabilityRequest(int slotid);
    static std::string getSimImsiStatus(int slot);
private:
    static void logd(android::String8 s);
private:
    static const std::string PROPERTY_ICCID;
    static const std::string PROPERTY_CAPABILITY_SWITCH;
    // OP01 SIMs
    static const std::string PLMN_TABLE_OP01[];

    // OP02 SIMs
    static const std::string PLMN_TABLE_OP02[];

    // OP09 SIMs
    static const std::string PLMN_TABLE_OP09[];

    // OP18 SIMs
    static const std::string PLMN_TABLE_OP18[];

    // OP02 case
    static const std::string NO_SIM_VALUE;
    static const std::string CN_MCC;
    static const std::string PROPERTY_SIM_ICCID[];

    static const int IMSI_NOT_READY_OR_SIM_LOCKED;
    static const int ICCID_ERROR;

    // sim icc status
    // 0: imsi not ready
    // 1: imsi ready
    static const std::string IMSI_NOT_READY;
    static const std::string IMSI_READY;
    static const std::string PROPERTY_SIM_IMSI_STATUS[];

    static const std::string PROPERTY_RIL_FULL_UICC_TYPE[];

    static const std::string PROPERTY_RIL_CT3G[];
};

#endif /* SRC_UTIL_RADIO_CAPABILITY_SWITCH_UTIL_H_ */
