/*
 This is an internal header file.
 Here are common definitions for the vendor-ril.
 */

#ifndef __ATCI_SS_CMD_H__
#define __ATCI_SS_CMD_H__

/*
 * <classx> is a sum of integers each representing a class of information (default 7):
 * 1    voice (telephony)
 * 2    data (refers to all bearer services; with <mode>=2 this may refer only to some bearer service if TA does not support values 16, 32, 64 and 128)
 * 4    fax (facsimile services)
 * 8    short message service
 * 16   data circuit sync
 * 32   data circuit async
 * 64   dedicated packet access
 * 128  dedicated PAD access
 */
typedef enum {
  CLASS_NONE = 0,
  CLASS_VOICE = 1,
  CLASS_DATA = 2,
  CLASS_FAX = 4,
  CLASS_DEFAULT = 7,
  CLASS_SMS = 8,
  CLASS_DATA_SYNC = 16,
  CLASS_DATA_ASYNC = 32,
  CLASS_DEDICATED_PACKET_ACCESS = 64,
  CLASS_DEDICATED_PAD_ACCESS = 128,
  CLASS_MTK_LINE2 = 256,
  CLASS_MTK_VIDEO = 512,
  CLASS_DATASYNC_OR_DATAASYNC = 48,
  CLASS_VOICE_OR_SMS_OR_FAX = 13,
  CLASS_SMS_OR_FAX = 12,
  CLASS_VOICE_OR_FAX = 5,
  CLASS_DATASYNC_OR_DEDICATEDPACKETACCESS = 80,
  CLASS_DATASYNC_OR_DEDICATEDPADACCESS = 160,
  CLASS_DATASYNC_OR_VOICE = 17,
  CLASS_MTKVIDEO_OR_DATASYNC = 528
} AtInfoClassE;

#define BS_ALL                   ""
#define BS_TELE_ALL              "10"
#define BS_TELEPHONY             "11"
#define BS_TELE_DATA_ALL         "12"
#define BS_TELE_FAX              "13"
#define BS_TELE_SMS              "16"
#define BS_TELE_VGCS             "17" /* Not supported by framework */
#define BS_TELE_VBS              "18" /* Not supported by framework */
#define BS_TELE_ALL_EXCEPT_SMS   "19"
#define BS_DATA_ALL              "20"
#define BS_DATA_ASYNC_ALL        "21"
#define BS_DATA_SYNC_ALL         "22"
#define BS_DATA_CIRCUIT_SYNC     "24" /* This is also for VT call */
#define BS_DATA_CIRCUIT_ASYNC    "25"
#define BS_DATA_SYNC_TELE        "26" /* Supported by framework */
#define BS_GPRS_ALL              "99"

int atci_ss_init(void *arg);
int atci_ss_hdlr(char *cmd, int op_type, int target, char *response);

#endif

