#include <lynq_call.h>
#include <log/log.h>
#include <liblog/lynq_deflog.h>
#include <lynq_call_ext.h>
#include "cc.h"
#include <string.h>
#undef LOG_TAG
#define LOG_TAG "LYNQ_CALL_EXT"

int lynq_voice_dial(const char *num)
{
    int32_t token;
    int32_t error = -1;
    lynqCallList *msg = (lynqCallList*)malloc(sizeof(lynqCallList));
    memset(msg,0,sizeof(lynqCallList));
    msg->addr=(char *)malloc(sizeof(char));
    memset(msg->addr,0,sizeof(char));
    token = lynq_call(num, msg);
	error = msg->base.e;
	RLOGD("lynq_voice_dial,error:%d",error);

    free(msg->addr);
    msg->addr=NULL;
    free(msg);
    msg=NULL;
    return error;
}
int lynq_voice_answer()
{
    int32_t token;
	int32_t error = -1;
    lynqCallList *msg = (lynqCallList*)malloc(sizeof(lynqCallList));
    memset(msg,0,sizeof(lynqCallList));
    msg->addr=(char *)malloc(sizeof(char));
    memset(msg->addr,0,sizeof(char));
    token = lynq_call_answer(msg);
	error = msg->base.e;
	RLOGD("lynq_voice_answer,error:%d",error);	
    free(msg->addr);
    msg->addr=NULL;
    free(msg);
    msg=NULL;
    return error;
}
int lynq_reject_call_ext()
{
    lynqBase msg;
    lynq_reject_call(&msg);
    return msg.e;
}

int lynq_call_hang_up_ext()
{
   lynqBase msg;
    lynq_reject_call(&msg);
    return msg.e;
}

int lynq_get_spk_modem_volume()
{
 return mixer_get_volume();
}
int lynq_set_spk_modem_volume(int volume)
{
  return mixer_set_volume(volume);
}
 int lynq_set_call_mute(int mute)
 {
   return setCallMute(mute);
 }
 int lynq_get_call_mute()
 {
  return getCallMute();
 
 }
	

