#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

echo "Modem on/off"
if [ ! -n "$1" ]
then
        echo -E "Error:"
        echo -E "please input parameter, you can input 'ModemOn -h' for more details"
        exit 1
fi

if [ "$1" == "-h" ]
then
	echo -E "modem power on /modem power off"
	echo -E "Usage: Modem On data"
	echo -E "where data := {1|0}"
	echo -E "0, /*modem off*/"
	echo -E "1, /*modem on*/"
	exit 0
fi

data=$1
#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
if [ "$1" == "0" ]
then
	echo -E "modem power off."
	echo "RIL_REQUEST_MODEM_POWEROFF $data" >&9
else
	echo -E "modem power on."
	echo "RIL_REQUEST_MODEM_POWERON $data" >&9
fi

#close socket R/W
exec 9>&-
exec 9<&-
exit 0