#!/bin/bash
#Copyright (c) [2016], MediaTek Inc. All rights reserved.
#This software/firmware and related documentation ("MediaTek Software") are protected under relevant copyright laws.
#The information contained herein is confidential and proprietary to MediaTek Inc. and/or its licensors.
#Except as otherwise provided in  the applicable licensing terms with MediaTek Inc. and/or its licensors, any reproduction, 
#modification, use or disclosure of MediaTek Software, and information contained herein, in whole or in part, shall be strictly prohibited.

if [ ! -n "$1" ]
then
	echo -E "Error:"
	echo -E "please input parameter, you can input ' SetPrefferredNetworkType -h' for more details"
	exit 1
fi
if [ "$1" == "-h" ]
then
	echo -E "Usage: SetPrefferredNetworkType PreferredNetworkType"
	echo -E "0 : GSM/WCDMA (WCDMA preferred)"
	echo -E "1 : GSM only"
	echo -E "2 : WCDMA"
	echo -E "3 : GSM/WCDMA (auto mode, according to PRL)"
	echo -E "4 : CDMA and EvDo (auto mode, according to PRL)"
	echo -E "5 : CDMA only"
	echo -E "6 : EvDo only"
	echo -E "7 : GSM/WCDMA, CDMA, and EvDo (auto mode, according to PRL)"
	echo -E "8 : LTE, CDMA and EvDo"
	echo -E "9 : LTE, GSM/WCDMA"
	echo -E "10: LTE, CDMA, EvDo, GSM/WCDMA"
	echo -E "11: LTE only"
	echo -E "12: LTE/WCDMA"
	echo -E "23: NR 5G only mode"
	echo -E "24: NR 5G, LTE"
	echo -E "25: NR 5G, LTE, CDMA and EvDo "
	echo -E "31: NR 5G, LTE, TD-SCDMA, WCDMA"
	echo -E "32: NR 5G, LTE, TD-SCDMA, GSM and WCDMA"
	echo -E "33: NR 5G, LTE, TD-SCDMA, CDMA, EVDO, GSM and WCDMA"
	exit 0
fi

PreferredNetworkType=$1
echo "set prefferred network type."
#open a socket, communicated with Service.
exec 9<> /dev/udp/127.0.0.1/8000

#send Terminal response CMD
echo "RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE $PreferredNetworkType" >&9

#close socket R/W
exec 9>&-
exec 9<&-
exit 0
