/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "CommandBody.h"
#include "../../utils/GostEcallUtils.h"

using namespace std;

#undef LOG_TAG
#define LOG_TAG "DEMO_EGOST_CommandBody"

CommandBody::CommandBody() {
    ADR  = UINT16_MAX;

    //8bit
    SzAct = UINT8_MAX;
    SZ = UINT8_MAX; //4bit
    ACT = UINT8_MAX; //4bit

    CCD = UINT16_MAX;
    DT = "";  //O
}

CommandBody::~CommandBody() {
    // TODO Auto-generated destructor stub
}

std::uint8_t CommandBody::getAct() const {
    return ACT;
}

void CommandBody::setAct(std::uint8_t act) {
    ACT = act;
}

std::uint16_t CommandBody::getAdr() const {
    return ADR;
}

void CommandBody::setAdr(std::uint16_t adr) {
    ADR = adr;
}

std::uint16_t CommandBody::getCcd() const {
    return CCD;
}

void CommandBody::setCcd(std::uint16_t ccd) {
    CCD = ccd;
}

const std::string& CommandBody::getDt() const {
    return DT;
}

void CommandBody::setDt(const std::string dt) {
    DT = dt;
}

std::uint8_t CommandBody::getSz() const {
    return SZ;
}

void CommandBody::setSz(std::uint8_t sz) {
    SZ = sz;
}

std::uint8_t CommandBody::getSzAct() const {
    return SzAct;
}

void CommandBody::setSzAct(std::uint8_t szAct) {
    SzAct = szAct;
}

int CommandBody::decodeCmdDt() {
    if (EcallUtils::isEcallCmd(CCD)) {
        deEcallUtils = std::make_shared<EcallUtils>();
        deEcallUtils->decodeECallCmd(CCD, DT);
    } else if (CmdUtils::isCmdCommands(CCD)) {
        deCmdUtils = std::make_shared<CmdUtils>();
        deCmdUtils->decodeCmdCommand(CCD, DT);
    } else {
        MTK_RLOGW("don't support, return");
    }
    return 0;
}

bool CommandBody::isIncludedCmdCode(std::uint16_t cmd) {
    bool ret = (cmd == CCD);
    MTK_RLOGD("cmd=0X%04X, ccd=0X%04X, ret: %d", cmd, CCD, ret);
    return ret;
}

bool CommandBody::isNeedNewSms() {
    MTK_RLOGD("ccd=0X%04X", CCD);
    if(!deEcallUtils) {
        MTK_RLOGW("no decode ecall utils");
        return false;
    }
    return deEcallUtils->isNeedNewSms();
}

int CommandBody::getEcallReqPara() {
    MTK_RLOGD("ccd=0X%04X", CCD);
    if(!deEcallUtils) {
        MTK_RLOGW("no decode ecall utils");
        return 0;
    }
    return deEcallUtils->getEcallReqPara();
}
