/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef BITWISEINPUTSTREAM_H_
#define BITWISEINPUTSTREAM_H_
#include <cstdint>
#include <vector>

class BitwiseInputStream {
public:
  BitwiseInputStream(std::vector<uint8_t> buf);
  virtual ~BitwiseInputStream();

  /**
   * Return the number of bit still available for reading.
   */
  int available();

  /**
   * Read some data and increment the current position.
   *
   * The 8-bit limit on access to bitwise streams is intentional to
   * avoid endianness issues.
   *
   * @param bits the amount of data to read (gte 0, lte 8)
   * @return byte of read data (possibly partially filled, from lsb)
   */
  uint32_t read(uint32_t bits);

  /**
   * Read data in bulk into a byte array and increment the current position.
   *
   * @param bits the amount of data to read
   * @return newly allocated byte array of read data
   */
  //uint8_t* readByteArray(uint32_t bits, int* length);
  std::vector<uint8_t> readByteVector(uint32_t bits);
  /**
   * Increment the current position and ignore contained data.
   *
   * @param bits the amount by which to increment the position
   */
  void skip(uint32_t bits);
private:
  // The byte array being read from.
  //uint8_t* mBuf;
  std::vector<uint8_t> mBuf;

  // The current position offset, in bits, from the msb in byte 0.
  uint32_t mPos;

  // The last valid bit offset.
  uint32_t mEnd;

};

#endif /* BITWISEINPUTSTREAM_H_ */
