#ifndef __LYNQ_MEDIA_H__
#define __LYNQ_MEDIA_H__
typedef enum {
     VOLUME_LEVEL1= 1,
     VOLUME_LEVEL2,
     VOLUME_LEVEL3,
     VOLUME_LEVEL4,
     VOLUME_LEVEL5,
     VOLUME_LEVEL6,
     VOLUME_LEVEL7,
}volume_level_t;
typedef enum {
     MIC_VOLUME_LEVEL1= 1,
     MIC_VOLUME_LEVEL2,
     MIC_VOLUME_LEVEL3,
     MIC_VOLUME_LEVEL4,
     MIC_VOLUME_LEVEL5,
     MIC_VOLUME_LEVEL6,
     MIC_VOLUME_LEVEL7,
}mic_volume_level_t;

#define VOLUME_MAX 7
#define VOLUME_MIN 1

int lynq_spk_volume_up();
int lynq_spk_volume_down();
int lynq_get_spk_volume(int* volume);
int lynq_set_spk_volume(const int volume);
int lynq_get_mic_volume(int* volume);
int lynq_set_mic_volume(const int volume);
int lynq_get_pa_volume(int* volume);
int lynq_set_pa_volume(const int volume);

/*dongyu@2023.6.27 Add Tone sound play, stop and status acquisition interface start*/
int lynq_set_audtone(double high_freq, double low_freq, double duration, \
                int stop_interval, int num_repetitions);
int lynq_get_audtone(double* high_freq, double* low_freq, double* duration, \
                int* stop_interval, int* num_repetitions);
void lynq_stop_audtone();
/*dongyu@2023.6.27 Add Tone sound play, stop and status acquisition interface end*/
int lynq_media_play_audio(const char *path);
void lynq_media_stop_audio();
#endif  //__LYNQ_MEDIA_H__
