#include <stdio.h>
#include <stdlib.h>
#include "lynq_medial.h"
#include <syslog.h>
#include <gst/gst.h>
#include <pthread.h>
#include <cutils/properties.h>
//#include "modem_afe_ctrl.h"
#include <fcntl.h>
#include <linux/i2c-dev.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <stdint.h>
#include <math.h>
#include <unistd.h>
#include <pthread.h>
#define AUDIO_PATH get_customer_tone_path()
#define SAMPLE_RATE get_customer_tone_sample_rate()
typedef struct {
    size_t size;
    unsigned short* data;
    double high_freq;
    double low_freq;
    double duration;
    int stop_interval;
    int num_repetitions;
} wav_t;
wav_t g_current_tone = {0};
#include <log/log.h>
#include "liblynq-codec/lynq_codec.h"
#define LOG_TAG "MEDIA_API"
#define NV_VOLUME_NAME    "ro.spk.volume.level"
#define NV_MIC_VOLUME_NAME    "ro.mic.volume.level"
//static char *volume_rcv = "/tmp/libmodem-afe-ctrl/server_rcv";
static const int VOLUME_LEVEL_1 = 1;//0;
static const int VOLUME_LEVEL_2 = 22;//200;
static const int VOLUME_LEVEL_3 = 43;//209;
static const int VOLUME_LEVEL_4 = 64;//220;
static const int VOLUME_LEVEL_5 = 85;//234;
static const int VOLUME_LEVEL_6 = 106;//245;
static const int VOLUME_LEVEL_7 = 127;//255;

static const int MIC_VOLUME_LEVEL_1 = 9;
static const int MIC_VOLUME_LEVEL_2 = 19;
static const int MIC_VOLUME_LEVEL_3 = 28;
static const int MIC_VOLUME_LEVEL_4 = 37;
static const int MIC_VOLUME_LEVEL_5 = 46;
static const int MIC_VOLUME_LEVEL_6 = 55;
static const int MIC_VOLUME_LEVEL_7 = 63;

typedef void *MEDIA_HANDLE;
volatile static MEDIA_HANDLE g_media_handle=NULL;

typedef struct {
  MEDIA_HANDLE handle;
  gint mute;		
  gdouble volume;
  pthread_t thread;
  GMainLoop *loop;
  GstElement *playbin;
  guint bus_watch_id;
  GstState gst_cur_state;
} MEDIA_PARAM_T;

static gboolean
  bus_call (GstBus * bus, GstMessage * msg, gpointer datas)
  {
    GstState oldstate, newstate, pending;
    MEDIA_PARAM_T *param = (MEDIA_PARAM_T *)datas;
    GMainLoop *loop = param->loop;
    switch (GST_MESSAGE_TYPE (msg)) {
      case GST_MESSAGE_EOS:{
        RLOGD ("End-of-stream\n");
        g_main_loop_quit (loop);
        break;
      }
      case GST_MESSAGE_STATE_CHANGED:
        gst_message_parse_state_changed (msg, &oldstate, &newstate, &pending);
        param->gst_cur_state = newstate;
        break;
      case GST_MESSAGE_ERROR:{
        gchar *debug;
        GError *err;
        gst_message_parse_error (msg, &err, &debug);
        g_printerr ("Debugging info: %s\n", (debug) ? debug : "none");
        g_free (debug);
        RLOGD ("Error: %s\n", err->message);
        g_error_free (err);
  
        g_main_loop_quit (loop);
  
        break;
      }
      default:
        break;
    }
    return TRUE;
  }
int lynq_get_mic_current_volume()
{
    char  cvolume_levle[5]= {0};
    property_get(NV_MIC_VOLUME_NAME, cvolume_levle, "5");
	printf("lynq_media_get_current_volume end :%s\n" ,cvolume_levle);
    return atoi(cvolume_levle);
	 
}
static void lynq_set_mic_volume_to_nvram(const int volume_levle )
{
    char buf[5];
    sprintf(buf, "%d", volume_levle);
    property_set(NV_MIC_VOLUME_NAME, buf);

}
static int lynq_set_mic_real_volume(const int real_volume)
{
    char cmd[256];
    RLOGD("mic real volume: %d \n", real_volume);
    sprintf(cmd, "amixer -c0 cset name=\"PGA Volume\" %d", real_volume);
    system(cmd);
    return 0;
}
static int get_mic_real_volume(const int volume_levle)
{
    int real_volume;
    switch (volume_levle) {
    case MIC_VOLUME_LEVEL1:
        real_volume = MIC_VOLUME_LEVEL_1;
        break;
    case MIC_VOLUME_LEVEL2:
        real_volume = MIC_VOLUME_LEVEL_2;
        break;
    case MIC_VOLUME_LEVEL3:
        real_volume = MIC_VOLUME_LEVEL_3;
        break;
    case MIC_VOLUME_LEVEL4:
        real_volume = MIC_VOLUME_LEVEL_4;
        break;
    case MIC_VOLUME_LEVEL5:
        real_volume = MIC_VOLUME_LEVEL_5;
        break;
    case MIC_VOLUME_LEVEL6:
        real_volume = MIC_VOLUME_LEVEL_6;
        break;
    case MIC_VOLUME_LEVEL7:
        real_volume = MIC_VOLUME_LEVEL_7;
        break;
    default:
        syslog(LOG_ERR, "Not the correct parameter");
        return 0;
    } 
    return real_volume;
}
 int lynq_set_mic_volume(const int volume) {
    int real_volume;
    if((volume>MIC_VOLUME_LEVEL7)||(volume<MIC_VOLUME_LEVEL1))
    return 1;
    lynq_set_mic_volume_to_nvram(volume);
    real_volume = get_mic_real_volume(volume);
    lynq_set_mic_real_volume(real_volume);
    return 0;
}

int lynq_get_mic_volume(int* volume) {
    if(volume==NULL)
    {
        return 1;
    }
   
    (*volume) = lynq_get_mic_current_volume();
    return 0;
}
int lynq_get_spk_current_volume()
{
    char  cvolume_levle[5] = {0};
    property_get(NV_VOLUME_NAME, cvolume_levle, "5");
    printf("lynq_media_get_current_volume end :%s\n" ,cvolume_levle);
    return atoi(cvolume_levle);
	 
}
static void lynq_set_spk_volume_to_nvram(const int volume_levle )
{
    char buf[5] = {0};
    sprintf(buf, "%d", volume_levle);
    property_set(NV_VOLUME_NAME, buf);
}
static int lynq_set_spk_real_volume(const int volume)
{
    char cmd[256];
    RLOGD("spk real volume: %d \n", volume);
   // sprintf(cmd, "amixer -c0 cset name=\"Playback Volume\" %d", volume);
    sprintf(cmd, "amixer -c0 cset name=\"Line DAC Playback Volume\" %d", volume);
    system(cmd);
    return 0;
}
static int get_spk_real_volume(const int volume_levle)
{
    int real_volume;
    switch (volume_levle) {
    case VOLUME_LEVEL1:
        real_volume = VOLUME_LEVEL_1;
        break;
    case VOLUME_LEVEL2:
        real_volume = VOLUME_LEVEL_2;
        break;
    case VOLUME_LEVEL3:
        real_volume = VOLUME_LEVEL_3;
        break;
    case VOLUME_LEVEL4:
        real_volume = VOLUME_LEVEL_4;
        break;
    case VOLUME_LEVEL5:
        real_volume = VOLUME_LEVEL_5;
        break;
    case VOLUME_LEVEL6:
        real_volume = VOLUME_LEVEL_6;
        break;
    case VOLUME_LEVEL7:
        real_volume = VOLUME_LEVEL_7;
        break;
    default:
        syslog(LOG_ERR, "Not the correct parameter");
        return 0;
    } 
    return real_volume;
}
int lynq_spk_volume_up()
{ 
    int real_volume,current_volume;
    current_volume = lynq_get_spk_current_volume();
    if(VOLUME_LEVEL7 == current_volume)
    {
        return 1;
    }
    else
    {
        lynq_set_spk_volume_to_nvram(current_volume+1);
        real_volume = get_spk_real_volume(current_volume+1);
        lynq_set_spk_real_volume(real_volume);
        return 0;
    }
	
}
int lynq_spk_volume_down()
{   
    int real_volume,current_volume;
    current_volume = lynq_get_spk_current_volume();
	
    if(VOLUME_LEVEL1 == current_volume)
    {
        return 1;
    }
    else
    {
        lynq_set_spk_volume_to_nvram(current_volume-1);
        real_volume = get_spk_real_volume(current_volume-1);
        lynq_set_spk_real_volume(real_volume);
        return 0;
    }
	
}

int lynq_set_spk_volume(const int volume)
{
    if((volume>VOLUME_LEVEL7)||(volume<VOLUME_LEVEL1))
    return 1;
    lynq_set_spk_volume_to_nvram(volume);
    int real_volume = get_spk_real_volume(volume);
    lynq_set_spk_real_volume(real_volume);
    return 0;
}
int lynq_get_spk_volume(int* volume) {
    if(volume==NULL)
    {
        return 1;
    }
    (*volume) = lynq_get_spk_current_volume();
    return 0;
}

/*dongyu@2023.6.27 Add Tone sound play, stop and status acquisition interface start*/
static int is_current_media_playing()
{
    if (g_media_handle == NULL)
    {
        RLOGD("is_current_media_playing g_media_handle is NULL\n");
        return 0;
    }

    MEDIA_PARAM_T *param = (MEDIA_PARAM_T *)g_media_handle;

    if (g_media_handle != param->handle)
    {
        RLOGD("invalid handle: %p \n", g_media_handle);
    }

    if (param->gst_cur_state == GST_STATE_PLAYING)
    {
        RLOGE("Error: already in playback state\n");
        return 1;
    }

    return 0;
}

static int lynq_generate_wav(double high_freq, double low_freq, double duration, wav_t* wav)
{
    int num_repeats = 10;
    int num_samples = (int)(SAMPLE_RATE * duration);
    wav->size = num_samples * sizeof(int16_t);
    wav->data = (int16_t*)malloc(wav->size);
    if(wav->data == NULL)
    {
        RLOGE("Memory allocation failed\n");
        return -1;
    }
    for (int i = 0; i < num_samples; i++)
    {
        double t = (double)i / SAMPLE_RATE;
        double signal1 = 0.0;
        double signal2 = 0.0;
        for (int j = 0; j < num_repeats; j++)
	{
            double f = (j % 2 == 0) ? high_freq : low_freq;
            signal1 += sin(2.0 * M_PI * f * t);
            f = (j % 2 == 0) ? low_freq : high_freq;
            signal2 += sin(2.0 * M_PI * f * t);
        }
        double signal = (signal1 + signal2) / 2;
        wav->data[i] = (int16_t)(32767.0 * signal / num_repeats);
        if (i % (int)(SAMPLE_RATE * 50) == 0)
	{
            num_repeats = (num_repeats == 1) ? 2 : 1;
        }
    }
    return 0;
}

int lynq_set_audtone(double high_freq, double low_freq, double duration, \
                int stop_interval, int num_repetitions)
{
    if(high_freq<100 || high_freq>4000 || low_freq<100 || low_freq>4000 || \
            duration<0 || duration>60000 || \
            stop_interval<0 || stop_interval>60000 || \
            num_repetitions<1 || num_repetitions>300)
    {
        RLOGE("Frequency range is 100Hz~4KHz, duration range is 0~60000ms, "
            "stop_interval range is 0~60000ms, num_repetitions range is 1~300\n");
        return -1;
    }
    RLOGE("SET: high_freq=%.2f, low_freq=%.2f, duration=%.2f, "
            "stop_interval=%d, num_repetitions=%d\n", high_freq, \
            low_freq, duration, stop_interval, num_repetitions);

    //Checks if the aplay exists before entering the thread
    if(is_current_media_playing() != 0)
    {
        RLOGE("There is currently media playing\n");
        return 1;
    }

    wav_t wav = {0};
    if(lynq_generate_wav(high_freq, low_freq, duration / 1000.0, &wav) != 0)
    {
        RLOGE("Failed to generate wav\n");
        free(wav.data);
        return -1;
    }

    wav_t stop_wav = {0};
    if(lynq_generate_wav(0, 0, stop_interval / 1000.0, &stop_wav) != 0)
    {
        RLOGE("Failed to generate top wav\n");
        free(wav.data);
        free(stop_wav.data);
        return -1;
    }

    FILE* file = fopen(AUDIO_PATH, "wb");
    if(file == NULL)
    {
        RLOGE("Failed to open file\n");
        free(wav.data);
        free(stop_wav.data);
        return -1;
    }
    fwrite("RIFF", 1, 4, file);
    int chunk_size = 36 + num_repetitions * (wav.size + stop_wav.size);
    fwrite(&chunk_size, 4, 1, file);
    fwrite("WAVE", 1, 4, file);
    fwrite("fmt ", 1, 4, file);
    int subchunk1_size = 16;
    fwrite(&subchunk1_size, 4, 1, file);
    unsigned short audio_format = 1;
    fwrite(&audio_format, 2, 1, file);
    unsigned short num_channels = 1;
    fwrite(&num_channels, 2, 1, file);
    int sample_rate = SAMPLE_RATE;
    fwrite(&sample_rate, 4, 1, file);
    int byte_rate = SAMPLE_RATE * 2;
    fwrite(&byte_rate, 4, 1, file);
    unsigned short block_align = 2;
    fwrite(&block_align, 2, 1, file);
    unsigned short bits_per_sample = 16;
    fwrite(&bits_per_sample, 2, 1, file);
     fwrite("data", 1, 4, file);
    int subchunk2_size = num_repetitions * (wav.size + stop_wav.size);
    fwrite(&subchunk2_size, 4, 1, file);

    for (int i = 0; i < num_repetitions; i++)
    {
        fwrite(wav.data, 1, wav.size, file);
        fwrite(stop_wav.data, 1, stop_wav.size, file);
    }

    fclose(file);
    free(wav.data);
    free(stop_wav.data);

    g_current_tone.high_freq = high_freq;
    g_current_tone.low_freq = low_freq;
    g_current_tone.duration = duration;
    g_current_tone.stop_interval = stop_interval;
    g_current_tone.num_repetitions = num_repetitions;
    g_current_tone.size = wav.size;
    g_current_tone.data = wav.data;

    if(lynq_media_play_audio(AUDIO_PATH) != 0)
    {
        RLOGE("Failed to play WAV fileln");
        return -1;
    }

    printf("lynq_set_audtone is playing audio !\n");

    return 0;
}

int lynq_get_audtone(double* high_freq, double* low_freq, double* duration, \
               int* stop_interval, int* num_repetitions)
{
    if(high_freq == NULL || low_freq == NULL || duration == NULL || \
		    stop_interval == NULL || num_repetitions == NULL){
        RLOGE("lynq_get_audtone Pointers are NULL, returning -1\n");
        return -1;
    }

    *high_freq = g_current_tone.high_freq;
    *low_freq = g_current_tone.low_freq;
    *duration = g_current_tone.duration;
    *stop_interval = g_current_tone.stop_interval;
    *num_repetitions = g_current_tone.num_repetitions;

    return 0;
}

void lynq_stop_audtone()
{
    lynq_media_stop_audio();
    RLOGD("lynq_stop_audtone stop audio playback\n");
}

/*dongyu@2023.6.27 Add Tone sound play, stop and status acquisition interface end*/
/*dongyu@2023.6.13 Add ZK set the PA's volume gain level start*/
int lynq_set_pa_volume(const int volume)
{
    return customer_set_pa_volume(volume);
}


int lynq_get_pa_volume(int* volume)
{
    return customer_get_pa_volume(volume);
}

/*dongyu@2023.6.13 Add ZK set the PA's volume gain level end*/
static int media_stop_full(MEDIA_PARAM_T *param)
{
  GMainLoop *loop = param->loop;
  GstElement *playbin = param->playbin;
  guint bus_watch_id = param->bus_watch_id;
  GstEvent *event_stop = NULL;
  if (param != param->handle) {
      RLOGE("invalid handle: %p \n", param->handle);
      return 1;
  }
  param->handle = NULL;	
  gst_element_set_state (playbin, GST_STATE_NULL);
  gst_object_unref (GST_OBJECT (playbin));
  g_source_remove (bus_watch_id);
  g_main_loop_unref (loop);
  
  free(param);
  set_codec(LYNQ_MEDIA, CODEC_CLOSE); //hqing add for Geely demand on 11/07/2022, stop audio, close codec
  param = NULL;
  g_media_handle=NULL;
  RLOGI("media_stop_full Thread exit\n");
  return 0;

}

void* media_thread_func(void *arg)
{
    MEDIA_PARAM_T *param = (MEDIA_PARAM_T *)arg;
    RLOGD("%s start \n", __FUNCTION__);
    g_main_loop_run (param->loop);
    RLOGD("g_main_loop_run end \n");

    media_stop_full(param);
    return ((void *)0);
}
 static void start_main_loop(const MEDIA_PARAM_T *param)
{
    pthread_attr_t attr; 
    pthread_attr_init( &attr ); 
    pthread_attr_setdetachstate(&attr,PTHREAD_CREATE_DETACHED); 
    pthread_create(&(param->thread), &attr, (void *)media_thread_func, param);
}

int lynq_media_play_audio(const char *path)
{

  GstBus *bus;
  GstMessage *msg;
  GMainLoop *loop;
  GstElement *playbin;
  gchar *uri;
  guint bus_watch_id;
  int ret;
  pthread_t thread;
  int cnt;
  MEDIA_HANDLE handle = NULL;
  MEDIA_PARAM_T *param;

  if(g_media_handle!=NULL)
  {
    RLOGE ("media is running.\n");
    return 1;
  }

  param = malloc(sizeof(MEDIA_PARAM_T));

  if (param == NULL) {
    RLOGE ("malloc MEDIA_PARAM_T fail \n");
    return 1;
  }
  memset(param, 0, sizeof(MEDIA_PARAM_T));
  handle = (MEDIA_HANDLE)param;
  g_media_handle=handle;
  param->mute = 0;
  param->volume = 1.0;
  gst_init (NULL, NULL);
  loop = g_main_loop_new (NULL, FALSE);
  playbin = gst_element_factory_make ("playbin", "playbin");
  RLOGD ("main start.\n");
  if (!playbin) {
    g_printerr ("Not all elements could be created.\n");   
    free(param); 
    g_media_handle=NULL;
    return 1;
  }

  if (gst_uri_is_valid (path))
    uri = g_strdup (path);
  else
    uri = gst_filename_to_uri (path, NULL);
  g_object_set (playbin, "uri", uri, NULL);
  g_object_set (playbin, "flags",0x42,NULL);
  g_object_set (playbin, "volume",param->volume,NULL);
  g_object_set (playbin, "mute",param->mute,NULL);

  bus = gst_element_get_bus (playbin);
  bus_watch_id = gst_bus_add_watch (bus, bus_call, (gpointer)param);
  g_object_unref (bus);
  param->playbin = playbin;
  param->bus_watch_id = bus_watch_id;
  param->thread = thread;
  param->loop = loop;
  param->handle = handle;  
  start_main_loop(param);
  RLOGD ("gst_bus_add_watch.\n");
  set_codec(LYNQ_MEDIA, CODEC_OPEN); //hqing add for Geely demand on 11/07/2022, play audio, open codec
  gst_element_set_state (playbin, GST_STATE_PLAYING);
  cnt=0;
  do {      
      if (param->gst_cur_state == GST_STATE_PLAYING)
      {
          break;
      }
      else
      {
         if (cnt==30){
            RLOGD ("After 3s, not enter playing state.\n");
            lynq_media_stop_audio();          
            return 1;
         }
         cnt++;
         usleep(100000);
      }
  } while (1);  
  RLOGD ("lynq_media_play_audio end, handle is %p\n",handle);
  return 0;
}

void lynq_media_stop_audio()
{
    if (g_media_handle == NULL) {
        RLOGE ("%s, g_media_handle is NULL\n", __FUNCTION__);
        return;
    }
    MEDIA_PARAM_T *param = (MEDIA_PARAM_T *)g_media_handle;

    if (g_media_handle != param->handle) {
        RLOGE("invalid handle: %p \n", g_media_handle);       
    }

    g_main_loop_quit (param->loop);
    pthread_join(param->thread, NULL);
    RLOGD ("lynq_media_stop_audio end\n");

    for (int i = 0; i < 50; i++)
    {
        if (g_media_handle == NULL)
	{
            RLOGD("Exit media_stop_full\n");
	    return;
        }
        usleep(100000);
        RLOGD("lynq_media_stop_audio loop %d times\n", i);
    }

    return;
}



