#include "ftp/lynq_ftp.h"

int lynq_ftp_login(lynq_ftp_socker_info *FTP)
{
	struct sockaddr_in serv_addr;
	char recvdate;
	char sendline[MAXSIZE] = "", recvline[MAXSIZE] = "";
	struct hostent *host = NULL;

	char name[MAXSIZE] = "", password[MAXSIZE] = "";
	LYDBGLOG("[%s-%d] ftp,enter the hostname = %s\n", __FUNCTION__, __LINE__, FTP->sevname);
	
	host = gethostbyname(FTP->sevname);
	
	if(host == NULL)
	{
		error = 35;
		LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
		login_yes = 0;
	}
	else
	{
		FTP->control_sockfd = socket(AF_INET, SOCK_STREAM, 0);
		if(FTP->control_sockfd < 0)
		{
			error = 50;
			LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
			LYDBGLOG("[%s-%d]\n", __FUNCTION__, __LINE__);
			login_yes = 0;
		}

		bzero(&serv_addr, sizeof(serv_addr));

		memset(&serv_addr, 0, sizeof(struct sockaddr_in));
		memcpy(&serv_addr.sin_addr.s_addr, host->h_addr, host->h_length);
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_port = htons(FTP->portnum);

		if((connect(FTP->control_sockfd, (struct sockaddr*)&serv_addr, sizeof(struct sockaddr))) < 0)
		{
			error = 33;
			LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
			login_yes = 0;
		}


		recvdate = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
		if(recvdate == -1)
		{
			error = 33;
			LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
			login_yes = 0;
		}
		else if(strncmp(recvline, "220", 3) == 0)
		{
			LYDBGLOG("ftp,connect success\n");
			login_yes = 1;
		}
		else 
		{
			error = 33;
			LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
			login_yes = 0;    
		}
		if(login_yes == 1)
		{
			int sendbytes, recvbytes;

			zeromery(name, 1024);
			zeromery(password, 1024);
			zeromery(recvline, 1024);
			zeromery(sendline, 1024);
			strcat(sendline, "USER ");
			strcat(sendline, FTP->username);
			strcat(sendline, "\r\n");
			//printf("[%s %d] --->%s\n",__FUNCTION__ , __LINE__,sendline);
			sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
			if(sendbytes == -1)
			{
				error = 38;
				LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
				login_yes = 0;
				//return FTP_USER_ERROR;
			}
			recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
			if(strncmp(recvline, "331", 3) == 0)
			{
				LYDBGLOG("[%s %d] ftp,331 please specify the password.\n", __FUNCTION__ , __LINE__);
			}
			else
			{
				error = 38;
				LYDBGLOG("[%s-%d] ftp,recv date is error.%d\n", __FUNCTION__ , __LINE__, error);
				LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
				login_yes = 0;
			}
			zeromery(sendline, 1024);
			zeromery(recvline, 1024);
			//printf("ftp-> ");
			strcat(sendline, "PASS ");
			strcat(sendline, FTP->pw);
			strcat(sendline, "\r\n");
			//printf("[%s %d]--->%s\n",__FUNCTION__, __LINE__, sendline);
			sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
			if(sendbytes == -1)
			{
				error = 39;
				LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
				login_yes = 0;
			}
			recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
			if(strncmp(recvline, "230", 3) == 0)
			{
				LYVERBLOG("+[ftp][login][session%d]: ok!!\n", FTP->session);
				login_yes = 1;
			}
			else 
			{
				error = 39;
				LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
				login_yes = 0;
			}

#if 1
			//support rest
			char str[255];
			sprintf(str, "%d", FTP->rest);
			zeromery(sendline, 1024);
			zeromery(recvline, 1024);
			strcat(sendline, "REST ");
			strcat(sendline, str);
			strcat(sendline, "\r\n");
			//printf("[%s-%d]--->%s\n", __FUNCTION__,  __LINE__,  sendline);
			sendbytes = send(FTP->control_sockfd,sendline,strlen(sendline),0);
			if(sendbytes == -1)
			{
				error = 41;
				LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
				login_yes = 0;
			}
			recvbytes = recv(FTP->control_sockfd, recvline,sizeof(recvline),0);
			if(recvbytes == -1)
			{
				error = 41;
				LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);    
				login_yes = 0;    
			}
			if(strncmp(recvline, "350",3) == 0)
			{
				LYDBGLOG("[%s-%d] support rest\n", __FUNCTION__, __LINE__);
				login_yes = 1;
			}
			else
			{
				error = 41;
				LYDBGLOG("[%s-%d] ftp,not support rest%d\n", __FUNCTION__, __LINE__, error);
				LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
				login_yes = 0;    
			}   
#endif  
		}

	}
	return login_yes;
}

void zeromery(char *a,int len)
{
	int i;
	len = sizeof(a);
	for(i = 0; i < len; i++)
	{
		a[i] = 0;
	}
}

void lynq_ftp_pwd(int control_sockfd)
{
	int recvbytes,sendbytes;
	char sendline[1024], recvline[1024];
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	strcat(sendline, "PWD");
	strcat(sendline, "\r\n");
	sendbytes = send(FTP->control_sockfd,sendline,strlen(sendline),0);
	if(sendbytes < 0)
	{
		LYDBGLOG("[%s-%d] ftp,pwd,send is error\n", __FUNCTION__, __LINE__);
		error = 52;
		LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
	}
	recvbytes = recv(FTP->control_sockfd, recvline,sizeof(recvline),0);
	if(strncmp(recvline, "257",3) == 0)
	{
		LYDBGLOG("[%s-%d] ftp,current directory is:%s\n", __FUNCTION__, __LINE__, recvline);
	}
	else
	{
		error = 51;
		LYDBGLOG("[%s-%d] ftp,pwd,recv is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][login][session%d]: error num = %d\n", FTP->session, error);
	}
}

//rest
void lynq_ftp_rest(int control_sockfd)
{

	int recvbytes,sendbytes;
	char sendline[1024], recvline[1024];
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	strcat(sendline, "REST ");
	strcat(sendline, "500");
	strcat(sendline, "\r\n");
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		error = 52;
		LYDBGLOG("[%s-%d] ftp,stru send is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][reset][session%d]: error num = %d\n", FTP->session, error);
	}
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
	if(recvbytes < 0)
	{
		error = 51;
		LYVERBLOG("+[ftp][reset][session%d]: error num = %d\n", FTP->session, error);
	}
	if(strncmp(recvline, "350",3) == 0)
	{
		LYDBGLOG("[%s-%d] ftp,%s\n", __FUNCTION__, __LINE__, recvline);
	}
}

int strtosrv(char *str)
{

	int addr[6];
	//printf("%s\n",str);
	sscanf(str, "%*[^(](%d,%d,%d,%d,%d,%d)", &addr[0], &addr[1], &addr[2], &addr[3], &addr[4], &addr[5]);

	LYDBGLOG("[%s-%d] ftp,%d,%d,%d,%d\n", __FUNCTION__, __LINE__, addr[0],addr[1],addr[2],addr[3]);
	bzero(hoster, strlen(hoster));
	sprintf(hoster, "%d.%d.%d.%d", addr[0], addr[1], addr[2], addr[3]);

	LYDBGLOG("[%s-%d] ftp,hoster = %s", __FUNCTION__, __LINE__, hoster);
	int port = addr[4]*256 + addr[5];
	LYDBGLOG("[%s-%d] ftp,port = %d\n", __FUNCTION__, __LINE__, port);
	return port;
}


int lynq_ftp_download(lynq_ftp_socker_info* FTP)
{
	char catbuf[1024];
	int data_sock;
	int recvbytes, sendbytes;
	char sendline[1024] = "", recvline[1024] = "";
	char getfilepath[FTP_MAX_ASCII_LEN+5] = "/tmp/";

#if 1
	//type

	zeromery(recvline, 1024);
	zeromery(sendline, 1024);
	strcat(sendline, "TYPE ");
	strcat(sendline, FTP->file_type);
	strcat(sendline, "\r\n");
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline),0);
	if(sendbytes < 0)
	{
		error = 52;//FTP_SEND_ERROR
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", FTP->session, error);
		return FTP_SEND_ERROR;
	}
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
	LYDBGLOG("[%s-%d] ftp,recvline = %s\n",__FUNCTION__, __LINE__, recvline);
	if(strncmp(recvline, "200", 3) == 0)
	{
		LYDBGLOG("[%s-%d] ftp,binary transmisson\n",__FUNCTION__, __LINE__);
	}
	else
	{
		error = 46; //FTP_DOWNLOAD_ERROR
		LYDBGLOG("[%s-%d] ftp,download error\n",__FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", FTP->session, error);
		return FTP_DOWNLOAD_ERROR;
	}
#endif

	zeromery(recvline, 1024);
	zeromery(sendline, 1024);
	strcat(sendline, FTP->is_pasv_mode);
	strcat(sendline, " \r\n");
	
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		error  = 52; //FTP_SEND_ERROR
		LYDBGLOG("[%s-%d] type send is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", FTP->session, error);
		return FTP_SEND_ERROR;
	}
	
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
	if(strncmp(recvline, "227", 3) == 0)
	{
		LYDBGLOG("[%s-%d] ftp,binary transmisson\n", __FUNCTION__, __LINE__);
	}
	else
	{
		error = 43;//FTP_ACTIVE_ERROR
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", FTP->session, error);
		LYDBGLOG("[%s-%d] type recv is error!\n", __FUNCTION__, __LINE__);
		return FTP_ACTIVE_ERROR;
	}

	LYDBGLOG("-------- [%s-%d] recvline = %s\n", __FUNCTION__, __LINE__, recvline);
	int port1 = strtosrv(recvline);
	data_sock = cliopen(hoster, port1);

	LYDBGLOG("[%s-%d] ftp,data_sock = %d\n", __FUNCTION__, __LINE__, data_sock);
	LYDBGLOG("[%s-%d] FTP->getfilename = %s\n", __FUNCTION__, __LINE__, FTP->getfilename);
	LYDBGLOG("[%s-%d] FTP->getfilename_path = %s\n", __FUNCTION__, __LINE__, FTP->getfilename_path);

	//send the command retr;
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	strcat(sendline, "RETR ");
	strcat(sendline, FTP->getfilename_path);
	strcat(sendline, "/");
	strcat(sendline, FTP->getfilename);
	strcat(sendline, "\r\n");
	//printf("%s\n", sendline);

	LYDBGLOG("[%s-%d] ftp,%ld\n", __FUNCTION__, __LINE__, write(FTP->control_sockfd,sendline,strlen(sendline)));
	LYDBGLOG("[%s-%d] getfilename= %s FTP->control_sockfd = %d\n", __FUNCTION__, __LINE__, FTP->getfilename, FTP->control_sockfd);
#if 1
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);

	if(recvbytes < 0)
	{
		error  = 52;//FTP_SEND_ERROR
		LYDBGLOG("[%s-%d] retr recv is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", FTP->session, error);

		return FTP_SEND_ERROR;
	}
	LYDBGLOG("[%s-%d] recvline = %s\n", __FUNCTION__, __LINE__, recvline);
	if(strncmp(recvline, "400", 3) > 0)
	{
		error = 51;//FTP_RCV_ERROR
		
		LYDBGLOG("[%s-%d] return is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", FTP->session, error);
		return FTP_RCV_ERROR;
	}

	strcat(getfilepath, FTP->getfilename);
	lynq_ftp_get(data_sock, getfilepath, FTP->session);

	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);

	strcpy(FTP->respond, recvline);

	LYDBGLOG("[%s-%d] FTP->respond = %s\n", __FUNCTION__, __LINE__, FTP->respond);

	if(strncmp(FTP->respond, "550", 3) == 0)
	{
		error = 46; //FTP_DOWNLOAD_ERROR
		LYDBGLOG("[%s-%d] download is error %d \n", __FUNCTION__, __LINE__, error);
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", FTP->session, error);

		return FTP_DOWNLOAD_ERROR;
	}

	if(strncmp(FTP->respond, "421",3) == 0)
	{
		error = 34;//FTP_TIMEROUT
		LYDBGLOG("[%s-%d] download is error %d \n", __FUNCTION__, __LINE__, error);
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", FTP->session, error);

		return FTP_TIMEROUT;
	}

	if((strncmp(FTP->respond, "226", 3) == 0) || (strncmp(FTP->respond, "125",3) == 0))
	{
		LYVERBLOG("+[ftp][get][session%d]: ok!!\n", FTP->session);
	}
#endif
	return 0;

}

int lynq_ftp_put(int sck, char *pUploadFileName_s)
{
	int handle = open(pUploadFileName_s, O_RDWR);
	int nread;
	if(handle == -1)
		return -1;
	
	while(1)
	{
		if((nread = read(handle, rbuf1, 1024)) < 0)
		{
			error = 54;//FTP_READ_ERROR
			LYDBGLOG("[%s-%d] read error!", __FUNCTION__, __LINE__);
			LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, error);
		}
		else if(nread == 0)
			break;
		LYDBGLOG("[%s-%d] rbuf1 = %s \n", __FUNCTION__, __LINE__, rbuf1);

		if(write(sck, rbuf1, nread) != nread){
			error = 54;
			LYDBGLOG("[%s-%d] send error!", __FUNCTION__, __LINE__);
			LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, error);
		}
		memset(rbuf1,0,1024);
	}
	if(close(sck) < 0)
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, FTP_CLOSE_ERROR);

	return 0;
}


int lynq_ftp_up(lynq_ftp_socker_info* FTP)
{
	char catbuf[1024];
	int data_sock;
	int recvbytes,sendbytes;
	char sendline[1024], recvline[1024];
	int put_ret = -1;

	if((access(FTP->putfilename, F_OK)) == -1)   
	{	
		//FTP_SOCK_ERROR
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, FTP_SOCK_ERROR);
		LYDBGLOG("[%s-%d] %s file does not exist\n", __FUNCTION__, __LINE__, FTP->putfilename);
		return FTP_SOCK_ERROR;
	}	
	
#if 1
	zeromery(recvline, 1024);
	zeromery(sendline, 1024);
	strcat(sendline, "TYPE ");
	strcat(sendline, FTP->file_type);
	strcat(sendline, "\r\n");
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		LYDBGLOG("[%s-%d] ftp type send is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, FTP_SEND_ERROR);
		return FTP_SEND_ERROR;
	}
	recvbytes = recv(FTP->control_sockfd, recvline,sizeof(recvline),0);
	if(strncmp(recvline, "200",3) == 0)
	{
		LYDBGLOG("[%s-%d] initalize\n", __FUNCTION__, __LINE__);
	}
	else
	{
		LYDBGLOG("[%s-%d] type recv is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, FTP_RCV_ERROR);
		return FTP_RCV_ERROR;
	}
#endif

	//PASV   
	zeromery(recvline, 1024);
	zeromery(sendline, 1024);
	strcat(sendline, FTP->is_pasv_mode);
	strcat(sendline, " \r\n");
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		LYDBGLOG("[%s-%d] type send is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, FTP_SEND_ERROR);
	}
	recvbytes = recv(FTP->control_sockfd, recvline,sizeof(recvline), 0);
	if(strncmp(recvline, "227", 3) == 0)
	{
		LYDBGLOG("[%s-%d] binary transmisson\n", __FUNCTION__, __LINE__);
	}
	else
	{
		error = 43;//FTP_ACTIVE_ERROR
		LYDBGLOG("[%s-%d] type recv is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, error);
		return FTP_ACTIVE_ERROR;
	}

	//init datelink  server port information
	int port1 = strtosrv(recvline);
	LYDBGLOG("[%s-%d] ftp,hoster =%s,port1 = %d\n", __FUNCTION__, __LINE__, hoster,port1);
	data_sock = cliopen(hoster, port1);

	LYDBGLOG("[%s-%d] ftp,data_sock = %d\n", __FUNCTION__, __LINE__, data_sock);
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	strcat(sendline, FTP->put_opt);
	strcat(sendline, " ");
	strcat(sendline, FTP->putfilename_path);
	strcat(sendline, "/");
	strcat(sendline, FTP->putfilename);
	strcat(sendline, "\r\n");

	LYDBGLOG("[%s-%d] ftp,%s\n", __FUNCTION__, __LINE__, sendline);
	LYDBGLOG("%ld\n", write(FTP->control_sockfd, sendline, strlen(sendline)));
	LYDBGLOG("[%s-%d] ftp,filename = %s\n", __FUNCTION__, __LINE__, FTP->putfilename);
	

	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);

	LYDBGLOG("RETR RECVLINE = %s\n", recvline);
	if(recvbytes < 0)
	{
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, FTP_RCV_ERROR);
		LYDBGLOG("[%s-%d] retr recv is error!\n", __FUNCTION__, __LINE__);
		return FTP_RCV_ERROR;
	}
	if(strncmp(recvline, "400", 3) > 0)
	{
		error = 400;
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, error);
	}

	lynq_ftp_put(data_sock, FTP->putfilename);
	
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);

	strcpy(FTP->respond, recvline);

	if(strncmp(FTP->respond, "226",3) == 0)
	{
		LYDBGLOG("[%s-%d] FTP->respond = %s\n", __FUNCTION__, __LINE__, FTP->respond);
		LYVERBLOG("+[ftp][up][session%d]: ok!!\n", FTP->session);
	}
	else
	{
		error = 45;//FTP_UPLOAD_ERROR
		LYVERBLOG("+[ftp][up][session%d]: error num = %d\n", FTP->session, error);
		return FTP_UPLOAD_ERROR;
	}
	return 0;

}


int lynq_ftp_ls(lynq_ftp_socker_info* FTP)
{
	char catbuf[1024];
	int data_sock;
	int recvbytes, sendbytes;
	char sendline[1024], recvline[1024];  

	
	//PASV   
	zeromery(recvline, 1024);
	zeromery(sendline, 1024);
	strcat(sendline, FTP->is_pasv_mode);
	strcat(sendline, " \r\n");
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		LYDBGLOG("[%s-%d] type send is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][ls][session%d]: error num = %d\n", FTP->session, FTP_SEND_ERROR);
		return FTP_SEND_ERROR;
	}
	recvbytes = recv(FTP->control_sockfd, recvline,sizeof(recvline), 0);
	if(strncmp(recvline, "227",3) == 0)
	{
		LYDBGLOG("[%s-%d] binary transmit\n", __FUNCTION__, __LINE__);
	}
	else
	{
		error = 43;
		LYDBGLOG("[%s-%d] type recv is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][ls][session%d]: error num = %d\n", FTP->session, error);
		return error;
	}

	//init datelink  server port information
	int port1 = strtosrv(recvline);
	LYDBGLOG("[%s-%d] ftp,hoster =%s,port1 = %d\n", __FUNCTION__, __LINE__, hoster,port1);
	data_sock = cliopen(hoster, port1);

	//printf("data_sock = %d\n",data_sock);

	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	strcat(sendline, "LIST -al ");
	strcat(sendline, FTP->dir);
	strcat(sendline, "\r\n");

	LYDBGLOG("%ld\n", write(FTP->control_sockfd, sendline, strlen(sendline)));

	LYDBGLOG("[%s-%d] ftp,%s\n", __FUNCTION__, __LINE__,sendline);

	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);

	//printf("RETR RECVLINE = %s\n",recvline);
	LYDBGLOG("[%s-%d] recvline = %s\n", __FUNCTION__, __LINE__, recvline);

	if(recvbytes < 0)
	{
		LYVERBLOG("+[ftp][ls][session%d]: error num = %d\n", FTP->session, FTP_SEND_ERROR);
	}
	if(strncmp(recvline, "400", 3)>0)
	{
		error = 400;
		LYDBGLOG("[%s-%d] type recv is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][ls][session%d]: error num = %d\n", FTP->session, error);
		return error;
	}

	ftp_list(data_sock, FTP->session); 

	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);

	LYDBGLOG("[%s-%d] recvline = %s\n", __FUNCTION__, __LINE__, recvline);

	strcpy(FTP->respond, recvline);

	if((strncmp(FTP->respond, "226", 3) == 0) || (strncmp(FTP->respond, "150",3) == 0) || strncmp(FTP->respond, "125", 3) == 0)
	{	
		if(strstr(FTP->respond, ". 0 bytes")){//rita add @2021.07.19 for ls
			LYDBGLOG("[%s-%d] FTP->respond = %s\n", __FUNCTION__, __LINE__, FTP->respond);
			LYVERBLOG("+[ftp][ls][session%d]: error num = %d\n", FTP->session, FTP_LS_ERROR);
			return FTP_LS_ERROR;
		}
		else
			LYVERBLOG("+[ftp][ls][session%d]: ok!!\n", FTP->session);
	}
	else{
		error = 44;
		LYDBGLOG("[%s-%d] ls error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][ls][session%d]: error num = %d\n", FTP->session, error);
		return error;
	}

	return 0;
}


void lynq_ftp_get(int sck, char *pDownloadFileName, int session)
{
	int handle = open(pDownloadFileName, O_WRONLY | O_CREAT | O_TRUNC, S_IREAD| S_IWRITE);
	int nread;
	
	while(1)
	{
		//printf("%d\n",sck);
		//printf("%d\n",handle);
		if((nread = recv(sck, rbuf1, 1024, 0)) < 0)
		{
			error = 51;
			//LYDBGLOG("[%s-%d] ftp,rbuf1 = %s\n", __FUNCTION__, __LINE__, rbuf1);
			LYDBGLOG("[%s-%d] receive error\n", __FUNCTION__, __LINE__);
			LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", session, error);
			return;
		}
		else if(nread == 0)
		{
			LYDBGLOG("[%s-%d] over\n", __FUNCTION__, __LINE__);
			break;
		}
		if(write(handle, rbuf1, nread) != nread)
		{
			LYDBGLOG("[%s-%d] receive error from server!\n", __FUNCTION__, __LINE__);
			LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", session, FTP_WRITE_ERROR);
		}
		
		//LYDBGLOG("[%s-%d] rbuf1 = %s \n", __FUNCTION__, __LINE__, rbuf1);
		
		memset(rbuf1,0,1024);
	}
	if(close(sck) < 0){
		LYDBGLOG("[%s-%d] close error\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][get][session%d]: error num = %d\n", session, FTP_CLOSE_ERROR);
	}
}



int cliopen(char *hoster, int port)
{

	int control_sockfd;

	struct sockaddr_in serv_addr;
	struct hostent *host = NULL;

	//get hostent argument
	char name[MAXSIZE];
	//printf("please enter the hostname\n");
	//printf("ftp-> ");

	strcpy(name, hoster);
	host = gethostbyname(name);
	if(host == NULL)
	{
		LYDBGLOG("[%s-%d] ftp,get host by name is error!\n", __FUNCTION__, __LINE__);
		login_yes = 0;
	}
	else
	{
		//creact socket
		control_sockfd = socket(AF_INET, SOCK_STREAM, 0);
		if(control_sockfd < 0)
		{
			//printf("socket is error\n");
			LYDBGLOG("[%s-%d] ftp,socket is error\n", __FUNCTION__, __LINE__);
			login_yes = 0;
		}

		//set sockaddr_in
		bzero(&serv_addr, sizeof(serv_addr));

		memset(&serv_addr, 0, sizeof(struct sockaddr_in));
		memcpy(&serv_addr.sin_addr.s_addr, host->h_addr, host->h_length);
		serv_addr.sin_family = AF_INET;
		serv_addr.sin_port = htons(port);

		//printf("line port = %d\n",port);
		if((connect(control_sockfd, (struct sockaddr*)&serv_addr, sizeof(struct sockaddr))) < 0)
		{
			//printf("connect is error\n");
			LYDBGLOG("[%s-%d] ftp,connect is error\n", __FUNCTION__, __LINE__);
			login_yes = 0;
		} 
	}
	return control_sockfd;
}

void ftp_list(int sockfd, int session)
{
	int nread;

	for(;;)
	{
		if((nread = recv(sockfd, rbuf1, 1024, 0)) < 0)
		{
			LYDBGLOG("[%s-%d] recv error\n", __FUNCTION__, __LINE__);
		}
		else if(nread == 0)
		{
			LYDBGLOG("[%s-%d] disconnect \n", __FUNCTION__, __LINE__);
			break;
		}
		LYVERBLOG("+[ftp][ls][session%d]: data = %s\n", session, rbuf1);
		LYVERBLOG("+[ftp][ls][session%d]: ok!! \n", session);
		memset(rbuf1, 0, 1024);
	}
	if(close(sockfd) < 0){
		LYDBGLOG("[%s-%d] close error\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][ls][session%d]: error num = %d\n", session, FTP_CLOSE_ERROR);
	}
}

void lynq_ftp_cd(lynq_ftp_socker_info* FTP)
{
	char catbuf[1024];
	char sendline[1024];
	char recvline[1024];
	
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	int recvbytes, sendbytes;
	int issuccess;

	if(strcmp(FTP->del_mkr_filename, "..") == 0)
	{
		sprintf(sendline, "CDUP %s\n", FTP->del_mkr_filename);
	}
	else
	{
		sprintf(sendline, "CWD %s\n", FTP->del_mkr_filename);
	}
	strcat(sendline, "\r\n");

	LYDBGLOG("[%s-%d] %s\n", __FUNCTION__, __LINE__, sendline);
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		LYDBGLOG("cd send is error!");
		exit(1);
	}


	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
	if(strncmp(recvline, "257", 3) == 0)
	{
		issuccess = 1;
	}
	else
	{
		error = 44;
		issuccess = 0;
	}
}

void lynq_ftp_creat_mkd(lynq_ftp_socker_info* FTP)
{
	char catbuf[1024];
	char sendline[1024];
	char recvline[1024];
	
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	int recvbytes, sendbytes;
	int issuccess;
	strcat(sendline, "MKD ");
	strcat(sendline, FTP->del_mkr_filename);
	strcat(sendline, "\r\n");
	LYDBGLOG("[%s-%d] %s\n", __FUNCTION__, __LINE__, sendline);
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		LYDBGLOG("[%s-%d] mkd send is error!", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][mkdir][session%d]: error num = %s\n", FTP->session, FTP_SEND_ERROR);
		exit(1);
	}
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
	if(strncmp(recvline, "257", 3) == 0)
	{
		issuccess = 1;
		LYVERBLOG("+[ftp][mkdir][session%d]: ok!!\n", FTP->session);
	}
	else
	{
		error = 44;
		LYVERBLOG("+[ftp][mkdir][session%d]: error num = %d\n", FTP->session, error);
		issuccess = 0;
	}
}


void lynq_ftp_delete_mkd(lynq_ftp_socker_info* FTP)
{
	char sendline[1024];
	char recvline[1024];
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	int recvbytes, sendbytes;
	int issuccess;
	char catbuf[1024];
	
	strcat(sendline, "RMD ");
	strcat(sendline, FTP->del_mkr_filename);
	strcat(sendline, "\r\n");
	LYDBGLOG("[%s-%d] %s\n", __FUNCTION__, __LINE__,sendline);
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		LYDBGLOG("[%s-%d] rmd send is error!", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][rmd][session%d]: error num = %s\n", FTP->session, FTP_SEND_ERROR);
		exit(1);
	}
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
	if(strncmp(recvline, "250", 3) == 0)
	{
		issuccess = 1;
		LYVERBLOG("+[ftp][rmd][session%d]: ok!!\n", FTP->session);
	}
	else
	{
		error = 44;
		issuccess = 0;
		LYVERBLOG("+[ftp][rmd][session%d]: error num = %s\n", FTP->session, error);
	}
}

void lynq_ftp_quit(lynq_ftp_socker_info* FTP)
{

	int recvbytes, sendbytes;
	char sendline[1024], recvline[1024];
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);

	
	strcat(sendline, "bye ");
	strcat(sendline, "\n");
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		LYDBGLOG("[%s-%d] stru send is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][quit][session%d]: error num = %s\n", FTP->session, FTP_SEND_ERROR);
	}
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);

	LYDBGLOG("[%s-%d] quit = %s\n", __FUNCTION__, __LINE__, recvline);
	if(recvbytes < 0)
	{
		LYDBGLOG("[%s-%d] stru recv is error!\n", __FUNCTION__, __LINE__);
		LYVERBLOG("+[ftp][quit][session%d]: error num = %s\n", FTP->session, FTP_RCV_ERROR);
	}
	if(strncmp(recvline, "221", 3) == 0)
	{
		LYVERBLOG("+[ftp][quit][session%d]: ok!!\n", FTP->session);
	}
}

void lynq_ftp_deletefile_mkd(lynq_ftp_socker_info* FTP)
{
	char sendline[1024];
	char recvline[1024];
	
	zeromery(sendline, 1024);
	zeromery(recvline, 1024);
	int recvbytes, sendbytes;
	int issuccess;
	char catbuf[1024];
	strcat(sendline, "DELE ");
	strcat(sendline, FTP->del_mkr_filename);
	strcat(sendline, "\r\n");
	LYDBGLOG("[%s-%d] %s\n", __FUNCTION__, __LINE__,sendline);
	sendbytes = send(FTP->control_sockfd, sendline, strlen(sendline), 0);
	if(sendbytes < 0)
	{
		LYVERBLOG("+[ftp][delfile][session%d]: error num = %d\n", FTP->session, FTP_SEND_ERROR);
		exit(1);
	}
	recvbytes = recv(FTP->control_sockfd, recvline, sizeof(recvline), 0);
	if(strncmp(recvline, "250", 3) == 0)
	{
		issuccess = 1;
		LYVERBLOG("+[ftp][delfile][session%d]: ok!!\n", FTP->session);
	}
	else
	{
		error = 44;
		issuccess = 0;
		LYVERBLOG("+[ftp][delfile][session%d]: error num = %d\n", FTP->session, error);
	}
}

