inherit hsm-sign-env

python __anonymous () {
        depends = d.getVar("DEPENDS", True)
        depends = "%s u-boot-mkimage-native lz4-native" % depends
        d.setVar("DEPENDS", depends)
}

#
# Emit the fitImage ITS header
#
fitimage_emit_fit_header() {
        cat << EOF >> ${WORKDIR}/fit-image.its
/dts-v1/;

/ {
        description = "MD fitImage";
        #address-cells = <1>;
EOF
}

#
# Emit the fitImage section bits
#
# $1 ... Section bit type: imagestart - image section start
#                          confstart  - configuration section start
#                          sectend    - section end
#                          fitend     - fitimage end
#
fitimage_emit_section_maint() {
        case $1 in
        imagestart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        images {
EOF
        ;;
        confstart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        configurations {
EOF
        ;;
        sectend)
                cat << EOF >> ${WORKDIR}/fit-image.its
        };
EOF
        ;;
        fitend)
                cat << EOF >> ${WORKDIR}/fit-image.its
};
EOF
        ;;
        esac
}

fitimage_emit_section_md() {

        if [ -n "${IMAGE_HASH_ALGO}" ] ; then
            md_csum="${IMAGE_HASH_ALGO}"
        else
            md_csum="sha256"
        fi

        cat << EOF >> ${WORKDIR}/fit-image.its
                md1img_1 {
                        description = "LK based MD Image";
                        data = /incbin/("${1}");
                        type = "kernel";
                        arch = "arm";
                        os = "linux";
                        compression = "none";
                        load = <${MD_LOADADDRESS}>;
                        entry = <${MD_ENTRYPOINT}>;
                        hash_1 {
                                algo = "${md_csum}";
                        };
                };
EOF
}

#
# Emit the fitImage ITS configuration section
#
fitimage_emit_section_config_md() {

        if [ -n "${VB_HASH_ALGO}" ] && [ -n "${VB_RSA_ALGO}" ] ; then
            conf_csum="${VB_HASH_ALGO},${VB_RSA_ALGO}"
        else
            conf_csum="sha256,rsa2048"
        fi
        conf_key_name="dev"

        conf_desc="${MTK_PROJECT} configuration"

        cat << EOF >> ${WORKDIR}/fit-image.its
                default = "conf_1";
                conf_1 {
                        description = "${conf_desc}";
                        kernel = "md1img_1";
                        signature_1 {
                                algo = "${conf_csum}";
                                key-name-hint="${conf_key_name}";
                                sign-images = "kernel";
                        };
                };
EOF
}

do_assemble_mdfitimage() {

                rm -f ${WORKDIR}/fit-image.its

                fitimage_emit_fit_header

                #
                # Step 1: Prepare a md image section.
                #
                fitimage_emit_section_maint imagestart


                fitimage_emit_section_md ${WORKDIR}/modem-org.img

                fitimage_emit_section_maint sectend

                #
                # Step 2: Prepare a configurations section
                #
                fitimage_emit_section_maint confstart

                fitimage_emit_section_config_md

                fitimage_emit_section_maint sectend

                fitimage_emit_section_maint fitend

                #
                # Step 3: Assemble the image
                #
                ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -f ${WORKDIR}/fit-image.its ${WORKDIR}/${MD_IMAGE}

                if [ "${SECURE_BOOT_ENABLE}" = "yes" ]; then
                        mkdir -p ${WORKDIR}/mykeys
                        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ${WORKDIR}/mykeys/dev.crt
                        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ${WORKDIR}/mykeys/dev.key
                        ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -D "-I dts -O dtb -p 1024" -k ${WORKDIR}/mykeys -f ${WORKDIR}/fit-image.its -r ${WORKDIR}/${MD_IMAGE}
                fi
}