inherit hsm-sign-env

python __anonymous () {
    medmcutype = d.getVar('MEDMCU_IMAGETYPE', True)
    if medmcutype == 'fitImage':
        depends = d.getVar("DEPENDS", True)
        depends = "%s u-boot-mkimage-native lz4-native dtc-native " % depends
        d.setVar("DEPENDS", depends)
}

#
# Emit the fitImage ITS header
#
fitimage_emit_fit_header() {
        cat << EOF >> ${WORKDIR}/fit-image.its
/dts-v1/;

/ {
        description = "U-Boot fitImage for ${DISTRO_NAME}/${PV}/${MACHINE}";
        #address-cells = <1>;
EOF
}

#
# Emit the fitImage section bits
#
# $1 ... Section bit type: imagestart - image section start
#                          confstart  - configuration section start
#                          sectend    - section end
#                          fitend     - fitimage end
#
fitimage_emit_section_maint() {
        case $1 in
        imagestart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        images {
EOF
        ;;
        confstart)
                cat << EOF >> ${WORKDIR}/fit-image.its

        configurations {
EOF
        ;;
        sectend)
                cat << EOF >> ${WORKDIR}/fit-image.its
        };
EOF
        ;;
        fitend)
                cat << EOF >> ${WORKDIR}/fit-image.its
};
EOF
        ;;
        esac
}

#
# Emit the fitImage ITS medmcu section
#
# $1 ... Path to medmcu image
# $2 ... Compression type
fitimage_emit_section_medmcu() {

        if [ -n "${IMAGE_HASH_ALGO}" ] ; then
            medmcu_csum="${IMAGE_HASH_ALGO}"
        else
            medmcu_csum="sha256"
        fi

        cat << EOF >> ${WORKDIR}/fit-image.its
                medmcu_1 {
                        description = "medmcu";
                        data = /incbin/("${1}");
                        type = "kernel";
                        arch = "arm";
                        os = "linux";
                        compression = "none";
                        load = <${MEDMCU_LOADADDRESS}>;
                        entry = <${MEDMCU_ENTRYPOINT}>;
                        hash_1 {
                                algo = "${medmcu_csum}";
                        };
                };
EOF
}

#
# Emit the fitImage ITS configuration section
#
# $1 ... medmcu image ID
fitimage_emit_section_config() {

        if [ -n "${VB_HASH_ALGO}" -a -n "${VB_RSA_ALGO}" ] ; then
            conf_csum="${VB_HASH_ALGO},${VB_RSA_ALGO}"
        else
            conf_csum="sha256,rsa2048"
        fi
        conf_key_name="dev"
        conf_desc="medmcu configuration"

        medmcu_line="kernel = \"medmcu_1\";"
        sign_images_line="sign-images = \"kernel\";"

        cat << EOF >> ${WORKDIR}/fit-image.its
                default = "conf_1";
                conf_1 {
                        description = "${conf_desc}";
                        ${medmcu_line}
                        signature_1 {
                                algo = "${conf_csum}";
                                key-name-hint="${conf_key_name}";
                                ${sign_images_line}
                        };
                };
EOF
}

do_assemble_fitimage() {
                rm -f ${WORKDIR}/fit-image.its

                fitimage_emit_fit_header

                #
                # Step 1: Prepare a medmcu image section.
                #
                fitimage_emit_section_maint imagestart

                fitimage_emit_section_medmcu ${MEDMCU_OUT}/${MEDMCU_BINARY_SELECT}

                fitimage_emit_section_maint sectend

                #
                # Step 2: Prepare a configurations section
                #
                fitimage_emit_section_maint confstart

                fitimage_emit_section_config

                fitimage_emit_section_maint sectend

                fitimage_emit_section_maint fitend

                #
                # Step 3: Assemble the image
                #

                if [ "${SECURE_BOOT_ENABLE}" = "yes" ]; then
                        if [ "${STANDALONE_SIGN_PREPARE}" = "yes" ];then
                                ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -f ${WORKDIR}/fit-image.its ${MEDMCU_OUT}/${MEDMCU_BINARY}
                                exit 0
                        fi
                        mkdir -p ${WORKDIR}/mykeys
                        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ${WORKDIR}/mykeys/dev.crt
                        cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ${WORKDIR}/mykeys/dev.key
                        ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -D "-I dts -O dtb -p 1024" -k ${WORKDIR}/mykeys -f ${WORKDIR}/fit-image.its -r ${MEDMCU_OUT}/${MEDMCU_BINARY}
                else
                        ${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -f ${WORKDIR}/fit-image.its ${MEDMCU_OUT}/${MEDMCU_BINARY}
                fi
}

addtask assemble_fitimage before do_deploy after do_compile
