IMAGE_FSTYPES_NO_WHITESPACE="$(echo "${IMAGE_FSTYPES}" | tr -d '[:space:]')"
MCF_FS_PARTITION = "mcf_fs.ubi"

DEPENDS += "mtd-utils-native coreutils-native"

mk_mcf_image() {
	if test -f ${DEPLOY_DIR_IMAGE}/MCF_OTA_FILES.tar.gz; then
		cd ${WORKDIR}

		# Create empty directory for MCF_OTA_1
		rm -rf MCF_OTA_1
		mkdir MCF_OTA_1

		# Extract tar to MCF_OTA_2
		rm -rf MCF_OTA_2
		mkdir MCF_OTA_2
		tar zxvf ${DEPLOY_DIR_IMAGE}/MCF_OTA_FILES.tar.gz -C MCF_OTA_2

		if test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "ubi" || test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "squashfs"; then
			echo \[ubifs\] > ubinize_mcf.cfg
			echo mode=ubi >> ubinize_mcf.cfg
			echo image=${MCF_FS_PARTITION} >> ubinize_mcf.cfg
			echo vol_id=0 >> ubinize_mcf.cfg
			echo vol_type=dynamic >> ubinize_mcf.cfg
			echo vol_name=mcf >> ubinize_mcf.cfg
			echo vol_flags=autoresize >> ubinize_mcf.cfg

			# MCF_OTA_1
			echo mkfs.ubifs -r MCF_OTA_1 ${MKUBIFS_MCF_ARGS} -o ${MCF_FS_PARTITION}
			mkfs.ubifs -r MCF_OTA_1 ${MKUBIFS_MCF_ARGS} -o ${MCF_FS_PARTITION}

			echo ubinize -o MCF_MOD_OTA.img ${UBINIZE_ARGS} ubinize_mcf.cfg
			ubinize -o ${DEPLOY_DIR_IMAGE}/MCF_MOD_OTA.img ${UBINIZE_ARGS} ubinize_mcf.cfg

			rm ${MCF_FS_PARTITION}

			# MCF_OTA_2
			echo mkfs.ubifs -r MCF_OTA_2 ${MKUBIFS_MCF_ARGS} -o ${MCF_FS_PARTITION}
			mkfs.ubifs -r MCF_OTA_2 ${MKUBIFS_MCF_ARGS} -o ${MCF_FS_PARTITION}

			echo ubinize -o MCF_OEM_OTA.img ${UBINIZE_ARGS} ubinize_mcf.cfg
			ubinize -o ${DEPLOY_DIR_IMAGE}/MCF_OEM_OTA.img ${UBINIZE_ARGS} ubinize_mcf.cfg

		elif test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "ext4"; then
			# MCF_OTA_1
			dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/MCF_MOD_OTA.img seek=4096 count=0 bs=1k
			mkfs.ext4 -F -i 4096 ${DEPLOY_DIR_IMAGE}/MCF_MOD_OTA.img -d MCF_OTA_1

			# MCF_OTA_2
			dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/MCF_OEM_OTA.img seek=4096 count=0 bs=1k
			mkfs.ext4 -F -i 4096 ${DEPLOY_DIR_IMAGE}/MCF_OEM_OTA.img -d MCF_OTA_2
		else
			echo "This type of file system is not supported for MCF image: ${IMAGE_FSTYPES_NO_WHITESPACE}"
		fi

		cd -
	fi
}

ROOTFS_POSTPROCESS_COMMAND += " mk_mcf_image;"

