NVRAM_DIR_IMAGE_SIZE ?= "20480"
NVRAM_DIR_IMAGE_PATH = "${DEPLOY_DIR_IMAGE}/nvram"
IMAGE_FSTYPES_NO_WHITESPACE="$(echo "${IMAGE_FSTYPES}" | tr -d '[:space:]')"
NVRAM_FS_PARTITION = "nvram_fs.ubi"
NVRAM_PARTITION = "nvram.ubi"
DEPENDS += "mtd-utils-native coreutils-native"
mk_nvram_image() {

	rm -rf ${NVRAM_DIR_IMAGE_PATH}
	mkdir -p ${NVRAM_DIR_IMAGE_PATH}

	touch ${NVRAM_DIR_IMAGE_PATH}/raw
	truncate -s 16384K ${NVRAM_DIR_IMAGE_PATH}/raw

  if test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "ubi" || test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "squashfs"; then
	echo \[ubifs\] > ubinize_nvram.cfg
	echo mode=ubi >> ubinize_nvram.cfg
	echo image=${DEPLOY_DIR_IMAGE}/${NVRAM_FS_PARTITION} >> ubinize_nvram.cfg
	echo vol_id=0 >> ubinize_nvram.cfg
	echo vol_size=20480KiB >> ubinize_nvram.cfg
	echo vol_type=dynamic >> ubinize_nvram.cfg
	echo vol_name=nvram >> ubinize_nvram.cfg
	echo vol_flags=autoresize >> ubinize_nvram.cfg
	echo dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/${NVRAM_FS_PARTITION} seek=${NVRAM_DIR_IMAGE_SIZE} count=0 bs=1k
	dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/${NVRAM_FS_PARTITION} seek=${NVRAM_DIR_IMAGE_SIZE} count=0 bs=1k

	echo mkfs.ubifs -r ${NVRAM_DIR_IMAGE_PATH} ${MKUBIFS_NVRAM_CONFIG_ARGS} -o ${DEPLOY_DIR_IMAGE}/${NVRAM_FS_PARTITION}
	mkfs.ubifs -r ${NVRAM_DIR_IMAGE_PATH} ${MKUBIFS_NVRAM_CONFIG_ARGS} -o ${DEPLOY_DIR_IMAGE}/${NVRAM_FS_PARTITION}

	echo ubinize -o ${NVRAM_PARTITION} ${UBINIZE_ARGS} ubinize_nvram.cfg
	ubinize -o ${NVRAM_PARTITION} ${UBINIZE_ARGS} ubinize_nvram.cfg

	cp ${NVRAM_PARTITION} ${DEPLOY_DIR_IMAGE}/${NVRAM_PARTITION}

  elif test "${IMAGE_FSTYPES_NO_WHITESPACE}" = "ext4"; then
	STATE_PARTITION="nvram.ext4"
	dd if=/dev/zero of=${DEPLOY_DIR_IMAGE}/${STATE_PARTITION} seek=${NVRAM_DIR_IMAGE_SIZE} count=0 bs=1k
	mkfs.ext4 -F -i 4096 ${DEPLOY_DIR_IMAGE}/${STATE_PARTITION} -d ${NVRAM_DIR_IMAGE_PATH}
	else
	echo "No method to make ${IMAGE_FSTYPES_NO_WHITESPACE} type state image"
  fi
}

ROOTFS_POSTPROCESS_COMMAND += " mk_nvram_image;"

