IMAGE_FSTYPES_NO_WHITESPACE ?= "$(echo "${IMAGE_FSTYPES}" | tr -d '[:space:]')"
EXTRA_DIR_IMAGE_PATH := "${DEPLOY_DIR_IMAGE}/oemdata"

mk_oemdata_image(){
	if [ ! -d "$EXTRA_DIR_IMAGE_PATH" ]; then
		mkdir -p ${EXTRA_DIR_IMAGE_PATH}
		#echo "just test mount a read-write directory /oemdata" > ${EXTRA_DIR_IMAGE_PATH}/test.txt
	fi

	STATE_PARTITION="oemdata.ubifs"
	STATE_UBI="oemdata.img"	
	STATE_UBINIZE_CFG="oemdata.cfg"
	cat << EOF > ${STATE_UBINIZE_CFG}
[ubifs]
mode=ubi
image=${DEPLOY_DIR_IMAGE}/${STATE_PARTITION}
vol_id=0
vol_type=dynamic
vol_name=oemdata
vol_flags=autoresize
EOF

	#mkfs.ubifs -r ${EXTRA_DIR_IMAGE_PATH} -m 4096 -e 253952 -c 240 -o ${DEPLOY_DIR_IMAGE}/${STATE_PARTITION} ${MKUBIFS_ARGS}
	#ubinize -o ${DEPLOY_DIR_IMAGE}/${STATE_UBI} -m 4096 -p 256KiB -s 4096 ${UBINIZE_ARGS} ${STATE_UBINIZE_CFG}

	mkfs.ubifs -r ${EXTRA_DIR_IMAGE_PATH} -o ${DEPLOY_DIR_IMAGE}/${STATE_PARTITION} ${MKUBIFS_ARGS}
	ubinize -o ${DEPLOY_DIR_IMAGE}/${STATE_UBI} ${UBINIZE_ARGS} ${STATE_UBINIZE_CFG}
}
ROOTFS_POSTPROCESS_COMMAND += " mk_oemdata_image;"
