SUMMARY = "BL33-IMAGE"
inherit deploy bl33-fitimage hsm-sign-env

LICENSE = "MIT"
BL33_OUT = "${WORKDIR}/out"
LIC_FILES_CHKSUM = "file://${WORKDIR}/LICENSE;md5=411c267670838099ca82e01c7f044a7b"
SRC_URI = "file://dev_info file://pbp file://key file://lk_dts file://dummy_img file://fit-lk"
SRC_URI += " file://LICENSE "

#S = "${WORKDIR}"
DEPENDS += "u-boot-mkimage-native bc-native dtc-native"

WORKONSRC = "${TOPDIR}/../prebuilt/firmware/bl33"
BL33_BINARY = "lk.bin"
BL33_DEPLOY_BINARY = "bl33.bin"
BL33_IMAGE = "bl33.img"
PACKAGE_ARCH = "${MACHINE_ARCH}"
DEPENDS += "libgcc"
PBP_DIR = "${WORKDIR}/pbp"
KEY_DIR = "${WORKDIR}/key"
DTS_DIR = "${WORKDIR}/lk_dts"
DUMMY_IMG_DIR="${WORKDIR}/dummy_img"

IC_NAME="$(echo ${TARGET_PLATFORM}|tr '[a-z]' '[A-Z]')"
DEV_INFO_HDR_TOOL = "${TOPDIR}/../src/bsp/scatter/scripts/dev-info-hdr-tool.py"

do_configure () {
	:
}

do_genkey () {
	mkdir -p ${BL33_OUT}/include
	if [ "${SECURE_BOOT_ENABLE}" = "yes" ]; then
		mkdir -p ${WORKDIR}/mykeys
		dtc -p 0x3ff ${DTS_DIR}/lk.dts -O dtb -o ${DTS_DIR}/lk.dtb
		cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ${WORKDIR}/mykeys/dev.crt
		cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ${WORKDIR}/mykeys/dev.key
		${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -D "-I dts -O dtb -p 1024" -F -k ${WORKDIR}/mykeys -K ${DTS_DIR}/lk.dtb -r ${DUMMY_IMG_DIR}/fitImage
		OFF_DT_STRINGS="`fdtdump ${DTS_DIR}/lk.dtb | grep off_dt_strings | sed "s,^\/\/.*:\s*0x,,"`"
		SIZE_DT_STRINGS="`fdtdump ${DTS_DIR}/lk.dtb | grep size_dt_strings | sed "s,^\/\/.*:\s*0x,,"`"
		KEYNODE_LEN="`echo "obase=16;ibase=16;${OFF_DT_STRINGS} + ${SIZE_DT_STRINGS}" | bc`"
		python ${WORKDIR}/dev_info/dtb-transfer-array.py ${DTS_DIR}/lk.dtb ${DTS_DIR}/blob.h ${KEYNODE_LEN}
		cp ${DTS_DIR}/blob.h ${BL33_OUT}/include/blob.h
		rm -rf ${WORKDIR}/mykeys
	else
		cp ${DTS_DIR}/tmp_blob.txt ${BL33_OUT}/include/blob.h
	fi
}

do_compile[nostamp] = "1"
do_deploy () {
	install -d ${DEPLOYDIR}
	install ${BL33_OUT}/build-${BL33_PROJECT}/${BL33_BINARY} ${DEPLOYDIR}/${BL33_DEPLOY_BINARY}
	install ${WORKDIR}/${BL33_IMAGE} ${DEPLOYDIR}/${BL33_IMAGE}
}

addtask deploy before do_build after do_compile
do_compile() {
	echo "no source with images"
	install -d ${BL33_OUT}/build-${BL33_PROJECT}
	install -m 755 ${WORKONSRC}/${BL33_BINARY}  ${BL33_OUT}/build-${BL33_PROJECT}/${BL33_BINARY}
}


addtask genkey before do_compile after do_configure
addtask deploy before do_build after do_compile

