inherit deploy srcprebuilt externalsrc bl33-fitimage hsm-sign-env

LICENSE = "MIT"
MTK_SRC = "${TOPDIR}/../src/bsp/lk"
BL33_OUT = "${WORKDIR}/out"
LIC_FILES_CHKSUM = "file://${MTK_SRC}/LICENSE;md5=25394d472e4c06f4d61140e88861fb5b"
SRC_URI = "file://dev_info file://pbp file://key file://lk_dts file://fit-lk"
#S = "${WORKDIR}"
DEPENDS += "u-boot-mkimage-native bc-native dtc-native"

TOOLCHAIN_PREFIX = "${TARGET_PREFIX}"
EXTERNALSRC = "${MTK_SRC}"
EXTERNALSRC_BUILD = "${MTK_SRC}"
BL33_BINARY = "lk.bin"
BL33_DEPLOY_BINARY = "bl33.bin"
BL33_IMAGE = "bl33.img"
PACKAGE_ARCH = "${MACHINE_ARCH}"
DEPENDS += "libgcc"
PBP_DIR = "${WORKDIR}/pbp"
KEY_DIR = "${WORKDIR}/key"
DTS_DIR = "${WORKDIR}/lk_dts"

IC_NAME="$(echo ${TARGET_PLATFORM}|tr '[a-z]' '[A-Z]')"
DEV_INFO_HDR_TOOL = "${TOPDIR}/../src/bsp/scatter/scripts/dev-info-hdr-tool.py"

do_configure () {
	:
}

do_genkey () {
	mkdir -p ${BL33_OUT}/include
	if [ "${SECURE_BOOT_ENABLE}" = "yes" ]; then
		mkdir -p ${WORKDIR}/mykeys
		dtc -p 0x3ff ${DTS_DIR}/lk.dts -O dtb -o ${DTS_DIR}/lk.dtb
		cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.crt ${WORKDIR}/mykeys/dev.crt
		cp ${MTK_KEY_DIR}/${VERIFIED_KEY}.pem ${WORKDIR}/mykeys/dev.key

		echo -n -e \\xde\\xed\\xbe\\xef > ${DTS_DIR}/dummy.bin
		${HSM_ENV} HSM_KEY_NAME=${VERIFIED_KEY} uboot-mkimage -D "-I dts -O dtb -p 1024" -k ${WORKDIR}/mykeys -K ${DTS_DIR}/lk.dtb -r -f ${DTS_DIR}/dummy.its ${DTS_DIR}/dummyfit.img
		OFF_DT_STRINGS="`fdtdump ${DTS_DIR}/lk.dtb | grep off_dt_strings | sed "s,^\/\/.*:\s*0x,,"`"
		SIZE_DT_STRINGS="`fdtdump ${DTS_DIR}/lk.dtb | grep size_dt_strings | sed "s,^\/\/.*:\s*0x,,"`"
		KEYNODE_LEN="`echo "obase=16;ibase=16;${OFF_DT_STRINGS} + ${SIZE_DT_STRINGS}" | bc`"
		python ${WORKDIR}/dev_info/dtb-transfer-array.py ${DTS_DIR}/lk.dtb ${DTS_DIR}/blob.h ${KEYNODE_LEN}
		cp ${DTS_DIR}/blob.h ${BL33_OUT}/include/blob.h
		rm -rf ${WORKDIR}/mykeys
		rm -f ${DTS_DIR}/dummy.bin
		rm -f ${DTS_DIR}/dummyfit.img
	else
		cp ${DTS_DIR}/tmp_blob.txt ${BL33_OUT}/include/blob.h
	fi
}

do_compile () {
	if [ "${DEFAULTTUNE}" = "aarch64" ]; then
		oe_runmake ARCH_arm64_TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
		           NOECHO="" \
		           BUILDROOT=${BL33_OUT} \
		           LIBGCC="" \
		           CFLAGS="" \
		           DEBUG=${LOG_STORE_ENABLE} \
		           SECURE_BOOT_ENABLE=${SECURE_BOOT_ENABLE} \
		           SECURE_BOOT_TYPE=${SECURE_BOOT_TYPE} \
		           MTK_KEDUMP_MINI_SUPPORT=${MTK_KEDUMP_MINI_SUPPORT} \
		           MTK_MRDUMP_SUPPORT=${MTK_MRDUMP_SUPPORT} \
		           MTK_BOOT_REASON_SUPPORT=${MTK_BOOT_REASON_SUPPORT} \
		           AVB_ENABLE_ANTIROLLBACK=${AVB_ENABLE_ANTIROLLBACK} \
		           AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		           ${BL33_PROJECT}
	else
		oe_runmake TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
		           NOECHO="" \
		           BUILDROOT=${BL33_OUT} \
		           LIBGCC="$(${CC} --sysroot ${STAGING_DIR_HOST} -print-libgcc-file-name)" \
		           CFLAGS="" \
		           DEBUG=${LOG_STORE_ENABLE} \
		           SECURE_BOOT_ENABLE=${SECURE_BOOT_ENABLE} \
		           SECURE_BOOT_TYPE=${SECURE_BOOT_TYPE} \
		           MTK_KEDUMP_MINI_SUPPORT=${MTK_KEDUMP_MINI_SUPPORT} \
		           MTK_MRDUMP_SUPPORT=${MTK_MRDUMP_SUPPORT} \
		           MTK_BOOT_REASON_SUPPORT=${MTK_BOOT_REASON_SUPPORT} \
		           AVB_ENABLE_ANTIROLLBACK=${AVB_ENABLE_ANTIROLLBACK} \
		           AB_OTA_UPDATER=${AB_OTA_UPDATER} \
		           ${BL33_PROJECT}
	fi
	# add filesize check
	start=$(grep -w _start -n ${BL33_OUT}/build-${BL33_PROJECT}/lk.elf.sym.sorted | \
			sed -E  's/(.*):([0-9a-fA-F]+)(.*)/\2/' | tr '[:lower:]' '[:upper:]')
	end=$(grep -w _end -n ${BL33_OUT}/build-${BL33_PROJECT}/lk.elf.sym.sorted | \
		  sed -E  's/(.*):([0-9a-fA-F]+)(.*)/\2/' | tr '[:lower:]' '[:upper:]')
	fs=`echo "obase=16;ibase=16; $end - $start" | bc`
	maxsize=${BL33_MAX_SIZE}
	if [ ${BL33_MAX_SIZE} != "" ] && [[ 0x$fs -gt $maxsize ]]; then
		  bberror "Little kernel image size overflow, please have a check."
	fi
}

do_buildclean () {
	if [ "${DEFAULTTUNE}" = "aarch64" ]; then
		oe_runmake ARCH_arm64_TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
			   NOECHO="" \
			   BUILDROOT=${BL33_OUT} \
			   LIBGCC="" \
			   CFLAGS="" \
			   DEBUG=${LOG_STORE_ENABLE} \
			   ${BL33_PROJECT} clean
	else
		oe_runmake TOOLCHAIN_PREFIX=${TOOLCHAIN_PREFIX} \
			   NOECHO="" \
			   BUILDROOT=${BL33_OUT} \
			   LIBGCC="$(${CC} --sysroot ${STAGING_DIR_HOST} -print-libgcc-file-name)" \
			   CFLAGS="" \
			   DEBUG=${LOG_STORE_ENABLE} \
			   ${BL33_PROJECT} clean
	fi
}

do_deploy () {
	install -d ${DEPLOYDIR}
	install ${BL33_OUT}/build-${BL33_PROJECT}/${BL33_BINARY} ${DEPLOYDIR}/${BL33_DEPLOY_BINARY}
	install ${WORKDIR}/${BL33_IMAGE} ${DEPLOYDIR}/${BL33_IMAGE}
}

addtask genkey before do_compile after do_configure
addtask deploy before do_build after do_compile

